/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.container;

import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.container.QuadGanttChartContainerBase;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.container.ContainerSkinBase;
import impl.com.flexganttfx.skin.util.Binder;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import org.controlsfx.control.MasterDetailPane;

public class QuadGanttChartContainerSkin
extends ContainerSkinBase<QuadGanttChartContainerBase> {
    public QuadGanttChartContainerSkin(QuadGanttChartContainerBase container) {
        super(container);
        MasterDetailPane upperPane = container.getUpperMasterDetailPane();
        upperPane.setMasterNode((Node)new Wrapper(Corner.UPPER_LEFT));
        upperPane.setDetailNode((Node)new Wrapper(Corner.UPPER_RIGHT));
        MasterDetailPane lowerPane = container.getLowerMasterDetailPane();
        lowerPane.setMasterNode((Node)new Wrapper(Corner.LOWER_LEFT));
        lowerPane.setDetailNode((Node)new Wrapper(Corner.LOWER_RIGHT));
        Bindings.bindBidirectional((Property)upperPane.showDetailNodeProperty(), (Property)lowerPane.showDetailNodeProperty());
        Bindings.bindBidirectional((Property)upperPane.dividerPositionProperty(), (Property)lowerPane.dividerPositionProperty());
        MasterDetailPane masterDetailPane = container.getUpperLowerMasterDetailPane();
        masterDetailPane.setMasterNode((Node)upperPane);
        masterDetailPane.setDetailNode((Node)lowerPane);
        masterDetailPane.setShowDetailNode(container.isShowLower());
        Bindings.bindBidirectional((Property)container.showLowerProperty(), (Property)masterDetailPane.showDetailNodeProperty());
        this.getChildren().add((Object)masterDetailPane);
        InvalidationListener updateListener = it -> this.updatePositions();
        container.upperLeftGanttChartProperty().addListener(updateListener);
        container.upperRightGanttChartProperty().addListener(updateListener);
        container.lowerLeftGanttChartProperty().addListener(updateListener);
        container.lowerRightGanttChartProperty().addListener(updateListener);
        this.updatePositions();
    }

    private void updatePositions() {
        Object upperLeft = ((QuadGanttChartContainerBase)this.getSkinnable()).getUpperLeftGanttChart();
        Object upperRight = ((QuadGanttChartContainerBase)this.getSkinnable()).getUpperRightGanttChart();
        Object lowerLeft = ((QuadGanttChartContainerBase)this.getSkinnable()).getLowerLeftGanttChart();
        Object lowerRight = ((QuadGanttChartContainerBase)this.getSkinnable()).getLowerRightGanttChart();
        this.clearStyles((GanttChartBase<?>)((Object)upperLeft));
        this.clearStyles((GanttChartBase<?>)((Object)upperRight));
        this.clearStyles((GanttChartBase<?>)((Object)lowerLeft));
        this.clearStyles((GanttChartBase<?>)((Object)lowerRight));
        ((GanttChartBase)((Object)upperLeft)).setPosition(Position.FIRST);
        ((GanttChartBase)((Object)upperRight)).setPosition(Position.FIRST);
        ((GanttChartBase)((Object)lowerLeft)).setPosition(Position.LAST);
        ((GanttChartBase)((Object)lowerRight)).setPosition(Position.LAST);
        if (upperLeft instanceof GanttChart) {
            ((GanttChart)((Object)upperLeft)).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-first");
        }
        if (upperRight instanceof GanttChart) {
            ((GanttChart)((Object)upperRight)).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-first");
        }
        if (lowerLeft instanceof GanttChart) {
            ((GanttChart)((Object)lowerLeft)).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-last");
        }
        if (lowerRight instanceof GanttChart) {
            ((GanttChart)((Object)lowerRight)).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-last");
        }
        ((GanttChartBase)((Object)upperLeft)).getTimeline().getStyleClass().add((Object)"timeline-first");
        ((GanttChartBase)((Object)upperRight)).getTimeline().getStyleClass().add((Object)"timeline-first");
        ((GanttChartBase)((Object)lowerLeft)).getTimeline().getStyleClass().add((Object)"timeline-last");
        ((GanttChartBase)((Object)lowerRight)).getTimeline().getStyleClass().add((Object)"timeline-last");
        ((GanttChartBase)((Object)lowerLeft)).setMasterTimeline(((GanttChartBase)((Object)upperLeft)).getTimeline());
        ((GanttChartBase)((Object)lowerRight)).setMasterTimeline(((GanttChartBase)((Object)upperRight)).getTimeline());
        Binder.bind(upperLeft, lowerLeft, true);
        Binder.bind(upperRight, lowerRight, true);
    }

    private void clearStyles(GanttChartBase<?> ganttChart) {
        if (ganttChart instanceof GanttChart) {
            ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-first");
            ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-middle");
            ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-last");
        }
        ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-first");
        ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-middle");
        ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-last");
    }

    private class Wrapper
    extends BorderPane {
        public Wrapper(Corner corner) {
            switch (corner) {
                case UPPER_LEFT: {
                    this.topProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperLeftHeaderProperty());
                    this.centerProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperLeftGanttChartProperty());
                    this.bottomProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperLeftFooterProperty());
                    break;
                }
                case UPPER_RIGHT: {
                    this.topProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperRightHeaderProperty());
                    this.centerProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperRightGanttChartProperty());
                    this.bottomProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperRightFooterProperty());
                    ((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).upperRightGanttChartProperty().addListener(observable -> SplitPane.setResizableWithParent(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).getUpperRightGanttChart(), (Boolean)false));
                    break;
                }
                case LOWER_LEFT: {
                    this.topProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerLeftHeaderProperty());
                    this.centerProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerLeftGanttChartProperty());
                    this.bottomProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerLeftFooterProperty());
                    break;
                }
                case LOWER_RIGHT: {
                    this.topProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerRightHeaderProperty());
                    this.centerProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerRightGanttChartProperty());
                    this.bottomProperty().bind(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerRightFooterProperty());
                    ((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).lowerRightGanttChartProperty().addListener(observable -> SplitPane.setResizableWithParent(((QuadGanttChartContainerBase)QuadGanttChartContainerSkin.this.getSkinnable()).getLowerRightGanttChart(), (Boolean)false));
                }
            }
        }
    }

    private static enum Corner {
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

