/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import com.flexganttfx.view.util.TimelineScrollBar;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import org.controlsfx.control.HiddenSidesPane;
import org.controlsfx.control.MasterDetailPane;

public abstract class GanttChartBaseSkin<R extends Row<?, ?, ?>, C extends GanttChartBase<R>>
extends SkinBase<C> {
    private final BorderPane timelineGraphicsPane;
    private Timeline timeline;
    private final MasterDetailPane graphicsMasterDetailPane;
    private final TimelineScrollBar timelineScrollBar;
    private final Node detailNode;
    private final HiddenSidesPane hiddenSidesPane;

    public GanttChartBaseSkin(C control) {
        super(control);
        ListViewGraphics graphics = ((GanttChartBase)((Object)control)).getGraphics();
        this.timeline = ((GanttChartBase)((Object)control)).getTimeline();
        this.timelineScrollBar = ((GanttChartBase)((Object)control)).getTimelineScrollBar();
        this.detailNode = ((GanttChartBase)((Object)control)).getDetail();
        control.setMinSize(0.0, 0.0);
        this.timelineGraphicsPane = new BorderPane();
        this.timelineGraphicsPane.getStyleClass().add((Object)"timeline-graphics");
        this.timelineGraphicsPane.setTop((Node)this.timeline);
        this.timelineGraphicsPane.setCenter(graphics);
        this.hiddenSidesPane = new HiddenSidesPane();
        this.hiddenSidesPane.setContent((Node)this.timelineGraphicsPane);
        this.hiddenSidesPane.setBottom((Node)this.timelineScrollBar);
        this.graphicsMasterDetailPane = ((GanttChartBase)((Object)control)).getGraphicsMasterDetailPane();
        this.graphicsMasterDetailPane.setMasterNode((Node)this.hiddenSidesPane);
        ((GanttChartBase)((Object)control)).detailProperty().addListener(it -> this.configureDetailNode());
        this.configureDetailNode();
        this.getChildren().add((Object)this.graphicsMasterDetailPane);
        ((GanttChartBase)((Object)control)).positionProperty().addListener(it -> this.updatePosition());
        ((GanttChartBase)((Object)control)).graphicsHeaderProperty().addListener(it -> this.updatePosition());
        this.updatePosition();
    }

    protected void configureDetailNode() {
        Node detail = ((GanttChartBase)this.getSkinnable()).getDetail();
        if (detail != null) {
            SplitPane.setResizableWithParent((Node)detail, (Boolean)false);
            this.graphicsMasterDetailPane.setDetailNode(this.detailNode);
        } else {
            this.graphicsMasterDetailPane.setDetailNode((Node)new Label());
        }
    }

    public HiddenSidesPane getHiddenSidesPane() {
        return this.hiddenSidesPane;
    }

    protected final BorderPane getTimelineGraphicsPane() {
        return this.timelineGraphicsPane;
    }

    protected final TimelineScrollBar getTimelineScrollBar() {
        return this.timelineScrollBar;
    }

    private void updatePosition() {
        Position pos = ((GanttChartBase)this.getSkinnable()).getPosition();
        switch (pos) {
            case FIRST: 
            case ONLY: {
                this.getTimelineGraphicsPane().setTop((Node)((GanttChartBase)this.getSkinnable()).getTimeline());
                this.getTimelineScrollBar().toBack();
                break;
            }
            case LAST: 
            case MIDDLE: {
                this.getTimelineGraphicsPane().setTop(((GanttChartBase)this.getSkinnable()).getGraphicsHeader());
                this.getTimelineScrollBar().toFront();
                break;
            }
        }
    }
}

