/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.extras.skin;

import com.flexganttfx.extras.RadarView;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.DatelineScrollingEvent;
import com.flexganttfx.view.timeline.Timeline;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class RadarViewSkin<R extends Row<?, ?, ?>>
extends SkinBase<RadarView<R>> {
    private Canvas canvas;
    private Rectangle2D visibleBounds;
    private EventHandler<DatelineScrollingEvent> scrollingListener = evt -> this.drawRadar();
    private WeakEventHandler<DatelineScrollingEvent> weakScrollingListener = new WeakEventHandler(this.scrollingListener);
    private InvalidationListener redrawListener = evt -> this.drawRadar();
    private InvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private double dragStart;

    public RadarViewSkin(RadarView<R> view) {
        super(view);
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().add((Object)"radar");
        this.canvas = new Canvas();
        this.canvas.widthProperty().bind((ObservableValue)view.radarWidthProperty());
        this.canvas.heightProperty().bind((ObservableValue)view.radarHeightProperty());
        stackPane.getChildren().add((Object)this.canvas);
        this.getChildren().add((Object)stackPane);
        GraphicsBase<R> graphics = view.getGraphics();
        if (graphics != null) {
            graphics.getTimeline().getDateline().addEventHandler((EventType)DatelineScrollingEvent.ANY_SCROLLING, (EventHandler)this.weakScrollingListener);
            graphics.getRows().addListener(this.weakRedrawListener);
        }
        view.graphicsProperty().addListener((observable, oldGraphics, newGraphics) -> {
            if (oldGraphics != null) {
                oldGraphics.getTimeline().getDateline().removeEventHandler((EventType)DatelineScrollingEvent.ANY_SCROLLING, (EventHandler)this.weakScrollingListener);
                oldGraphics.getRows().removeListener(this.weakRedrawListener);
            }
            if (newGraphics != null) {
                newGraphics.getTimeline().getDateline().addEventHandler((EventType)DatelineScrollingEvent.ANY_SCROLLING, (EventHandler)this.weakScrollingListener);
                newGraphics.getRows().addListener(this.weakRedrawListener);
            }
        });
        this.drawRadar();
        this.canvas.setOnMouseMoved(this::mouseMoved);
        this.canvas.setOnMousePressed(this::mousePressed);
        this.canvas.setOnMouseDragged(this::mouseDragged);
    }

    private void mouseMoved(MouseEvent e) {
        if (this.visibleBounds != null && this.visibleBounds.contains(e.getX(), e.getY())) {
            this.canvas.setCursor(Cursor.HAND);
        }
    }

    private void mousePressed(MouseEvent e) {
        if (this.visibleBounds != null && this.visibleBounds.contains(e.getX(), e.getY())) {
            this.canvas.setCursor(Cursor.CLOSED_HAND);
            this.dragStart = e.getX();
        }
    }

    private void mouseDragged(MouseEvent e) {
        if (this.visibleBounds != null) {
            double delta = e.getX() - this.dragStart;
            this.dragStart = e.getX();
            double location = Math.min(this.canvas.getWidth() - this.visibleBounds.getWidth(), Math.max(0.0, this.visibleBounds.getMinX() + delta));
            Instant time = this.calculateTimeAt(location);
            Timeline timeline = ((RadarView)this.getSkinnable()).getGraphics().getTimeline();
            TimelineModel<?> timelineModel = timeline.getModel();
            timelineModel.setStartTime(time);
        }
    }

    private void drawRadar() {
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        gc.clearRect(0.0, 0.0, width, height);
        GraphicsBase graphics = ((RadarView)this.getSkinnable()).getGraphics();
        if (graphics != null) {
            Dateline dateline = graphics.getTimeline().getDateline();
            TemporalUnit temporalUnit = dateline.getPrimaryTemporalUnit();
            ZoneId zoneId = dateline.getZoneId();
            gc.setStroke((Paint)Color.RED);
            gc.setLineWidth(0.5);
            Instant earliestTimeUsed = graphics.getEarliestTimeUsed();
            Instant latestTimeUsed = graphics.getLatestTimeUsed();
            ObservableList rows = graphics.getRows();
            int numberOfRows = rows.size();
            for (int i = 0; i < numberOfRows; ++i) {
                Row row = (Row)rows.get(i);
                ActivityRepository repository = row.getRepository();
                Instant earliestTimeUsedInRow = repository.getEarliestTimeUsed();
                Instant latestTimeUsedInRow = repository.getLatestTimeUsed();
                if (earliestTimeUsedInRow == null || latestTimeUsedInRow == null) continue;
                for (Layer layer : graphics.getLayers()) {
                    Iterator activities = repository.getActivities(layer, earliestTimeUsedInRow, latestTimeUsedInRow, temporalUnit, zoneId);
                    while (activities.hasNext()) {
                        Activity activity = (Activity)activities.next();
                        double x1 = this.calculateX(activity.getStartTime(), width, earliestTimeUsed, latestTimeUsed);
                        double x2 = this.calculateX(activity.getEndTime(), width, earliestTimeUsed, latestTimeUsed);
                        double y = this.calculateY(i, numberOfRows, height);
                        gc.strokeLine(x1, y, x2, y);
                    }
                }
            }
            Timeline timeline = graphics.getTimeline();
            Instant visibleStartTime = timeline.getVisibleStartTime();
            Instant visibleEndTime = timeline.getVisibleEndTime();
            if (earliestTimeUsed != null && latestTimeUsed != null) {
                if (visibleStartTime.isBefore(earliestTimeUsed)) {
                    visibleStartTime = earliestTimeUsed;
                }
                if (visibleEndTime.isAfter(latestTimeUsed)) {
                    visibleEndTime = latestTimeUsed;
                }
                double x1 = this.calculateX(visibleStartTime, width, earliestTimeUsed, latestTimeUsed);
                double x2 = this.calculateX(visibleEndTime, width, earliestTimeUsed, latestTimeUsed);
                gc.setFill((Paint)Color.GREEN.deriveColor(0.0, 1.0, 1.0, 0.3));
                gc.fillRect(x1, 0.0, x2 - x1, height);
                this.visibleBounds = new Rectangle2D(x1, 0.0, Math.max(0.0, x2 - x1), Math.max(0.0, height));
            } else {
                this.visibleBounds = null;
            }
        }
    }

    private double calculateY(int rowIndex, int totalNumberOfRows, double canvasHeight) {
        return (double)((int)(canvasHeight / (double)totalNumberOfRows * (double)rowIndex)) + 0.5;
    }

    private double calculateX(Instant time, double width, Instant earliestTimeUsed, Instant latestTimeUsed) {
        double mpp = (double)(latestTimeUsed.toEpochMilli() - earliestTimeUsed.toEpochMilli()) / width;
        return (double)(time.toEpochMilli() - earliestTimeUsed.toEpochMilli()) / mpp;
    }

    private Instant calculateTimeAt(double x) {
        GraphicsBase graphics = ((RadarView)this.getSkinnable()).getGraphics();
        Instant earliestTimeUsed = graphics.getEarliestTimeUsed();
        Instant latestTimeUsed = graphics.getLatestTimeUsed();
        double mpp = (double)(latestTimeUsed.toEpochMilli() - earliestTimeUsed.toEpochMilli()) / this.canvas.getWidth();
        long millis = (long)(mpp * x);
        return Instant.ofEpochMilli(earliestTimeUsed.toEpochMilli() + millis);
    }
}

