/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.util;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.util.Messages;
import impl.com.flexganttfx.skin.treetable.GanttChartTreeItem;
import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class RowHeader<R extends Row<?, ?, ?>>
extends TreeTableColumn<R, R> {
    private TreeTableView<R> treeTable;
    private GanttChart<R> ganttChart;
    private Menu columns;
    private Pane cornerRegion;
    private final InvalidationListener columnListener = it -> this.updateColumnsMenu();
    private final InvalidationListener tableMenuButtonListener = it -> this.cornerRegion.setVisible(this.ganttChart.tableMenuButtonVisibleProperty().get());

    public RowHeader(GanttChart<R> ganttChart) {
        Objects.requireNonNull(ganttChart);
        this.ganttChart = ganttChart;
        this.treeTable = ganttChart.getTreeTable();
        this.setCellFactory(column -> new RowHeaderCell());
        this.setPrefWidth(30.0);
        this.setResizable(true);
        this.setSortable(false);
        this.setEditable(false);
        this.impl_setFixed(true);
        this.impl_setReorderable(false);
        ContextMenu contextMenu = new ContextMenu();
        MenuItem resizeColums = new MenuItem(Messages.getString("RowHeader.MENU_ITEM_FIT_COLUMNS"));
        resizeColums.setOnAction(evt -> ganttChart.resizeColumns());
        contextMenu.getItems().add((Object)resizeColums);
        this.columns = new Menu(Messages.getString("RowHeader.MENU_COLUMNS"));
        contextMenu.getItems().add((Object)this.columns);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem expandAllItem = new MenuItem(Messages.getString("RowHeader.MENU_ITEM_EXPAND_ALL"));
        expandAllItem.setOnAction(evt -> ganttChart.expandRows());
        contextMenu.getItems().add((Object)expandAllItem);
        MenuItem expandOnce = new MenuItem(Messages.getString("RowHeader.MENU_ITEM_EXPAND_ONCE"));
        expandOnce.setOnAction(evt -> ganttChart.expandRowsByOneLevel());
        contextMenu.getItems().add((Object)expandOnce);
        MenuItem collapseAllItem = new MenuItem(Messages.getString("RowHeader.MENU_ITEM_COLLAPSE_ALL"));
        collapseAllItem.setOnAction(evt -> ganttChart.collapseRows());
        contextMenu.getItems().add((Object)collapseAllItem);
        MenuItem collapseOnceItem = new MenuItem(Messages.getString("RowHeader.MENU_ITEM_COLLAPSE_ONCE"));
        collapseOnceItem.setOnAction(evt -> ganttChart.collapseRowsByOneLevel());
        contextMenu.getItems().add((Object)collapseOnceItem);
        ganttChart.getTreeTable().getColumns().addListener((InvalidationListener)new WeakInvalidationListener(this.columnListener));
        this.updateColumnsMenu();
        final StackPane image = new StackPane();
        image.setSnapToPixel(false);
        image.getStyleClass().setAll((Object[])new String[]{"show-hide-column-image"});
        this.cornerRegion = new StackPane(){

            protected void layoutChildren() {
                double imageWidth = image.snappedLeftInset() + image.snappedRightInset();
                double imageHeight = image.snappedTopInset() + image.snappedBottomInset();
                image.resize(imageWidth, imageHeight);
                this.positionInArea((Node)image, 0.0, 0.0, this.getWidth(), this.getHeight() - 3.0, 0.0, HPos.CENTER, VPos.CENTER);
            }
        };
        this.cornerRegion.getStyleClass().setAll((Object[])new String[]{"show-hide-columns-button"});
        this.cornerRegion.getChildren().addAll((Object[])new Node[]{image});
        this.cornerRegion.setVisible(ganttChart.tableMenuButtonVisibleProperty().get());
        ganttChart.tableMenuButtonVisibleProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.tableMenuButtonListener));
        this.setContextMenu(contextMenu);
        this.cornerRegion.setPrefSize(20.0, 20.0);
        this.setGraphic((Node)this.cornerRegion);
    }

    private void updateColumnsMenu() {
        ArrayList items = new ArrayList();
        this.ganttChart.getTreeTable().getColumns().stream().filter(column -> !(column instanceof RowHeader)).forEach(column -> {
            CheckMenuItem item = new CheckMenuItem();
            item.textProperty().bind((ObservableValue)column.textProperty());
            Bindings.bindBidirectional((Property)item.selectedProperty(), (Property)column.visibleProperty());
            items.add(item);
        });
        this.columns.getItems().setAll(items);
    }

    public final TreeTableView<R> getTreeTable() {
        return this.treeTable;
    }

    public final GanttChart<R> getGanttChart() {
        return this.ganttChart;
    }

    class RowHeaderCell
    extends TreeTableCell<R, R> {
        private static final String DEFAULT_STYLE_CLASS = "row-header-cell";
        private R row;
        private double startY;
        private boolean empty;
        private final InvalidationListener typeListener = observable -> {
            this.updateIndex(this.getIndex());
            this.updateItem((R)this.row, this.empty);
        };
        private final InvalidationListener nodeFactoryListener = observable -> {
            this.updateIndex(this.getIndex());
            this.updateItem((R)this.row, this.empty);
        };

        public RowHeaderCell() {
            RowHeader.this.ganttChart.rowHeaderTypeProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.typeListener));
            RowHeader.this.ganttChart.rowHeaderNodeFactoryProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.nodeFactoryListener));
            this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
            this.addEventHandler(MouseEvent.MOUSE_MOVED, evt -> {
                if (evt.getY() > this.getHeight() - 4.0 && this.getRow() != null) {
                    if (RowHeader.this.ganttChart.getFixedCellSize() == -1.0) {
                        this.setCursor(Cursor.V_RESIZE);
                    }
                } else {
                    this.setCursor(Cursor.DEFAULT);
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, evt -> {
                this.startY = evt.getY() > this.getHeight() - 4.0 && RowHeader.this.ganttChart.getFixedCellSize() == -1.0 ? evt.getY() : -1.0;
            });
            this.addEventHandler(MouseEvent.MOUSE_DRAGGED, evt -> {
                if (this.startY != -1.0) {
                    double delta = evt.getY() - this.startY;
                    this.startY = evt.getY();
                    if (this.row != null) {
                        ((Row)this.row).setHeight(Math.min(Math.max(((Row)this.row).getHeight() + delta, ((Row)this.row).getMinHeight()), ((Row)this.row).getMaxHeight()));
                    }
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, evt -> {
                if ((evt.isShiftDown() || evt.isShortcutDown()) && this.row != null) {
                    double rowHeight = ((Row)this.row).getHeight();
                    RowHeader.this.ganttChart.getGraphics().getRows().forEach(r -> {
                        if (rowHeight < r.getMinHeight()) {
                            r.setHeight(r.getMinHeight());
                        } else if (rowHeight > r.getMaxHeight()) {
                            r.setHeight(r.getMaxHeight());
                        } else {
                            r.setHeight(rowHeight);
                        }
                    });
                }
            });
            this.setContentDisplay(ContentDisplay.CENTER);
        }

        public Row<?, ?, ?> getRow() {
            return this.row;
        }

        public void updateIndex(int i) {
            super.updateIndex(i);
            switch (RowHeader.this.ganttChart.getRowHeaderType()) {
                case ROW_NUMBER: {
                    if (this.getRow() != null) {
                        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                        this.setText(Integer.toString(i + 1));
                        this.setAlignment(Pos.CENTER_RIGHT);
                        break;
                    }
                    this.setText(null);
                    break;
                }
            }
        }

        protected void updateItem(R row, boolean empty) {
            super.updateItem(row, empty);
            this.empty = empty;
            if (this.row != null) {
                Bindings.unbindBidirectional((Property)((Row)this.row).heightProperty(), (Property)this.prefHeightProperty());
            }
            this.row = (Row)this.getTreeTableRow().getItem();
            if (this.row != null) {
                switch (RowHeader.this.ganttChart.getRowHeaderType()) {
                    case GRAPHIC_NODE: {
                        Callback rowHeaderNodeFactory = RowHeader.this.ganttChart.getRowHeaderNodeFactory();
                        Node headerNode = (Node)rowHeaderNodeFactory.call(this.row);
                        this.setGraphic(headerNode);
                        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        break;
                    }
                    case LEVEL_NUMBER: {
                        GanttChartTreeItem item = (GanttChartTreeItem)this.getTreeTableRow().getTreeItem();
                        this.setText(item.getLevelNumber());
                        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                        this.setAlignment(Pos.CENTER_LEFT);
                        break;
                    }
                }
                this.setPrefHeight(((Row)this.row).getHeight());
                Bindings.bindBidirectional((Property)((Row)this.row).heightProperty(), (Property)this.prefHeightProperty());
            } else {
                switch (RowHeader.this.ganttChart.getRowHeaderType()) {
                    case GRAPHIC_NODE: {
                        this.setGraphic(null);
                        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        break;
                    }
                    default: {
                        this.setText(null);
                        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                    }
                }
                this.setPrefHeight(24.0);
            }
        }
    }
}

