/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.timeline;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.timeline.ChronoUnitTimelineModel;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.util.FlexGanttFXControl;
import impl.com.flexganttfx.skin.timeline.TimelineSkin;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Skin;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.util.Duration;
import org.controlsfx.control.PropertySheet;

public class Timeline
extends FlexGanttFXControl {
    private static final String DEFAULT_STYLE_CLASS = "timeline";
    private final Dateline dateline;
    private final Eventline eventline;
    private Instant zoomTime;
    private final BooleanProperty scrollDragEnabled = new SimpleBooleanProperty((Object)this, "scrollDragEnabled", false);
    private final ReadOnlyObjectWrapper<Instant> visibleStartTime = new ReadOnlyObjectWrapper((Object)this, "visibleStartTime", (Object)Instant.now());
    private final ReadOnlyObjectWrapper<Instant> visibleEndTime = new ReadOnlyObjectWrapper((Object)this, "visibleEndTime", (Object)Instant.now());
    private final ObjectProperty<Duration> moveDuration = new SimpleObjectProperty((Object)this, "moveDuration", (Object)Duration.seconds((double)0.33));
    private final BooleanProperty moveAnimated = new SimpleBooleanProperty((Object)this, "moveAnimated", true);
    private Instant requestedTime;
    private boolean requestedTimeCenter;
    private final ObjectProperty<TimelineModel<?>> model = new SimpleObjectProperty((Object)this, "model");
    private final ObjectProperty<Duration> zoomDuration = new SimpleObjectProperty((Object)this, "zoomDuration", (Object)Duration.seconds((double)0.2));
    private final BooleanProperty zoomAnimated = new SimpleBooleanProperty((Object)this, "zoomAnimated", true);
    private final ObjectProperty<ZoomMode> zoomMode = new SimpleObjectProperty((Object)this, "zoomMode", (Object)ZoomMode.KEEP_START_TIME);
    private final DoubleProperty zoomFactor = new SimpleDoubleProperty((Object)this, "zoomFactor", 0.5){

        public void setValue(Number number) {
            if (number.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("zoom factor must be larger than 0");
            }
            super.setValue(number);
        }
    };
    private TimeInterval requestedInterval;
    private final int SLOW_SPEED_PERCENTAGE = 20;
    private final int HIGH_SPEED_PERCENTAGE = 40;
    private static final String TIMELINE_PROPERTIES_CATEGORY = "Control: Timeline";

    public Timeline() {
        this.setPrefWidth(0.0);
        this.setMinWidth(0.0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setFocusTraversable(true);
        this.registerListeners();
        this.setModel(new ChronoUnitTimelineModel());
        this.addEventHandler(ScrollEvent.SCROLL, evt -> {
            this.getDateline().getProperties().put((Object)"com.flexganttfx.dateline.hover.interval", null);
            double deltaX = evt.getDeltaX();
            if (deltaX != 0.0) {
                Instant time = this.getModel().calculateTimeForLocation(-deltaX);
                this.getModel().setStartTime(time);
            } else if (evt.isShiftDown()) {
                double deltaY = evt.getDeltaY();
                if (deltaY > 0.0) {
                    this.zoomIn();
                } else if (deltaY < 0.0) {
                    this.zoomOut();
                }
                evt.consume();
            }
        });
        this.addEventHandler(ZoomEvent.ZOOM_STARTED, event -> {
            TimelineModel<?> model = this.getModel();
            this.zoomTime = model.calculateTimeForLocation(event.getX());
        });
        this.addEventHandler(ZoomEvent.ZOOM, event -> this.zoom(Math.abs(event.getZoomFactor() - 1.0), event.getZoomFactor() > 1.0, this.zoomTime));
        this.widthProperty().addListener(observable -> {
            boolean wasAnimated;
            if (this.requestedInterval != null) {
                wasAnimated = this.isZoomAnimated();
                this.setZoomAnimated(false);
                this.showRange(this.requestedInterval);
                this.setZoomAnimated(wasAnimated);
            }
            if (this.requestedTime != null) {
                wasAnimated = this.isZoomAnimated();
                this.setZoomAnimated(false);
                this.showTime(this.requestedTime, this.requestedTimeCenter);
                this.setZoomAnimated(wasAnimated);
            }
        });
        this.dateline = new Dateline(this);
        this.eventline = new Eventline(this);
    }

    protected Skin<?> createDefaultSkin() {
        return new TimelineSkin(this);
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(Timeline.class, "timeline.css");
    }

    public final Dateline getDateline() {
        return this.dateline;
    }

    public final Eventline getEventline() {
        return this.eventline;
    }

    private void registerListeners() {
        this.widthProperty().addListener((value, oldWidth, newWidth) -> this.updateVisibleStartAndEndTime());
        ChangeListener startTimeListener = (value, oldInstant, newInstant) -> this.updateVisibleStartAndEndTime();
        ChangeListener mppListener = (value, oldNumber, newNumber) -> this.updateVisibleStartAndEndTime();
        this.modelProperty().addListener((value, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.startTimeProperty().removeListener(startTimeListener);
                oldModel.millisPerPixelProperty().removeListener(mppListener);
            }
            if (newModel != null) {
                this.updateVisibleStartAndEndTime();
                newModel.startTimeProperty().addListener(startTimeListener);
                newModel.millisPerPixelProperty().addListener(mppListener);
            }
        });
    }

    public final BooleanProperty scrollDragEnabledProperty() {
        return this.scrollDragEnabled;
    }

    public final boolean isScrollDragEnabled() {
        return this.scrollDragEnabled.get();
    }

    public final void setScrollDragEnabled(boolean enabled) {
        this.scrollDragEnabled.set(enabled);
    }

    public final ReadOnlyObjectProperty<Instant> visibleStartTimeProperty() {
        return this.visibleStartTime.getReadOnlyProperty();
    }

    public final Instant getVisibleStartTime() {
        return (Instant)this.visibleStartTimeProperty().get();
    }

    public final ReadOnlyObjectProperty<Instant> visibleEndTimeProperty() {
        return this.visibleEndTime.getReadOnlyProperty();
    }

    public final Instant getVisibleEndTime() {
        return (Instant)this.visibleEndTimeProperty().get();
    }

    public final java.time.Duration getVisibleDuration() {
        return java.time.Duration.ofMillis(this.getVisibleEndTime().toEpochMilli() - this.getVisibleStartTime().toEpochMilli());
    }

    private void updateVisibleStartAndEndTime() {
        TimelineModel<?> timelineModel = this.getModel();
        if (timelineModel != null) {
            this.visibleStartTime.set((Object)timelineModel.getStartTime());
            this.visibleEndTime.set((Object)timelineModel.calculateTimeForLocation(this.getWidth()));
        }
    }

    public final ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    public final void setMoveDuration(Duration duration) {
        this.moveDurationProperty().set((Object)duration);
    }

    public final Duration getMoveDuration() {
        return (Duration)this.moveDurationProperty().get();
    }

    public final BooleanProperty moveAnimatedProperty() {
        return this.moveAnimated;
    }

    public final boolean isMoveAnimated() {
        return this.moveAnimatedProperty().get();
    }

    public final void setMoveAnimated(boolean animated) {
        this.moveAnimatedProperty().set(animated);
    }

    public final void showNow() {
        this.showNow(true);
    }

    public final void showNow(boolean center) {
        this.showTime(this.getModel().getNow(), center);
    }

    public final void showTime(Instant time) {
        this.showTime(time, false);
    }

    public final void showTime(Instant time, boolean center) {
        if (this.getWidth() == 0.0) {
            this.requestedTime = time;
            this.requestedTimeCenter = center;
            return;
        }
        this.requestedTime = null;
        if (center) {
            time = time.minus(this.getVisibleDuration().dividedBy(2L));
        }
        TimelineModel<?> timelineModel = this.getModel();
        if (this.isMoveAnimated()) {
            SimpleLongProperty startTimeProperty = new SimpleLongProperty(timelineModel.getStartTime().toEpochMilli());
            startTimeProperty.addListener((value, oldStartTime, newStartTime) -> {
                Instant instant = Instant.ofEpochMilli(newStartTime.longValue());
                timelineModel.setStartTime(instant);
            });
            KeyValue keyStartTimeValue = new KeyValue((WritableValue)startTimeProperty, (Object)time.toEpochMilli());
            javafx.animation.Timeline animationTimeline = new javafx.animation.Timeline(new KeyFrame[]{new KeyFrame(this.getMoveDuration(), new KeyValue[]{keyStartTimeValue})});
            animationTimeline.play();
        } else {
            timelineModel.setStartTime(time);
        }
    }

    public final void showTemporalUnit(TemporalUnit temporalUnit, double width) {
        Objects.requireNonNull(temporalUnit);
        if (width < 10.0) {
            throw new IllegalArgumentException("requested with / temporal unit must be equal to or larger than 10");
        }
        long requestedMillis = temporalUnit.getDuration().toMillis();
        TimelineModel<?> model = this.getModel();
        model.setMillisPerPixel((double)requestedMillis / width);
    }

    public final ObjectProperty<TimelineModel<?>> modelProperty() {
        return this.model;
    }

    public final TimelineModel<?> getModel() {
        return (TimelineModel)this.model.get();
    }

    public final void setModel(TimelineModel<?> model) {
        Objects.requireNonNull(model);
        this.model.set(model);
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.zoomDuration;
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public final BooleanProperty zoomAnimatedProperty() {
        return this.zoomAnimated;
    }

    public final boolean isZoomAnimated() {
        return this.zoomAnimatedProperty().get();
    }

    public final void setZoomAnimated(boolean animated) {
        this.zoomAnimatedProperty().set(animated);
    }

    public final ObjectProperty<ZoomMode> zoomModeProperty() {
        return this.zoomMode;
    }

    public final ZoomMode getZoomMode() {
        return (ZoomMode)((Object)this.zoomModeProperty().get());
    }

    public final void setZoomMode(ZoomMode mode) {
        this.zoomModeProperty().set((Object)mode);
    }

    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public final double getZoomFactor() {
        return this.zoomFactorProperty().get();
    }

    public final void setZoomFactor(double zoomFactor) {
        this.zoomFactorProperty().set(zoomFactor);
    }

    public final void zoomIn() {
        this.zoom(this.getZoomFactor(), true, null);
    }

    public final void zoomOut() {
        this.zoom(1.0 / this.getZoomFactor(), false, null);
    }

    public final void zoom(double factor, boolean zoomIn, Instant frozenTime) {
        TimelineModel<?> model = this.getModel();
        Instant startTime = model.getStartTime();
        Instant endTime = model.calculateTimeForLocation(this.getWidth());
        long delta = endTime.toEpochMilli() - startTime.toEpochMilli();
        if (frozenTime != null) {
            double frozenXBefore = model.calculateLocationForTime(frozenTime);
            if (zoomIn) {
                startTime = startTime.plusMillis((long)(factor * (double)delta) / 2L);
                endTime = endTime.minusMillis((long)(factor * (double)delta) / 2L);
            } else {
                startTime = startTime.minusMillis((long)(factor * (double)delta) / 2L);
                endTime = endTime.plusMillis((long)(factor * (double)delta) / 2L);
            }
            if (startTime.isBefore(endTime)) {
                boolean zoomAnimated = this.isZoomAnimated();
                this.setZoomAnimated(false);
                boolean limitReached = this.showRange(startTime, endTime);
                if (limitReached) {
                    return;
                }
                this.setZoomAnimated(zoomAnimated);
                double frozenXAfter = model.calculateLocationForTime(frozenTime);
                double deltaX = frozenXBefore - frozenXAfter;
                Instant deltaTime = model.calculateTimeForLocation(deltaX);
                long deltaMillis = deltaTime.toEpochMilli() - startTime.toEpochMilli();
                Instant adjustedStartTime = startTime.minusMillis(deltaMillis);
                model.setStartTime(adjustedStartTime);
            }
        } else {
            switch (this.getZoomMode()) {
                case CENTER: {
                    Instant centerTime = model.calculateTimeForLocation(this.getWidth() / 2.0);
                    startTime = centerTime.minusMillis((long)(factor * (double)delta / 2.0));
                    endTime = centerTime.plusMillis((long)(factor * (double)delta / 2.0));
                    break;
                }
                case KEEP_END_TIME: {
                    startTime = endTime.minusMillis((long)(factor * (double)delta));
                    break;
                }
                case KEEP_START_TIME: {
                    endTime = startTime.plusMillis((long)(factor * (double)delta));
                }
            }
            this.showRange(startTime, endTime);
        }
    }

    public final void showRange(Instant startTime, java.time.Duration duration) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(duration);
        this.showRange(startTime, startTime.plus(duration));
    }

    public final void showRange(TimeInterval interval) {
        Objects.requireNonNull(interval);
        this.showRange(interval.getStartTime(), interval.getEndTime());
    }

    public final boolean showRange(Instant startTime, Instant endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        if (startTime.equals(endTime) || startTime.isAfter(endTime)) {
            LoggingDomain.NAVIGATION.warning("start time is NOT before end time, ignoring showing range");
            return false;
        }
        double width = this.getWidth();
        if (width == 0.0) {
            this.requestedInterval = new TimeInterval(startTime, endTime);
            return true;
        }
        this.requestedInterval = null;
        long st = startTime.toEpochMilli();
        long et = endTime.toEpochMilli();
        TimelineModel<?> timelineModel = this.getModel();
        double mppMin = timelineModel.getMinimumMillisPerPixel();
        double mppMax = timelineModel.getMaximumMillisPerPixel();
        double mpp = Math.max(mppMin, Math.min(mppMax, (double)(et - st) / width));
        boolean limitReached = false;
        if (mpp == mppMin || mpp == mppMax) {
            limitReached = true;
        }
        if (!limitReached && this.isZoomAnimated()) {
            SimpleLongProperty startTimeProperty = new SimpleLongProperty(timelineModel.getStartTime().toEpochMilli());
            startTimeProperty.addListener((value, oldStartTime, newStartTime) -> {
                Instant instant = Instant.ofEpochMilli(newStartTime.longValue());
                timelineModel.setStartTime(instant);
            });
            KeyValue keyStartTimeValue = new KeyValue((WritableValue)startTimeProperty, (Object)st);
            DoubleProperty millisPerPixel = timelineModel.millisPerPixelProperty();
            timelineModel.startTimeProperty();
            KeyValue keyMillisPerPixelValue = new KeyValue((WritableValue)millisPerPixel, (Object)mpp);
            javafx.animation.Timeline animationTimeline = new javafx.animation.Timeline(new KeyFrame[]{new KeyFrame(this.getZoomDuration(), new KeyValue[]{keyMillisPerPixelValue, keyStartTimeValue})});
            animationTimeline.play();
        } else {
            if (!limitReached) {
                timelineModel.setStartTime(startTime);
            }
            timelineModel.setMillisPerPixel(mpp);
        }
        return limitReached;
    }

    public final void scrollRight() {
        this.doScroll(20.0);
    }

    public final void scrollRightFast() {
        this.doScroll(40.0);
    }

    public final void scrollLeft() {
        this.doScroll(-20.0);
    }

    public final void scrollLeftFast() {
        this.doScroll(-40.0);
    }

    private synchronized void doScroll(double percentage) {
        TimelineModel<?> model = this.getModel();
        long startTime = model.getStartTime().toEpochMilli();
        double visible = model.calculateTimeForLocation(this.getWidth()).toEpochMilli() - startTime;
        long jump = (long)(visible / 100.0 * percentage);
        Instant targetTime = Instant.ofEpochMilli(startTime + jump);
        SimpleLongProperty prop = new SimpleLongProperty(model.getStartTime().toEpochMilli());
        prop.addListener(arg_0 -> Timeline.lambda$doScroll$10(model, (LongProperty)prop, arg_0));
        KeyValue keyValue = new KeyValue((WritableValue)prop, (Object)targetTime.toEpochMilli());
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)333.0), new KeyValue[]{keyValue});
        javafx.animation.Timeline timeline = new javafx.animation.Timeline(new KeyFrame[]{keyFrame});
        timeline.play();
    }

    public final List<PropertySheet.Item> getPropertySheetItems() {
        ArrayList<PropertySheet.Item> items = new ArrayList<PropertySheet.Item>();
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.zoomAnimatedProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setZoomAnimated((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Timeline.this.isZoomAnimated();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Animated Zoom";
            }

            @Override
            public String getDescription() {
                return "Zoom operations can be performed with or without animation.";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.zoomFactorProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setZoomFactor((Double)value);
            }

            @Override
            public Object getValue() {
                return Timeline.this.getZoomFactor();
            }

            @Override
            public Class<?> getType() {
                return Double.class;
            }

            @Override
            public String getName() {
                return "Zoom Factor";
            }

            @Override
            public String getDescription() {
                return "The factor used for zooming in or out, default = .5";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.zoomModeProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setZoomMode((ZoomMode)((Object)value));
            }

            @Override
            public Object getValue() {
                return Timeline.this.getZoomMode();
            }

            @Override
            public Class<?> getType() {
                return ZoomMode.class;
            }

            @Override
            public String getName() {
                return "Zoom Mode";
            }

            @Override
            public String getDescription() {
                return "The method of zooming in (keep start, keep end, keep center time).";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.zoomDurationProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setZoomDuration((Duration)value);
            }

            @Override
            public Object getValue() {
                return Timeline.this.getZoomDuration();
            }

            @Override
            public Class<?> getType() {
                return Duration.class;
            }

            @Override
            public String getName() {
                return "Zoom Duration";
            }

            @Override
            public String getDescription() {
                return "The duration of the zoom animation.";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.moveAnimatedProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setMoveAnimated((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Timeline.this.isMoveAnimated();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Animated Move";
            }

            @Override
            public String getDescription() {
                return "Move operations can be performed with or without animation.";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Timeline.this.moveDurationProperty());
            }

            @Override
            public void setValue(Object value) {
                Timeline.this.setMoveDuration((Duration)value);
            }

            @Override
            public Object getValue() {
                return Timeline.this.getMoveDuration();
            }

            @Override
            public Class<?> getType() {
                return Duration.class;
            }

            @Override
            public String getName() {
                return "Move Duration";
            }

            @Override
            public String getDescription() {
                return "The duration of the move animation.";
            }

            @Override
            public String getCategory() {
                return Timeline.TIMELINE_PROPERTIES_CATEGORY;
            }
        });
        return items;
    }

    private static /* synthetic */ void lambda$doScroll$10(TimelineModel model, LongProperty prop, Observable it) {
        model.setStartTime(Instant.ofEpochMilli(prop.get()));
    }

    public static enum ZoomMode {
        CENTER,
        KEEP_START_TIME,
        KEEP_END_TIME;

    }
}

