/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.timeline;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.ActivityBase;
import com.flexganttfx.model.activity.CompletableActivityBase;
import com.flexganttfx.model.activity.MutableActivityBase;
import com.flexganttfx.model.activity.MutableCompletableActivityBase;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.SingleRowGraphics;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.FlexGanttFXControl;
import impl.com.flexganttfx.skin.timeline.EventlineSkin;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.PropertySheet;

public class Eventline
extends FlexGanttFXControl {
    private static final String DEFAULT_STYLE_CLASS = "eventline";
    private final Timeline timeline;
    private final SingleRowGraphics<Row<?, ?, ?>> graphics;
    private final BooleanProperty showFrozenRow = new SimpleBooleanProperty((Object)this, "showFrozenRow", false);
    private final ObjectProperty<Row<?, ?, ?>> frozenRow = new SimpleObjectProperty((Object)this, "frozenRow");
    private final ReadOnlyDoubleWrapper cursorLocation = new ReadOnlyDoubleWrapper((Object)this, "cursorLocation", 100.0);
    private final ReadOnlyObjectWrapper<Instant> cursorTime = new ReadOnlyObjectWrapper((Object)this, "cursorTime");
    private final BooleanProperty showTimeCursor = new SimpleBooleanProperty((Object)this, "showTimeCursor", true);
    private final BooleanProperty showDSTMarker = new SimpleBooleanProperty((Object)this, "showDSTMarker", true);
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatter = new SimpleObjectProperty((Object)this, "dateTimeFormatter", (Object)DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
    private final BooleanProperty showMarkedTimeInterval = new SimpleBooleanProperty((Object)this, "showMarkedTimeInterval", true);
    private final ObjectProperty<TimeInterval> markedTimeInterval = new SimpleObjectProperty((Object)this, "markedTimeInterval");
    private static final String EVENTLINE_PROPERTIES_CATEGORY = "Control: Eventline";

    public Eventline(Timeline timeline) {
        Objects.requireNonNull(timeline);
        this.timeline = timeline;
        this.graphics = new SingleRowGraphics();
        this.graphics.visibleProperty().bind((ObservableValue)this.showFrozenRow);
        this.graphics.managedProperty().bind((ObservableValue)this.showFrozenRow);
        this.graphics.setActivityRenderer(ActivityBase.class, GanttLayout.class, new EventlineActivityRenderer(this.graphics, "Eventline Activity Renderer"));
        this.graphics.setActivityRenderer(MutableActivityBase.class, GanttLayout.class, new EventlineActivityRenderer(this.graphics, "Eventline Mutable Activity Renderer"));
        this.graphics.setActivityRenderer(CompletableActivityBase.class, GanttLayout.class, new EventlineActivityRenderer(this.graphics, "Eventline Completable Activity Renderer"));
        this.graphics.setActivityRenderer(MutableCompletableActivityBase.class, GanttLayout.class, new EventlineActivityRenderer(this.graphics, "Eventline Mutable Completable Activity Renderer"));
        this.registerListeners();
        this.setFocusTraversable(true);
        this.setPrefWidth(0.0);
        this.setMinWidth(0.0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.cursorLocationProperty().addListener(observable -> this.updateCursorTime());
        this.getProperties().addListener(change -> {
            if (change.getKey().equals("com.flexganttfx.eventline.cursor.location") && change.getValueAdded() != null) {
                Double mode = (Double)change.getValueAdded();
                this.cursorLocation.set(mode.doubleValue());
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new EventlineSkin(this);
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(Eventline.class, "eventline.css");
    }

    public final BooleanProperty showFrozenRowProperty() {
        return this.showFrozenRow;
    }

    public final boolean isShowFrozenRow() {
        return this.showFrozenRow.get();
    }

    public final void setShowFrozenRow(boolean showFrozenRow) {
        this.showFrozenRow.set(showFrozenRow);
    }

    public final SingleRowGraphics<Row<?, ?, ?>> getGraphics() {
        return this.graphics;
    }

    private void registerListeners() {
        ChangeListener startTimeListener = (value, oldInstant, newInstant) -> this.updateCursorTime();
        this.getTimeline().getModel().startTimeProperty().addListener(startTimeListener);
        ChangeListener mppListener = (value, oldNumber, newNumber) -> this.updateCursorTime();
        this.getTimeline().getModel().millisPerPixelProperty().addListener(mppListener);
        this.getTimeline().modelProperty().addListener((value, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.startTimeProperty().removeListener(startTimeListener);
                oldModel.millisPerPixelProperty().removeListener(mppListener);
            }
            if (newModel != null) {
                newModel.startTimeProperty().addListener(startTimeListener);
                newModel.millisPerPixelProperty().addListener(mppListener);
            }
        });
    }

    private void updateCursorTime() {
        TimelineModel<?> timelineModel = this.getTimeline().getModel();
        double location = this.getCursorLocation();
        if (location < 0.0 || location > this.getWidth()) {
            this.cursorTime.set(null);
        } else {
            this.cursorTime.set((Object)timelineModel.calculateTimeForLocation(location));
        }
    }

    public final Timeline getTimeline() {
        return this.timeline;
    }

    public final ObjectProperty<Row<?, ?, ?>> frozenRowProperty() {
        return this.frozenRow;
    }

    public final Row<?, ?, ?> getFrozenRow() {
        return (Row)this.frozenRow.get();
    }

    public final void setFrozenRow(Row<?, ?, ?> frozenRow) {
        this.frozenRow.set(frozenRow);
    }

    public final ReadOnlyDoubleProperty cursorLocationProperty() {
        return this.cursorLocation;
    }

    public final double getCursorLocation() {
        return this.cursorLocationProperty().get();
    }

    public final ReadOnlyObjectProperty<Instant> cursorTimeProperty() {
        return this.cursorTime;
    }

    public final Instant getCursorTime() {
        return (Instant)this.cursorTimeProperty().get();
    }

    public final BooleanProperty showTimeCursorProperty() {
        return this.showTimeCursor;
    }

    public final boolean isShowTimeCursor() {
        return this.showTimeCursorProperty().get();
    }

    public final void setShowTimeCursor(boolean show) {
        this.showTimeCursorProperty().set(show);
    }

    public final BooleanProperty showDSTMarkerProperty() {
        return this.showDSTMarker;
    }

    public final boolean isShowDSTMarker() {
        return this.showDSTMarkerProperty().get();
    }

    public final void setShowDSTMarker(boolean show) {
        this.showDSTMarkerProperty().set(show);
    }

    public final ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatter;
    }

    public final void setDateTimeFormatter(DateTimeFormatter formatter) {
        this.dateTimeFormatterProperty().set((Object)formatter);
    }

    public final DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatter.get();
    }

    public final BooleanProperty showMarkedTimeIntervalProperty() {
        return this.showMarkedTimeInterval;
    }

    public final boolean isShowMarkedTimeInterval() {
        return this.showMarkedTimeIntervalProperty().get();
    }

    public final void setShowMarkedTimeInterval(boolean show) {
        this.showMarkedTimeIntervalProperty().set(show);
    }

    public final ObjectProperty<TimeInterval> markedTimeIntervalProperty() {
        return this.markedTimeInterval;
    }

    public final void setMarkedTimeInterval(TimeInterval timeInterval) {
        this.markedTimeInterval.set((Object)timeInterval);
    }

    public final TimeInterval getMarkedTimeInterval() {
        return (TimeInterval)this.markedTimeInterval.get();
    }

    public final List<PropertySheet.Item> getPropertySheetItems() {
        ArrayList<PropertySheet.Item> items = new ArrayList<PropertySheet.Item>();
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Eventline.this.showTimeCursorProperty());
            }

            @Override
            public void setValue(Object value) {
                Eventline.this.setShowTimeCursor((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Eventline.this.isShowTimeCursor();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Show Time Cursor";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the display of the time cursor.";
            }

            @Override
            public String getCategory() {
                return Eventline.EVENTLINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Eventline.this.showFrozenRowProperty());
            }

            @Override
            public void setValue(Object value) {
                Eventline.this.setShowFrozenRow((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Eventline.this.isShowFrozenRow();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Show Frozen Row";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the use of a frozen row.";
            }

            @Override
            public String getCategory() {
                return Eventline.EVENTLINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Eventline.this.showMarkedTimeIntervalProperty());
            }

            @Override
            public void setValue(Object value) {
                Eventline.this.setShowMarkedTimeInterval((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Eventline.this.isShowMarkedTimeInterval();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Show Marked Time Intervals";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the display of a marked time interval.";
            }

            @Override
            public String getCategory() {
                return Eventline.EVENTLINE_PROPERTIES_CATEGORY;
            }
        });
        return items;
    }

    class EventlineActivityRenderer
    extends ActivityRenderer {
        public EventlineActivityRenderer(GraphicsBase graphics, String name) {
            super(graphics, name);
            this.setStroke((Paint)Color.TRANSPARENT);
        }
    }
}

