/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.timeline;

import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.timeline.Dateline;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public abstract class DatelineCell<T extends TemporalUnit>
extends Region {
    private static final String DEFAULT_STYLE_CLASS = "dateline-cell";
    private Resolution<T> resolution;
    private Instant startTime;
    private Instant endTime;
    private Dateline dateline;
    private Text text;
    private Resolution.Position scalePosition;

    protected DatelineCell() {
        this.setMouseTransparent(true);
        this.text = new Text(){

            public boolean isResizable() {
                return true;
            }
        };
        this.text.setTextOrigin(VPos.CENTER);
        this.text.setTextAlignment(TextAlignment.LEFT);
        this.text.getStyleClass().add((Object)"text");
        this.text.setManaged(false);
        this.getChildren().add((Object)this.text);
    }

    public void update(Instant startTime, Instant endTime, Resolution<T> resolution, Dateline dateline, Resolution.Position position) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS, position.name().toLowerCase(), resolution.getTemporalUnit().toString().toLowerCase()});
        this.startTime = startTime;
        this.endTime = endTime;
        this.dateline = dateline;
        this.resolution = resolution;
        this.scalePosition = position;
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double w = this.getWidth() - insets.getLeft() - insets.getRight();
        double h = this.getHeight() - insets.getTop() - insets.getBottom();
        double prefWidth = this.text.prefWidth(h);
        double prefHeight = this.text.prefHeight(-1.0);
        this.text.setWrappingWidth(Math.max(prefWidth, w));
        if (prefWidth > w) {
            if (this.getStyleClass().contains((Object)"dateline-cell-first")) {
                this.text.resizeRelocate(this.getWidth() - prefWidth - insets.getRight(), h / 2.0 - prefHeight / 2.0, prefWidth, h);
            } else if (this.getStyleClass().contains((Object)"dateline-cell-last")) {
                this.text.resizeRelocate(insets.getLeft(), h / 2.0 - prefHeight / 2.0, w, h);
            }
        } else {
            this.text.resizeRelocate(insets.getLeft(), h / 2.0 - prefHeight / 2.0, w, h);
        }
        this.setClip((Node)new Rectangle(0.0, 0.0, this.getWidth(), this.getHeight()));
    }

    protected double computePrefWidth(double height) {
        return this.text.prefWidth(-1.0) + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    protected double computePrefHeight(double width) {
        return this.text.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    protected void setText(String txt) {
        this.text.setText(txt);
    }

    public final Resolution<T> getResolution() {
        return this.resolution;
    }

    public final Dateline getDateline() {
        return this.dateline;
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Instant getEndTime() {
        return this.endTime;
    }

    public final TimeInterval getInterval() {
        return new TimeInterval(this.getStartTime(), this.getEndTime());
    }

    public final Resolution.Position getScalePosition() {
        return this.scalePosition;
    }
}

