/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.timeline.Timeline;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class Renderer {
    private final String name;
    private GraphicsBase<?> graphics;
    private boolean drawingInProgress;
    private final InvalidationListener redrawListener = observable -> {
        if (!this.drawingInProgress) {
            this.graphics.redraw();
        }
    };
    private final BooleanProperty enabled = new SimpleBooleanProperty((Object)this, "enabled", true);
    private final BooleanProperty snapToPixel = new SimpleBooleanProperty((Object)this, "snapToPixel", true);
    private final ObjectProperty<Insets> padding = new SimpleObjectProperty((Object)this, "padding", (Object)Insets.EMPTY);
    private final ObjectProperty<Paint> fill = new SimpleObjectProperty((Object)this, "fill");
    private final ObjectProperty<Paint> fillPressed = new SimpleObjectProperty((Object)this, "fillPressed");
    private final ObjectProperty<Paint> fillHighlight = new SimpleObjectProperty((Object)this, "fillHighlight");
    private final ObjectProperty<Paint> fillSelected = new SimpleObjectProperty((Object)this, "fillSelected");
    private final ObjectProperty<Paint> fillHover = new SimpleObjectProperty((Object)this, "fillHover");
    private final DoubleProperty alpha = new SimpleDoubleProperty((Object)this, "alpha", 1.0);

    public Renderer(GraphicsBase<?> graphics, String name) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(graphics);
        this.name = name;
        this.graphics = graphics;
        this.setFill((Paint)Color.LIGHTBLUE);
        this.setFillPressed((Paint)Color.LIGHTBLUE.darker());
        this.setFillHighlight((Paint)Color.YELLOW.deriveColor(1.0, 1.0, 1.0, 0.5));
        this.setFillSelected((Paint)Color.valueOf((String)"#F21B1BBB"));
        this.setFillHover((Paint)Color.GREEN);
        this.redrawObservable((Observable)this.enabled);
        this.redrawObservable((Observable)this.snapToPixel);
        this.redrawObservable((Observable)this.padding);
        this.redrawObservable((Observable)this.alpha);
        this.redrawObservable((Observable)this.fill);
        this.redrawObservable((Observable)this.fillHighlight);
        this.redrawObservable((Observable)this.fillPressed);
        this.redrawObservable((Observable)this.fillSelected);
        this.redrawObservable((Observable)this.fillHover);
    }

    protected double snapPosition(double value) {
        return this.snapPosition(value, this.isSnapToPixel());
    }

    protected double snapSpace(double value) {
        return this.snapSpace(value, this.isSnapToPixel());
    }

    protected double snapSize(double value) {
        return this.snapSize(value, this.isSnapToPixel());
    }

    private double snapSpace(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) : value;
    }

    private double snapSize(double value, boolean snapToPixel) {
        return snapToPixel ? Math.ceil(value) : value;
    }

    private double snapPosition(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) + 0.5 : value;
    }

    protected final void disableRedrawAfterPropertyChange() {
        this.drawingInProgress = true;
    }

    protected final void enableRedrawAfterPropertyChange() {
        this.drawingInProgress = false;
    }

    protected void redrawObservable(Observable observable) {
        Objects.requireNonNull(observable);
        observable.addListener(this.redrawListener);
    }

    public final String getName() {
        return this.name;
    }

    public final GraphicsBase<?> getGraphics() {
        return this.graphics;
    }

    protected final double getLocation(Instant time) {
        Timeline timeline = this.getGraphics().getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        return timelineModel.calculateLocationForTime(time);
    }

    protected final Instant getTimeAt(double location) {
        Timeline timeline = this.getGraphics().getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        return timelineModel.calculateTimeForLocation(location);
    }

    protected Paint getFill(boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (pressed) {
            return this.getFillPressed();
        }
        if (highlighted) {
            return this.getFillHighlight();
        }
        if (hover) {
            return this.getFillHover();
        }
        if (selected) {
            return this.getFillSelected();
        }
        return this.getFill();
    }

    public final BooleanProperty enabledProperty() {
        return this.enabled;
    }

    public final BooleanProperty snapToPixelProperty() {
        return this.snapToPixel;
    }

    public final ObjectProperty<Insets> paddingProperty() {
        return this.padding;
    }

    public final DoubleProperty alphaProperty() {
        return this.alpha;
    }

    public final ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public final ObjectProperty<Paint> fillPressedProperty() {
        return this.fillPressed;
    }

    public final ObjectProperty<Paint> fillHoverProperty() {
        return this.fillHover;
    }

    public final ObjectProperty<Paint> fillSelectedProperty() {
        return this.fillSelected;
    }

    public final ObjectProperty<Paint> fillHighlightProperty() {
        return this.fillHighlight;
    }

    public final boolean isEnabled() {
        return this.enabled.get();
    }

    public final void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public final void setSnapToPixel(boolean snap) {
        this.snapToPixel.set(snap);
    }

    public final boolean isSnapToPixel() {
        return this.snapToPixel.get();
    }

    public final Insets getPadding() {
        return (Insets)this.padding.get();
    }

    public final void setPadding(Insets insets) {
        Objects.requireNonNull(insets);
        this.padding.set((Object)insets);
    }

    public final Paint getFill() {
        return (Paint)this.fill.get();
    }

    public final void setFill(Paint paint) {
        Objects.nonNull(paint);
        this.fill.set((Object)paint);
    }

    public final Paint getFillPressed() {
        return (Paint)this.fillPressed.get();
    }

    public final void setFillPressed(Paint paint) {
        Objects.nonNull(paint);
        this.fillPressed.set((Object)paint);
    }

    public final Paint getFillHighlight() {
        return (Paint)this.fillHighlight.get();
    }

    public final void setFillHighlight(Paint paint) {
        Objects.nonNull(paint);
        this.fillHighlight.set((Object)paint);
    }

    public final Paint getFillSelected() {
        return (Paint)this.fillSelected.get();
    }

    public final void setFillSelected(Paint paint) {
        Objects.nonNull(paint);
        this.fillSelected.set((Object)paint);
    }

    public final Paint getFillHover() {
        return (Paint)this.fillHover.get();
    }

    public final void setFillHover(Paint paint) {
        Objects.nonNull(paint);
        this.fillHover.set((Object)paint);
    }

    public final void setAlpha(double alpha) {
        this.alpha.set(alpha);
    }

    public final double getAlpha() {
        return this.alpha.get();
    }
}

