/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.util.Position;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class ActivityBarRenderer<A extends Activity>
extends ActivityRenderer<A> {
    private static final Color WHITE = new Color(1.0, 1.0, 1.0, 0.3);
    private final DoubleProperty barHeight = new SimpleDoubleProperty((Object)this, "barHeight", 10.0);
    private final DoubleProperty textGap = new SimpleDoubleProperty((Object)this, "textGap", 8.0);
    private final BooleanProperty glossy = new SimpleBooleanProperty((Object)this, "glossy", true);
    private final BooleanProperty autoFixText = new SimpleBooleanProperty((Object)this, "autoFixText", true);
    private final ObjectProperty<Paint> textFill = new SimpleObjectProperty((Object)this, "textFill");
    private final ObjectProperty<Paint> textFillHover = new SimpleObjectProperty((Object)this, "textFillHover");
    private final ObjectProperty<Paint> textFillHighlight = new SimpleObjectProperty((Object)this, "textFillHighlight");
    private final ObjectProperty<Paint> textFillSelected = new SimpleObjectProperty((Object)this, "textFillSelected");
    private final ObjectProperty<Paint> textFillPressed = new SimpleObjectProperty((Object)this, "textFillPressed");
    private final ObjectProperty<Font> font = new SimpleObjectProperty((Object)this, "font", (Object)Font.font((double)10.0));

    public ActivityBarRenderer(GraphicsBase<?> graphics, String name) {
        super(graphics, name);
        this.setTextFill((Paint)Color.BLACK);
        this.setTextFillHover((Paint)Color.BLACK);
        this.setTextFillHighlight((Paint)Color.BLACK);
        this.setTextFillSelected((Paint)Color.BLACK);
        this.setTextFillPressed((Paint)Color.BLACK);
        this.redrawObservable((Observable)this.autoFixText);
        this.redrawObservable((Observable)this.barHeight);
        this.redrawObservable((Observable)this.font);
        this.redrawObservable((Observable)this.glossy);
        this.redrawObservable((Observable)this.textFill);
        this.redrawObservable((Observable)this.textGap);
        this.redrawObservable((Observable)this.textFill);
        this.redrawObservable((Observable)this.textFillSelected);
        this.redrawObservable((Observable)this.textFillHover);
        this.redrawObservable((Observable)this.textFillPressed);
        this.redrawObservable((Observable)this.textFillHighlight);
    }

    @Override
    protected ActivityBounds drawActivity(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        this.drawBackground(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        this.drawBorder(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        double my = y;
        double mh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            mh = barHeight;
        }
        if (this.isMilestone(activityRef)) {
            return new ActivityBounds(activityRef, x - barHeight / 2.0, my, barHeight, barHeight);
        }
        return new ActivityBounds(activityRef, x, my, w, mh);
    }

    @Override
    protected void drawBackground(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (this.isMilestone(activityRef)) {
            this.drawMilestoneBackground(activityRef, gc, x, y, w, h, selected, hover, highlighted, pressed);
        } else {
            this.drawActivityBackground(gc, x, y, w, h, selected, hover, highlighted, pressed);
        }
    }

    private boolean isMilestone(ActivityRef<?> activityRef) {
        Object activity = activityRef.getActivity();
        return activity.getStartTime().equals(activity.getEndTime());
    }

    private void drawActivityBackground(GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        double cornerRadius;
        double my = y;
        double bh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            bh = barHeight;
        }
        boolean glossy = this.isGlossy();
        if (selected) {
            gc.setStroke(this.getStrokeSelected());
            if (this.isCornersRounded()) {
                cornerRadius = this.getCornerRadius();
                gc.strokeRoundRect(x - 3.0, my - 3.0, w + 6.0, bh + 6.0, cornerRadius, cornerRadius);
            } else {
                gc.strokeRect(x - 3.0, my - 3.0, w + 6.0, bh + 6.0);
            }
        }
        gc.setFill(this.getFill(false, hover, highlighted, pressed));
        if (this.isCornersRounded()) {
            cornerRadius = this.getCornerRadius();
            gc.fillRoundRect(x, my, w, bh, cornerRadius, cornerRadius);
            if (glossy) {
                gc.setFill((Paint)WHITE);
                gc.fillRoundRect(x, my, w, bh / 2.0, cornerRadius, cornerRadius);
            }
        } else {
            gc.fillRect(x, my, w, bh);
            if (glossy) {
                gc.setFill((Paint)WHITE);
                gc.fillRect(x, my, w, bh / 2.0);
            }
        }
    }

    private void drawMilestoneBackground(ActivityRef<A> activityRef, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        double my = y;
        double bh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            bh = barHeight;
        }
        boolean glossy = this.isGlossy();
        double[] xx = new double[]{x, x + bh / 2.0, x, x - bh / 2.0, x};
        double[] yy = new double[]{my, my + bh / 2.0, my + bh, my + bh / 2.0, my};
        if (selected) {
            double[] xxSelected = new double[]{x, x + bh / 2.0 + 2.0, x, x - bh / 2.0 - 2.0, x};
            double[] yySelected = new double[]{my - 2.0, my + bh / 2.0, my + bh + 2.0, my + bh / 2.0, my - 2.0};
            gc.setStroke(this.getStrokeSelected());
            gc.strokePolygon(xxSelected, yySelected, 5);
        }
        gc.setFill(this.getFill(false, hover, highlighted, pressed));
        gc.fillPolygon(xx, yy, 5);
        if (glossy) {
            gc.setFill((Paint)WHITE);
            gc.fillPolygon(xx, yy, 3);
        }
    }

    @Override
    protected void drawBorder(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (this.isMilestone(activityRef)) {
            this.drawMilestoneBorder(activityRef, gc, x, y, w, h, selected, hover, highlighted, pressed);
        } else {
            this.drawActivityBorder(activityRef, gc, x, y, w, h, selected, hover, highlighted, pressed);
        }
    }

    private void drawActivityBorder(ActivityRef<A> activityRef, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        gc.setStroke(this.getStroke(false, hover, highlighted, pressed));
        double my = y;
        double bh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            bh = barHeight;
        }
        if (this.isCornersRounded()) {
            double cornerRadius = this.getCornerRadius();
            gc.strokeRoundRect(x, my, w, bh, cornerRadius, cornerRadius);
        } else {
            gc.strokeRect(x, my, w, bh);
        }
    }

    private void drawMilestoneBorder(ActivityRef<A> activityRef, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        gc.setStroke(this.getStroke(false, hover, highlighted, pressed));
        double my = y;
        double bh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            bh = barHeight;
        }
        double[] xx = new double[]{x, x + bh / 2.0, x, x - bh / 2.0, x};
        double[] yy = new double[]{my, my + bh / 2.0, my + bh, my + bh / 2.0, my};
        gc.strokePolygon(xx, yy, 5);
    }

    protected void drawText(ActivityRef<A> activityRef, String text, TextPosition position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        double availableWidth;
        switch (position) {
            case LEADING: 
            case TRAILING: {
                availableWidth = Double.MAX_VALUE;
                break;
            }
            case CENTER: {
                availableWidth = Math.max(0.0, Math.min(x < 0.0 ? w + x : w, gc.getCanvas().getWidth() - (x < 0.0 ? 0.0 : x)));
                break;
            }
            default: {
                availableWidth = Math.max(0.0, Math.min((x < 0.0 ? w + x : w) - 2.0 * this.getTextGap(), gc.getCanvas().getWidth() - (x < 0.0 ? 0.0 : x)));
            }
        }
        if (!this.isTextVisible(text, position, availableWidth)) {
            return;
        }
        double my = y;
        double bh = h;
        double barHeight = this.getBarHeight();
        if (barHeight > 0.0) {
            my = y + (h - barHeight) / 2.0;
            bh = barHeight;
        }
        gc.setFill(this.getTextFill(selected, hover, highlighted, pressed));
        double textX = 0.0;
        double textY = 0.0;
        double textGap = this.isMilestone(activityRef) ? barHeight / 2.0 + this.getTextGap() : this.getTextGap();
        switch (position) {
            case LEADING: {
                textX = x - textGap;
                textY = my + bh / 2.0;
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                break;
            }
            case TRAILING: {
                textX = x + w + textGap;
                textY = my + bh / 2.0;
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.CENTER);
                break;
            }
            case LEFT: {
                boolean autoFixText = this.isAutoFixText();
                textX = autoFixText ? Math.max(0.0, x + textGap) : x + textGap;
                textY = my + bh / 2.0;
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.CENTER);
                break;
            }
            case RIGHT: {
                textX = Math.min(gc.getCanvas().getWidth(), x + w) - textGap;
                textY = my + bh / 2.0;
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                break;
            }
            case CENTER: {
                textX = (x < 0.0 ? 0.0 : x) + availableWidth / 2.0;
                textY = my + bh / 2.0;
                gc.setTextAlign(TextAlignment.CENTER);
                gc.setTextBaseline(VPos.CENTER);
                break;
            }
            case ABOVE: {
                textX = (x < 0.0 ? 0.0 : x) + availableWidth / 2.0;
                textY = my;
                gc.setTextAlign(TextAlignment.CENTER);
                gc.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case ABOVE_LEFT: {
                textX = x < 0.0 ? 0.0 : x;
                textY = my;
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case ABOVE_RIGHT: {
                textX = Math.min(gc.getCanvas().getWidth(), x + w);
                textY = my;
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case BELOW: {
                textX = (x < 0.0 ? 0.0 : x) + availableWidth / 2.0;
                textY = my + bh;
                gc.setTextAlign(TextAlignment.CENTER);
                gc.setTextBaseline(VPos.TOP);
                break;
            }
            case BELOW_LEFT: {
                textX = x < 0.0 ? 0.0 : x;
                textY = my + bh;
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.TOP);
                break;
            }
            case BELOW_RIGHT: {
                textX = Math.min(gc.getCanvas().getWidth(), x + w);
                textY = my + bh;
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.TOP);
                break;
            }
        }
        gc.setFont(this.getFont());
        switch (position) {
            case LEADING: 
            case TRAILING: {
                gc.fillText(text, this.snapPosition(textX), this.snapPosition(textY));
                break;
            }
            default: {
                gc.fillText(text, this.snapPosition(textX), this.snapPosition(textY), availableWidth);
            }
        }
    }

    protected boolean isTextVisible(String text, TextPosition position, double availableWidth) {
        return !(availableWidth < 10.0) && text != null && !((double)(text.length() * 3) > availableWidth);
    }

    protected Paint getTextFill(boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (pressed) {
            return this.getTextFillPressed();
        }
        if (highlighted) {
            return this.getTextFillHighlight();
        }
        if (hover) {
            return this.getTextFillHover();
        }
        if (selected) {
            return this.getTextFillSelected();
        }
        return this.getTextFill();
    }

    public final DoubleProperty barHeightProperty() {
        return this.barHeight;
    }

    public final double getBarHeight() {
        return this.barHeightProperty().get();
    }

    public final void setBarHeight(double height) {
        this.barHeightProperty().set(height);
    }

    public final DoubleProperty textGapProperty() {
        return this.textGap;
    }

    public final void setTextGap(double gap) {
        this.textGapProperty().set(gap);
    }

    public final double getTextGap() {
        return this.textGapProperty().get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        return this.textFill;
    }

    public final void setTextFill(Paint fill) {
        Objects.nonNull(fill);
        this.textFillProperty().set((Object)fill);
    }

    public final Paint getTextFill() {
        return (Paint)this.textFillProperty().get();
    }

    public final ObjectProperty<Paint> textFillHoverProperty() {
        return this.textFillHover;
    }

    public final void setTextFillHover(Paint fill) {
        Objects.nonNull(fill);
        this.textFillHoverProperty().set((Object)fill);
    }

    public final Paint getTextFillHover() {
        return (Paint)this.textFillHover.get();
    }

    public final ObjectProperty<Paint> textFillHighlightProperty() {
        return this.textFillHighlight;
    }

    public final void setTextFillHighlight(Paint fill) {
        Objects.nonNull(fill);
        this.textFillHighlightProperty().set((Object)fill);
    }

    public final Paint getTextFillHighlight() {
        return (Paint)this.textFillHighlightProperty().get();
    }

    public final ObjectProperty<Paint> textFillPressedProperty() {
        return this.textFillPressed;
    }

    public final void setTextFillPressed(Paint fill) {
        Objects.nonNull(fill);
        this.textFillPressedProperty().set((Object)fill);
    }

    public final Paint getTextFillPressed() {
        return (Paint)this.textFillPressedProperty().get();
    }

    public final ObjectProperty<Paint> textFillSelectedProperty() {
        return this.textFillSelected;
    }

    public final void setTextFillSelected(Paint fill) {
        Objects.nonNull(fill);
        this.textFillSelectedProperty().set((Object)fill);
    }

    public final Paint getTextFillSelected() {
        return (Paint)this.textFillSelectedProperty().get();
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font font) {
        Objects.nonNull(font);
        this.fontProperty().set((Object)font);
    }

    public final Font getFont() {
        return (Font)this.fontProperty().get();
    }

    public final BooleanProperty glossyProperty() {
        return this.glossy;
    }

    public final void setGlossy(boolean glossy) {
        this.glossyProperty().set(glossy);
    }

    public final boolean isGlossy() {
        return this.glossyProperty().get();
    }

    public final BooleanProperty autoFixTextProperty() {
        return this.autoFixText;
    }

    public final void setAutoFixText(boolean auto) {
        this.autoFixTextProperty().set(auto);
    }

    public final boolean isAutoFixText() {
        return this.autoFixTextProperty().get();
    }

    public static enum TextPosition {
        LEFT,
        CENTER,
        RIGHT,
        ABOVE,
        ABOVE_LEFT,
        ABOVE_RIGHT,
        BELOW,
        BELOW_LEFT,
        BELOW_RIGHT,
        LEADING,
        TRAILING;

    }
}

