/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

public abstract class SystemLayer<R extends Row<?, ?, ?>> {
    private final String name;
    private final GraphicsBase<R> graphicsView;
    private final InvalidationListener redrawListener = observable -> this.redraw();
    private final InvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private final ChangeListener<Boolean> fadeInOutListener = (observable, oldVisibility, newVisibility) -> {
        if (newVisibility.booleanValue()) {
            this.fade(1.0);
        } else {
            this.fade(0.0);
        }
    };
    private final ChangeListener<Boolean> weakFadeInOutListener = new WeakChangeListener(this.fadeInOutListener);
    private final BooleanProperty snapToPixel = new SimpleBooleanProperty((Object)this, "snapToPixel", true);
    private final BooleanProperty visible = new SimpleBooleanProperty((Object)this, "visible", true);
    private final ReadOnlyDoubleWrapper opacity = new ReadOnlyDoubleWrapper((Object)this, "opacity", 1.0);

    public SystemLayer(String name, GraphicsBase<R> graphicsView) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(graphicsView);
        this.name = name;
        this.graphicsView = graphicsView;
        this.redrawObservable((Observable)this.visibleProperty());
        this.redrawObservable((Observable)this.opacityProperty());
    }

    protected void redrawObservable(Observable observable) {
        Objects.requireNonNull(observable);
        observable.addListener(this.weakRedrawListener);
    }

    protected void fadeInOutObservable(ObservableBooleanValue observable) {
        Objects.requireNonNull(observable);
        observable.addListener(this.weakFadeInOutListener);
        if (!observable.get()) {
            this.opacity.set(0.0);
        }
    }

    public final GraphicsBase<R> getGraphics() {
        return this.graphicsView;
    }

    private void fade(double opacityTarget) {
        if (this.getGraphics().isFadeInOutVisibilityChanges()) {
            KeyValue keyValue = new KeyValue((WritableValue)this.opacity, (Object)opacityTarget);
            KeyFrame keyFrame = new KeyFrame(Duration.millis((double)this.getGraphics().getFadeInOutVisibilityChangesDuration()), new KeyValue[]{keyValue});
            Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
            timeline.play();
        } else {
            this.opacity.set(opacityTarget);
        }
    }

    public String getName() {
        return this.name;
    }

    public final BooleanProperty snapToPixelProperty() {
        return this.snapToPixel;
    }

    public final void setSnapToPixel(boolean snap) {
        this.snapToPixel.set(snap);
    }

    public final boolean isSnapToPixel() {
        return this.snapToPixel.get();
    }

    protected double snapPosition(double value) {
        return this.snapPosition(value, this.isSnapToPixel());
    }

    protected double snapSpace(double value) {
        return this.snapSpace(value, this.isSnapToPixel());
    }

    protected double snapSize(double value) {
        return this.snapSize(value, this.isSnapToPixel());
    }

    private double snapSpace(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) : value;
    }

    private double snapSize(double value, boolean snapToPixel) {
        return snapToPixel ? Math.ceil(value) : value;
    }

    private double snapPosition(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) + 0.5 : value;
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public final boolean isVisible() {
        return this.visibleProperty().get();
    }

    public final void setVisible(boolean visible) {
        this.visibleProperty().set(visible);
    }

    public final void redraw() {
        this.graphicsView.redraw();
    }

    public final ReadOnlyDoubleProperty opacityProperty() {
        return this.opacity.getReadOnlyProperty();
    }

    public final double getOpacity() {
        return this.opacityProperty().get();
    }

    public abstract void drawLayer(RowCanvas<R> var1, Instant var2, Instant var3);
}

