/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class LayoutLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> paddingFill = new SimpleObjectProperty((Object)this, "fill", (Object)new Color(0.0, 0.0, 0.0, 0.1));

    public LayoutLayer(GraphicsBase<R> graphics) {
        super("Layout", graphics);
        this.redrawObservable((Observable)this.paddingFill);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showLayoutLayerProperty());
    }

    public final ObjectProperty<Paint> paddingFillProperty() {
        return this.paddingFill;
    }

    public final Paint getPaddingFill() {
        return (Paint)this.paddingFill.get();
    }

    public final void setPaddingFill(Paint fill) {
        Objects.requireNonNull("fill can not be null");
        this.paddingFillProperty().set((Object)fill);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        R row = canvas.getRow();
        if (row != null) {
            double y = 0.0;
            double w = canvas.getWidth();
            double h = canvas.getHeight();
            Layout layout = ((Row)row).getLayout();
            if (layout == null) {
                throw new IllegalArgumentException("no layout returned for row " + ((Row)row).getName());
            }
            this.drawLayout(layout, canvas, y, w, h);
            int lineCount = ((Row)row).getLineCount();
            if (lineCount > 0) {
                for (int i = 0; i < lineCount; ++i) {
                    y = ((Row)row).getLineLocation(i);
                    h = ((Row)row).getLineHeight(i);
                    layout = ((Row)row).getLineLayout(i);
                    if (layout == null) {
                        throw new IllegalArgumentException("no layout returned for line " + i + " of row " + ((Row)row).getName() + ", lines manager = " + ((Row)row).getLinesManager().getClass());
                    }
                    this.drawLayout(layout, canvas, y, w, h);
                }
            }
        }
    }

    private void drawLayout(Layout layout, RowCanvas<R> canvas, double y, double w, double h) {
        double padding = layout.getPadding();
        if (padding > 0.0 && h >= 2.0 * padding) {
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.setFill(this.getPaddingFill());
            gc.fillRect(0.0, y, w, padding);
            gc.fillRect(0.0, y + h - padding + 1.0, w, padding);
        }
    }
}

