/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class GridLinesLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> lineStroke1 = new SimpleObjectProperty((Object)this, "lineStroke1");
    private final ObjectProperty<Paint> lineStroke2 = new SimpleObjectProperty((Object)this, "lineStroke2");
    private final ObjectProperty<Paint> lineStroke3 = new SimpleObjectProperty((Object)this, "lineStroke3");
    private final DoubleProperty lineWidth1 = new SimpleDoubleProperty((Object)this, "lineWidth1");
    private final DoubleProperty lineWidth2 = new SimpleDoubleProperty((Object)this, "lineWidth2");
    private final DoubleProperty lineWidth3 = new SimpleDoubleProperty((Object)this, "lineWidth3");

    public GridLinesLayer(GraphicsBase<R> graphics) {
        super("Grid Lines", graphics);
        this.lineStroke1.bindBidirectional(graphics.gridLineColor1Property());
        this.lineStroke2.bindBidirectional(graphics.gridLineColor2Property());
        this.lineStroke3.bindBidirectional(graphics.gridLineColor3Property());
        this.setLineWidth1(0.5);
        this.setLineWidth2(0.5);
        this.setLineWidth3(0.5);
        this.redrawObservable((Observable)this.lineStroke1);
        this.redrawObservable((Observable)this.lineStroke2);
        this.redrawObservable((Observable)this.lineStroke3);
        this.redrawObservable((Observable)this.lineWidth1);
        this.redrawObservable((Observable)this.lineWidth2);
        this.redrawObservable((Observable)this.lineWidth3);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showGridLineLayerProperty());
    }

    public final ObjectProperty<Paint> lineStroke1Property() {
        return this.lineStroke1;
    }

    public final Paint getLineStroke1() {
        return (Paint)this.lineStroke1.get();
    }

    public final void setLineStroke1(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.lineStroke1.set((Object)stroke);
    }

    public final ObjectProperty<Paint> lineStroke2Property() {
        return this.lineStroke2;
    }

    public final Paint getLineStroke2() {
        return (Paint)this.lineStroke2.get();
    }

    public final void setLineStroke2(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.lineStroke2.set((Object)stroke);
    }

    public final ObjectProperty<Paint> lineStroke3Property() {
        return this.lineStroke3;
    }

    public final Paint getLineStroke3() {
        return (Paint)this.lineStroke3.get();
    }

    public final void setLineStroke3(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.lineStroke3.set((Object)stroke);
    }

    public final DoubleProperty lineWidth1Property() {
        return this.lineWidth1;
    }

    public final double getLineWidth1() {
        return this.lineWidth1.get();
    }

    public final void setLineWidth1(double width) {
        this.lineWidth1.set(width);
    }

    public final DoubleProperty lineWidth2Property() {
        return this.lineWidth2;
    }

    public final double getLineWidth2() {
        return this.lineWidth2.get();
    }

    public final void setLineWidth2(double width) {
        this.lineWidth2.set(width);
    }

    public final DoubleProperty lineWidth3Property() {
        return this.lineWidth3;
    }

    public final double getLineWidth3() {
        return this.lineWidth3.get();
    }

    public final void setLineWidth3(double width) {
        this.lineWidth3.set(width);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        Dateline dateline = canvas.getGraphics().getTimeline().getDateline();
        DayOfWeek firstDayOfWeek = dateline.getFirstDayOfWeek();
        TimelineModel<?> timelineModel = canvas.getTimelineModel();
        GraphicsContext gc = canvas.getGraphicsContext2D();
        ZoneId zoneId = dateline.getZoneId();
        R row = canvas.getRow();
        if (row != null) {
            zoneId = ((Row)row).getZoneId();
        }
        double height = canvas.getHeight();
        double width = canvas.getWidth();
        int maxGridLevel = canvas.getGraphics().getMaxGridLevel();
        int counter = 0;
        for (Resolution resolution : this.getGraphics().getTimeline().getDateline().getScaleResolutions()) {
            switch (counter) {
                case 0: {
                    gc.setStroke(this.getLineStroke1());
                    gc.setLineWidth(this.getLineWidth1());
                    break;
                }
                case 1: {
                    gc.setStroke(this.getLineStroke2());
                    gc.setLineWidth(this.getLineWidth2());
                    break;
                }
                default: {
                    gc.setStroke(this.getLineStroke3());
                    gc.setLineWidth(this.getLineWidth3());
                }
            }
            Instant time = resolution.truncate(startTime, zoneId, firstDayOfWeek);
            double x = this.snapPosition(timelineModel.calculateLocationForTime(time));
            do {
                gc.strokeLine(x, 0.0, x, height);
            } while ((x = this.snapPosition(timelineModel.calculateLocationForTime(time = resolution.increment(time, zoneId)))) < width);
            if (++counter < maxGridLevel) continue;
            break;
        }
    }
}

