/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.zone.ZoneOffsetTransition;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class DSTLineLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> stroke = new SimpleObjectProperty((Object)this, "stroke");
    private final DoubleProperty lineWidth = new SimpleDoubleProperty((Object)this, "lineWidth");

    public DSTLineLayer(GraphicsBase<R> graphics) {
        super("DST Line", graphics);
        this.setStroke((Paint)Color.DARKORANGE);
        this.setLineWidth(2.5);
        this.redrawObservable((Observable)this.strokeProperty());
        this.redrawObservable((Observable)this.lineWidthProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showDSTLineLayerProperty());
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.stroke;
    }

    public final Paint getStroke() {
        return (Paint)this.strokeProperty().get();
    }

    public final void setStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.strokeProperty().set((Object)stroke);
    }

    public final DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public final double getLineWidth() {
        return this.lineWidthProperty().get();
    }

    public final void setLineWidth(double lineWidth) {
        this.lineWidthProperty().set(lineWidth);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        ZoneOffsetTransition transition;
        R row;
        ZoneId zoneId;
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setStroke(this.getStroke());
        gc.setLineWidth(this.getLineWidth());
        TimelineModel<?> model = canvas.getTimelineModel();
        Instant now = model.getNow();
        Timeline timeline = canvas.getGraphics().getTimeline();
        Dateline dateline = timeline.getDateline();
        TemporalUnit unit = dateline.getPrimaryTemporalUnit();
        if (unit != null && (unit.equals(ChronoUnit.HOURS) || unit.equals(ChronoUnit.MINUTES)) && (zoneId = (row = canvas.getRow()) != null ? ((Row)row).getZoneId() : dateline.getZoneId()) != null && (transition = zoneId.getRules().nextTransition(startTime)) != null) {
            double location = this.snapPosition(model.calculateLocationForTime(transition.getInstant()));
            gc.strokeLine(location, 0.0, location, canvas.getHeight());
        }
    }
}

