/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.calendar.CalendarActivity;
import com.flexganttfx.model.calendar.CalendarActivityBase;
import com.flexganttfx.model.calendar.MutableCalendarActivityBase;
import com.flexganttfx.model.calendar.WeekendCalendarActivity;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.graphics.renderer.CalendarActivityRenderer;
import com.flexganttfx.view.graphics.renderer.WeekendCalendarActivityRenderer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.canvas.GraphicsContext;

public class CalendarLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObservableMap<Class<?>, CalendarActivityRenderer<?>> calendarRendererMap = FXCollections.observableHashMap();

    public CalendarLayer(GraphicsBase<R> graphics) {
        super("Calendar", graphics);
        this.setCalendarActivityRenderer(CalendarActivityBase.class, new CalendarActivityRenderer(graphics, "Calendars"));
        this.setCalendarActivityRenderer(MutableCalendarActivityBase.class, new CalendarActivityRenderer(graphics, "Mutable Calendars"));
        this.setCalendarActivityRenderer(WeekendCalendarActivity.class, new WeekendCalendarActivityRenderer(graphics, "Weekends"));
        this.redrawObservable((Observable)this.calendarRendererMap);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showCalendarLayerProperty());
        this.calendarRendererMap.addListener(evt -> graphics.updatePropertySheet());
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        R row = canvas.getRow();
        TimelineModel<?> timelineModel = canvas.getTimelineModel();
        double height = canvas.getHeight();
        GraphicsBase<R> graphicsView = canvas.getGraphics();
        Object calendars = graphicsView.getCalendars();
        this.drawCalendars((Row<?, ?, ?>)row, canvas, timelineModel, (ObservableList<Calendar<?>>)calendars, height, startTime, endTime);
        if (row != null) {
            calendars = ((Row)row).getCalendars();
            this.drawCalendars((Row<?, ?, ?>)row, canvas, timelineModel, (ObservableList<Calendar<?>>)calendars, height, startTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCalendars(Row<?, ?, ?> row, RowCanvas canvas, TimelineModel<?> timelineModel, ObservableList<Calendar<?>> calendars, double height, Instant startTime, Instant endTime) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        GraphicsBase graphics = canvas.getGraphics();
        Dateline dateline = graphics.getTimeline().getDateline();
        ZoneId zoneId = dateline.getZoneId();
        if (row != null) {
            zoneId = row.getZoneId();
        }
        TemporalUnit temporalUnit = dateline.getPrimaryTemporalUnit();
        for (Calendar calendar : calendars) {
            if (!calendar.visibleProperty().get()) continue;
            Iterator entries = calendar.getActivities(null, startTime, endTime, temporalUnit, zoneId);
            while (entries.hasNext()) {
                CalendarActivity activity = (CalendarActivity)entries.next();
                double x1 = this.snapPosition(timelineModel.calculateLocationForTime(activity.getStartTime()));
                double x2 = this.snapPosition(timelineModel.calculateLocationForTime(activity.getEndTime()));
                CalendarActivityRenderer<?> renderer = this.getCalendarActivityRenderer(activity.getClass());
                if (renderer == null || !renderer.isEnabled()) continue;
                double alpha = gc.getGlobalAlpha();
                try {
                    if (graphics.isSafeRendering()) {
                        gc.save();
                    }
                    gc.setGlobalAlpha(alpha * renderer.getAlpha());
                    renderer.draw(new ActivityRef<CalendarActivity>(row, null, activity), Position.ONLY, gc, x1, 0.0, x2 - x1, height, false, false, false, false);
                }
                finally {
                    if (graphics.isSafeRendering()) {
                        gc.restore();
                        continue;
                    }
                    gc.setGlobalAlpha(alpha);
                }
            }
        }
    }

    public final <A extends Activity> void setCalendarActivityRenderer(Class<? extends A> clazz, CalendarActivityRenderer<? extends A> renderer) {
        Objects.requireNonNull(clazz);
        if (renderer != null) {
            LoggingDomain.CONFIG.fine("class = " + clazz + ", policy = " + renderer.getClass().getName());
        } else {
            LoggingDomain.CONFIG.fine("class = " + clazz + ", policy = null");
        }
        this.calendarRendererMap.put(clazz, renderer);
    }

    public final <A extends CalendarActivity> CalendarActivityRenderer<? extends A> getCalendarActivityRenderer(Class<? extends A> clazz) {
        Objects.requireNonNull(clazz);
        return this.doGetCalendarActivityRenderer((Map<Class<?>, ? extends CalendarActivityRenderer<?>>)this.calendarRendererMap, clazz);
    }

    private <A extends CalendarActivity> CalendarActivityRenderer<A> doGetCalendarActivityRenderer(Map<Class<?>, ? extends CalendarActivityRenderer<?>> map, Class<?> clazz) {
        if (clazz != null) {
            CalendarActivityRenderer<?> renderer = map.get(clazz);
            if (renderer == null) {
                return this.doGetCalendarActivityRenderer(map, clazz.getSuperclass());
            }
            return renderer;
        }
        return null;
    }
}

