/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.com.flexganttfx.skin.graphics.ListViewGraphicsSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ListViewGraphics<R extends Row<?, ?, ?>>
extends GraphicsBase<R> {
    private final ListView<R> listView;
    private final DoubleProperty autoscrollProximity = new SimpleDoubleProperty((Object)this, "autoscrollProximity", 20.0);
    private final DoubleProperty scrollValue = new SimpleDoubleProperty((Object)this, "scrollValue", 24.0){

        public void set(double newValue) {
            if (newValue < 1.0) {
                throw new IllegalArgumentException("scroll value must be larger than or equal to 0 but was " + newValue);
            }
            super.set(newValue);
        }
    };

    public ListViewGraphics() {
        this.getStyleClass().add((Object)"list-view-graphics");
        this.listView = this.createListView();
        this.listView.getStyleClass().add((Object)"graphics-list-view");
        this.listView.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.UP) {
                this.scrollUp();
                e.consume();
            } else if (e.getCode() == KeyCode.DOWN) {
                this.scrollDown();
                e.consume();
            }
        });
        this.setPrefSize(700.0, 350.0);
    }

    protected Skin<?> createDefaultSkin() {
        return new ListViewGraphicsSkin(this);
    }

    public final ListView<R> getListView() {
        return this.listView;
    }

    protected ListView<R> createListView() {
        return new ListView();
    }

    public final DoubleProperty autoscrollProximityProperty() {
        return this.autoscrollProximity;
    }

    public final double getAutoscrollProximity() {
        return this.autoscrollProximityProperty().get();
    }

    public final void setAutoscrollProximity(double value) {
        this.autoscrollProximityProperty().set(value);
    }

    public final DoubleProperty scrollValueProperty() {
        return this.scrollValue;
    }

    public final double getScrollValue() {
        return this.scrollValueProperty().get();
    }

    public final void setScrollValue(double pixels) {
        this.scrollValueProperty().set(pixels);
    }

    public final void scrollUp() {
        this.getVirtualFlow().adjustPixels(-this.getScrollValue());
    }

    public final void scrollDown() {
        this.getVirtualFlow().adjustPixels(this.getScrollValue());
    }

    private VirtualFlow<?> getVirtualFlow() {
        return (VirtualFlow)this.lookup("VirtualFlow");
    }
}

