/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.ActivityBase;
import com.flexganttfx.model.activity.ChartActivity;
import com.flexganttfx.model.activity.ChartActivityBase;
import com.flexganttfx.model.activity.CompletableActivity;
import com.flexganttfx.model.activity.CompletableActivityBase;
import com.flexganttfx.model.activity.MutableActivity;
import com.flexganttfx.model.activity.MutableActivityBase;
import com.flexganttfx.model.activity.MutableChartActivityBase;
import com.flexganttfx.model.activity.MutableCompletableActivityBase;
import com.flexganttfx.model.activity.MutableHighLowChartActivityBase;
import com.flexganttfx.model.calendar.CalendarActivity;
import com.flexganttfx.model.calendar.CalendarActivityBase;
import com.flexganttfx.model.calendar.WeekendCalendar;
import com.flexganttfx.model.dateline.ChronoUnitGrid;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.repository.RepositoryEvent;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.LassoEvent;
import com.flexganttfx.view.graphics.layer.AgendaLinesLayer;
import com.flexganttfx.view.graphics.layer.CalendarLayer;
import com.flexganttfx.view.graphics.layer.ChartLinesLayer;
import com.flexganttfx.view.graphics.layer.DSTLineLayer;
import com.flexganttfx.view.graphics.layer.GridLinesLayer;
import com.flexganttfx.view.graphics.layer.HoverTimeIntervalLayer;
import com.flexganttfx.view.graphics.layer.InnerLinesLayer;
import com.flexganttfx.view.graphics.layer.LayoutLayer;
import com.flexganttfx.view.graphics.layer.NowLineLayer;
import com.flexganttfx.view.graphics.layer.RowLayer;
import com.flexganttfx.view.graphics.layer.ScaleLayer;
import com.flexganttfx.view.graphics.layer.SelectedTimeIntervalsLayer;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.graphics.layer.ZoomTimeIntervalLayer;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.graphics.renderer.ChartActivityRenderer;
import com.flexganttfx.view.graphics.renderer.CompletableActivityRenderer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.util.FlexGanttFXControl;
import com.flexganttfx.view.util.Messages;
import com.flexganttfx.view.util.Position;
import com.sun.javafx.css.converters.PaintConverter;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.LinksPane;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;

public abstract class GraphicsBase<R extends Row<?, ?, ?>>
extends FlexGanttFXControl {
    private static final String DEFAULT_STYLE_CLASS = "graphics";
    private Instant zoomTime;
    private final ObjectProperty<Predicate<R>> rowFilter = new SimpleObjectProperty((Object)this, "rowFilter", row -> true);
    private final ObjectProperty<Predicate<Activity>> activityFilter = new SimpleObjectProperty((Object)this, "activityFilter");
    private final BooleanProperty lassoEnabled = new SimpleBooleanProperty((Object)this, "lassoEnabled", true);
    private final BooleanProperty automaticRedraw = new SimpleBooleanProperty((Object)this, "automaticRedraw", true);
    private final InvalidationListener updatePropertySheetListener = observable -> this.updatePropertySheet();
    private final WeakInvalidationListener weakUpdatePropertySheetListener = new WeakInvalidationListener(this.updatePropertySheetListener);
    private final EventHandler<RepositoryEvent> repositoryListener = evt -> {
        if (this.isAutomaticRedraw()) {
            this.redraw();
        }
    };
    private final WeakEventHandler<RepositoryEvent> weakRepositoryListener = new WeakEventHandler(this.repositoryListener);
    private final InvalidationListener redrawListener = observable -> {
        if (observable instanceof ReadOnlyProperty && LoggingDomain.RENDERING.isLoggable(Level.FINE)) {
            LoggingDomain.RENDERING.fine("redraw because of property change, property = " + ((ReadOnlyProperty)observable).getName());
        }
        this.redraw();
    };
    private final WeakInvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private final ChangeListener<Instant> redrawNowListener = new ChangeListener<Instant>(){

        public void changed(ObservableValue<? extends Instant> observable, Instant oldNow, Instant newNow) {
            Instant visibleStart = GraphicsBase.this.getTimeline().getVisibleStartTime();
            Instant visibleEnd = GraphicsBase.this.getTimeline().getVisibleEndTime();
            if (visibleStart != null && visibleEnd != null && (this.inRange(oldNow, visibleStart, visibleEnd) || this.inRange(newNow, visibleStart, visibleEnd))) {
                GraphicsBase.this.redraw();
            }
        }

        private boolean inRange(Instant time, Instant visibleStart, Instant visibleEnd) {
            return visibleStart.equals(time) || visibleEnd.equals(time) || visibleStart.isBefore(time) && visibleEnd.isAfter(time);
        }
    };
    private final WeakChangeListener<Instant> weakRedrawNowListener = new WeakChangeListener(this.redrawNowListener);
    private final ReadOnlyBooleanWrapper lassoActive = new ReadOnlyBooleanWrapper((Object)this, "lassoActive", false);
    private final BooleanProperty lassoSnapsToGrid = new SimpleBooleanProperty((Object)this, "lassoSnapsToGrid", false);
    private final LayerVisibilityListener layerVisibilityListener = new LayerVisibilityListener();
    private final WeakChangeListener<Boolean> weakLayerVisibilityListener = new WeakChangeListener((ChangeListener)this.layerVisibilityListener);
    private final ObservableList<ActivityLink<?>> links = FXCollections.observableArrayList();
    private final ObservableList<Layer> layers = FXCollections.observableArrayList();
    private final ListProperty<R> rows = new SimpleListProperty((Object)this, "rows", FXCollections.observableArrayList());
    private final ObjectProperty<com.flexganttfx.view.timeline.Timeline> timeline = new SimpleObjectProperty((Object)this, "timeline");
    private final DoubleProperty fixedCellSize = new SimpleDoubleProperty((Object)this, "fixedCellSize", -1.0);
    private ActivityEventHandlerProperty onActivityDeleted;
    private ActivityEventHandlerProperty onActivityChange;
    private ActivityEventHandlerProperty onActivityChangeStarted;
    private ActivityEventHandlerProperty onActivityChangeOngoing;
    private ActivityEventHandlerProperty onActivityChangeFinished;
    private ActivityEventHandlerProperty onActivityDragStarted;
    private ActivityEventHandlerProperty onActivityDragOngoing;
    private ActivityEventHandlerProperty onActivityDragFinished;
    private ActivityEventHandlerProperty onActivityDragDone;
    private ActivityEventHandlerProperty onActivityChartValueChangeStarted;
    private ActivityEventHandlerProperty onActivityChartValueChangeOngoing;
    private ActivityEventHandlerProperty onActivityChartValueChangeFinished;
    private ActivityEventHandlerProperty onActivityChartHighValueChangeStarted;
    private ActivityEventHandlerProperty onActivityChartHighValueChangeOngoing;
    private ActivityEventHandlerProperty onActivityChartHighValueChangeFinished;
    private ActivityEventHandlerProperty onActivityChartLowValueChangeStarted;
    private ActivityEventHandlerProperty onActivityChartLowValueChangeOngoing;
    private ActivityEventHandlerProperty onActivityChartLowValueChangeFinished;
    private ActivityEventHandlerProperty onActivityHorizontalDragStarted;
    private ActivityEventHandlerProperty onActivityHorizontalDragOngoing;
    private ActivityEventHandlerProperty onActivityHorizontalDragFinished;
    private ActivityEventHandlerProperty onActivityVerticalDragStarted;
    private ActivityEventHandlerProperty onActivityVerticalDragOngoing;
    private ActivityEventHandlerProperty onActivityVerticalDragFinished;
    private ActivityEventHandlerProperty onActivityVerticalDragDone;
    private ActivityEventHandlerProperty onActivityEndTimeChangeStarted;
    private ActivityEventHandlerProperty onActivityEndTimeChangeOngoing;
    private ActivityEventHandlerProperty onActivityEndTimeChangeFinished;
    private ActivityEventHandlerProperty onActivityPercentageChangeStarted;
    private ActivityEventHandlerProperty onActivityPercentageChangeOngoing;
    private ActivityEventHandlerProperty onActivityPercentageChangeFinished;
    private ActivityEventHandlerProperty onActivityStartTimeChangeStarted;
    private ActivityEventHandlerProperty onActivityStartTimeChangeOngoing;
    private ActivityEventHandlerProperty onActivityStartTimeChangeFinished;
    private LassoEventHandlerProperty onLassoSelection;
    private LassoEventHandlerProperty onLassoSelectionStarted;
    private LassoEventHandlerProperty onLassoSelectionOngoing;
    private LassoEventHandlerProperty onLassoSelectionFinished;
    private final ReadOnlyObjectWrapper<EditMode> editMode = new ReadOnlyObjectWrapper((Object)this, "editMode", (Object)EditMode.NONE);
    private final ObservableSet<Row<?, ?, ?>> highlightedRows = FXCollections.observableSet((Object[])new Row[0]);
    private final ObservableSet<ActivityRef<?>> highlightedActivities = FXCollections.observableSet((Object[])new ActivityRef[0]);
    private final LongProperty highlightDelay = new SimpleLongProperty((Object)this, "highlightDelay", 500L);
    private final ReadOnlyBooleanWrapper highlighted = new ReadOnlyBooleanWrapper((Object)this, "highlighted", false);
    private HighlightThread highlightThread;
    private final ObjectProperty<Callback<ContextMenuParameter<R>, ContextMenu>> contextMenuCallback = new SimpleObjectProperty((Object)this, "contextMenuCallback");
    private final IntegerProperty extraPixels = new SimpleIntegerProperty((Object)this, "extraPixels", 20);
    private final BooleanProperty autoMarkedTimeInterval = new SimpleBooleanProperty((Object)this, "autoMarkedTimeInterval", true);
    private final IntegerProperty maxGridLevel = new SimpleIntegerProperty((Object)this, "maxGridLevel", 2);
    private final BooleanProperty showVerticalCursor = new SimpleBooleanProperty((Object)this, "showVerticalCursor", false);
    private final BooleanProperty showHorizontalCursor = new SimpleBooleanProperty((Object)this, "showHorizontalCursor", false);
    private final BooleanProperty showMarkedTimeInterval = new SimpleBooleanProperty((Object)this, "showMarkedTimeInterval", true);
    private final BooleanProperty debugMode = new SimpleBooleanProperty((Object)this, "debugMode", false);
    private final BooleanProperty autoGridEnabled = new SimpleBooleanProperty((Object)this, "autoGrid", false);
    private final ReadOnlyBooleanWrapper gridEnabled = new ReadOnlyBooleanWrapper((Object)this, "gridEnabled");
    private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.MULTIPLE);
    private final ObservableList<ActivityRef<?>> selectedActivities = FXCollections.observableArrayList();
    private final ObjectProperty<LassoSelectionBehaviour> lassoSelectionBehaviour = new SimpleObjectProperty((Object)this, "selectionBehaviour", (Object)LassoSelectionBehaviour.INTERSECTION);
    private final ObservableList<Calendar<? extends CalendarActivity>> calendars = FXCollections.observableArrayList();
    private final ReadOnlyObjectWrapper<ActivityRef<?>> hoverActivity = new ReadOnlyObjectWrapper((Object)this, "hoverActivity");
    private final ReadOnlyObjectWrapper<R> hoverRow = new ReadOnlyObjectWrapper((Object)this, "hoverRow");
    private final ReadOnlyObjectWrapper<Layout> hoverLayout = new ReadOnlyObjectWrapper((Object)this, "hoverLayout");
    private final ReadOnlyObjectWrapper<ActivityRef<?>> editedActivity = new ReadOnlyObjectWrapper((Object)this, "editedActivity");
    private final ReadOnlyObjectWrapper<ActivityRef<?>> pressedActivity = new ReadOnlyObjectWrapper((Object)this, "pressedActivity");
    private final ObjectProperty<VirtualGrid<?>> virtualGrid = new SimpleObjectProperty((Object)this, "virtualGrid");
    private final ObservableList<VirtualGrid<?>> virtualGrids = FXCollections.observableArrayList();
    private final ObjectProperty<Node> placeholder = new SimpleObjectProperty((Object)this, "node");
    private final ObservableList<RowPane<R>> rowPanes = FXCollections.observableArrayList();
    private LinksPane<R> linksPane;
    private final ObservableMap<Class<? extends Layout>, ObservableMap<Class<?>, ActivityRenderer<?>>> rendererLayoutMap = FXCollections.observableHashMap();
    private final ObservableMap<Class<? extends Layout>, ObservableMap<Class<?>, ActivityRenderer<?>>> cachedRendererMap = FXCollections.observableHashMap();
    private final ActivityRenderer<?> defaultGanttActivityRenderer = new ChartActivityRenderer(this, "Default Gantt Activity Renderer");
    private final ActivityRenderer<?> defaultChartActivityRenderer = new ChartActivityRenderer(this, "Default Chart Activity Renderer");
    private final ActivityRenderer<?> defaultAgendaActivityRenderer = new ChartActivityRenderer(this, "Default Agenda Activity Renderer");
    private final ObservableMap<Class<?>, Callback<EditingCallbackParameter, Boolean>> activityEditingCallbackMap = FXCollections.observableHashMap();
    private final ObservableMap<Class<?>, Callback<DragAndDropInfo, Boolean>> dragAndDropCallbackMap = FXCollections.observableHashMap();
    private final ReadOnlyObjectWrapper<DragAndDropInfo> dragAndDropInfo = new ReadOnlyObjectWrapper((Object)this, "dragAndDropInfo");
    private final ObjectProperty<Callback<ActivityRef<?>, Image>> dragImageProvider = new SimpleObjectProperty((Object)this, "dragImageProvider");
    private final ObservableList<SystemLayer<R>> backgroundLayers = FXCollections.observableArrayList();
    private final ObservableList<SystemLayer<R>> foregroundLayers = FXCollections.observableArrayList();
    private final BooleanProperty showAgendaLinesLayer = new SimpleBooleanProperty((Object)this, "showAgendaLinesLayer", true);
    private final BooleanProperty showCalendarLayer = new SimpleBooleanProperty((Object)this, "showCalendarLayer", true);
    private final BooleanProperty showLayoutLayer = new SimpleBooleanProperty((Object)this, "showLayoutLayer", true);
    private final BooleanProperty showChartLinesLayer = new SimpleBooleanProperty((Object)this, "showChartLinesLayer", true);
    private final BooleanProperty showGridLineLayer = new SimpleBooleanProperty((Object)this, "showGridLineLayer", true);
    private final BooleanProperty showHoverTimeIntervalLayer = new SimpleBooleanProperty((Object)this, "showHoverTimeIntervalLayer", true);
    private final BooleanProperty showInnerLinesLayer = new SimpleBooleanProperty((Object)this, "showInnerLinesLayer", true);
    private final BooleanProperty showNowLineLayer = new SimpleBooleanProperty((Object)this, "showNowLineLayer", true);
    private final BooleanProperty showDSTLineLayer = new SimpleBooleanProperty((Object)this, "showDSTLineLayer", true);
    private final BooleanProperty showRowLayer = new SimpleBooleanProperty((Object)this, "showRowLayer", true);
    private final BooleanProperty showScaleLayer = new SimpleBooleanProperty((Object)this, "showScaleLayer", false);
    private final BooleanProperty showSelectedTimeIntervalsLayer = new SimpleBooleanProperty((Object)this, "showSelectedTimeIntervals", true);
    private final BooleanProperty showZoomTimeIntervalLayer = new SimpleBooleanProperty((Object)this, "showZoomTimeIntervalLayer", true);
    private final BooleanProperty showZoneId = new SimpleBooleanProperty((Object)this, "showZoneId", false);
    private final BooleanProperty fadeInOutVisibilityChanges = new SimpleBooleanProperty((Object)this, "fadeInOutVisibilityChanges", true);
    private final DoubleProperty fadeInOutVisibilityChangesDuration = new SimpleDoubleProperty((Object)this, "fadeInOutVisibilityChangesDuration", 200.0);
    private final ObjectProperty<DragAndDropFeedback> dragAndDropFeedback = new SimpleObjectProperty((Object)this, "dragAndDropFeedback", (Object)DragAndDropFeedback.RENDERED);
    private final ObjectProperty<Callback<RowControlsParameter<R>, Node>> rowControlsFactory = new SimpleObjectProperty((Object)this, "rowControls");
    private final ObjectProperty<Callback<RowEditorParameter<R>, Node>> rowEditorFactory = new SimpleObjectProperty((Object)this, "rowEditor", param -> null);
    private final ObjectProperty<RowEditingMode> rowEditingMode = new SimpleObjectProperty((Object)this, "rowEditingMode", (Object)RowEditingMode.SINGLE_ROW);
    private final ObservableList<R> rowsEditing = FXCollections.observableArrayList();
    private final BooleanProperty animateRowEditor = new SimpleBooleanProperty((Object)this, "animateRowEditor", true);
    private final ObservableMap<Class<? extends Layout>, ObservableMap<Class<?>, Callback<EditModeCallbackParameter, EditMode>>> editModeCallbackMap = FXCollections.observableHashMap();
    private final ObjectProperty<Callback<DragAndDropInfo, Layer>> dropLayerProvider = new SimpleObjectProperty((Object)this, "dropLayerProvider", info -> info.getActivityRef().getLayer());
    private final BooleanProperty horizontalDragEnabled = new SimpleBooleanProperty((Object)this, "horizontalDragEnabled", true);
    private BooleanProperty safeRendering;
    private boolean _safeRendering = false;
    private StyleableObjectProperty<Paint> gridLineColor1;
    private StyleableObjectProperty<Paint> gridLineColor2;
    private StyleableObjectProperty<Paint> gridLineColor3;
    private StyleableObjectProperty<Paint> weekendColor;
    private StyleableObjectProperty<Paint> timeNowColor;
    private StyleableObjectProperty<Paint> innerLinesColor;

    public GraphicsBase() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        ObservableList<VirtualGrid<?>> grids = this.getVirtualGrids();
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_1"), ChronoUnit.MINUTES, 1));
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_5"), ChronoUnit.MINUTES, 5));
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_10"), ChronoUnit.MINUTES, 10));
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_15"), ChronoUnit.MINUTES, 15));
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_30"), ChronoUnit.MINUTES, 30));
        grids.add((Object)new ChronoUnitGrid(Messages.getString("GraphicsBase.GRID_MINUTES_60"), ChronoUnit.MINUTES, 60));
        this.timeline.addListener(evt -> this.connectToTimeline());
        this.addEventHandler(ZoomEvent.ZOOM_STARTED, event -> {
            com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
            TimelineModel<?> model = timeline.getModel();
            this.zoomTime = model.calculateTimeForLocation(event.getX());
        });
        this.addEventHandler(ZoomEvent.ZOOM, event -> {
            com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
            timeline.zoom(Math.abs(event.getZoomFactor() - 1.0), event.getZoomFactor() > 1.0, this.zoomTime);
        });
        this.addEventFilter(ScrollEvent.SCROLL, event -> {
            if (event.isShortcutDown()) {
                com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
                TimelineModel<?> model = timeline.getModel();
                this.zoomTime = model.calculateTimeForLocation(event.getX());
                timeline.zoom(0.1, event.getDeltaY() > 0.0, this.zoomTime);
                event.consume();
            } else if (event.isShiftDown()) {
                com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
                TimelineModel<?> model = timeline.getModel();
                Instant newTime = model.getStartTime();
                if (event.getDeltaY() < 0.0) {
                    newTime = model.calculateTimeForLocation(20.0);
                } else if (event.getDeltaY() > 0.0) {
                    newTime = model.calculateTimeForLocation(-20.0);
                }
                boolean animated = timeline.isMoveAnimated();
                timeline.setMoveAnimated(false);
                timeline.showTime(newTime);
                timeline.setMoveAnimated(animated);
                event.consume();
            }
        });
        this.debugModeProperty().addListener((InvalidationListener)this.weakRedrawListener);
        this.selectionModeProperty().addListener(observable -> this.getSelectedActivities().clear());
        this.setContextMenuCallback(x$0 -> new GraphicsViewMenu(x$0));
        this.setActivityRenderer(ActivityBase.class, GanttLayout.class, new ActivityRenderer(this, "Activities (Gantt Layout)"));
        this.setActivityRenderer(CompletableActivityBase.class, GanttLayout.class, new CompletableActivityRenderer(this, "Completable Activity (Gantt Layout)"));
        this.setActivityRenderer(CalendarActivityBase.class, GanttLayout.class, new ActivityRenderer(this, "Calendars (Gantt Layout)"));
        this.setActivityRenderer(ActivityBase.class, ChartLayout.class, new ActivityRenderer(this, "Activities (Chart Layout)"));
        this.setActivityRenderer(CompletableActivityBase.class, ChartLayout.class, new CompletableActivityRenderer(this, "Completable Activity (Chart Layout)"));
        this.setActivityRenderer(ChartActivityBase.class, ChartLayout.class, new ChartActivityRenderer(this, "Chart Activity (Chart Layout)"));
        this.setActivityRenderer(CalendarActivityBase.class, ChartLayout.class, new ActivityRenderer(this, "Calendars (Chart Layout)"));
        this.setActivityRenderer(MutableActivityBase.class, AgendaLayout.class, new ActivityRenderer(this, "Activities (Agenda Layout)"));
        this.setEditModeCallback(MutableActivityBase.class, GanttLayout.class, new ActivityEditModeCallback());
        this.setEditModeCallback(MutableChartActivityBase.class, GanttLayout.class, new ActivityEditModeCallback());
        this.setEditModeCallback(MutableHighLowChartActivityBase.class, GanttLayout.class, new ActivityEditModeCallback());
        this.setEditModeCallback(MutableCompletableActivityBase.class, GanttLayout.class, new CompletableActivityEditModeCallback());
        this.setEditModeCallback(MutableActivityBase.class, ChartLayout.class, new ActivityEditModeCallback());
        this.setEditModeCallback(MutableCompletableActivityBase.class, ChartLayout.class, new CompletableActivityEditModeCallback());
        this.setEditModeCallback(MutableChartActivityBase.class, ChartLayout.class, new ChartActivityEditModeCallback());
        this.setEditModeCallback(MutableHighLowChartActivityBase.class, ChartLayout.class, new ChartHighLowEditModeCallback());
        this.setEditModeCallback(MutableActivityBase.class, AgendaLayout.class, new ActivityInAgendaLayoutEditModeCallback());
        this.setActivityEditingCallback(MutableActivityBase.class, (Callback<EditingCallbackParameter, Boolean>)((Callback)input -> true));
        this.setActivityEditingCallback(MutableChartActivityBase.class, (Callback<EditingCallbackParameter, Boolean>)((Callback)input -> true));
        this.setActivityEditingCallback(MutableCompletableActivityBase.class, (Callback<EditingCallbackParameter, Boolean>)((Callback)input -> true));
        this.setRowDragAndDropCallback(Row.class, (Callback<DragAndDropInfo, Boolean>)((Callback)param -> true));
        this.rendererLayoutMap.addListener((InvalidationListener)this.weakRedrawListener);
        this.rendererLayoutMap.addListener((InvalidationListener)this.weakUpdatePropertySheetListener);
        this.getBackgroundSystemLayers().add(new RowLayer(this));
        this.getBackgroundSystemLayers().add(new CalendarLayer(this));
        this.getBackgroundSystemLayers().add(new ChartLinesLayer(this));
        this.getBackgroundSystemLayers().add(new AgendaLinesLayer(this));
        this.getBackgroundSystemLayers().add(new InnerLinesLayer(this));
        this.getForegroundSystemLayers().add(new NowLineLayer(this));
        this.getBackgroundSystemLayers().add(new HoverTimeIntervalLayer(this));
        this.getBackgroundSystemLayers().add(new SelectedTimeIntervalsLayer(this));
        this.getBackgroundSystemLayers().add(new ZoomTimeIntervalLayer(this));
        this.getBackgroundSystemLayers().add(new GridLinesLayer(this));
        this.getBackgroundSystemLayers().add(new DSTLineLayer(this));
        this.getBackgroundSystemLayers().addListener((InvalidationListener)this.weakRedrawListener);
        this.getForegroundSystemLayers().add(new LayoutLayer(this));
        this.getForegroundSystemLayers().add(new ScaleLayer(this));
        this.getForegroundSystemLayers().addListener((InvalidationListener)this.weakRedrawListener);
        this.redrawObservable((Observable)this.showGridLineLayer);
        this.redrawObservable((Observable)this.showNowLineLayer);
        this.redrawObservable((Observable)this.showCalendarLayer);
        this.redrawObservable((Observable)this.showInnerLinesLayer);
        this.redrawObservable((Observable)this.showHoverTimeIntervalLayer);
        this.redrawObservable((Observable)this.showSelectedTimeIntervalsLayer);
        this.redrawObservable((Observable)this.showZoomTimeIntervalLayer);
        this.redrawObservable((Observable)this.showAgendaLinesLayer);
        this.redrawObservable((Observable)this.showChartLinesLayer);
        this.redrawObservable((Observable)this.showScaleLayer);
        this.redrawObservable((Observable)this.maxGridLevel);
        this.redrawObservable((Observable)this.activityFilter);
        this.rowEditingModeProperty().addListener(it -> {
            switch (this.getRowEditingMode()) {
                case NONE: 
                case SINGLE_ROW: {
                    new ArrayList<R>(this.getRowsEditing()).forEach((Consumer<R>)((Consumer<Row>)this::stopRowEditing));
                    break;
                }
            }
        });
        this.timeline.addListener((observable, oldTimeline, newTimeline) -> {
            if (oldTimeline != null) {
                this.removeRedrawObservable((Observable)oldTimeline.getDateline().firstDayOfWeekProperty());
            }
            if (newTimeline != null) {
                this.redrawObservable((Observable)newTimeline.getDateline().firstDayOfWeekProperty());
            }
        });
        InvalidationListener highlightListener = observable -> {
            if (!this.getHighlightedActivities().isEmpty() || !this.getHighlightedRows().isEmpty()) {
                this.startHighlighting();
            } else {
                this.stopHighlighting();
            }
        };
        this.getHighlightedActivities().addListener(highlightListener);
        this.getHighlightedRows().addListener(highlightListener);
        this.highlightedProperty().addListener((InvalidationListener)this.weakRedrawListener);
        this.getLayers().addListener((InvalidationListener)this.weakRedrawListener);
        this.getCalendars().addListener((InvalidationListener)this.weakRedrawListener);
        this.getCalendars().addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Calendar calendar : change.getAddedSubList()) {
                        calendar.visibleProperty().addListener((InvalidationListener)this.weakRedrawListener);
                        calendar.addEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Calendar calendar : change.getRemoved()) {
                    calendar.visibleProperty().removeListener((InvalidationListener)this.weakRedrawListener);
                    calendar.removeEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
                }
            }
        });
        this.getCalendars().add((Object)new WeekendCalendar());
        ListChangeListener layerListListener = change -> {
            while (change.next()) {
                change.getRemoved().forEach(this::removeListenersFromLayer);
                change.getAddedSubList().forEach(this::addListenersToLayer);
            }
        };
        this.getLayers().addListener(layerListListener);
        this.automaticRedraw.addListener((InvalidationListener)this.weakRedrawListener);
        this.layers.forEach(this::addListenersToLayer);
        this.getProperties().addListener(change -> {
            if (change.getKey().equals("com.flexganttfx.currenteditmode")) {
                if (change.getValueAdded() != null) {
                    EditMode mode = (EditMode)((Object)((Object)change.getValueAdded()));
                    this.editMode.set((Object)mode);
                } else {
                    this.editMode.set((Object)EditMode.NONE);
                }
            } else if (change.getKey().equals("com.flexganttfx.currentlyeditedactivity")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof ActivityRef) {
                        ActivityRef activity = (ActivityRef)change.getValueAdded();
                        this.editedActivity.set((Object)activity);
                    } else {
                        this.editedActivity.set(null);
                    }
                } else {
                    this.editedActivity.set(null);
                }
            } else if (change.getKey().equals("com.flexganttfx.draganddropinfo")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof DragAndDropInfo) {
                        DragAndDropInfo info = (DragAndDropInfo)change.getValueAdded();
                        this.dragAndDropInfo.set((Object)info);
                    } else {
                        this.dragAndDropInfo.set(null);
                    }
                } else {
                    this.dragAndDropInfo.set(null);
                }
            } else if (change.getKey().equals("com.flexganttfx.lassoActive")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof Boolean) {
                        this.lassoActive.set(((Boolean)valueAdded).booleanValue());
                    } else {
                        this.lassoActive.set(Boolean.FALSE.booleanValue());
                    }
                }
            } else if (change.getKey().equals("com.flexganttfx.hover.row")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof Row) {
                        this.hoverRow.set((Object)((Row)valueAdded));
                    } else {
                        this.hoverRow.set(null);
                    }
                } else {
                    this.hoverRow.set(null);
                }
            } else if (change.getKey().equals("com.flexganttfx.hover.activity")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof ActivityRef) {
                        this.hoverActivity.set((Object)((ActivityRef)valueAdded));
                    } else {
                        this.hoverActivity.set(null);
                    }
                } else {
                    this.hoverActivity.set(null);
                }
            } else if (change.getKey().equals("com.flexganttfx.hover.layout")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof Layout) {
                        this.hoverLayout.set((Object)((Layout)valueAdded));
                    } else {
                        this.hoverLayout.set(null);
                    }
                } else {
                    this.hoverLayout.set(null);
                }
            } else if (change.getKey().equals("com.flexganttfx.pressed.activity")) {
                Object valueAdded = change.getValueAdded();
                if (valueAdded != null) {
                    if (valueAdded instanceof ActivityRef) {
                        this.pressedActivity.set((Object)((ActivityRef)valueAdded));
                    } else {
                        this.pressedActivity.set(null);
                    }
                } else {
                    this.pressedActivity.set(null);
                }
            }
        });
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(GraphicsBase.class, "graphics.css");
    }

    public final ObjectProperty<Predicate<R>> rowFilterProperty() {
        return this.rowFilter;
    }

    public final void setRowFilter(Predicate<R> predicate) {
        this.rowFilter.set(predicate);
    }

    public final Predicate getRowFilter() {
        return (Predicate)this.rowFilter.get();
    }

    public final ObjectProperty<Predicate<Activity>> activityFilterProperty() {
        return this.activityFilter;
    }

    public final Predicate<Activity> getActivityFilter() {
        return (Predicate)this.activityFilter.get();
    }

    public final void setActivityFilter(Predicate<Activity> filter) {
        this.activityFilter.set(filter);
    }

    public final BooleanProperty lassoEnabledProperty() {
        return this.lassoEnabled;
    }

    public final void setLassoEnabled(boolean enabled) {
        this.lassoEnabled.set(enabled);
    }

    public final boolean isLassoEnabled() {
        return this.lassoEnabled.get();
    }

    public final ReadOnlyBooleanProperty automaticRedrawProperty() {
        return this.automaticRedraw;
    }

    public final boolean isAutomaticRedraw() {
        return this.automaticRedraw.get();
    }

    public final void setAutomaticRedraw(boolean automatic) {
        this.automaticRedraw.set(automatic);
    }

    private void removeListenersFromLayer(Layer layer) {
        layer.visibleProperty().removeListener(this.weakLayerVisibilityListener);
        layer.opacityProperty().removeListener((InvalidationListener)this.weakRedrawListener);
        layer.nameProperty().removeListener((InvalidationListener)this.weakRedrawListener);
        layer.fadeInOutOpacityProperty().removeListener((InvalidationListener)this.weakRedrawListener);
    }

    private void addListenersToLayer(Layer layer) {
        if (!layer.isVisible()) {
            layer.setFadeInOutOpacity(0.0);
        }
        layer.visibleProperty().addListener(this.weakLayerVisibilityListener);
        layer.opacityProperty().addListener((InvalidationListener)this.weakRedrawListener);
        layer.nameProperty().addListener((InvalidationListener)this.weakRedrawListener);
        layer.fadeInOutOpacityProperty().addListener((InvalidationListener)this.weakRedrawListener);
    }

    private void connectToTimeline() {
        com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
        this.redrawObservable((Observable)timeline.getModel().startTimeProperty());
        this.redrawObservable((Observable)timeline.getModel().millisPerPixelProperty());
        timeline.getModel().nowProperty().addListener(this.weakRedrawNowListener);
        timeline.modelProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.nowProperty().removeListener(this.weakRedrawNowListener);
                this.removeRedrawObservable((Observable)timeline.getModel().startTimeProperty());
                this.removeRedrawObservable((Observable)timeline.getModel().millisPerPixelProperty());
            }
            if (newValue != null) {
                newValue.nowProperty().addListener(this.weakRedrawNowListener);
                this.redrawObservable((Observable)timeline.getModel().startTimeProperty());
                this.redrawObservable((Observable)timeline.getModel().millisPerPixelProperty());
            }
        });
        Dateline dateline = timeline.getDateline();
        this.redrawObservable((Observable)dateline.primaryTemporalUnitProperty());
        this.redrawObservable((Observable)dateline.hoverTimeIntervalProperty());
        this.redrawObservable((Observable)dateline.zoneIdProperty());
        this.redrawObservable((Observable)dateline.selectedTimeIntervalProperty());
        dateline.getSelectedIntervals().addListener((InvalidationListener)this.weakRedrawListener);
        dateline.getScaleResolutions().addListener((InvalidationListener)this.weakRedrawListener);
        this.timelineProperty().addListener((observable, oldTimeline, newTimeline) -> {
            if (oldTimeline != null) {
                Dateline oldDateline = oldTimeline.getDateline();
                this.removeRedrawObservable((Observable)oldDateline.primaryTemporalUnitProperty());
                this.removeRedrawObservable((Observable)oldDateline.hoverTimeIntervalProperty());
                oldDateline.getSelectedIntervals().removeListener((InvalidationListener)this.weakRedrawListener);
                this.removeRedrawObservable((Observable)oldTimeline.getDateline().selectedTimeIntervalProperty());
            }
            if (newTimeline != null) {
                Dateline newDateline = newTimeline.getDateline();
                this.redrawObservable((Observable)newDateline.primaryTemporalUnitProperty());
                this.redrawObservable((Observable)newDateline.hoverTimeIntervalProperty());
                newDateline.getSelectedIntervals().addListener((InvalidationListener)this.weakRedrawListener);
                this.redrawObservable((Observable)newTimeline.getDateline().selectedTimeIntervalProperty());
            }
        });
        this.autoGridEnabled.addListener(it -> this.updateGridProperty());
        this.virtualGrid.addListener(it -> this.updateGridProperty());
    }

    private void updateGridProperty() {
        this.gridEnabled.set(this.isAutoGridEnabled() || this.getVirtualGrid() != null);
    }

    public void updatePropertySheet() {
    }

    private void redrawObservable(Observable property) {
        property.addListener((InvalidationListener)this.weakRedrawListener);
    }

    private void removeRedrawObservable(Observable property) {
        property.removeListener((InvalidationListener)this.weakRedrawListener);
    }

    public final ReadOnlyBooleanProperty lassoActiveProperty() {
        return this.lassoActive.getReadOnlyProperty();
    }

    public final boolean isLassoActive() {
        return this.lassoActiveProperty().get();
    }

    public final BooleanProperty lassoSnapsToGridProperty() {
        return this.lassoSnapsToGrid;
    }

    public final boolean isLassoSnapsToGrid() {
        return this.lassoSnapsToGridProperty().get();
    }

    public final void setLassoSnapsToGrid(boolean snaps) {
        this.lassoSnapsToGridProperty().set(snaps);
    }

    public final ObservableList<ActivityLink<?>> getLinks() {
        return this.links;
    }

    public final ObservableList<Layer> getLayers() {
        return this.layers;
    }

    public final ListProperty<R> rowsProperty() {
        return this.rows;
    }

    public final void setRows(ObservableList<R> rows) {
        Objects.requireNonNull(rows);
        this.rows.set(rows);
    }

    public final ObservableList<R> getRows() {
        return (ObservableList)this.rows.get();
    }

    public final ObjectProperty<com.flexganttfx.view.timeline.Timeline> timelineProperty() {
        return this.timeline;
    }

    public final void setTimeline(com.flexganttfx.view.timeline.Timeline timeline) {
        this.timelineProperty().set((Object)timeline);
    }

    public final com.flexganttfx.view.timeline.Timeline getTimeline() {
        return (com.flexganttfx.view.timeline.Timeline)((Object)this.timeline.get());
    }

    public final DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize.get();
    }

    public final void setFixedCellSize(double size) {
        this.fixedCellSizeProperty().set(size);
    }

    public final double getLocation(Instant time) {
        com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        return timelineModel.calculateLocationForTime(time);
    }

    public final Instant getTimeAt(double location) {
        com.flexganttfx.view.timeline.Timeline timeline = this.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        return timelineModel.calculateTimeForLocation(location);
    }

    public final LocalTime getLocalTimeAt(double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getLocalTimeAt(y);
    }

    public final R getRowAt(double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getRowAt(y);
    }

    public final Layout getLayoutAt(double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getLayoutAt(y);
    }

    public final ActivityBounds getActivityBoundsAt(double x, double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getActivityBoundsAt(x, y);
    }

    public final ActivityRef<?> getActivityRefAt(double x, double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getActivityRefAt(x, y);
    }

    public final List<ActivityBounds> getAllActivityBoundsAt(double x, double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getAllActivityBoundsAt(x, y);
    }

    public final List<ActivityRef<?>> getAllActivityRefsAt(double x, double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getAllActivityRefsAt(x, y);
    }

    public final List<CalendarActivity> getAllCalendarActivitiesAt(double x, double y) {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getSkin();
        return skin.getAllCalendarActivitiesAt(x, y);
    }

    public final void moveLayerToFront(Layer layer) {
        Objects.requireNonNull(layer);
        if (!this.getLayers().contains((Object)layer)) {
            throw new IllegalArgumentException("given layer is not a member of the model, can not move it");
        }
        this.getLayers().remove((Object)layer);
        this.getLayers().add((Object)layer);
    }

    public final void moveLayerToBack(Layer layer) {
        Objects.requireNonNull(layer);
        if (!this.getLayers().contains((Object)layer)) {
            throw new IllegalArgumentException("given layer is not a member of the model, can not move it");
        }
        this.getLayers().remove((Object)layer);
        this.getLayers().add(0, (Object)layer);
    }

    public final void moveLayerForward(Layer layer) {
        Objects.requireNonNull(layer);
        if (!this.getLayers().contains((Object)layer)) {
            throw new IllegalArgumentException("given layer is not a member of the model, can not move it");
        }
        ObservableList<Layer> layers = this.getLayers();
        int oldIndex = layers.indexOf((Object)layer);
        int newIndex = Math.min(oldIndex + 1, layers.size() - 1);
        layers.remove(oldIndex);
        layers.add(newIndex, (Object)layer);
    }

    public final void moveLayerBackward(Layer layer) {
        Objects.requireNonNull(layer);
        if (!this.getLayers().contains((Object)layer)) {
            throw new IllegalArgumentException("given layer is not a member of the model, can not move it");
        }
        ObservableList<Layer> layers = this.getLayers();
        int oldIndex = layers.indexOf((Object)layer);
        int newIndex = Math.max(oldIndex - 1, 0);
        layers.remove(oldIndex);
        layers.add(newIndex, (Object)layer);
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityDeletedProperty() {
        if (this.onActivityDeleted == null) {
            this.onActivityDeleted = new ActivityEventHandlerProperty("onActivityDeleted", ActivityEvent.ACTIVITY_DELETED);
        }
        return this.onActivityDeleted;
    }

    public final void setOnActivityDeleted(EventHandler<ActivityEvent> value) {
        this.onActivityDeletedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityDeleted() {
        return this.onActivityDeleted == null ? null : (EventHandler)this.onActivityDeletedProperty().get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChangeProperty() {
        if (this.onActivityChange == null) {
            this.onActivityChange = new ActivityEventHandlerProperty("onActivityChange", ActivityEvent.ACTIVITY_CHANGE);
        }
        return this.onActivityChange;
    }

    public final void setOnActivityChange(EventHandler<ActivityEvent> value) {
        this.onActivityChangeProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChange() {
        return this.onActivityChange == null ? null : (EventHandler)this.onActivityChange.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChangeStartedProperty() {
        if (this.onActivityChangeStarted == null) {
            this.onActivityChangeStarted = new ActivityEventHandlerProperty("onActivityChangeStarted", ActivityEvent.ACTIVITY_CHANGE_STARTED);
        }
        return this.onActivityChangeStarted;
    }

    public final void setOnActivityChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChangeStarted() {
        return this.onActivityChangeStarted == null ? null : (EventHandler)this.onActivityChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChangeOngoingProperty() {
        if (this.onActivityChangeOngoing == null) {
            this.onActivityChangeOngoing = new ActivityEventHandlerProperty("onActivityChangeOngoing", ActivityEvent.ACTIVITY_CHANGE_ONGOING);
        }
        return this.onActivityChangeOngoing;
    }

    public final void setOnActivityChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChangeOngoing() {
        return this.onActivityChangeOngoing == null ? null : (EventHandler)this.onActivityChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChangeFinishedProperty() {
        if (this.onActivityChangeFinished == null) {
            this.onActivityChangeFinished = new ActivityEventHandlerProperty("onActivityChangeFinished", ActivityEvent.ACTIVITY_CHANGE_FINISHED);
        }
        return this.onActivityChangeFinished;
    }

    public final void setOnActivityChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChangeFinished() {
        return this.onActivityChangeFinished == null ? null : (EventHandler)this.onActivityChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityDragStartedProperty() {
        if (this.onActivityDragStarted == null) {
            this.onActivityDragStarted = new ActivityEventHandlerProperty("onActivityDragStarted", ActivityEvent.DRAG_STARTED);
        }
        return this.onActivityDragStarted;
    }

    public final void setOnActivityDragStarted(EventHandler<ActivityEvent> value) {
        this.onActivityDragStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityDragStarted() {
        return this.onActivityDragStarted == null ? null : (EventHandler)this.onActivityDragStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityDragOngoingProperty() {
        if (this.onActivityDragOngoing == null) {
            this.onActivityDragOngoing = new ActivityEventHandlerProperty("onActivityDragOngoing", ActivityEvent.DRAG_ONGOING);
        }
        return this.onActivityDragOngoing;
    }

    public final void setOnActivityDragOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityDragOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityDragOngoing() {
        return this.onActivityDragOngoing == null ? null : (EventHandler)this.onActivityDragOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityDragFinishedProperty() {
        if (this.onActivityDragFinished == null) {
            this.onActivityDragFinished = new ActivityEventHandlerProperty("onActivityDragFinished", ActivityEvent.DRAG_FINISHED);
        }
        return this.onActivityDragFinished;
    }

    public final void setOnActivityDragFinished(EventHandler<ActivityEvent> value) {
        this.onActivityDragFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityDragFinished() {
        return this.onActivityDragFinished == null ? null : (EventHandler)this.onActivityDragFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityDragDoneProperty() {
        if (this.onActivityDragDone == null) {
            this.onActivityDragDone = new ActivityEventHandlerProperty("onActivityDragDone", ActivityEvent.DRAG_DONE);
        }
        return this.onActivityDragDone;
    }

    public final void setOnActivityDragDone(EventHandler<ActivityEvent> value) {
        this.onActivityDragDoneProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityDragDone() {
        return this.onActivityDragDone == null ? null : (EventHandler)this.onActivityDragDone.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartValueChangeStartedProperty() {
        if (this.onActivityChartValueChangeFinished == null) {
            this.onActivityChartValueChangeStarted = new ActivityEventHandlerProperty("onActivityChartValueChangeStarted", ActivityEvent.CHART_VALUE_CHANGE_STARTED);
        }
        return this.onActivityChartValueChangeStarted;
    }

    public final void setOnActivityChartValueChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityChartValueChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartValueChangeStarted() {
        return this.onActivityChartValueChangeStarted == null ? null : (EventHandler)this.onActivityChartValueChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartValueChangeOngoingProperty() {
        if (this.onActivityChartValueChangeOngoing == null) {
            this.onActivityChartValueChangeOngoing = new ActivityEventHandlerProperty("onActivityChartValueChangeOngoing", ActivityEvent.CHART_VALUE_CHANGE_ONGOING);
        }
        return this.onActivityChartValueChangeOngoing;
    }

    public final void setOnActivityChartValueChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityChartValueChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartValueChangeOngoing() {
        return this.onActivityChartValueChangeOngoing == null ? null : (EventHandler)this.onActivityChartValueChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartValueChangeFinishedProperty() {
        if (this.onActivityChartValueChangeFinished == null) {
            this.onActivityChartValueChangeFinished = new ActivityEventHandlerProperty("onActivityChartValueChangeFinished", ActivityEvent.CHART_VALUE_CHANGE_FINISHED);
        }
        return this.onActivityChartValueChangeFinished;
    }

    public final void setOnActivityChartValueChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityChartValueChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartValueChangeFinished() {
        return this.onActivityChartValueChangeFinished == null ? null : (EventHandler)this.onActivityChartValueChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartHighValueChangeStartedProperty() {
        if (this.onActivityChartHighValueChangeStarted == null) {
            this.onActivityChartHighValueChangeStarted = new ActivityEventHandlerProperty("onActivityChartHighValueChangeStarted", ActivityEvent.CHART_HIGH_VALUE_CHANGE_STARTED);
        }
        return this.onActivityChartHighValueChangeStarted;
    }

    public final void setOnActivityChartHighValueChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityChartHighValueChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartHighValueChangeStarted() {
        return this.onActivityChartHighValueChangeStarted == null ? null : (EventHandler)this.onActivityChartHighValueChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartHighValueChangeOngoingProperty() {
        if (this.onActivityChartHighValueChangeOngoing == null) {
            this.onActivityChartHighValueChangeOngoing = new ActivityEventHandlerProperty("onActivityChartHighValueChangeOngoing", ActivityEvent.CHART_HIGH_VALUE_CHANGE_ONGOING);
        }
        return this.onActivityChartHighValueChangeOngoing;
    }

    public final void setOnActivityChartHighValueChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityChartHighValueChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartHighValueChangeOngoing() {
        return this.onActivityChartHighValueChangeOngoing == null ? null : (EventHandler)this.onActivityChartHighValueChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartHighValueChangeFinishedProperty() {
        if (this.onActivityChartHighValueChangeFinished == null) {
            this.onActivityChartHighValueChangeFinished = new ActivityEventHandlerProperty("onActivityChartHighValueChangeFinished", ActivityEvent.CHART_HIGH_VALUE_CHANGE_FINISHED);
        }
        return this.onActivityChartHighValueChangeFinished;
    }

    public final void setOnActivityChartHighValueChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityChartHighValueChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartHighValueChangeFinished() {
        return this.onActivityChartHighValueChangeFinished == null ? null : (EventHandler)this.onActivityChartHighValueChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartLowValueChangeStartedProperty() {
        if (this.onActivityChartLowValueChangeStarted == null) {
            this.onActivityChartLowValueChangeStarted = new ActivityEventHandlerProperty("onActivityChartLowValueChangeStarted", ActivityEvent.CHART_LOW_VALUE_CHANGE_STARTED);
        }
        return this.onActivityChartLowValueChangeStarted;
    }

    public final void setOnActivityChartLowValueChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityChartLowValueChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartLowValueChangeStarted() {
        return this.onActivityChartLowValueChangeStarted == null ? null : (EventHandler)this.onActivityChartLowValueChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartLowValueChangeOngoingProperty() {
        if (this.onActivityChartLowValueChangeOngoing == null) {
            this.onActivityChartLowValueChangeOngoing = new ActivityEventHandlerProperty("onActivityChartLowValueChangeOngoing", ActivityEvent.CHART_LOW_VALUE_CHANGE_ONGOING);
        }
        return this.onActivityChartLowValueChangeOngoing;
    }

    public final void setOnActivityChartLowValueChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityChartLowValueChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartLowValueChangeOngoing() {
        return this.onActivityChartLowValueChangeOngoing == null ? null : (EventHandler)this.onActivityChartLowValueChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityChartLowValueChangeFinishedProperty() {
        if (this.onActivityChartLowValueChangeFinished == null) {
            this.onActivityChartLowValueChangeFinished = new ActivityEventHandlerProperty("onActivityChartLowValueChangeFinished", ActivityEvent.CHART_LOW_VALUE_CHANGE_FINISHED);
        }
        return this.onActivityChartLowValueChangeFinished;
    }

    public final void setOnActivityChartLowValueChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityChartLowValueChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityChartLowValueChangeFinished() {
        return this.onActivityChartLowValueChangeFinished == null ? null : (EventHandler)this.onActivityChartLowValueChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityHorizontalDragStartedProperty() {
        if (this.onActivityHorizontalDragStarted == null) {
            this.onActivityHorizontalDragStarted = new ActivityEventHandlerProperty("onActivityHorizontalDragStarted", ActivityEvent.HORIZONTAL_DRAG_STARTED);
        }
        return this.onActivityHorizontalDragStarted;
    }

    public final void setOnActivityHorizontalDragStarted(EventHandler<ActivityEvent> value) {
        this.onActivityHorizontalDragStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityHorizontalDragStarted() {
        return this.onActivityHorizontalDragStarted == null ? null : (EventHandler)this.onActivityHorizontalDragStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityHorizontalDragOngoingProperty() {
        if (this.onActivityHorizontalDragOngoing == null) {
            this.onActivityHorizontalDragOngoing = new ActivityEventHandlerProperty("onActivityHorizontalDragOngoing", ActivityEvent.HORIZONTAL_DRAG_ONGOING);
        }
        return this.onActivityHorizontalDragOngoing;
    }

    public final void setOnActivityHorizontalDragOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityHorizontalDragOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityHorizontalDragOngoing() {
        return this.onActivityHorizontalDragOngoing == null ? null : (EventHandler)this.onActivityHorizontalDragOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityHorizontalDragFinishedProperty() {
        if (this.onActivityHorizontalDragFinished == null) {
            this.onActivityHorizontalDragFinished = new ActivityEventHandlerProperty("onActivityHorizontalDragFinished", ActivityEvent.HORIZONTAL_DRAG_FINISHED);
        }
        return this.onActivityHorizontalDragFinished;
    }

    public final void setOnActivityHorizontalDragFinished(EventHandler<ActivityEvent> value) {
        this.onActivityHorizontalDragFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityHorizontalDragFinished() {
        return this.onActivityHorizontalDragFinished == null ? null : (EventHandler)this.onActivityHorizontalDragFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityVerticalDragStartedProperty() {
        if (this.onActivityVerticalDragStarted == null) {
            this.onActivityVerticalDragStarted = new ActivityEventHandlerProperty("onActivityVerticalDragStarted", ActivityEvent.VERTICAL_DRAG_STARTED);
        }
        return this.onActivityVerticalDragFinished;
    }

    public final void setOnActivityVerticalDragStarted(EventHandler<ActivityEvent> value) {
        this.onActivityVerticalDragStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityVerticalDragStarted() {
        return this.onActivityVerticalDragStarted == null ? null : (EventHandler)this.onActivityVerticalDragStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityVerticalDragOngoingProperty() {
        if (this.onActivityVerticalDragOngoing == null) {
            this.onActivityVerticalDragOngoing = new ActivityEventHandlerProperty("onActivityVerticalDragOngoing", ActivityEvent.VERTICAL_DRAG_ONGOING);
        }
        return this.onActivityVerticalDragOngoing;
    }

    public final void setOnActivityVerticalDragOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityVerticalDragOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityVerticalDragOngoing() {
        return this.onActivityVerticalDragOngoing == null ? null : (EventHandler)this.onActivityVerticalDragOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityVerticalDragFinishedProperty() {
        if (this.onActivityVerticalDragFinished == null) {
            this.onActivityVerticalDragFinished = new ActivityEventHandlerProperty("onActivityVerticalDragFinished", ActivityEvent.VERTICAL_DRAG_FINISHED);
        }
        return this.onActivityVerticalDragFinished;
    }

    public final void setOnActivityVerticalDragFinished(EventHandler<ActivityEvent> value) {
        this.onActivityVerticalDragFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityVerticalDragFinished() {
        return this.onActivityVerticalDragFinished == null ? null : (EventHandler)this.onActivityVerticalDragFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityVerticalDragDoneProperty() {
        if (this.onActivityVerticalDragDone == null) {
            this.onActivityVerticalDragDone = new ActivityEventHandlerProperty("onActivityVerticalDragDone", ActivityEvent.VERTICAL_DRAG_DONE);
        }
        return this.onActivityVerticalDragDone;
    }

    public final void setOnActivityVerticalDragDone(EventHandler<ActivityEvent> value) {
        this.onActivityVerticalDragDoneProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityVerticalDragDone() {
        return this.onActivityVerticalDragDone == null ? null : (EventHandler)this.onActivityVerticalDragDone.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityEndTimeChangeStartedProperty() {
        if (this.onActivityEndTimeChangeStarted == null) {
            this.onActivityEndTimeChangeStarted = new ActivityEventHandlerProperty("onActivityEndTimeChangeStarted", ActivityEvent.END_TIME_CHANGE_STARTED);
        }
        return this.onActivityEndTimeChangeStarted;
    }

    public final void setOnActivityEndTimeChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityEndTimeChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityEndTimeChangeStarted() {
        return this.onActivityEndTimeChangeStarted == null ? null : (EventHandler)this.onActivityEndTimeChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityEndTimeChangeOngoingProperty() {
        if (this.onActivityEndTimeChangeOngoing == null) {
            this.onActivityEndTimeChangeOngoing = new ActivityEventHandlerProperty("onActivityEndTimeChangeOngoing", ActivityEvent.END_TIME_CHANGE_ONGOING);
        }
        return this.onActivityEndTimeChangeOngoing;
    }

    public final void setOnActivityEndTimeChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityEndTimeChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityEndTimeChangeOngoing() {
        return this.onActivityEndTimeChangeOngoing == null ? null : (EventHandler)this.onActivityEndTimeChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityEndTimeChangeFinishedProperty() {
        if (this.onActivityEndTimeChangeFinished == null) {
            this.onActivityEndTimeChangeFinished = new ActivityEventHandlerProperty("onActivityEndTimeChangeFinished", ActivityEvent.END_TIME_CHANGE_FINISHED);
        }
        return this.onActivityEndTimeChangeFinished;
    }

    public final void setOnActivityEndTimeChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityEndTimeChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityEndTimeChangeFinished() {
        return this.onActivityEndTimeChangeFinished == null ? null : (EventHandler)this.onActivityEndTimeChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityPercentageChangeStartedProperty() {
        if (this.onActivityPercentageChangeStarted == null) {
            this.onActivityPercentageChangeStarted = new ActivityEventHandlerProperty("onActivityPercentageChangeStarted", ActivityEvent.PERCENTAGE_CHANGE_STARTED);
        }
        return this.onActivityPercentageChangeStarted;
    }

    public final void setOnActivityPercentageChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityPercentageChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityPercentageChangeStarted() {
        return this.onActivityPercentageChangeStarted == null ? null : (EventHandler)this.onActivityPercentageChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityPercentageChangeOngoingProperty() {
        if (this.onActivityPercentageChangeOngoing == null) {
            this.onActivityPercentageChangeOngoing = new ActivityEventHandlerProperty("onActivityPercentageChangeOngoing", ActivityEvent.PERCENTAGE_CHANGE_ONGOING);
        }
        return this.onActivityPercentageChangeOngoing;
    }

    public final void setOnActivityPercentageChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityPercentageChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityPercentageChangeOngoing() {
        return this.onActivityPercentageChangeOngoing == null ? null : (EventHandler)this.onActivityPercentageChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityPercentageChangeFinishedProperty() {
        if (this.onActivityPercentageChangeFinished == null) {
            this.onActivityPercentageChangeFinished = new ActivityEventHandlerProperty("onActivityPercentageChangeFinished", ActivityEvent.PERCENTAGE_CHANGE_FINISHED);
        }
        return this.onActivityPercentageChangeFinished;
    }

    public final void setOnActivityPercentageChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityPercentageChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityPercentageChangeFinished() {
        return this.onActivityPercentageChangeFinished == null ? null : (EventHandler)this.onActivityPercentageChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityStartTimeChangeStartedProperty() {
        if (this.onActivityStartTimeChangeStarted == null) {
            this.onActivityStartTimeChangeStarted = new ActivityEventHandlerProperty("onActivityStartTimeChangeStarted", ActivityEvent.START_TIME_CHANGE_STARTED);
        }
        return this.onActivityStartTimeChangeStarted;
    }

    public final void setOnActivityStartTimeChangeStarted(EventHandler<ActivityEvent> value) {
        this.onActivityStartTimeChangeStartedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityStartTimeChangeStarted() {
        return this.onActivityStartTimeChangeStarted == null ? null : (EventHandler)this.onActivityStartTimeChangeStarted.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityStartTimeChangeOngoingProperty() {
        if (this.onActivityStartTimeChangeOngoing == null) {
            this.onActivityStartTimeChangeOngoing = new ActivityEventHandlerProperty("onActivityStartTimeChangeOngoing", ActivityEvent.START_TIME_CHANGE_ONGOING);
        }
        return this.onActivityStartTimeChangeOngoing;
    }

    public final void setOnActivityStartTimeChangeOngoing(EventHandler<ActivityEvent> value) {
        this.onActivityStartTimeChangeOngoingProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityStartTimeChangeOngoing() {
        return this.onActivityStartTimeChangeOngoing == null ? null : (EventHandler)this.onActivityStartTimeChangeOngoing.get();
    }

    public final ObjectProperty<EventHandler<ActivityEvent>> onActivityStartTimeChangeFinishedProperty() {
        if (this.onActivityStartTimeChangeFinished == null) {
            this.onActivityStartTimeChangeFinished = new ActivityEventHandlerProperty("onActivityStartTimeChangeFinished", ActivityEvent.START_TIME_CHANGE_FINISHED);
        }
        return this.onActivityStartTimeChangeFinished;
    }

    public final void setOnActivityStartTimeChangeFinished(EventHandler<ActivityEvent> value) {
        this.onActivityStartTimeChangeFinishedProperty().set(value);
    }

    public final EventHandler<ActivityEvent> getOnActivityStartTimeChangeFinished() {
        return this.onActivityStartTimeChangeFinished == null ? null : (EventHandler)this.onActivityStartTimeChangeFinished.get();
    }

    public final ObjectProperty<EventHandler<LassoEvent>> onLassoSelectionProperty() {
        if (this.onLassoSelection == null) {
            this.onLassoSelection = new LassoEventHandlerProperty("onLassoSelection", LassoEvent.ALL);
        }
        return this.onLassoSelection;
    }

    public final void setOnLassoSelection(EventHandler<LassoEvent> value) {
        this.onLassoSelectionProperty().set(value);
    }

    public final EventHandler<LassoEvent> getOnLassoSelection() {
        return this.onLassoSelection == null ? null : (EventHandler)this.onLassoSelection.get();
    }

    public final ObjectProperty<EventHandler<LassoEvent>> onLassoSelectionStartedProperty() {
        if (this.onLassoSelectionStarted == null) {
            this.onLassoSelectionStarted = new LassoEventHandlerProperty("onLassoSelectionStarted", LassoEvent.SELECTION_STARTED);
        }
        return this.onLassoSelectionStarted;
    }

    public final void setOnLassoSelectionStarted(EventHandler<LassoEvent> value) {
        this.onLassoSelectionStartedProperty().set(value);
    }

    public final EventHandler<LassoEvent> getOnLassoSelectionStarted() {
        return this.onLassoSelectionStarted == null ? null : (EventHandler)this.onLassoSelectionStarted.get();
    }

    public final ObjectProperty<EventHandler<LassoEvent>> onLassoSelectionOngoingProperty() {
        if (this.onLassoSelectionOngoing == null) {
            this.onLassoSelectionOngoing = new LassoEventHandlerProperty("onLassoSelectionOngoing", LassoEvent.SELECTION_ONGOING);
        }
        return this.onLassoSelectionOngoing;
    }

    public final void setOnLassoSelectionOngoing(EventHandler<LassoEvent> value) {
        this.onLassoSelectionOngoingProperty().set(value);
    }

    public final EventHandler<LassoEvent> getOnLassoSelectionOngoing() {
        return this.onLassoSelectionOngoing == null ? null : (EventHandler)this.onLassoSelectionOngoing.get();
    }

    public final ObjectProperty<EventHandler<LassoEvent>> onLassoSelectionFinishedProperty() {
        if (this.onLassoSelectionFinished == null) {
            this.onLassoSelectionFinished = new LassoEventHandlerProperty("onLassoSelectionFinished", LassoEvent.SELECTION_FINISHED);
        }
        return this.onLassoSelectionFinished;
    }

    public final void setOnLassoSelectionFinished(EventHandler<LassoEvent> value) {
        this.onLassoSelectionFinishedProperty().set(value);
    }

    public final EventHandler<LassoEvent> getOnLassoSelectionFinished() {
        return this.onLassoSelectionFinished == null ? null : (EventHandler)this.onLassoSelectionFinished.get();
    }

    public final ReadOnlyObjectProperty<EditMode> editModeProperty() {
        return this.editMode.getReadOnlyProperty();
    }

    public final EditMode getEditMode() {
        return (EditMode)((Object)this.editMode.get());
    }

    public final ObservableSet<Row<?, ?, ?>> getHighlightedRows() {
        return this.highlightedRows;
    }

    public final ObservableSet<ActivityRef<?>> getHighlightedActivities() {
        return this.highlightedActivities;
    }

    public final LongProperty highlightDelayProperty() {
        return this.highlightDelay;
    }

    public final void setHighlightDelay(long delay) {
        if (delay < 100L) {
            throw new IllegalArgumentException("delay must be at least 100 millis, but was " + delay);
        }
        this.highlightDelayProperty().set(delay);
    }

    public final long getHighlightDelay() {
        return this.highlightDelay.get();
    }

    public final ReadOnlyBooleanProperty highlightedProperty() {
        return this.highlighted.getReadOnlyProperty();
    }

    private void setHighlighted(boolean on) {
        this.highlighted.set(on);
    }

    public final boolean isHighlighted() {
        return this.highlightedProperty().get();
    }

    private void startHighlighting() {
        if (this.highlightThread == null || !this.highlightThread.isRunning()) {
            this.highlightThread = new HighlightThread();
            this.highlightThread.start();
        }
    }

    private void stopHighlighting() {
        if (this.highlightThread != null) {
            this.highlightThread.stopRunning();
        }
    }

    public final ObjectProperty<Callback<ContextMenuParameter<R>, ContextMenu>> contextMenuCallbackProperty() {
        return this.contextMenuCallback;
    }

    public final void setContextMenuCallback(Callback<ContextMenuParameter<R>, ContextMenu> callback) {
        if (callback != null) {
            LoggingDomain.CONFIG.fine("callback class: " + callback.getClass().getName());
        } else {
            LoggingDomain.CONFIG.fine("callback: null");
        }
        this.contextMenuCallbackProperty().set(callback);
    }

    public final Callback<ContextMenuParameter<R>, ContextMenu> getContextMenuCallback() {
        return (Callback)this.contextMenuCallbackProperty().get();
    }

    public final IntegerProperty extraPixelsProperty() {
        return this.extraPixels;
    }

    public final int getExtraPixels() {
        return this.extraPixelsProperty().get();
    }

    public final void setExtraPixels(int pixels) {
        if (pixels < 0 || pixels > 100) {
            throw new IllegalArgumentException("extra pixels must be within [0, 100] but was " + pixels);
        }
        this.extraPixelsProperty().set(pixels);
    }

    public final BooleanProperty autoMarkedTimeIntervalProperty() {
        return this.autoMarkedTimeInterval;
    }

    public final boolean isAutoMarkedTimeInterval() {
        return this.autoMarkedTimeIntervalProperty().get();
    }

    public final void setAutoMarkedTimeInterval(boolean auto) {
        this.autoMarkedTimeIntervalProperty().set(auto);
    }

    public final IntegerProperty maxGridLevelProperty() {
        return this.maxGridLevel;
    }

    public final int getMaxGridLevel() {
        return this.maxGridLevelProperty().get();
    }

    public final void setMaxGridLevel(int max) {
        if (max < 1 || max > 5) {
            throw new IllegalArgumentException("max grid level must be within [1, 5] but was " + max);
        }
        this.maxGridLevelProperty().set(max);
    }

    public final BooleanProperty showVerticalCursorProperty() {
        return this.showVerticalCursor;
    }

    public final boolean isShowVerticalCursor() {
        return this.showVerticalCursorProperty().get();
    }

    public final void setShowVerticalCursor(boolean show) {
        this.showVerticalCursorProperty().set(show);
    }

    public final BooleanProperty showHorizontalCursorProperty() {
        return this.showHorizontalCursor;
    }

    public final boolean isShowHorizontalCursor() {
        return this.showHorizontalCursorProperty().get();
    }

    public final void setShowHorizontalCursor(boolean show) {
        this.showHorizontalCursorProperty().set(show);
    }

    public final BooleanProperty showMarkedTimeIntervalProperty() {
        return this.showMarkedTimeInterval;
    }

    public final boolean isShowMarkedTimeInterval() {
        return this.showMarkedTimeIntervalProperty().get();
    }

    public final void setShowMarkedTimeInterval(boolean show) {
        this.showMarkedTimeIntervalProperty().set(show);
    }

    public final BooleanProperty debugModeProperty() {
        return this.debugMode;
    }

    public final boolean isDebugMode() {
        return this.debugModeProperty().get();
    }

    public final void setDebugMode(boolean debug) {
        this.debugModeProperty().set(debug);
    }

    public final BooleanProperty autoGridEnabledProperty() {
        return this.autoGridEnabled;
    }

    public final boolean isAutoGridEnabled() {
        return this.autoGridEnabled.get();
    }

    public final void setAutoGridEnabled(boolean auto) {
        this.autoGridEnabled.set(auto);
    }

    public final ReadOnlyBooleanProperty gridEnabledProperty() {
        return this.gridEnabled.getReadOnlyProperty();
    }

    public final boolean isGridEnabled() {
        return this.gridEnabled.get();
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        return this.selectionMode;
    }

    public final SelectionMode getSelectionMode() {
        return (SelectionMode)((Object)this.selectionMode.get());
    }

    public final void setSelectionMode(SelectionMode mode) {
        Objects.requireNonNull(mode);
        this.selectionModeProperty().set((Object)mode);
    }

    public final ObservableList<ActivityRef<?>> getSelectedActivities() {
        return this.selectedActivities;
    }

    public final ObjectProperty<LassoSelectionBehaviour> lassoSelectionBehaviourProperty() {
        return this.lassoSelectionBehaviour;
    }

    public final void setLassoSelectionBehaviour(LassoSelectionBehaviour behaviour) {
        Objects.requireNonNull(behaviour);
        this.lassoSelectionBehaviourProperty().set((Object)behaviour);
    }

    public final LassoSelectionBehaviour getLassoSelectionBehaviour() {
        return (LassoSelectionBehaviour)((Object)this.lassoSelectionBehaviourProperty().get());
    }

    public final ObservableList<Calendar<? extends CalendarActivity>> getCalendars() {
        return this.calendars;
    }

    public final void showEarliestActivities() {
        Instant time = this.getEarliestTimeUsed();
        if (time != null) {
            this.getTimeline().showTime(time, false);
        }
    }

    public final void showLatestActivities() {
        Instant time = this.getLatestTimeUsed();
        if (time != null) {
            this.getTimeline().showTime(time, true);
        }
    }

    public final void showAllActivities() {
        Instant earliestTime = this.getEarliestTimeUsed();
        Instant latestTime = this.getLatestTimeUsed();
        if (earliestTime != null && latestTime != null) {
            this.getTimeline().showRange(earliestTime, latestTime);
        }
    }

    public final Instant getEarliestTimeUsed() {
        Instant time = null;
        for (Row row : this.getRows()) {
            Instant earliest;
            if (row == null || (earliest = row.getEarliestTimeUsed()) == null || time != null && !earliest.isBefore(time)) continue;
            time = earliest;
        }
        return time;
    }

    public final Instant getLatestTimeUsed() {
        Instant time = null;
        for (Row row : this.getRows()) {
            Instant latest;
            if (row == null || (latest = row.getLatestTimeUsed()) == null || time != null && !latest.isAfter(time)) continue;
            time = latest;
        }
        return time;
    }

    public final ReadOnlyObjectProperty<ActivityRef<?>> hoverActivityProperty() {
        return this.hoverActivity;
    }

    public final ActivityRef<?> getHoverActivity() {
        return (ActivityRef)this.hoverActivityProperty().get();
    }

    public final ReadOnlyObjectProperty<R> hoverRowProperty() {
        return this.hoverRow;
    }

    public final R getHoverRow() {
        return (R)((Row)this.hoverRowProperty().get());
    }

    public final ReadOnlyObjectProperty<Layout> hoverLayoutProperty() {
        return this.hoverLayout;
    }

    public final Layout getHoverLayout() {
        return (Layout)this.hoverLayoutProperty().get();
    }

    public final ReadOnlyObjectProperty<ActivityRef<?>> editedActivityProperty() {
        return this.editedActivity.getReadOnlyProperty();
    }

    public final ActivityRef<?> getEditedActivity() {
        return (ActivityRef)this.editedActivityProperty().get();
    }

    public final ReadOnlyObjectProperty<ActivityRef<?>> pressedActivityProperty() {
        return this.pressedActivity;
    }

    public final ActivityRef<?> getPressedActivity() {
        return (ActivityRef)this.pressedActivityProperty().get();
    }

    public final ObjectProperty<VirtualGrid<?>> virtualGridProperty() {
        return this.virtualGrid;
    }

    public final VirtualGrid<?> getVirtualGrid() {
        return (VirtualGrid)this.virtualGridProperty().get();
    }

    public final void setVirtualGrid(VirtualGrid<?> grid) {
        this.virtualGridProperty().set(grid);
    }

    public final ObservableList<VirtualGrid<?>> getVirtualGrids() {
        return this.virtualGrids;
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.placeholder;
    }

    public final Node getPlaceholder() {
        return (Node)this.placeholderProperty().get();
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set((Object)node);
    }

    public final ObservableList<RowPane<R>> getRowPanes() {
        return this.rowPanes;
    }

    public void redraw() {
        if (LoggingDomain.RENDERING.isLoggable(Level.FINE)) {
            LoggingDomain.RENDERING.fine("row cells list size = " + this.getRowPanes().size());
        }
        if (LoggingDomain.PERFORMANCE.isLoggable(Level.FINE)) {
            Instant timeBefore = Instant.now();
            this.doDraw();
            Instant timeAfter = Instant.now();
            java.time.Duration duration = java.time.Duration.between(timeBefore, timeAfter);
            LoggingDomain.PERFORMANCE.fine("redraw duration (nanos): " + duration);
        } else {
            this.doDraw();
        }
        this.layoutLinks();
    }

    public void layoutLinks() {
        if (this.linksPane == null) {
            this.linksPane = (LinksPane)this.lookup("LinksPane");
        }
        if (this.linksPane != null) {
            this.linksPane.requestLayout();
        }
    }

    private void doDraw() {
        for (RowPane pane : this.getRowPanes()) {
            if (!pane.isVisible()) continue;
            Object row = pane.getRow();
            if (row != null && !((Row)row).isShowing()) {
                ((Row)row).getProperties().put((Object)"com.flexganttfx.row.showing", (Object)true);
            }
            pane.draw();
        }
    }

    private Map<Class<?>, ActivityRenderer<?>> getRendererMapForLayoutStrategy(Class<? extends Layout> layoutType) {
        ObservableMap layoutMap = (ObservableMap)this.rendererLayoutMap.get(layoutType);
        if (layoutMap == null) {
            layoutMap = FXCollections.observableHashMap();
            layoutMap.addListener((InvalidationListener)this.weakUpdatePropertySheetListener);
            this.rendererLayoutMap.put(layoutType, (Object)layoutMap);
        }
        return layoutMap;
    }

    public final List<ActivityRenderer<?>> getAllActivityRenderers() {
        ArrayList list = new ArrayList();
        for (Map rendererMap : this.rendererLayoutMap.values()) {
            list.addAll(rendererMap.values());
        }
        return list;
    }

    public final <A extends Activity> void setActivityRenderer(Class<? extends A> activityType, Class<? extends Layout> layoutType, ActivityRenderer<? extends A> renderer) {
        Objects.requireNonNull(activityType);
        Objects.requireNonNull(layoutType);
        this.cachedRendererMap.clear();
        if (renderer != null) {
            LoggingDomain.CONFIG.fine("activity type = " + activityType + ", layout type " + layoutType + ", renderer = " + renderer.getClass().getName());
        } else {
            LoggingDomain.CONFIG.fine("activity type = " + activityType + ", layout type " + layoutType + ", renderer = null");
        }
        if (renderer != null) {
            for (ObservableMap layoutMap : this.rendererLayoutMap.values()) {
                for (ActivityRenderer r : layoutMap.values()) {
                    if (r == null || !r.getName().equals(renderer.getName())) continue;
                    throw new IllegalArgumentException("a renderer with name " + renderer.getName() + " is already registered for the given layout type " + layoutType.getName());
                }
            }
        }
        Map<Class<?>, ActivityRenderer<?>> rendererMap = this.getRendererMapForLayoutStrategy(layoutType);
        rendererMap.put(activityType, renderer);
    }

    public final <A extends Activity> ActivityRenderer<? extends A> getActivityRenderer(Class<? extends A> activityType, Class<? extends Layout> layoutType) {
        Objects.requireNonNull(activityType);
        Objects.requireNonNull(layoutType);
        ObservableMap cache = (ObservableMap)this.cachedRendererMap.computeIfAbsent(layoutType, it -> FXCollections.observableHashMap());
        ActivityRenderer renderer = (ActivityRenderer)cache.computeIfAbsent(activityType, it -> this.doGetActivityRenderer(this.getRendererMapForLayoutStrategy(layoutType), activityType));
        if (renderer == null) {
            if (layoutType.equals(ChartLayout.class)) {
                return this.defaultChartActivityRenderer;
            }
            if (layoutType.equals(GanttLayout.class)) {
                return this.defaultGanttActivityRenderer;
            }
            if (layoutType.equals(AgendaLayout.class)) {
                return this.defaultAgendaActivityRenderer;
            }
        }
        return renderer;
    }

    private <A extends Activity> ActivityRenderer<A> doGetActivityRenderer(Map<Class<?>, ? extends ActivityRenderer<?>> map, Class<?> clazz) {
        if (clazz != null) {
            ActivityRenderer<?> renderer = map.get(clazz);
            if (renderer == null) {
                return this.doGetActivityRenderer(map, clazz.getSuperclass());
            }
            return renderer;
        }
        return null;
    }

    public final void setActivityEditingCallback(Class<? extends MutableActivity> activityType, Callback<EditingCallbackParameter, Boolean> callback) {
        Objects.requireNonNull(activityType);
        this.activityEditingCallbackMap.put(activityType, callback);
    }

    public final <A extends Activity> Callback<EditingCallbackParameter, Boolean> getActivityEditingCallback(Class<A> activityType) {
        return this.doGetEditingCallback(activityType);
    }

    private Callback<EditingCallbackParameter, Boolean> doGetEditingCallback(Class<?> activityType) {
        if (activityType != null) {
            Callback callback = (Callback)this.activityEditingCallbackMap.get(activityType);
            if (callback == null) {
                return this.doGetEditingCallback(activityType.getSuperclass());
            }
            return callback;
        }
        return null;
    }

    public final void setRowDragAndDropCallback(Class<? extends Row> rowType, Callback<DragAndDropInfo, Boolean> callback) {
        Objects.requireNonNull(rowType);
        this.dragAndDropCallbackMap.put(rowType, callback);
    }

    public final Callback<DragAndDropInfo, Boolean> getRowDragAndDropCallback(Class<? extends Row> rowType) {
        return this.doGetRowDragAndDropCallback(rowType);
    }

    private Callback<DragAndDropInfo, Boolean> doGetRowDragAndDropCallback(Class<?> rowType) {
        if (rowType != null) {
            Callback callback = (Callback)this.dragAndDropCallbackMap.get(rowType);
            if (callback == null) {
                return this.doGetRowDragAndDropCallback(rowType.getSuperclass());
            }
            return callback;
        }
        return null;
    }

    public final ReadOnlyObjectProperty<DragAndDropInfo> dragAndDropInfoProperty() {
        return this.dragAndDropInfo.getReadOnlyProperty();
    }

    public final DragAndDropInfo getDragAndDropInfo() {
        return (DragAndDropInfo)this.dragAndDropInfoProperty().get();
    }

    public final ObjectProperty<Callback<ActivityRef<?>, Image>> dragImageProviderProperty() {
        return this.dragImageProvider;
    }

    public final void setDragImageProvider(Callback<ActivityRef<?>, Image> provider) {
        this.dragImageProvider.set(provider);
    }

    public final Callback<ActivityRef<?>, Image> getDragImageProvider() {
        return (Callback)this.dragImageProvider.get();
    }

    private <SL extends SystemLayer<R>> SL doGetLayer(Class<SL> layerType, List<SystemLayer<R>> layers) {
        for (SystemLayer<R> layer : layers) {
            if (!layer.getClass().isAssignableFrom(layerType)) continue;
            return (SL)layer;
        }
        return null;
    }

    public final <SL extends SystemLayer<R>> SL getBackgroundSystemLayer(Class<SL> layerType) {
        return this.doGetLayer(layerType, (List<SystemLayer<R>>)this.backgroundLayers);
    }

    public final <SL extends SystemLayer<R>> SL getForegroundSystemLayer(Class<SL> layerType) {
        return this.doGetLayer(layerType, (List<SystemLayer<R>>)this.foregroundLayers);
    }

    public final <SL extends SystemLayer<R>> SL getSystemLayer(Class<SL> layerType) {
        SL layer = this.doGetLayer(layerType, (List<SystemLayer<R>>)this.backgroundLayers);
        if (layer == null) {
            layer = this.doGetLayer(layerType, (List<SystemLayer<R>>)this.foregroundLayers);
        }
        return layer;
    }

    public final ObservableList<SystemLayer<R>> getBackgroundSystemLayers() {
        return this.backgroundLayers;
    }

    public final ObservableList<SystemLayer<R>> getForegroundSystemLayers() {
        return this.foregroundLayers;
    }

    public final BooleanProperty showAgendaLinesLayerProperty() {
        return this.showAgendaLinesLayer;
    }

    public final void setShowAgendaLinesLayer(boolean show) {
        this.showAgendaLinesLayerProperty().set(show);
    }

    public final boolean isShowAgendaLinesLayer() {
        return this.showAgendaLinesLayerProperty().get();
    }

    public final BooleanProperty showCalendarLayerProperty() {
        return this.showCalendarLayer;
    }

    public final void setShowCalendarLayer(boolean show) {
        this.showCalendarLayerProperty().set(show);
    }

    public final boolean isShowCalendarLayer() {
        return this.showCalendarLayerProperty().get();
    }

    public final BooleanProperty showLayoutLayerProperty() {
        return this.showLayoutLayer;
    }

    public final void setShowLayoutLayer(boolean show) {
        this.showLayoutLayerProperty().set(show);
    }

    public final boolean isShowLayoutLayer() {
        return this.showLayoutLayerProperty().get();
    }

    public final BooleanProperty showChartLinesLayerProperty() {
        return this.showChartLinesLayer;
    }

    public final void setShowChartLinesLayer(boolean show) {
        this.showChartLinesLayerProperty().set(show);
    }

    public final boolean isShowChartLinesLayer() {
        return this.showChartLinesLayerProperty().get();
    }

    public final BooleanProperty showGridLineLayerProperty() {
        return this.showGridLineLayer;
    }

    public final void setShowGridLineLayer(boolean show) {
        this.showGridLineLayerProperty().set(show);
    }

    public final boolean isShowGridLineLayer() {
        return this.showGridLineLayerProperty().get();
    }

    public final BooleanProperty showHoverTimeIntervalLayerProperty() {
        return this.showHoverTimeIntervalLayer;
    }

    public final void setShowHoverTimeIntervalLayer(boolean show) {
        this.showHoverTimeIntervalLayerProperty().set(show);
    }

    public final boolean isShowHoverTimeIntervalLayer() {
        return this.showHoverTimeIntervalLayerProperty().get();
    }

    public final BooleanProperty showInnerLinesLayerProperty() {
        return this.showInnerLinesLayer;
    }

    public final void setShowInnerLinesLayer(boolean show) {
        this.showInnerLinesLayerProperty().set(show);
    }

    public final boolean isShowInnerLinesLayer() {
        return this.showInnerLinesLayerProperty().get();
    }

    public final BooleanProperty showNowLineLayerProperty() {
        return this.showNowLineLayer;
    }

    public final void setShowNowLineLayer(boolean show) {
        this.showNowLineLayerProperty().set(show);
    }

    public final boolean isShowNowLineLayer() {
        return this.showNowLineLayerProperty().get();
    }

    public final BooleanProperty showDSTLineLayerProperty() {
        return this.showDSTLineLayer;
    }

    public final void setShowDSTLineLayer(boolean show) {
        this.showDSTLineLayerProperty().set(show);
    }

    public final boolean isShowDSTLineLayer() {
        return this.showDSTLineLayerProperty().get();
    }

    public final BooleanProperty showRowLayerProperty() {
        return this.showRowLayer;
    }

    public final void setShowRowLayer(boolean show) {
        this.showRowLayerProperty().set(show);
    }

    public final boolean isShowRowLayer() {
        return this.showRowLayerProperty().get();
    }

    public final BooleanProperty showScaleLayerProperty() {
        return this.showScaleLayer;
    }

    public final void setShowScaleLayer(boolean show) {
        this.showScaleLayerProperty().set(show);
    }

    public final boolean isShowScaleLayer() {
        return this.showScaleLayerProperty().get();
    }

    public final BooleanProperty showSelectedTimeIntervalsLayerProperty() {
        return this.showSelectedTimeIntervalsLayer;
    }

    public final void setShowSelectedTimeIntervalsLayer(boolean show) {
        this.showSelectedTimeIntervalsLayerProperty().set(show);
    }

    public final boolean isShowSelectedTimeIntervalsLayer() {
        return this.showSelectedTimeIntervalsLayerProperty().get();
    }

    public final BooleanProperty showZoomTimeIntervalLayerProperty() {
        return this.showZoomTimeIntervalLayer;
    }

    public final void setShowZoomTimeIntervalLayer(boolean show) {
        this.showZoomTimeIntervalLayerProperty().set(show);
    }

    public final boolean isShowZoomTimeIntervalLayer() {
        return this.showZoomTimeIntervalLayerProperty().get();
    }

    public final BooleanProperty showZoneIdProperty() {
        return this.showZoneId;
    }

    public final void setShowZoneId(boolean show) {
        this.showZoneIdProperty().set(show);
    }

    public final boolean isShowZoneId() {
        return this.showZoneIdProperty().get();
    }

    public final BooleanProperty fadeInOutVisibilityChangesProperty() {
        return this.fadeInOutVisibilityChanges;
    }

    public final boolean isFadeInOutVisibilityChanges() {
        return this.fadeInOutVisibilityChangesProperty().get();
    }

    public final void setFadeInOutVisibilityChanges(boolean show) {
        this.fadeInOutVisibilityChangesProperty().set(show);
    }

    public final DoubleProperty fadeInOutVisibilityChangesDurationProperty() {
        return this.fadeInOutVisibilityChangesDuration;
    }

    public final double getFadeInOutVisibilityChangesDuration() {
        return this.fadeInOutVisibilityChangesDurationProperty().get();
    }

    public final void setFadeInOutVisibilityChangesDuration(double duration) {
        if (duration < 0.0) {
            throw new IllegalArgumentException("duration must be larger or equal to 0 but was " + duration);
        }
        this.fadeInOutVisibilityChangesDurationProperty().set(duration);
    }

    public final ObjectProperty<DragAndDropFeedback> dragAndDropFeedbackProperty() {
        return this.dragAndDropFeedback;
    }

    public final void setDragAndDropFeedback(DragAndDropFeedback feedback) {
        Objects.requireNonNull(feedback);
        this.dragAndDropFeedback.set((Object)feedback);
    }

    public final DragAndDropFeedback getDragAndDropFeedback() {
        return (DragAndDropFeedback)((Object)this.dragAndDropFeedback.get());
    }

    public final ObjectProperty<Callback<RowControlsParameter<R>, Node>> rowControlsFactoryProperty() {
        return this.rowControlsFactory;
    }

    public final void setRowControlsFactory(Callback<RowControlsParameter<R>, Node> factory) {
        this.rowControlsFactory.set(factory);
    }

    public final Callback<RowControlsParameter<R>, Node> getRowControlsFactory() {
        return (Callback)this.rowControlsFactory.get();
    }

    public final ObjectProperty<Callback<RowEditorParameter<R>, Node>> rowEditorFactoryProperty() {
        return this.rowEditorFactory;
    }

    public final void setRowEditorFactory(Callback<RowEditorParameter<R>, Node> factory) {
        Objects.requireNonNull(factory);
        this.rowEditorFactory.set(factory);
    }

    public final Callback<RowEditorParameter<R>, Node> getRowEditorFactory() {
        return (Callback)this.rowEditorFactory.get();
    }

    public final ObjectProperty<RowEditingMode> rowEditingModeProperty() {
        return this.rowEditingMode;
    }

    public final void setRowEditingMode(RowEditingMode mode) {
        this.rowEditingMode.set((Object)mode);
    }

    public final RowEditingMode getRowEditingMode() {
        return (RowEditingMode)((Object)this.rowEditingMode.get());
    }

    public final ObservableList<R> getRowsEditing() {
        return this.rowsEditing;
    }

    public final void stopRowEditing() {
        this.rowsEditing.forEach(this::stopRowEditing);
    }

    public final void stopRowEditing(R row) {
        this.getRowPanes().stream().filter(pane -> pane.getRow() == row).forEach(pane -> {
            this.getRowsEditing().remove((Object)row);
            pane.stopEditing();
        });
    }

    public final void startRowEditing(R row) {
        switch (this.getRowEditingMode()) {
            case NONE: {
                return;
            }
            case SINGLE_ROW: {
                new ArrayList<R>(this.getRowsEditing()).forEach((Consumer<R>)((Consumer<Row>)this::stopRowEditing));
                break;
            }
        }
        this.getRowPanes().stream().filter(pane -> pane.getRow() == row).forEach(pane -> {
            this.getRowsEditing().add((Object)row);
            pane.startEditing();
        });
    }

    public final BooleanProperty animateRowEditorProperty() {
        return this.animateRowEditor;
    }

    public final void setAnimateRowEditor(boolean animate) {
        this.animateRowEditorProperty().set(animate);
    }

    public final boolean isAnimateRowEditor() {
        return this.animateRowEditorProperty().get();
    }

    public final void setEditModeCallback(Class<? extends MutableActivity> activityType, Class<? extends Layout> layoutType, Callback<EditModeCallbackParameter, EditMode> callback) {
        if (callback != null) {
            LoggingDomain.CONFIG.fine("layout = " + layoutType + ", class = " + activityType + ", callback = " + callback.getClass().getName());
        } else {
            LoggingDomain.CONFIG.fine("class = " + activityType + ", callback = null");
        }
        ObservableMap layoutMap = (ObservableMap)this.editModeCallbackMap.computeIfAbsent(layoutType, k -> FXCollections.observableHashMap());
        layoutMap.put(activityType, callback);
    }

    public final Callback<EditModeCallbackParameter, EditMode> getEditModeCallback(Class<? extends MutableActivity> activityType, Class<? extends Layout> layoutType) {
        return this.doGetEditModeCallback(activityType, layoutType);
    }

    private Callback<EditModeCallbackParameter, EditMode> doGetEditModeCallback(Class<?> activityType, Class<? extends Layout> layoutType) {
        ObservableMap modeMap;
        if (activityType != null && (modeMap = (ObservableMap)this.editModeCallbackMap.get(layoutType)) != null) {
            Callback callback = (Callback)modeMap.get(activityType);
            if (callback == null) {
                return this.doGetEditModeCallback(activityType.getSuperclass(), layoutType);
            }
            return callback;
        }
        return null;
    }

    public final ObjectProperty<Callback<DragAndDropInfo, Layer>> dropLayerProviderProperty() {
        return this.dropLayerProvider;
    }

    public final Callback<DragAndDropInfo, Layer> getDropLayerProvider() {
        return (Callback)this.dropLayerProvider.get();
    }

    public final void setDropLayerProvider(Callback<DragAndDropInfo, Layer> provider) {
        Objects.requireNonNull(provider);
        this.dropLayerProvider.set(provider);
    }

    public final BooleanProperty horizontalDragEnabledProperty() {
        return this.horizontalDragEnabled;
    }

    public final void setHorizontalDragEnabled(boolean enabled) {
        this.horizontalDragEnabled.set(enabled);
    }

    public final boolean isHorizontalDragEnabled() {
        return this.horizontalDragEnabled.get();
    }

    public final BooleanProperty safeRenderingProperty() {
        if (this.safeRendering == null) {
            this.safeRendering = new SimpleBooleanProperty((Object)this, "safeRendering", this._safeRendering);
        }
        return this.safeRendering;
    }

    public final void setSafeRendering(boolean safe) {
        if (this.safeRendering == null) {
            this._safeRendering = safe;
        } else {
            this.safeRendering.set(safe);
        }
    }

    public final boolean isSafeRendering() {
        if (this.safeRendering == null) {
            return this._safeRendering;
        }
        return this.safeRendering.get();
    }

    public final StyleableObjectProperty<Paint> gridLineColor1Property() {
        if (this.gridLineColor1 == null) {
            this.gridLineColor1 = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.GRID_LINE_COLOR1;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "gridLineColor1";
                }
            };
        }
        return this.gridLineColor1;
    }

    public final Paint getGridLineColor1() {
        return (Paint)this.gridLineColor1Property().get();
    }

    public void setGridLineColor1(Paint color) {
        this.gridLineColor1Property().set((Object)color);
    }

    public final StyleableObjectProperty<Paint> gridLineColor2Property() {
        if (this.gridLineColor2 == null) {
            this.gridLineColor2 = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.GRID_LINE_COLOR2;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "gridLineColor2";
                }
            };
        }
        return this.gridLineColor2;
    }

    public final Paint getGridLineColor2() {
        return (Paint)this.gridLineColor2Property().get();
    }

    public void setGridLineColor2(Paint color) {
        this.gridLineColor2Property().set((Object)color);
    }

    public final StyleableObjectProperty<Paint> gridLineColor3Property() {
        if (this.gridLineColor3 == null) {
            this.gridLineColor3 = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.GRID_LINE_COLOR3;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "gridLineColor3";
                }
            };
        }
        return this.gridLineColor3;
    }

    public final Paint getGridLineColor3() {
        return (Paint)this.gridLineColor3Property().get();
    }

    public void setGridLineColor3(Paint color) {
        this.gridLineColor3Property().set((Object)color);
    }

    public final StyleableObjectProperty<Paint> weekendColorProperty() {
        if (this.weekendColor == null) {
            this.weekendColor = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.WEEKEND_COLOR;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "weekendColor";
                }
            };
        }
        return this.weekendColor;
    }

    public final Paint getWeekendColor() {
        return (Paint)this.weekendColorProperty().get();
    }

    public void setWeekendColor(Paint color) {
        this.weekendColorProperty().set((Object)color);
    }

    public final StyleableObjectProperty<Paint> timeNowColorProperty() {
        if (this.timeNowColor == null) {
            this.timeNowColor = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.TIME_NOW_COLOR;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "timeNowColor";
                }
            };
        }
        return this.timeNowColor;
    }

    public final Paint getTimeNowColor() {
        return (Paint)this.timeNowColorProperty().get();
    }

    public void setTimeNowColor(Paint color) {
        this.timeNowColorProperty().set((Object)color);
    }

    public final StyleableObjectProperty<Paint> innerLinesColorProperty() {
        if (this.innerLinesColor == null) {
            this.innerLinesColor = new StyleableObjectProperty(){

                public CssMetaData<GraphicsBase, Paint> getCssMetaData() {
                    return StyleableProperties.INNER_LINES_COLOR;
                }

                public Object getBean() {
                    return GraphicsBase.this;
                }

                public String getName() {
                    return "innerLinesColor";
                }
            };
        }
        return this.innerLinesColor;
    }

    public final Paint getInnerLinesColor() {
        return (Paint)this.innerLinesColorProperty().get();
    }

    public void setInnerLinesColor(Paint color) {
        this.innerLinesColorProperty().set((Object)color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return GraphicsBase.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<GraphicsBase, Paint> INNER_LINES_COLOR;
        private static final CssMetaData<GraphicsBase, Paint> GRID_LINE_COLOR1;
        private static final CssMetaData<GraphicsBase, Paint> GRID_LINE_COLOR2;
        private static final CssMetaData<GraphicsBase, Paint> GRID_LINE_COLOR3;
        private static final CssMetaData<GraphicsBase, Paint> WEEKEND_COLOR;
        private static final CssMetaData<GraphicsBase, Paint> TIME_NOW_COLOR;

        private StyleableProperties() {
        }

        static {
            INNER_LINES_COLOR = new CssMetaData<GraphicsBase, Paint>("-fx-inner-lines-color", PaintConverter.getInstance(), (Paint)Color.LIGHTGRAY){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getGridLineColor1();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.innerLinesColor == null || !n.innerLinesColor.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.innerLinesColorProperty();
                }
            };
            GRID_LINE_COLOR1 = new CssMetaData<GraphicsBase, Paint>("-fx-grid-line-color1", PaintConverter.getInstance(), (Paint)Color.LIGHTGRAY){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getGridLineColor1();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.gridLineColor1 == null || !n.gridLineColor1.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.gridLineColor1Property();
                }
            };
            GRID_LINE_COLOR2 = new CssMetaData<GraphicsBase, Paint>("-fx-grid-line-color2", PaintConverter.getInstance(), (Paint)Color.GRAY){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getGridLineColor2();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.gridLineColor2 == null || !n.gridLineColor2.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.gridLineColor2Property();
                }
            };
            GRID_LINE_COLOR3 = new CssMetaData<GraphicsBase, Paint>("-fx-grid-line-color3", PaintConverter.getInstance(), (Paint)Color.DARKGRAY){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getGridLineColor3();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.gridLineColor3 == null || !n.gridLineColor3.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.gridLineColor3Property();
                }
            };
            WEEKEND_COLOR = new CssMetaData<GraphicsBase, Paint>("-fx-weekend-color", PaintConverter.getInstance(), (Paint)Color.LIGHTGRAY){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getWeekendColor();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.weekendColor == null || !n.weekendColor.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.weekendColorProperty();
                }
            };
            TIME_NOW_COLOR = new CssMetaData<GraphicsBase, Paint>("-fx-time-now-color", PaintConverter.getInstance(), (Paint)Color.RED){

                public Paint getInitialValue(GraphicsBase node) {
                    return node.getTimeNowColor();
                }

                public boolean isSettable(GraphicsBase n) {
                    return n.timeNowColor == null || !n.timeNowColor.isBound();
                }

                public StyleableObjectProperty<Paint> getStyleableProperty(GraphicsBase n) {
                    return n.timeNowColorProperty();
                }
            };
            ArrayList<CssMetaData<GraphicsBase, Paint>> styleables = new ArrayList<CssMetaData<GraphicsBase, Paint>>(Region.getClassCssMetaData());
            styleables.add(INNER_LINES_COLOR);
            styleables.add(GRID_LINE_COLOR1);
            styleables.add(GRID_LINE_COLOR2);
            styleables.add(GRID_LINE_COLOR3);
            styleables.add(WEEKEND_COLOR);
            styleables.add(TIME_NOW_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private class GraphicsViewMenu
    extends ContextMenu {
        private final CalendarMenu calendarMenu;

        public GraphicsViewMenu(ContextMenuParameter<R> input) {
            Objects.requireNonNull(input);
            MenuItem highlightOn = new MenuItem(Messages.getString("GraphicsBase.HIGHLIGHT_ON"));
            highlightOn.setOnAction(this.highlightOn(input));
            highlightOn.disableProperty().bind((ObservableValue)Bindings.isEmpty(GraphicsBase.this.getSelectedActivities()));
            this.getItems().add((Object)highlightOn);
            MenuItem highlightOff = new MenuItem(Messages.getString("GraphicsBase.HIGHLIGHT_OFF"));
            highlightOff.setOnAction(this.highlightOff(input));
            highlightOff.disableProperty().bind((ObservableValue)Bindings.isEmpty(GraphicsBase.this.getHighlightedActivities()));
            this.getItems().add((Object)highlightOff);
            this.calendarMenu = new CalendarMenu();
            this.calendarMenu.setText(Messages.getString("GraphicsBase.CALENDAR_MENU_TITLE"));
            this.getItems().add((Object)this.calendarMenu);
            Object row = input.getRow();
            if (row != null) {
                ObservableList<Calendar<CalendarActivity>> globalCalendars = input.getGraphics().getCalendars();
                ObservableList<Calendar<?>> localCalendars = ((Row)row).getCalendars();
                ObservableList allCalendars = FXCollections.observableArrayList();
                allCalendars.addAll(globalCalendars);
                allCalendars.addAll(localCalendars);
                this.calendarMenu.setCalendars(allCalendars);
                this.calendarMenu.setDisable(false);
            } else {
                this.calendarMenu.setDisable(true);
            }
            GridMenu gridMenu = new GridMenu();
            gridMenu.setText(Messages.getString("GraphicsBase.GRID_MENU_TITLE"));
            gridMenu.setVirtualGrids(GraphicsBase.this.getVirtualGrids());
            this.getItems().add((Object)gridMenu);
        }

        private EventHandler<ActionEvent> highlightOff(ContextMenuParameter<R> input) {
            return event -> {
                GraphicsBase view = input.getGraphics();
                view.getHighlightedActivities().clear();
            };
        }

        private EventHandler<ActionEvent> highlightOn(ContextMenuParameter<R> input) {
            return event -> {
                GraphicsBase view = input.getGraphics();
                view.getHighlightedActivities().clear();
                view.getHighlightedActivities().addAll(view.getSelectedActivities());
            };
        }
    }

    private class GridMenu
    extends Menu {
        private ObservableList<VirtualGrid<?>> grids;
        private final InvalidationListener gridsListener = observable -> this.buildMenu();
        private final WeakInvalidationListener weakGridsListener = new WeakInvalidationListener(this.gridsListener);

        public void setVirtualGrids(ObservableList<VirtualGrid<?>> grids) {
            Objects.requireNonNull(grids);
            this.getItems().clear();
            this.grids = grids;
            this.grids.addListener((InvalidationListener)this.weakGridsListener);
            this.buildMenu();
        }

        private void buildMenu() {
            CheckMenuItem offItem = new CheckMenuItem(Messages.getString("GraphicsBase.GRID_OFF"));
            offItem.setSelected(!GraphicsBase.this.isGridEnabled());
            this.getItems().add((Object)offItem);
            offItem.setOnAction(evt -> {
                GraphicsBase.this.setAutoGridEnabled(false);
                GraphicsBase.this.setVirtualGrid(null);
            });
            CheckMenuItem autoGrid = new CheckMenuItem("Auto");
            autoGrid.setOnAction(evt -> GraphicsBase.this.setAutoGridEnabled(autoGrid.isSelected()));
            autoGrid.selectedProperty().set(GraphicsBase.this.isAutoGridEnabled());
            this.getItems().add((Object)autoGrid);
            this.getItems().add((Object)new SeparatorMenuItem());
            for (VirtualGrid grid : this.grids) {
                CheckMenuItem item = new CheckMenuItem(grid.getName());
                item.selectedProperty().set(grid.equals(GraphicsBase.this.getVirtualGrid()));
                item.setOnAction(evt -> GraphicsBase.this.setVirtualGrid(grid));
                this.getItems().add((Object)item);
            }
        }
    }

    private class CalendarMenu
    extends Menu {
        private ObservableList<Calendar<?>> calendars;
        private final InvalidationListener calendarListListener = it -> this.buildMenu();
        private final WeakInvalidationListener weakCalendarListListener = new WeakInvalidationListener(this.calendarListListener);

        public void setCalendars(ObservableList<Calendar<?>> calendars) {
            Objects.requireNonNull(calendars);
            this.getItems().clear();
            this.calendars = calendars;
            this.calendars.addListener((InvalidationListener)new WeakInvalidationListener((InvalidationListener)this.weakCalendarListListener));
            this.buildMenu();
        }

        private void buildMenu() {
            this.getItems().clear();
            for (Calendar calendar : this.calendars) {
                CheckMenuItem item = new CheckMenuItem((String)calendar.nameProperty().get());
                item.setSelected(calendar.visibleProperty().get());
                Bindings.bindBidirectional((Property)item.textProperty(), (Property)calendar.nameProperty());
                Bindings.bindBidirectional((Property)calendar.visibleProperty(), (Property)item.selectedProperty());
                this.getItems().add((Object)item);
            }
        }
    }

    class ChartHighLowEditModeCallback
    extends ActivityEditModeCallback {
        ChartHighLowEditModeCallback() {
        }

        @Override
        public EditMode call(EditModeCallbackParameter input) {
            ActivityBounds bounds = input.getActivityBounds();
            MouseEvent evt = input.getMouseEvent();
            Layout layout = bounds.getLayout();
            if (evt.getY() < bounds.getMinY() + 3.0 && layout instanceof ChartLayout) {
                return EditMode.CHART_VALUE_HIGH_CHANGE;
            }
            if (evt.getY() > bounds.getMinY() + bounds.getHeight() - 3.0 && layout instanceof ChartLayout) {
                return EditMode.CHART_VALUE_LOW_CHANGE;
            }
            return super.call(input);
        }
    }

    class ChartActivityEditModeCallback
    extends ActivityEditModeCallback {
        ChartActivityEditModeCallback() {
        }

        @Override
        public EditMode call(EditModeCallbackParameter input) {
            ActivityBounds bounds = input.getActivityBounds();
            MouseEvent evt = input.getMouseEvent();
            Layout layout = bounds.getLayout();
            ChartActivity chartActivity = (ChartActivity)bounds.getActivity();
            if (chartActivity.getChartValue() >= 0.0 ? evt.getY() < bounds.getMinY() + 3.0 && layout instanceof ChartLayout : evt.getY() > bounds.getMinY() + bounds.getHeight() - 3.0 && layout instanceof ChartLayout) {
                return EditMode.CHART_VALUE_CHANGE;
            }
            return super.call(input);
        }
    }

    class CompletableActivityEditModeCallback
    extends ActivityEditModeCallback {
        CompletableActivityEditModeCallback() {
        }

        @Override
        public EditMode call(EditModeCallbackParameter input) {
            ActivityBounds bounds = input.getActivityBounds();
            MouseEvent evt = input.getMouseEvent();
            CompletableActivity completableActivity = (CompletableActivity)bounds.getActivity();
            double xCompletion = bounds.getMinX() + bounds.getWidth() / 100.0 * completableActivity.getPercentageComplete();
            if (GraphicsBase.this.getSelectedActivities().contains(bounds.getActivityRef()) && evt.getX() > xCompletion - 3.0 && evt.getX() < xCompletion + 3.0) {
                return EditMode.PERCENTAGE_COMPLETE_CHANGE;
            }
            return super.call(input);
        }
    }

    class ActivityInAgendaLayoutEditModeCallback
    implements Callback<EditModeCallbackParameter, EditMode> {
        ActivityInAgendaLayoutEditModeCallback() {
        }

        public EditMode call(EditModeCallbackParameter input) {
            ActivityBounds bounds = input.getActivityBounds();
            MouseEvent evt = input.getMouseEvent();
            Layout layout = bounds.getLayout();
            if (evt.isShiftDown()) {
                return EditMode.DRAGGING;
            }
            if (evt.isShortcutDown()) {
                return EditMode.DRAGGING_VERTICAL;
            }
            if (layout instanceof AgendaLayout) {
                Position pos = bounds.getPosition();
                if (evt.getY() < bounds.getMinY() + 3.0) {
                    switch (pos) {
                        case FIRST: 
                        case ONLY: {
                            return EditMode.AGENDA_START_TIME_CHANGE;
                        }
                    }
                }
                if (evt.getY() > bounds.getMinY() + bounds.getHeight() - 3.0) {
                    switch (pos) {
                        case ONLY: 
                        case LAST: {
                            return EditMode.AGENDA_END_TIME_CHANGE;
                        }
                    }
                }
                return EditMode.AGENDA_DRAGGING;
            }
            return EditMode.NONE;
        }
    }

    class ActivityEditModeCallback
    implements Callback<EditModeCallbackParameter, EditMode> {
        ActivityEditModeCallback() {
        }

        public EditMode call(EditModeCallbackParameter input) {
            ActivityBounds bounds = input.getActivityBounds();
            MouseEvent evt = input.getMouseEvent();
            if (evt.getX() < bounds.getMinX() + 3.0) {
                return EditMode.START_TIME_CHANGE;
            }
            if (evt.getX() > bounds.getMinX() + bounds.getWidth() - 3.0) {
                return EditMode.END_TIME_CHANGE;
            }
            if (evt.isShiftDown()) {
                return EditMode.DRAGGING;
            }
            if (evt.isShortcutDown()) {
                return EditMode.DRAGGING_VERTICAL;
            }
            return EditMode.DRAGGING_HORIZONTAL;
        }
    }

    public static final class EditModeCallbackParameter {
        private final ActivityBounds activityBounds;
        private final MouseEvent event;

        public EditModeCallbackParameter(ActivityBounds activityBounds, MouseEvent event) {
            Objects.requireNonNull(activityBounds);
            Objects.requireNonNull(event);
            this.activityBounds = activityBounds;
            this.event = event;
        }

        public ActivityBounds getActivityBounds() {
            return this.activityBounds;
        }

        public MouseEvent getMouseEvent() {
            return this.event;
        }
    }

    public static enum RowEditingMode {
        NONE,
        SINGLE_ROW,
        MULTIPLE_ROWS;

    }

    public static final class RowEditorParameter<R extends Row<?, ?, ?>> {
        private final R row;
        private final GraphicsBase<R> graphics;

        public RowEditorParameter(GraphicsBase<R> graphics, R row) {
            Objects.requireNonNull(graphics);
            Objects.requireNonNull(row);
            this.graphics = graphics;
            this.row = row;
        }

        public R getRow() {
            return this.row;
        }

        public GraphicsBase<R> getGraphics() {
            return this.graphics;
        }

        public void stopEditing() {
            this.graphics.stopRowEditing(this.row);
        }
    }

    public static final class RowControlsParameter<R extends Row<?, ?, ?>> {
        private final R row;
        private final GraphicsBase<R> graphics;

        public RowControlsParameter(GraphicsBase<R> graphics, R row) {
            Objects.requireNonNull(graphics);
            Objects.requireNonNull(row);
            this.graphics = graphics;
            this.row = row;
        }

        public R getRow() {
            return this.row;
        }

        public GraphicsBase<R> getGraphics() {
            return this.graphics;
        }
    }

    public static enum DragAndDropFeedback {
        NATIVE,
        RENDERED,
        RENDERED_GRID_SNAPPED;

    }

    public static class DragAndDropInfo {
        private final Row<?, ?, ?> row;
        private final DragEvent dragEvent;
        private final ActivityBounds activityBounds;
        private final TimeInterval dropInterval;
        private final Point2D offset;
        private final List<ActivityBounds> selectedActivities;

        public DragAndDropInfo(Row<?, ?, ?> row, ActivityBounds activityBounds, List<ActivityBounds> selectedActivities, TimeInterval dropInterval, DragEvent dragEvent, Point2D offset) {
            this.row = row;
            this.activityBounds = Objects.requireNonNull(activityBounds);
            this.selectedActivities = Objects.requireNonNull(selectedActivities);
            this.dropInterval = Objects.requireNonNull(dropInterval);
            this.dragEvent = Objects.requireNonNull(dragEvent);
            this.offset = Objects.requireNonNull(offset);
        }

        public Row<?, ?, ?> getRow() {
            return this.row;
        }

        public ActivityBounds getActivityBounds() {
            return this.activityBounds;
        }

        public List<ActivityBounds> getSelectedActivities() {
            return this.selectedActivities;
        }

        public ActivityRef<?> getActivityRef() {
            return this.activityBounds.getActivityRef();
        }

        public DragEvent getDragEvent() {
            return this.dragEvent;
        }

        public TimeInterval getDropInterval() {
            return this.dropInterval;
        }

        public Point2D getOffset() {
            return this.offset;
        }

        public String toString() {
            return "drag info = target row: " + (this.row != null ? this.row.getName() : "<No Row>") + ", source row: " + this.activityBounds.getRow().getName() + ", activity: " + this.activityBounds.getActivity().getName() + ", time interval: " + this.dropInterval.toString() + ", drag event: " + this.dragEvent.toString();
        }
    }

    public static final class EditingCallbackParameter {
        private final ActivityRef<?> activityRef;
        private final EditMode editMode;

        public EditingCallbackParameter(ActivityRef<?> activityRef, EditMode editMode) {
            Objects.requireNonNull(activityRef);
            Objects.requireNonNull(editMode);
            this.activityRef = activityRef;
            this.editMode = editMode;
        }

        public final ActivityRef<?> getActivityRef() {
            return this.activityRef;
        }

        public final EditMode getEditMode() {
            return this.editMode;
        }
    }

    public static enum EditMode {
        NONE,
        DELETING,
        START_TIME_CHANGE,
        END_TIME_CHANGE,
        PERCENTAGE_COMPLETE_CHANGE,
        DRAGGING_HORIZONTAL,
        DRAGGING_VERTICAL,
        DRAGGING,
        AGENDA_START_TIME_CHANGE,
        AGENDA_END_TIME_CHANGE,
        AGENDA_DRAGGING,
        AGENDA_ASSIGNING,
        CHART_VALUE_CHANGE,
        CHART_VALUE_HIGH_CHANGE,
        CHART_VALUE_LOW_CHANGE;

    }

    public static enum LassoSelectionBehaviour {
        INTERSECTION,
        TIME_INTERVAL_CONTAINMENT,
        BOUNDS_CONTAINMENT;

    }

    public static enum SelectionMode {
        SINGLE,
        MULTIPLE,
        NONE;

    }

    public static final class ContextMenuParameter<R extends Row<?, ?, ?>> {
        private final GraphicsBase<R> graphics;
        private final R row;
        private final List<ActivityRef<?>> activities;
        private final Layout layout;
        private final Instant time;
        private final LocalTime localTime;

        public ContextMenuParameter(GraphicsBase<R> graphics, R row, List<ActivityRef<?>> activities, Layout layout, Instant time, LocalTime localTime) {
            this.graphics = Objects.requireNonNull(graphics);
            this.row = row;
            this.activities = activities;
            this.layout = layout;
            this.time = Objects.requireNonNull(time);
            this.localTime = localTime;
        }

        public final GraphicsBase<R> getGraphics() {
            return this.graphics;
        }

        public final R getRow() {
            return this.row;
        }

        public final List<ActivityRef<?>> getActivities() {
            return this.activities;
        }

        public Layout getLayout() {
            return this.layout;
        }

        public LocalTime getLocalTime() {
            return this.localTime;
        }

        public Instant getTime() {
            return this.time;
        }
    }

    private class HighlightThread
    extends Thread {
        private boolean running;

        public HighlightThread() {
            super("Highlight Thread");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            while (this.running) {
                this.highlight(!GraphicsBase.this.isHighlighted());
                try {
                    Thread.sleep(GraphicsBase.this.getHighlightDelay());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.highlight(false);
                }
            }
            this.highlight(false);
        }

        private void highlight(boolean highlight) {
            Platform.runLater(() -> GraphicsBase.this.setHighlighted(highlight));
        }

        public final void stopRunning() {
            this.running = false;
        }

        public final boolean isRunning() {
            return this.running;
        }
    }

    private class LassoEventHandlerProperty
    extends SimpleObjectProperty<EventHandler<LassoEvent>> {
        private final EventType<LassoEvent> eventType;

        public LassoEventHandlerProperty(String name, EventType<LassoEvent> eventType) {
            super((Object)GraphicsBase.this, name);
            this.eventType = eventType;
        }

        protected void invalidated() {
            GraphicsBase.this.setEventHandler(this.eventType, (EventHandler)this.get());
        }
    }

    private class ActivityEventHandlerProperty
    extends SimpleObjectProperty<EventHandler<ActivityEvent>> {
        private final EventType<ActivityEvent> eventType;

        public ActivityEventHandlerProperty(String name, EventType<ActivityEvent> eventType) {
            super((Object)GraphicsBase.this, name);
            this.eventType = eventType;
        }

        protected void invalidated() {
            GraphicsBase.this.setEventHandler(this.eventType, (EventHandler)this.get());
        }
    }

    private class LayerVisibilityListener
    implements ChangeListener<Boolean> {
        private LayerVisibilityListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            Property property = (Property)observable;
            Layer layer = (Layer)property.getBean();
            if (newValue.booleanValue()) {
                this.fade(layer, GraphicsBase.this.getOpacity());
            } else {
                this.fade(layer, 0.0);
            }
        }

        private void fade(Layer layer, double opacityTarget) {
            if (GraphicsBase.this.isFadeInOutVisibilityChanges()) {
                KeyValue keyValue = new KeyValue((WritableValue)layer.fadeInOutOpacityProperty(), (Object)opacityTarget);
                KeyFrame keyFrame = new KeyFrame(Duration.millis((double)GraphicsBase.this.getFadeInOutVisibilityChangesDuration()), new KeyValue[]{keyValue});
                Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
                timeline.play();
            } else {
                layer.setFadeInOutOpacity(opacityTarget);
            }
        }
    }
}

