/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.util.TimeInterval;
import java.time.Instant;
import java.util.Objects;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;

public class ActivityEvent
extends InputEvent {
    private static final long serialVersionUID = 6875000631749792169L;
    public static final EventType<ActivityEvent> ACTIVITY_CHANGE = new EventType(InputEvent.ANY, "ACTIVITY_CHANGE");
    public static final EventType<ActivityEvent> ACTIVITY_CHANGE_STARTED = new EventType(ACTIVITY_CHANGE, "ACTIVITY_CHANGE");
    public static final EventType<ActivityEvent> ACTIVITY_CHANGE_ONGOING = new EventType(ACTIVITY_CHANGE, "ACTIVITY_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> ACTIVITY_CHANGE_FINISHED = new EventType(ACTIVITY_CHANGE, "ACTIVITY_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> ACTIVITY_DELETED = new EventType(ACTIVITY_CHANGE, "ACTIVITY_DELETED");
    public static final EventType<ActivityEvent> START_TIME_CHANGE_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "START_TIME_CHANGE_STARTED");
    public static final EventType<ActivityEvent> START_TIME_CHANGE_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "START_TIME_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> START_TIME_CHANGE_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "START_TIME_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> END_TIME_CHANGE_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "END_TIME_CHANGE_STARTED");
    public static final EventType<ActivityEvent> END_TIME_CHANGE_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "END_TIME_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> END_TIME_CHANGE_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "END_TIME_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> HORIZONTAL_DRAG_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "HORIZONTAL_DRAG_STARTED");
    public static final EventType<ActivityEvent> HORIZONTAL_DRAG_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "HORIZONTAL_DRAG_ONGOING");
    public static final EventType<ActivityEvent> HORIZONTAL_DRAG_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "HORIZONTAL_DRAG_FINISHED");
    public static final EventType<ActivityEvent> VERTICAL_DRAG_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "VERTICAL_DRAG_STARTED");
    public static final EventType<ActivityEvent> VERTICAL_DRAG_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "VERTICAL_DRAG_ONGOING");
    public static final EventType<ActivityEvent> VERTICAL_DRAG_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "VERTICAL_DRAG_FINISHED");
    public static final EventType<ActivityEvent> VERTICAL_DRAG_DONE = new EventType(ACTIVITY_CHANGE_FINISHED, "VERTICAL_DRAG_DONE");
    public static final EventType<ActivityEvent> DRAG_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "DRAG_STARTED");
    public static final EventType<ActivityEvent> DRAG_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "DRAG_ONGOING");
    public static final EventType<ActivityEvent> DRAG_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "DRAG_FINISHED");
    public static final EventType<ActivityEvent> DRAG_DONE = new EventType(ACTIVITY_CHANGE_FINISHED, "DRAG_DONE");
    public static final EventType<ActivityEvent> PERCENTAGE_CHANGE_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "PERCENTAGE_CHANGE_STARTED");
    public static final EventType<ActivityEvent> PERCENTAGE_CHANGE_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "PERCENTAGE_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> PERCENTAGE_CHANGE_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "PERCENTAGE_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> CHART_VALUE_CHANGE_STARTED = new EventType(ACTIVITY_CHANGE_STARTED, "CHART_VALUE_CHANGE_STARTED");
    public static final EventType<ActivityEvent> CHART_VALUE_CHANGE_FINISHED = new EventType(ACTIVITY_CHANGE_FINISHED, "CHART_VALUE_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> CHART_VALUE_CHANGE_ONGOING = new EventType(ACTIVITY_CHANGE_ONGOING, "CHART_VALUE_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> CHART_HIGH_VALUE_CHANGE_STARTED = new EventType(CHART_VALUE_CHANGE_STARTED, "CHART_HIGH_VALUE_CHANGE_STARTED");
    public static final EventType<ActivityEvent> CHART_HIGH_VALUE_CHANGE_FINISHED = new EventType(CHART_VALUE_CHANGE_FINISHED, "CHART_HIGH_VALUE_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> CHART_HIGH_VALUE_CHANGE_ONGOING = new EventType(CHART_VALUE_CHANGE_ONGOING, "CHART_HIGH_VALUE_CHANGE_ONGOING");
    public static final EventType<ActivityEvent> CHART_LOW_VALUE_CHANGE_STARTED = new EventType(CHART_VALUE_CHANGE_STARTED, "CHART_LOW_VALUE_CHANGE_STARTED");
    public static final EventType<ActivityEvent> CHART_LOW_VALUE_CHANGE_FINISHED = new EventType(CHART_VALUE_CHANGE_FINISHED, "CHART_LOW_VALUE_CHANGE_FINISHED");
    public static final EventType<ActivityEvent> CHART_LOW_VALUE_CHANGE_ONGOING = new EventType(CHART_VALUE_CHANGE_ONGOING, "CHART_LOW_VALUE_CHANGE_ONGOING");
    private Instant oldTime;
    private TimeInterval oldTimeInterval;
    private Row<?, ?, ?> oldRow;
    private Row<?, ?, ?> newRow;
    private double oldValue;
    private final ActivityRef<?> activityRef;

    public ActivityEvent(ActivityRef<?> activity, EventTarget target, EventType<? extends ActivityEvent> eventType) {
        super(activity, target, eventType);
        Objects.requireNonNull(activity);
        this.activityRef = activity;
    }

    public ActivityEvent(ActivityRef<?> activity, EventTarget target, EventType<? extends ActivityEvent> eventType, Instant oldTime) {
        super(activity, target, eventType);
        Objects.requireNonNull(activity);
        Objects.requireNonNull(oldTime);
        this.activityRef = activity;
        this.oldTime = oldTime;
    }

    public ActivityEvent(ActivityRef<?> activity, EventTarget target, EventType<? extends ActivityEvent> eventType, TimeInterval oldInterval) {
        super(activity, target, eventType);
        Objects.requireNonNull(activity);
        Objects.requireNonNull(oldInterval);
        this.activityRef = activity;
        this.oldTimeInterval = oldInterval;
    }

    public ActivityEvent(ActivityRef<?> activity, EventTarget target, EventType<? extends ActivityEvent> eventType, Row<?, ?, ?> oldRow, Row<?, ?, ?> newRow, TimeInterval oldTimeInterval) {
        super(activity, target, eventType);
        Objects.requireNonNull(activity);
        Objects.requireNonNull(oldRow);
        Objects.requireNonNull(newRow);
        Objects.requireNonNull(oldTimeInterval);
        this.activityRef = activity;
        this.oldRow = oldRow;
        this.newRow = newRow;
        this.oldTimeInterval = oldTimeInterval;
    }

    public ActivityEvent(ActivityRef<?> activity, EventTarget target, EventType<? extends ActivityEvent> eventType, double oldValue) {
        super(activity, target, eventType);
        Objects.requireNonNull(activity);
        Objects.requireNonNull(oldValue);
        this.activityRef = activity;
        this.oldValue = oldValue;
    }

    public final ActivityRef<?> getActivityRef() {
        return this.activityRef;
    }

    public final Instant getOldTime() {
        return this.oldTime;
    }

    public final TimeInterval getOldTimeInterval() {
        return this.oldTimeInterval;
    }

    public final Row<?, ?, ?> getNewRow() {
        return this.newRow;
    }

    public final Row<?, ?, ?> getOldRow() {
        return this.oldRow;
    }

    public final double getOldValue() {
        return this.oldValue;
    }

    public final TimeInterval getAffectedTimeInterval() {
        Object activity = this.getActivityRef().getActivity();
        if (this.isPotentialEndTimeChange()) {
            Instant et2;
            Instant et1 = activity.getEndTime();
            if (et1.isBefore(et2 = this.getOldTime())) {
                return new TimeInterval(activity.getStartTime(), et2);
            }
            return new TimeInterval(activity.getStartTime(), et1);
        }
        if (this.isPotentialStartTimeChange()) {
            Instant st2;
            Instant st1 = activity.getStartTime();
            if (st1.isBefore(st2 = this.getOldTime())) {
                return new TimeInterval(st1, activity.getEndTime());
            }
            return new TimeInterval(st2, activity.getEndTime());
        }
        if (this.isPotentialTimeIntervalChange()) {
            Instant st1 = activity.getStartTime();
            Instant st2 = this.getOldTimeInterval().getStartTime();
            Instant et1 = activity.getEndTime();
            Instant et2 = this.getOldTimeInterval().getEndTime();
            Instant st = st1.isBefore(st2) ? st1 : st2;
            Instant et = et1.isBefore(et2) ? et2 : et1;
            return new TimeInterval(st, et);
        }
        return new TimeInterval(activity.getStartTime(), activity.getEndTime());
    }

    public final boolean isPotentialEndTimeChange() {
        EventType type = this.getEventType();
        return type.equals(END_TIME_CHANGE_STARTED) || type.equals(END_TIME_CHANGE_ONGOING) || type.equals(END_TIME_CHANGE_FINISHED);
    }

    public final boolean isPotentialStartTimeChange() {
        EventType type = this.getEventType();
        return type.equals(START_TIME_CHANGE_STARTED) || type.equals(START_TIME_CHANGE_ONGOING) || type.equals(START_TIME_CHANGE_FINISHED);
    }

    public final boolean isPotentialTimeIntervalChange() {
        EventType type = this.getEventType();
        return type.equals(HORIZONTAL_DRAG_STARTED) || type.equals(HORIZONTAL_DRAG_ONGOING) || type.equals(HORIZONTAL_DRAG_FINISHED) || type.equals(DRAG_STARTED) || type.equals(DRAG_ONGOING) || type.equals(DRAG_FINISHED);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("event type: ");
        sb.append(this.getEventType());
        sb.append(", time interval: ");
        if (this.getOldTimeInterval() != null) {
            sb.append(this.getOldTimeInterval());
        } else {
            sb.append("[]");
        }
        sb.append(", value (chart value / percentage complete): ");
        sb.append(this.getOldValue());
        sb.append(", ");
        sb.append(this.getActivityRef());
        return sb.toString();
    }
}

