/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.util.Position;
import java.util.Objects;
import javafx.geometry.Rectangle2D;

public final class ActivityBounds
extends Rectangle2D {
    private final ActivityRef<?> activityRef;
    private Layout layout;
    private Position position;

    public ActivityBounds(ActivityRef<?> activityRef, double x, double y, double width, double height) {
        super(x, y, Math.max(0.0, width), Math.max(0.0, height));
        this.activityRef = Objects.requireNonNull(activityRef);
    }

    public final Activity getActivity() {
        return this.activityRef.getActivity();
    }

    public final Layer getLayer() {
        return this.activityRef.getLayer();
    }

    public final int getLineIndex() {
        return this.activityRef.getLineIndex();
    }

    public final Row<?, ?, ?> getRow() {
        return this.activityRef.getRow();
    }

    public final ActivityRef<?> getActivityRef() {
        return this.activityRef;
    }

    public final void setPosition(Position position) {
        this.position = position;
    }

    public final Position getPosition() {
        return this.position;
    }

    public final void setLayout(Layout layout) {
        this.layout = layout;
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activityRef == null ? 0 : this.activityRef.hashCode());
        result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ActivityBounds other = (ActivityBounds)((Object)obj);
        if (this.activityRef == null ? other.activityRef != null : !this.activityRef.equals(other.activityRef)) {
            return false;
        }
        if (this.layout == null ? other.layout != null : !this.layout.equals(other.layout)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "ActivityBounds [bounds = " + super.toString() + ", activityRef=" + this.activityRef + ", layout=" + this.layout + ", position=" + (Object)((Object)this.position) + "]";
    }
}

