/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.container;

import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.container.ContainerBase;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.container.QuadGanttChartContainerSkin;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.PropertySheet;

public abstract class QuadGanttChartContainerBase<T extends GanttChartBase<?>>
extends ContainerBase<T> {
    private final MasterDetailPane upperLowerMasterDetailPane;
    private final MasterDetailPane upperMasterDetailPane;
    private final MasterDetailPane lowerMasterDetailPane;
    private final ObjectProperty<T> upperLeftGanttChart = new SimpleObjectProperty((Object)this, "upperLeftGanttChart");
    private final ObjectProperty<Node> upperLeftHeader = new SimpleObjectProperty((Object)this, "upperLeftHeader");
    private final ObjectProperty<Node> upperLeftFooter = new SimpleObjectProperty((Object)this, "upperLeftFooter");
    private final ObjectProperty<Node> upperRightHeader = new SimpleObjectProperty((Object)this, "upperRightHeader");
    private final ObjectProperty<Node> upperRightFooter = new SimpleObjectProperty((Object)this, "upperRightFooter");
    private final ObjectProperty<T> upperRightGanttChart = new SimpleObjectProperty((Object)this, "upperRightGanttChart");
    private final ObjectProperty<Node> lowerRightHeader = new SimpleObjectProperty((Object)this, "lowerRightHeader");
    private final ObjectProperty<Node> lowerRightFooter = new SimpleObjectProperty((Object)this, "lowerRightFooter");
    private final ObjectProperty<T> lowerRightGanttChart = new SimpleObjectProperty((Object)this, "lowerRightGanttChart");
    private final ObjectProperty<T> lowerLeftGanttChart = new SimpleObjectProperty((Object)this, "lowerLeftGanttChart");
    private final ObjectProperty<Node> lowerLeftHeader = new SimpleObjectProperty((Object)this, "lowerLeftHeader");
    private final ObjectProperty<Node> lowerLeftFooter = new SimpleObjectProperty((Object)this, "lowerLeftFooter");
    private final BooleanProperty showLower = new SimpleBooleanProperty((Object)this, "showLower", true);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", true);
    private static final String QUAD_GANTT_CHART_CONTAINER_PROPERTIES_CATEGORY = "Control: Quad Gantt Chart Container";

    protected QuadGanttChartContainerBase(T upperLeftGanttChart, T upperRightGanttChart, T lowerLeftGanttChart, T lowerRightGanttChart) {
        super(true);
        this.upperLowerMasterDetailPane = new MasterDetailPane(Side.BOTTOM);
        this.upperLowerMasterDetailPane.setId("upper-lower-master-detail-pane");
        this.upperLowerMasterDetailPane.setDividerPosition(0.5);
        this.upperMasterDetailPane = new MasterDetailPane(Side.RIGHT);
        this.upperMasterDetailPane.setId("upper-master-detail-pane");
        this.upperMasterDetailPane.setDividerPosition(0.5);
        this.lowerMasterDetailPane = new MasterDetailPane(Side.RIGHT);
        this.lowerMasterDetailPane.setId("lower-master-detail-pane");
        this.lowerMasterDetailPane.setDividerPosition(0.5);
        this.upperLowerMasterDetailPane.animatedProperty().bind((ObservableValue)this.animatedProperty());
        this.upperMasterDetailPane.animatedProperty().bind((ObservableValue)this.animatedProperty());
        this.lowerMasterDetailPane.animatedProperty().bind((ObservableValue)this.animatedProperty());
        this.upperLeftGanttChartProperty().addListener((observable, oldGantt, newGantt) -> {
            if (oldGantt != null) {
                this.getGanttCharts().remove((Object)oldGantt);
            }
            newGantt.getTimeline().setId("upper-left-timeline");
            this.getGanttCharts().add(0, (Object)newGantt);
            newGantt.setPosition(Position.FIRST);
        });
        this.upperRightGanttChartProperty().addListener((observable, oldGantt, newGantt) -> {
            if (oldGantt != null) {
                this.getGanttCharts().remove((Object)oldGantt);
            }
            newGantt.getTimeline().setId("upper-right-timeline");
            this.getGanttCharts().add((Object)newGantt);
            newGantt.setPosition(Position.FIRST);
        });
        this.lowerLeftGanttChartProperty().addListener((observable, oldGantt, newGantt) -> {
            if (oldGantt != null) {
                this.getGanttCharts().remove((Object)oldGantt);
            }
            newGantt.getTimeline().setId("lower-left-timeline");
            this.getGanttCharts().add((Object)newGantt);
            newGantt.setPosition(Position.LAST);
        });
        this.lowerRightGanttChartProperty().addListener((observable, oldGantt, newGantt) -> {
            if (oldGantt != null) {
                this.getGanttCharts().remove((Object)oldGantt);
            }
            newGantt.getTimeline().setId("lower-right-timeline");
            this.getGanttCharts().add((Object)newGantt);
            newGantt.setPosition(Position.LAST);
        });
        this.setUpperLeftGanttChart(upperLeftGanttChart);
        this.setUpperRightGanttChart(upperRightGanttChart);
        this.setLowerLeftGanttChart(lowerLeftGanttChart);
        this.setLowerRightGanttChart(lowerRightGanttChart);
    }

    protected Skin<?> createDefaultSkin() {
        return new QuadGanttChartContainerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return GanttChart.class.getResource("gantt.css").toExternalForm();
    }

    public final MasterDetailPane getUpperLowerMasterDetailPane() {
        return this.upperLowerMasterDetailPane;
    }

    public final MasterDetailPane getUpperMasterDetailPane() {
        return this.upperMasterDetailPane;
    }

    public final MasterDetailPane getLowerMasterDetailPane() {
        return this.lowerMasterDetailPane;
    }

    public final ObjectProperty<T> upperLeftGanttChartProperty() {
        return this.upperLeftGanttChart;
    }

    public final void setUpperLeftGanttChart(T ganttChart) {
        this.upperLeftGanttChart.set(ganttChart);
    }

    public final T getUpperLeftGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.upperLeftGanttChart.get())));
    }

    public final ObjectProperty<Node> upperLeftHeaderProperty() {
        return this.upperLeftHeader;
    }

    public final void setUpperLeftHeader(Node header) {
        this.upperLeftHeaderProperty().set((Object)header);
    }

    public final Node getUpperLeftHeader() {
        return (Node)this.upperLeftHeaderProperty().get();
    }

    public final ObjectProperty<Node> upperLeftFooterProperty() {
        return this.upperLeftFooter;
    }

    public final void setUpperLeftFooter(Node footer) {
        this.upperLeftFooterProperty().set((Object)footer);
    }

    public final Node getUpperLeftFooter() {
        return (Node)this.upperLeftFooterProperty().get();
    }

    public final ObjectProperty<Node> upperRightHeaderProperty() {
        return this.upperRightHeader;
    }

    public final void setUpperRightHeader(Node header) {
        this.upperRightHeaderProperty().set((Object)header);
    }

    public final Node getUpperRightHeader() {
        return (Node)this.upperRightHeaderProperty().get();
    }

    public final ObjectProperty<Node> upperRightFooterProperty() {
        return this.upperRightFooter;
    }

    public final void setUpperRightFooter(Node footer) {
        this.upperRightFooter.set((Object)footer);
    }

    public final Node getUpperRightFooter() {
        return (Node)this.upperRightFooter.get();
    }

    public final ObjectProperty<T> upperRightGanttChartProperty() {
        return this.upperRightGanttChart;
    }

    public final void setUpperRightGanttChart(T ganttChart) {
        this.upperRightGanttChart.set(ganttChart);
    }

    public final T getUpperRightGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.upperRightGanttChart.get())));
    }

    public final ObjectProperty<Node> lowerRightHeaderProperty() {
        return this.lowerRightHeader;
    }

    public final void setLowerRightHeader(Node header) {
        this.lowerRightHeaderProperty().set((Object)header);
    }

    public final Node getLowerRightHeader() {
        return (Node)this.lowerRightHeaderProperty().get();
    }

    public final ObjectProperty<Node> lowerRightFooterProperty() {
        return this.lowerRightFooter;
    }

    public final void setLowerRightFooter(Node footer) {
        this.lowerRightFooter.set((Object)footer);
    }

    public final Node getLowerRightFooter() {
        return (Node)this.lowerRightFooter.get();
    }

    public final ObjectProperty<T> lowerRightGanttChartProperty() {
        return this.lowerRightGanttChart;
    }

    public final void setLowerRightGanttChart(T ganttChart) {
        this.lowerRightGanttChart.set(ganttChart);
    }

    public final T getLowerRightGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.lowerRightGanttChart.get())));
    }

    public final ObjectProperty<T> lowerLeftGanttChartProperty() {
        return this.lowerLeftGanttChart;
    }

    public final void setLowerLeftGanttChart(T ganttChart) {
        this.lowerLeftGanttChart.set(ganttChart);
    }

    public final T getLowerLeftGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.lowerLeftGanttChart.get())));
    }

    public final ObjectProperty<Node> lowerLeftHeaderProperty() {
        return this.lowerLeftHeader;
    }

    public final void setLowerLeftHeader(Node header) {
        this.lowerLeftHeaderProperty().set((Object)header);
    }

    public final Node getLowerLeftHeader() {
        return (Node)this.lowerLeftHeaderProperty().get();
    }

    public final ObjectProperty<Node> lowerLeftFooterProperty() {
        return this.lowerLeftFooter;
    }

    public final void setLowerLeftFooter(Node footer) {
        this.lowerLeftFooterProperty().set((Object)footer);
    }

    public final Node getLowerLeftFooter() {
        return (Node)this.lowerLeftFooterProperty().get();
    }

    public final BooleanProperty showLowerProperty() {
        return this.showLower;
    }

    public final boolean isShowLower() {
        return this.showLowerProperty().get();
    }

    public final void setShowLower(boolean show) {
        this.showLowerProperty().set(show);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final void showSingleChart() {
        this.setShowLower(false);
        this.getUpperMasterDetailPane().setShowDetailNode(false);
    }

    public final void showHorizontalSplitScreen(boolean equalHeight) {
        if (equalHeight) {
            this.getUpperLowerMasterDetailPane().setDividerPosition(0.5);
        }
        this.setShowLower(true);
        this.getUpperMasterDetailPane().setShowDetailNode(false);
    }

    public final void showVerticalSplitScreen(boolean equalWidth) {
        if (equalWidth) {
            this.getUpperMasterDetailPane().setDividerPosition(0.5);
        }
        this.setShowLower(false);
        this.getUpperMasterDetailPane().setShowDetailNode(true);
    }

    public final void showAllFour(boolean equalSize) {
        if (equalSize) {
            this.getUpperMasterDetailPane().setDividerPosition(0.5);
            this.getUpperLowerMasterDetailPane().setDividerPosition(0.5);
        }
        this.setShowLower(true);
        this.getUpperMasterDetailPane().setShowDetailNode(true);
    }

    public final ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(QuadGanttChartContainerBase.this.showLowerProperty());
            }

            @Override
            public void setValue(Object value) {
                QuadGanttChartContainerBase.this.setShowLower((Boolean)value);
            }

            @Override
            public Object getValue() {
                return QuadGanttChartContainerBase.this.isShowLower();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Show Lower";
            }

            @Override
            public String getDescription() {
                return "Show lower charts";
            }

            @Override
            public String getCategory() {
                return QuadGanttChartContainerBase.QUAD_GANTT_CHART_CONTAINER_PROPERTIES_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(QuadGanttChartContainerBase.this.animatedProperty());
            }

            @Override
            public void setValue(Object value) {
                QuadGanttChartContainerBase.this.setAnimated((Boolean)value);
            }

            @Override
            public Object getValue() {
                return QuadGanttChartContainerBase.this.isAnimated();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Animated";
            }

            @Override
            public String getDescription() {
                return "Open / close animations";
            }

            @Override
            public String getCategory() {
                return QuadGanttChartContainerBase.QUAD_GANTT_CHART_CONTAINER_PROPERTIES_CATEGORY;
            }
        });
        return items;
    }
}

