/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject.view;

import com.flexganttfx.msproject.model.MSProjectTaskRow;
import com.flexganttfx.view.graphics.GraphicsBase;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import net.sf.mpxj.Task;

public class MSProjectTaskDetails
extends GridPane {
    public MSProjectTaskDetails(GraphicsBase<MSProjectTaskRow> graphics, MSProjectTaskRow row) {
        this.setStyle("-fx-background-color: beige; -fx-padding: 10; -fx-border-color: lightgray; -fx-border-width: .5px;");
        this.setHgap(10.0);
        this.setVgap(10.0);
        Task task = row.getTask();
        Label title = new Label(task.getName());
        title.setFont(Font.font((double)18.0));
        Label startLabel = new Label("Start");
        Label finishLabel = new Label("Finish");
        DatePicker startPicker = new DatePicker(LocalDate.from(LocalDateTime.ofInstant(task.getStart().toInstant(), ZoneId.systemDefault())));
        DatePicker finishPicker = new DatePicker(LocalDate.from(LocalDateTime.ofInstant(task.getFinish().toInstant(), ZoneId.systemDefault())));
        Label percentage = new Label(task.getPercentageComplete().toString() + "%");
        percentage.setFont(Font.font((double)32.0));
        TextArea text = new TextArea(task.getNotes());
        text.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Button close = new Button("Close");
        close.setOnAction(evt -> graphics.stopRowEditing(row));
        this.add((Node)title, 0, 0);
        GridPane.setColumnSpan((Node)title, (Integer)4);
        this.add((Node)startLabel, 0, 1);
        this.add((Node)startPicker, 1, 1);
        this.add((Node)finishLabel, 0, 2);
        this.add((Node)finishPicker, 1, 2);
        this.add((Node)percentage, 0, 3);
        GridPane.setColumnSpan((Node)percentage, (Integer)2);
        GridPane.setHalignment((Node)percentage, (HPos)HPos.CENTER);
        this.add((Node)text, 2, 1);
        GridPane.setRowSpan((Node)text, (Integer)3);
        this.add((Node)close, 3, 1);
        this.setMinSize(0.0, 0.0);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setPrefHeight(200.0);
    }
}

