/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject.view;

import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.msproject.model.MSProjectGanttChartModel;
import com.flexganttfx.msproject.model.MSProjectTaskActivity;
import com.flexganttfx.msproject.model.MSProjectTaskRow;
import com.flexganttfx.msproject.view.MSProjectTaskActivityRenderer;
import com.flexganttfx.msproject.view.MSProjectTaskDetails;
import com.flexganttfx.view.GanttChartLite;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.timeline.Timeline;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.util.Callback;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

public class MSProjectGraphicsChartLite
extends GanttChartLite<MSProjectTaskRow> {
    public MSProjectGraphicsChartLite() {
        this.getStylesheets().add((Object)MSProjectGraphicsChartLite.class.getResource("msproject.css").toExternalForm());
        this.getGraphics().setActivityRenderer(MSProjectTaskActivity.class, GanttLayout.class, new MSProjectTaskActivityRenderer(this.getGraphics()));
        ArrayList<TreeTableColumn> columns = new ArrayList<TreeTableColumn>();
        TreeTableColumn nameColumn = new TreeTableColumn("Name");
        TreeTableColumn startColumn = new TreeTableColumn("Start");
        TreeTableColumn finishColumn = new TreeTableColumn("Finish");
        TreeTableColumn percentageCompleteColumn = new TreeTableColumn("%");
        TreeTableColumn percentageCompleteVisualColumn = new TreeTableColumn("Complete");
        nameColumn.setPrefWidth(250.0);
        startColumn.setPrefWidth(100.0);
        finishColumn.setPrefWidth(100.0);
        percentageCompleteColumn.setPrefWidth(40.0);
        percentageCompleteVisualColumn.setPrefWidth(100.0);
        nameColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("name"));
        startColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("startTime"));
        finishColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("finishTime"));
        percentageCompleteColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("percentageComplete"));
        percentageCompleteVisualColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("percentageComplete"));
        Callback nameCellFactory = param -> new TreeTableCell<MSProjectTaskRow, String>(){
            private Label parentImage;
            private Label childImage;

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (this.parentImage == null) {
                    this.parentImage = new Label();
                    this.parentImage.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.parentImage.getStyleClass().add((Object)"parent-task-image");
                    this.childImage = new Label();
                    this.childImage.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.childImage.getStyleClass().add((Object)"child-task-image");
                }
                if (item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    return;
                }
                this.setText(item);
                MSProjectTaskRow row = (MSProjectTaskRow)this.getTreeTableRow().getItem();
                if (row != null && row.getChildren().size() > 0) {
                    this.setGraphic((Node)this.parentImage);
                } else {
                    this.setGraphic((Node)this.childImage);
                }
            }
        };
        nameColumn.setCellFactory(nameCellFactory);
        Callback<TreeTableColumn<MSProjectTaskRow, Instant>, TreeTableCell<MSProjectTaskRow, Instant>> dateTimeCellFactory = new Callback<TreeTableColumn<MSProjectTaskRow, Instant>, TreeTableCell<MSProjectTaskRow, Instant>>(){
            private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);

            public TreeTableCell<MSProjectTaskRow, Instant> call(TreeTableColumn<MSProjectTaskRow, Instant> param) {
                return new TreeTableCell<MSProjectTaskRow, Instant>(){

                    protected void updateItem(Instant item, boolean empty) {
                        if (item != null) {
                            this.setText(formatter.format(ZonedDateTime.ofInstant(item, ZoneId.systemDefault())));
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
        startColumn.setCellFactory((Callback)dateTimeCellFactory);
        finishColumn.setCellFactory((Callback)dateTimeCellFactory);
        Callback<TreeTableColumn<MSProjectTaskRow, Double>, TreeTableCell<MSProjectTaskRow, Double>> percentageCellFactory = new Callback<TreeTableColumn<MSProjectTaskRow, Double>, TreeTableCell<MSProjectTaskRow, Double>>(){
            private NumberFormat formatter = DecimalFormat.getPercentInstance();

            public TreeTableCell<MSProjectTaskRow, Double> call(TreeTableColumn<MSProjectTaskRow, Double> param) {
                return new TreeTableCell<MSProjectTaskRow, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        if (item != null) {
                            this.setText(formatter.format(item / 100.0));
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
        percentageCompleteColumn.setCellFactory((Callback)percentageCellFactory);
        Callback percentageVisualCellFactory = param -> new TreeTableCell<MSProjectTaskRow, Double>(){
            private ProgressBar progressBar;

            protected void updateItem(Double item, boolean empty) {
                if (this.progressBar == null) {
                    this.progressBar = new ProgressBar();
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                }
                if (item != null) {
                    this.progressBar.setProgress(item / 100.0);
                    this.setGraphic((Node)this.progressBar);
                } else {
                    this.setGraphic(null);
                }
            }
        };
        percentageCompleteVisualColumn.setCellFactory(percentageVisualCellFactory);
        columns.add(nameColumn);
        columns.add(percentageCompleteColumn);
        columns.add(percentageCompleteVisualColumn);
        columns.add(startColumn);
        columns.add(finishColumn);
        this.getGraphics().setRowEditorFactory(new Callback<GraphicsBase.RowEditorParameter<MSProjectTaskRow>, Node>(){

            public Node call(GraphicsBase.RowEditorParameter<MSProjectTaskRow> param) {
                return new MSProjectTaskDetails(param.getGraphics(), param.getRow());
            }
        });
    }

    public final void load(String fileName, InputStream stream) throws FileNotFoundException {
        try {
            ProjectReader reader = ProjectReaderUtility.getProjectReader(fileName);
            ProjectFile projectFile = reader.read(stream);
            MSProjectGanttChartModel model = new MSProjectGanttChartModel(projectFile);
            this.getLayers().setAll(model.getLayers());
            this.getLinks().setAll(model.getLinks());
            Timeline timeline = this.getTimeline();
            timeline.showTime(projectFile.getStartDate().toInstant().minus(3L, ChronoUnit.DAYS));
        }
        catch (IllegalAccessException | InstantiationException | MPXJException e) {
            e.printStackTrace();
        }
    }

    public final void load(File file) throws FileNotFoundException {
        this.load(file.getName(), new FileInputStream(file));
    }
}

