/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject.model;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.repository.ListActivityRepository;
import com.flexganttfx.msproject.model.MSProjectTaskActivity;
import java.time.Instant;
import java.util.Map;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import net.sf.mpxj.Task;

public class MSProjectTaskRow
extends Row<MSProjectTaskRow, MSProjectTaskRow, MSProjectTaskActivity> {
    private final ObjectProperty<Instant> startTime = new SimpleObjectProperty();
    public final ObjectProperty<Instant> finishTime = new SimpleObjectProperty();
    public final DoubleProperty percentageComplete = new SimpleDoubleProperty();

    public MSProjectTaskRow() {
    }

    public MSProjectTaskRow(Layer layer, Task task, Map<Task, ActivityRef<MSProjectTaskActivity>> taskMap) {
        this.setName(task.getName());
        this.setUserObject(task);
        this.setExpanded(true);
        this.setRepository(new ListActivityRepository(ListActivityRepository.IteratorType.SIMPLE_ITERATOR));
        for (Task childTask : task.getChildTasks()) {
            this.getChildren().add((Object)new MSProjectTaskRow(layer, childTask, taskMap));
        }
        this.startTime.set((Object)task.getStart().toInstant());
        this.finishTime.set((Object)task.getFinish().toInstant());
        this.percentageComplete.set(task.getPercentageComplete().doubleValue());
        MSProjectTaskActivity activity = new MSProjectTaskActivity(this);
        this.addActivity(layer, activity);
        taskMap.put(task, new ActivityRef<MSProjectTaskActivity>(this, layer, activity));
    }

    public final Task getTask() {
        return (Task)this.getUserObject();
    }

    public final ObjectProperty<Instant> starTimeProperty() {
        return this.startTime;
    }

    public final Instant getStartTime() {
        return (Instant)this.startTime.get();
    }

    public final void setStartTime(Instant instant) {
        this.startTime.set((Object)instant);
    }

    public final ObjectProperty<Instant> finishTimeProperty() {
        return this.finishTime;
    }

    public final Instant getFinishTime() {
        return (Instant)this.finishTime.get();
    }

    public final void setFinishTime(Instant instant) {
        this.finishTime.set((Object)instant);
    }

    public final DoubleProperty percentageCompleteProperty() {
        return this.percentageComplete;
    }

    public final void setPercentageComplete(double complete) {
        this.percentageComplete.set(complete);
    }

    public final double getPercentageComplete() {
        return this.percentageComplete.get();
    }
}

