/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject.model;

import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.msproject.model.MSProjectTaskActivity;
import com.flexganttfx.msproject.model.MSProjectTaskRow;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;

public class MSProjectGanttChartModel {
    public Map<Task, ActivityRef<MSProjectTaskActivity>> taskMap;
    private ProjectFile projectFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private List<ActivityLink<?>> links = new ArrayList();
    private MSProjectTaskRow root = new MSProjectTaskRow();

    public MSProjectGanttChartModel(ProjectFile projectFile) {
        Objects.requireNonNull(projectFile);
        this.projectFile = projectFile;
        this.taskMap = new HashMap<Task, ActivityRef<MSProjectTaskActivity>>();
        Layer layer = new Layer("Default");
        this.layers.add(layer);
        ArrayList<MSProjectTaskRow> children = new ArrayList<MSProjectTaskRow>();
        for (Task task : projectFile.getChildTasks()) {
            children.add(new MSProjectTaskRow(layer, task, this.taskMap));
        }
        this.root.getChildren().setAll(children);
        for (Task task : projectFile.getChildTasks()) {
            this.createLinks(task);
        }
    }

    public final MSProjectTaskRow getRoot() {
        return this.root;
    }

    public final List<ActivityLink<?>> getLinks() {
        return this.links;
    }

    public final List<Layer> getLayers() {
        return this.layers;
    }

    private void createLinks(Task task) {
        List<Relation> predecessors;
        List<Relation> successors = task.getSuccessors();
        if (successors != null) {
            for (Relation relation : successors) {
                this.createRelation(task, relation, true);
            }
        }
        if ((predecessors = task.getPredecessors()) != null) {
            for (Relation relation : predecessors) {
                this.createRelation(task, relation, false);
            }
        }
        for (Task childTask : task.getChildTasks()) {
            this.createLinks(childTask);
        }
    }

    private void createRelation(Task task, Relation relation, boolean successor) {
        Task sourceTask = relation.getSourceTask();
        Task targetTask = relation.getTargetTask();
        ActivityRef<MSProjectTaskActivity> sourceRef = this.taskMap.get(sourceTask);
        ActivityRef<MSProjectTaskActivity> targetRef = this.taskMap.get(targetTask);
        if (successor) {
            this.links.add(new ActivityLink<MSProjectTaskActivity>(sourceRef, targetRef));
        } else {
            this.links.add(new ActivityLink<MSProjectTaskActivity>(targetRef, sourceRef));
        }
    }

    public final ProjectFile getProjectFile() {
        return this.projectFile;
    }

    public final Instant getHorizonStart() {
        return this.projectFile.getStartDate().toInstant();
    }

    public final Instant getHorizonEnd() {
        return this.projectFile.getFinishDate().toInstant();
    }
}

