/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.repository;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.repository.RepositoryEvent;
import java.time.Instant;
import java.util.logging.Level;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;

public abstract class ActivityRepositoryBase<A extends Activity>
implements ActivityRepository<A> {
    private ObservableList<EventHandler<RepositoryEvent>> repositoryListeners = FXCollections.observableArrayList();

    protected ActivityRepositoryBase() {
    }

    @Override
    public void addEventHandler(EventHandler<RepositoryEvent> l) {
        this.repositoryListeners.add(l);
    }

    @Override
    public void removeEventHandler(EventHandler<RepositoryEvent> l) {
        this.repositoryListeners.remove(l);
    }

    @Override
    public Instant getEarliestTimeUsed() {
        return Instant.MIN;
    }

    @Override
    public Instant getLatestTimeUsed() {
        return Instant.MAX;
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.append((event, tail1) -> {
            if (event instanceof RepositoryEvent) {
                for (EventHandler handler : this.repositoryListeners) {
                    handler.handle((Event)((RepositoryEvent)event));
                }
            }
            return event;
        });
    }

    protected void fireEvent(RepositoryEvent evt) {
        if (LoggingDomain.DND.isLoggable(Level.FINER)) {
            LoggingDomain.DND.finer("firing event: " + (Object)((Object)evt));
        }
        Event.fireEvent((EventTarget)this, (Event)evt);
    }
}

