/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.layout;

import com.flexganttfx.model.Layout;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;

public class AgendaLayout
extends Layout {
    private final DoubleProperty minLineSpacing = new SimpleDoubleProperty((Object)this, "minLineSpace", 20.0);
    private ObjectProperty<LocalTime> startTime = new SimpleObjectProperty((Object)this, "startTime", (Object)LocalTime.MIN);
    private ObjectProperty<LocalTime> endTime = new SimpleObjectProperty((Object)this, "endTime", (Object)LocalTime.MAX);
    private ObjectProperty<Duration> minDuration = new SimpleObjectProperty<Duration>((Object)this, "minDuration", Duration.ofMinutes(15L)){

        public void set(Duration duration) {
            if (duration == null) {
                throw new IllegalArgumentException("duration can not be null");
            }
            if (duration.equals(Duration.ZERO)) {
                throw new IllegalArgumentException("the minimum duration must be larger than zero");
            }
            super.set((Object)duration);
        }
    };
    private final ObjectProperty<LayoutStrategy> layoutStrategy = new SimpleObjectProperty((Object)this, "layoutStrategy", (Object)LayoutStrategy.PARALLEL);
    private final DoubleProperty overlapOffset = new SimpleDoubleProperty((Object)this, "overlapOffset", 0.25);

    public AgendaLayout() {
        this.setPadding(10.0);
    }

    public final DoubleProperty minLineSpacingProperty() {
        return this.minLineSpacing;
    }

    public final void setMinLineSpacing(double min) {
        this.minLineSpacing.set(min);
    }

    public final double getMinLineSpacing() {
        return this.minLineSpacing.get();
    }

    public final ObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime;
    }

    public final LocalTime getStartTime() {
        return (LocalTime)this.startTimeProperty().get();
    }

    public final void setStartTime(LocalTime time) {
        this.startTimeProperty().set((Object)time);
    }

    public final ObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime;
    }

    public final LocalTime getEndTime() {
        return (LocalTime)this.endTimeProperty().get();
    }

    public final void setEndTime(LocalTime time) {
        this.endTimeProperty().set((Object)time);
    }

    public final ObjectProperty<Duration> minDurationProperty() {
        return this.minDuration;
    }

    public final Duration getMinDuration() {
        return (Duration)this.minDurationProperty().get();
    }

    public final void setMinDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.minDurationProperty().set((Object)duration);
    }

    public final ObjectProperty<LayoutStrategy> layoutStrategyProperty() {
        return this.layoutStrategy;
    }

    public final LayoutStrategy getLayoutStrategy() {
        return (LayoutStrategy)((Object)this.layoutStrategyProperty().get());
    }

    public final void setLayoutStrategy(LayoutStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.layoutStrategyProperty().set((Object)strategy);
    }

    public final DoubleProperty overlapOffsetProperty() {
        return this.overlapOffset;
    }

    public final void setOverlapOffset(double offset) {
        if (offset < 0.0 || offset > 0.5) {
            throw new IllegalArgumentException("offset must be between 0 and .5");
        }
        this.overlapOffsetProperty().set(offset);
    }

    public final double getOverlapOffset() {
        return this.overlapOffsetProperty().get();
    }

    @Override
    public boolean isSupportingHorizontalCursorLine() {
        return true;
    }

    public String toString() {
        return "AgendaLayout [minLineSpacing=" + this.getMinLineSpacing() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", minDuration=" + this.getMinDuration() + ", layoutStrategy=" + (Object)((Object)this.getLayoutStrategy()) + ", overlapOffset=" + this.getOverlapOffset() + "]";
    }

    public static enum LayoutStrategy {
        OVERLAPPING,
        PARALLEL,
        PARALLEL_OVERLAPPING;

    }
}

