/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import com.flexganttfx.model.dateline.VirtualGrid;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class Resolution<T extends TemporalUnit> {
    private Set<Position> supportedPositions = new HashSet<Position>();
    private T temporalUnit;
    private String format;
    private int stepRate;

    public Resolution(T temporalUnit, String format, int stepRate, Position ... supportedPositions) {
        Objects.requireNonNull(temporalUnit);
        Objects.requireNonNull(format);
        Objects.requireNonNull(supportedPositions);
        if (stepRate <= 0) {
            throw new IllegalArgumentException("step rate must be larger than 0, but was " + stepRate);
        }
        if (supportedPositions.length == 0) {
            throw new IllegalArgumentException("at least one position must be specified for a resolution, but the passed array was empty");
        }
        this.temporalUnit = temporalUnit;
        this.format = format;
        this.stepRate = stepRate;
        this.supportedPositions.addAll(Arrays.asList(supportedPositions));
    }

    public Resolution(T temporalUnit, String format, int stepRate) {
        this(temporalUnit, format, stepRate, Position.values());
    }

    public final boolean isSupportingPosition(Position position) {
        return this.supportedPositions.contains((Object)position);
    }

    public final T getTemporalUnit() {
        return this.temporalUnit;
    }

    public final String getFormat() {
        return this.format;
    }

    public final int getStepRate() {
        return this.stepRate;
    }

    public String toString() {
        return "Resolution [supportedPositions=" + this.supportedPositions + ", temporalUnit=" + this.temporalUnit + ", format=" + this.format + ", stepRate=" + this.stepRate + "]";
    }

    public abstract String format(Instant var1, ZoneId var2);

    public abstract Instant truncate(Instant var1, ZoneId var2, DayOfWeek var3);

    public abstract Instant increment(Instant var1, ZoneId var2);

    public abstract VirtualGrid<T> createGrid();

    public static enum Position {
        TOP,
        MIDDLE,
        BOTTOM,
        ONLY;

    }
}

