/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import com.flexganttfx.model.dateline.ChronoUnitGrid;
import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.util.ChronoUnitUtils;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public final class ChronoUnitResolution
extends Resolution<ChronoUnit> {
    private boolean dstStart;
    private boolean dstEnd;

    public ChronoUnitResolution(ChronoUnit unit, String format, int stepRate, Resolution.Position ... supportedPositions) {
        super(unit, format, stepRate, supportedPositions);
    }

    public ChronoUnitResolution(ChronoUnit unit, String format, int stepRate) {
        super(unit, format, stepRate);
    }

    @Override
    public String format(Instant instant, ZoneId zoneId) {
        if (this.getFormat().equals("M")) {
            return ZonedDateTime.ofInstant(instant, zoneId).getMonth().getDisplayName(TextStyle.SHORT, Locale.getDefault()).substring(0, 1);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.getFormat()).withZone(zoneId);
        return formatter.format(zonedDateTime);
    }

    @Override
    public Instant truncate(Instant instant, ZoneId zoneId, DayOfWeek firstDayOfWeek) {
        ZonedDateTime truncatedTime = ChronoUnitUtils.truncate(instant.atZone(zoneId), (ChronoUnit)this.getTemporalUnit(), this.getStepRate(), firstDayOfWeek);
        return Instant.from(truncatedTime);
    }

    public boolean isDSTStartIncrement() {
        return this.dstStart;
    }

    public boolean isDSTEndIncrement() {
        return this.dstEnd;
    }

    @Override
    public Instant increment(Instant instant, ZoneId zoneId) {
        this.dstStart = false;
        this.dstEnd = false;
        ChronoUnit unit = (ChronoUnit)this.getTemporalUnit();
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, zoneId);
        int stepRate = this.getStepRate();
        switch (unit) {
            case NANOS: {
                time = time.plusNanos(stepRate);
                break;
            }
            case SECONDS: {
                time = time.plusSeconds(stepRate);
                break;
            }
            case MINUTES: {
                time = time.plusMinutes(stepRate);
                break;
            }
            case HOURS: {
                int hourBefore = Math.max(0, time.getHour());
                int dayBefore = time.getDayOfYear();
                time = time.plusHours(stepRate);
                int hourAfter = Math.min(23, time.getHour());
                int dayAfter = time.getDayOfYear();
                int deltaHours = hourAfter - hourBefore;
                if (dayBefore != dayAfter) break;
                if (deltaHours < stepRate) {
                    this.dstEnd = true;
                    break;
                }
                if (deltaHours <= stepRate) break;
                this.dstStart = true;
                break;
            }
            case DAYS: {
                time = time.plusDays(stepRate);
                break;
            }
            case WEEKS: {
                time = time.plusWeeks(stepRate);
                break;
            }
            case MONTHS: {
                time = time.plusMonths(stepRate);
                break;
            }
            case YEARS: {
                time = time.plusYears(stepRate);
                break;
            }
            case DECADES: {
                time = time.plusYears(stepRate * 10);
                break;
            }
            case CENTURIES: {
                time = time.plusYears(stepRate * 100);
                break;
            }
            case MILLENNIA: {
                time = time.plusYears(stepRate * 1000);
                break;
            }
            default: {
                return instant.plus(((ChronoUnit)this.getTemporalUnit()).getDuration().multipliedBy(stepRate));
            }
        }
        return Instant.from(time);
    }

    @Override
    public VirtualGrid<ChronoUnit> createGrid() {
        return new ChronoUnitGrid("Auto", (ChronoUnit)this.getTemporalUnit(), this.getStepRate());
    }
}

