/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.activity;

import com.flexganttfx.model.activity.HighLowChartActivityBase;
import com.flexganttfx.model.activity.MutableHighLowChartActivity;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class MutableHighLowChartActivityBase<T>
extends HighLowChartActivityBase<T>
implements MutableHighLowChartActivity {
    public MutableHighLowChartActivityBase() {
    }

    public MutableHighLowChartActivityBase(double low, double high, Instant startTime, Instant endTime) {
        super(low, high, startTime, endTime);
    }

    public MutableHighLowChartActivityBase(double low, double high, Instant time) {
        super(low, high, time);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setUserObject(T userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setStartTime(Instant time) {
        Objects.requireNonNull(time);
        this.startTime = time;
    }

    @Override
    public void setEndTime(Instant time) {
        Objects.requireNonNull(time);
        this.endTime = time;
    }

    public void setDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getStartTime().plus(duration));
    }

    public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    public void addDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.addDuration(duration, 1L);
    }

    public void addDuration(Duration duration, long multipliedBy) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getEndTime().plus(duration.multipliedBy(multipliedBy)));
    }

    @Override
    public void setHigh(double high) {
        this.high = high;
    }

    @Override
    public void setLow(double low) {
        this.low = low;
    }

    @Override
    public String toString() {
        return super.toString() + ", low = " + this.getLow() + ", high = " + this.getHigh();
    }
}

