/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.activity;

import com.flexganttfx.model.Activity;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class ActivityBase<T>
implements Activity {
    public static final Duration DEFAULT_DURATION = Duration.ofDays(5L);
    private static long ID_COUNTER = 1L;
    protected String name;
    protected String id = Long.toString(ActivityBase.createID());
    protected T userObject;
    protected Instant startTime;
    protected Instant endTime;

    public ActivityBase() {
        this(null);
    }

    public ActivityBase(String name) {
        this(name, Instant.now(), Instant.now().plus(DEFAULT_DURATION));
    }

    public ActivityBase(Instant startTime, Instant endTime) {
        this(null, startTime, endTime);
    }

    public ActivityBase(String name, Instant startTime, Instant endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static synchronized long createID() {
        return ID_COUNTER++;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setUserObject(T userObject) {
        this.userObject = userObject;
    }

    public T getUserObject() {
        return this.userObject;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Instant getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return this.getName() + " from " + this.getStartTime() + " until " + this.getEndTime() + ", user object = " + this.getUserObject();
    }
}

