/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras.properties.renderer;

import com.flexganttfx.extras.properties.ItemProvider;
import com.flexganttfx.view.graphics.renderer.Renderer;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.paint.Paint;
import org.controlsfx.control.PropertySheet;

public class RendererItemProvider
implements ItemProvider<Renderer> {
    @Override
    public List<PropertySheet.Item> getPropertySheetItems(final Renderer renderer) {
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.enabledProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setEnabled((Boolean)value);
            }

            @Override
            public Object getValue() {
                return renderer.isEnabled();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Enabled";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the renderer (if disabled activities using this renderer will not be shown at all).";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.snapToPixelProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setSnapToPixel((Boolean)value);
            }

            @Override
            public Object getValue() {
                return renderer.isSnapToPixel();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Snap To Pixel";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the snap to pixel feature.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.paddingProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setPadding((Insets)value);
            }

            @Override
            public Object getValue() {
                return renderer.getPadding();
            }

            @Override
            public Class<?> getType() {
                return Insets.class;
            }

            @Override
            public String getName() {
                return "Padding";
            }

            @Override
            public String getDescription() {
                return "Specifies a padding to be applied (not applicable for all renderers).";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.fillProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setFill((Paint)value);
            }

            @Override
            public Object getValue() {
                return renderer.getFill();
            }

            @Override
            public Class<?> getType() {
                return Paint.class;
            }

            @Override
            public String getName() {
                return "Fill";
            }

            @Override
            public String getDescription() {
                return "The color used for filling the activity background.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.fillHighlightProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setFillHighlight((Paint)value);
            }

            @Override
            public Object getValue() {
                return renderer.getFillHighlight();
            }

            @Override
            public Class<?> getType() {
                return Paint.class;
            }

            @Override
            public String getName() {
                return "Fill Highlight";
            }

            @Override
            public String getDescription() {
                return "The color used for filling the activity background when the activity is currently drawn highlighted.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.fillHoverProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setFillHover((Paint)value);
            }

            @Override
            public Object getValue() {
                return renderer.getFillHover();
            }

            @Override
            public Class<?> getType() {
                return Paint.class;
            }

            @Override
            public String getName() {
                return "Fill Hover";
            }

            @Override
            public String getDescription() {
                return "The color used for filling the activity background when the mouse cursor hovers over the activity.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.fillSelectedProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setFillSelected((Paint)value);
            }

            @Override
            public Object getValue() {
                return renderer.getFillSelected();
            }

            @Override
            public Class<?> getType() {
                return Paint.class;
            }

            @Override
            public String getName() {
                return "Fill Selected";
            }

            @Override
            public String getDescription() {
                return "The color used for filling the activity background when the activity is selected.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.fillPressedProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setFillPressed((Paint)value);
            }

            @Override
            public Object getValue() {
                return renderer.getFillPressed();
            }

            @Override
            public Class<?> getType() {
                return Paint.class;
            }

            @Override
            public String getName() {
                return "Fill Pressed";
            }

            @Override
            public String getDescription() {
                return "The color used for filling the activity background when the user presses on it.";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(renderer.alphaProperty());
            }

            @Override
            public void setValue(Object value) {
                renderer.setAlpha((Double)value);
            }

            @Override
            public Object getValue() {
                return renderer.getAlpha();
            }

            @Override
            public Class<?> getType() {
                return Double.class;
            }

            @Override
            public String getName() {
                return "Opacity / Alpha";
            }

            @Override
            public String getDescription() {
                return "The alpha value used when drawing the activity (opaque, transparent).";
            }

            @Override
            public String getCategory() {
                return "Renderer: " + renderer.getName();
            }
        });
        return items;
    }
}

