/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras.properties.layer;

import com.flexganttfx.extras.properties.ItemProvider;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import org.controlsfx.control.PropertySheet;

public class SystemLayerItemProvider
implements ItemProvider<SystemLayer> {
    @Override
    public List<PropertySheet.Item> getPropertySheetItems(final SystemLayer layer) {
        ArrayList<PropertySheet.Item> items = new ArrayList<PropertySheet.Item>();
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(layer.visibleProperty());
            }

            @Override
            public void setValue(Object value) {
                layer.setVisible((Boolean)value);
            }

            @Override
            public Object getValue() {
                return layer.isVisible();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Visible";
            }

            @Override
            public String getDescription() {
                return "Controls visibility of the system layer.";
            }

            @Override
            public String getCategory() {
                return "System Layer: " + layer.getName();
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(layer.snapToPixelProperty());
            }

            @Override
            public void setValue(Object value) {
                layer.setSnapToPixel((Boolean)value);
            }

            @Override
            public Object getValue() {
                return layer.isSnapToPixel();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Snap To Pixel";
            }

            @Override
            public String getDescription() {
                return "Enables / disables the snap to pixel feature.";
            }

            @Override
            public String getCategory() {
                return "System Layer: " + layer.getName();
            }
        });
        return items;
    }
}

