/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras;

import com.flexganttfx.extras.LayersView;
import com.flexganttfx.extras.RadarView;
import com.flexganttfx.extras.util.Messages;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import java.text.MessageFormat;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.stage.PopupWindow;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.textfield.CustomTextField;

public class GanttChartToolBar<R extends Row<?, ?, ?>>
extends ToolBar {
    private final ObjectProperty<GanttChartBase<R>> ganttChart = new SimpleObjectProperty((Object)this, "ganttChart");
    private PopOver layerControlsPopOver;
    private PopOver radarPopOver;

    public GanttChartToolBar() {
        this.setOrientation(Orientation.HORIZONTAL);
        this.getStylesheets().add((Object)GanttChart.class.getResource("gantt.css").toExternalForm());
        this.getStylesheets().add((Object)GanttChart.class.getResource("icons16/icons.css").toExternalForm());
        this.ganttChartProperty().addListener(observable -> this.buildToolBar());
    }

    public GanttChartToolBar(GanttChartBase<R> ganttChart) {
        this();
        this.setGanttChart(ganttChart);
    }

    public final ObjectProperty<GanttChartBase<R>> ganttChartProperty() {
        return this.ganttChart;
    }

    public final GanttChartBase<R> getGanttChart() {
        return (GanttChartBase)((Object)this.ganttChartProperty().get());
    }

    public final void setGanttChart(GanttChartBase<R> ganttChart) {
        Objects.requireNonNull(ganttChart);
        this.ganttChartProperty().set(ganttChart);
    }

    private void buildToolBar() {
        GanttChartBase<R> ganttChart;
        this.getItems().clear();
        if (this.layerControlsPopOver != null) {
            this.layerControlsPopOver.hide();
            this.layerControlsPopOver = null;
        }
        if ((ganttChart = this.getGanttChart()) != null) {
            ToggleButton detail = new ToggleButton(Messages.getString("GanttChartToolBar.BUTTON_DETAIL"));
            detail.getStyleClass().add((Object)"gearwheel-icon-16");
            detail.selectedProperty().bindBidirectional((Property)ganttChart.showDetailProperty());
            this.getItems().add((Object)detail);
            this.getItems().add((Object)new Separator());
            Button timeNow = new Button(Messages.getString("GanttChartToolBar.BUTTON_NOW"));
            timeNow.getStyleClass().add((Object)"clock-icon-16");
            timeNow.setOnAction(this.showTimeNow());
            this.getItems().add((Object)timeNow);
            Button earliest = new Button(Messages.getString("GanttChartToolBar.BUTTON_EARLIEST"));
            earliest.getStyleClass().add((Object)"navigate-beginning-icon-16");
            earliest.setOnAction(this.showEarliestActivities());
            this.getItems().add((Object)earliest);
            Button latest = new Button(Messages.getString("GanttChartToolBar.BUTTON_LATEST"));
            latest.getStyleClass().add((Object)"navigate-end-icon-16");
            latest.setOnAction(this.showLatestActivities());
            this.getItems().add((Object)latest);
            this.getItems().add((Object)new Separator());
            Button showAll = new Button(Messages.getString("GanttChartToolBar.BUTTON_ALL"));
            showAll.getStyleClass().add((Object)"fit-to-width-icon-16");
            showAll.setOnAction(this.showAllActivities());
            this.getItems().add((Object)showAll);
            this.getItems().add((Object)new Separator());
            Button zoomIn = new Button(Messages.getString("GanttChartToolBar.BUTTON_ZOOM_IN"));
            zoomIn.getStyleClass().add((Object)"zoom-in-icon-16");
            zoomIn.setOnAction(this.zoomIn());
            this.getItems().add((Object)zoomIn);
            Button zoomOut = new Button(Messages.getString("GanttChartToolBar.BUTTON_ZOOM_OUT"));
            zoomOut.getStyleClass().add((Object)"zoom-out-icon-16");
            zoomOut.setOnAction(this.zoomOut());
            this.getItems().add((Object)zoomOut);
            this.getItems().add((Object)new Separator());
            Button layers = new Button(Messages.getString("GanttChartToolBar.BUTTON_LAYERS"));
            layers.getStyleClass().add((Object)"front-icon-16");
            layers.setOnAction(this.showLayerControls(layers));
            this.getItems().add((Object)layers);
            Button radar = new Button(Messages.getString("GanttChartToolBar.BUTTON_RADAR"));
            radar.getStyleClass().add((Object)"radar-icon-16");
            radar.setOnAction(this.showRadarPopOver(radar));
            this.getItems().add((Object)radar);
            if (ganttChart instanceof GanttChart) {
                ToggleButton table = new ToggleButton(Messages.getString("GanttChartToolBar.BUTTON_TABLE"));
                table.selectedProperty().bindBidirectional((Property)((GanttChart)ganttChart).showTreeTableProperty());
                table.getStyleClass().add((Object)"close-treetable-icon-16");
                this.getItems().add((Object)table);
            }
            this.getItems().add((Object)new Separator());
            ListViewGraphics<R> graphics = ganttChart.getGraphics();
            ToggleButton cursor = new ToggleButton(Messages.getString("GanttChartToolBar.BUTTON_CURSOR"));
            cursor.getStyleClass().add((Object)"cursor-icon-16");
            cursor.selectedProperty().bindBidirectional((Property)graphics.showVerticalCursorProperty());
            this.getItems().add((Object)cursor);
            MenuButton gridLines = new MenuButton(Messages.getString("GanttChartToolBar.BUTTON_GRID"));
            gridLines.getStyleClass().add((Object)"table-icon-16");
            MenuItem gridOff = new MenuItem(Messages.getString("GanttChartToolBar.MENU_ITEM_GRID_OFF"));
            gridOff.setOnAction(this.hideGridLines());
            gridLines.getItems().add((Object)gridOff);
            for (int i = 1; i <= 5; ++i) {
                MenuItem gridOn = new MenuItem(MessageFormat.format(Messages.getString("GanttChartToolBar.MENU_ITEM_GRID_LEVELS"), i));
                gridLines.getItems().add((Object)gridOn);
                gridOn.setOnAction(this.showGridLines(i));
            }
            this.getItems().add((Object)gridLines);
            ToggleButton calendars = new ToggleButton(Messages.getString("GanttChartToolBar.BUTTON_CALENDARS"));
            calendars.selectedProperty().bindBidirectional((Property)graphics.showCalendarLayerProperty());
            this.getItems().add((Object)calendars);
            ToggleButton nowLine = new ToggleButton(Messages.getString("GanttChartToolBar.BUTTON_NOW_LINE"));
            nowLine.selectedProperty().bindBidirectional((Property)graphics.showNowLineLayerProperty());
            this.getItems().add((Object)nowLine);
            this.getItems().add((Object)new Separator());
            CustomTextField filterField = new CustomTextField();
            filterField.getStyleClass().add((Object)"search-field");
            filterField.setPromptText("Filter");
            filterField.textProperty().addListener(it -> this.filter(filterField.getText()));
            this.getItems().add((Object)filterField);
        }
    }

    private void filter(String txt) {
        if (txt.trim().equals("")) {
            this.getGanttChart().setRowFilter(null);
        } else {
            this.getGanttChart().setRowFilter(row -> row.getName().toLowerCase().contains(txt.toLowerCase()));
        }
    }

    private EventHandler<ActionEvent> showLayerControls(Button button) {
        return evt -> {
            if (this.layerControlsPopOver == null) {
                LayersView<R> layersView = new LayersView<R>();
                layersView.setGraphics(this.getGanttChart().getGraphics());
                this.layerControlsPopOver = new PopOver((Node)layersView);
                this.layerControlsPopOver.setTitle(Messages.getString("GanttChartToolBar.BUTTON_LAYERS"));
                this.layerControlsPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
            }
            Point2D localToScreen = button.localToScreen(0.0, 0.0);
            this.layerControlsPopOver.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
            this.layerControlsPopOver.show((Node)button, localToScreen.getX() + button.getWidth() / 2.0, localToScreen.getY() + button.getHeight() - 2.0);
        };
    }

    private EventHandler<ActionEvent> showRadarPopOver(Button button) {
        return evt -> {
            if (this.radarPopOver == null) {
                RadarView<R> radarView = new RadarView<R>();
                radarView.setGraphics(this.getGanttChart().getGraphics());
                this.radarPopOver = new PopOver((Node)radarView);
                this.radarPopOver.setTitle(Messages.getString("GanttChartToolBar.TITLE_RADAR"));
                this.radarPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
            }
            Point2D localToScreen = button.localToScreen(0.0, 0.0);
            this.radarPopOver.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
            this.radarPopOver.show((Node)button, localToScreen.getX() + button.getWidth() / 2.0, localToScreen.getY() + button.getHeight() - 2.0);
        };
    }

    private EventHandler<ActionEvent> showGridLines(int level) {
        return evt -> {
            this.getGanttChart().getGraphics().setMaxGridLevel(level);
            this.getGanttChart().getGraphics().setShowGridLineLayer(true);
        };
    }

    private EventHandler<ActionEvent> hideGridLines() {
        return evt -> this.getGanttChart().getGraphics().setShowGridLineLayer(false);
    }

    private EventHandler<ActionEvent> zoomOut() {
        return evt -> this.getGanttChart().getMasterTimeline().zoomOut();
    }

    private EventHandler<ActionEvent> zoomIn() {
        return evt -> this.getGanttChart().getMasterTimeline().zoomIn();
    }

    private EventHandler<ActionEvent> showAllActivities() {
        return evt -> this.getGanttChart().getGraphics().showAllActivities();
    }

    private EventHandler<ActionEvent> showLatestActivities() {
        return evt -> this.getGanttChart().getGraphics().showLatestActivities();
    }

    private EventHandler<ActionEvent> showEarliestActivities() {
        return evt -> this.getGanttChart().getGraphics().showEarliestActivities();
    }

    private EventHandler<ActionEvent> showTimeNow() {
        return evt -> this.getGanttChart().getMasterTimeline().showNow();
    }
}

