/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class ValueExtractor {
    private static List<ObservableValueExtractor> extractors = FXCollections.observableArrayList();
    private static final List<NodeValueExtractor> valueExtractors;

    public static void addObservableValueExtractor(Predicate<Control> test, Callback<Control, ObservableValue<?>> extract) {
        extractors.add(new ObservableValueExtractor(test, extract));
    }

    public static final Optional<Callback<Control, ObservableValue<?>>> getObservableValueExtractor(Control c2) {
        for (ObservableValueExtractor e : extractors) {
            if (!e.applicability.test(c2)) continue;
            return Optional.of(e.extraction);
        }
        return Optional.empty();
    }

    private ValueExtractor() {
    }

    public static void addValueExtractor(Predicate<Node> test, Callback<Node, Object> extractor) {
        valueExtractors.add(new NodeValueExtractor(test, extractor));
    }

    public static Object getValue(Node n) {
        for (NodeValueExtractor nve : valueExtractors) {
            if (!nve.applicability.test(n)) continue;
            return nve.extraction.call((Object)n);
        }
        return null;
    }

    static {
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof TextInputControl, c2 -> ((TextInputControl)c2).textProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof ComboBox, c2 -> ((ComboBox)c2).valueProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof ChoiceBox, c2 -> ((ChoiceBox)c2).valueProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof CheckBox, c2 -> ((CheckBox)c2).selectedProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof Slider, c2 -> ((Slider)c2).valueProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof ColorPicker, c2 -> ((ColorPicker)c2).valueProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof DatePicker, c2 -> ((DatePicker)c2).valueProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof ListView, c2 -> ((ListView)c2).itemsProperty());
        ValueExtractor.addObservableValueExtractor(c2 -> c2 instanceof TableView, c2 -> ((TableView)c2).itemsProperty());
        valueExtractors = FXCollections.observableArrayList();
        ValueExtractor.addValueExtractor(n -> n instanceof CheckBox, (Callback<Node, Object>)((Callback)cb -> ((CheckBox)cb).isSelected()));
        ValueExtractor.addValueExtractor(n -> n instanceof ChoiceBox, (Callback<Node, Object>)((Callback)cb -> ((ChoiceBox)cb).getValue()));
        ValueExtractor.addValueExtractor(n -> n instanceof ComboBox, (Callback<Node, Object>)((Callback)cb -> ((ComboBox)cb).getValue()));
        ValueExtractor.addValueExtractor(n -> n instanceof DatePicker, (Callback<Node, Object>)((Callback)dp -> (LocalDate)((DatePicker)dp).getValue()));
        ValueExtractor.addValueExtractor(n -> n instanceof RadioButton, (Callback<Node, Object>)((Callback)rb -> ((RadioButton)rb).isSelected()));
        ValueExtractor.addValueExtractor(n -> n instanceof Slider, (Callback<Node, Object>)((Callback)sl -> ((Slider)sl).getValue()));
        ValueExtractor.addValueExtractor(n -> n instanceof TextInputControl, (Callback<Node, Object>)((Callback)ta -> ((TextInputControl)ta).getText()));
        ValueExtractor.addValueExtractor(n -> n instanceof ListView, (Callback<Node, Object>)((Callback)lv -> {
            MultipleSelectionModel sm = ((ListView)lv).getSelectionModel();
            return sm.getSelectionMode() == SelectionMode.MULTIPLE ? sm.getSelectedItems() : sm.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(n -> n instanceof TreeView, (Callback<Node, Object>)((Callback)tv -> {
            MultipleSelectionModel sm = ((TreeView)tv).getSelectionModel();
            return sm.getSelectionMode() == SelectionMode.MULTIPLE ? sm.getSelectedItems() : sm.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(n -> n instanceof TableView, (Callback<Node, Object>)((Callback)tv -> {
            TableView.TableViewSelectionModel sm = ((TableView)tv).getSelectionModel();
            return sm.getSelectionMode() == SelectionMode.MULTIPLE ? sm.getSelectedItems() : sm.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(n -> n instanceof TreeTableView, (Callback<Node, Object>)((Callback)tv -> {
            TreeTableView.TreeTableViewSelectionModel sm = ((TreeTableView)tv).getSelectionModel();
            return sm.getSelectionMode() == SelectionMode.MULTIPLE ? sm.getSelectedItems() : sm.getSelectedItem();
        }));
    }

    private static class NodeValueExtractor {
        public final Predicate<Node> applicability;
        public final Callback<Node, Object> extraction;

        public NodeValueExtractor(Predicate<Node> applicability, Callback<Node, Object> extraction) {
            this.applicability = Objects.requireNonNull(applicability);
            this.extraction = Objects.requireNonNull(extraction);
        }
    }

    private static class ObservableValueExtractor {
        public final Predicate<Control> applicability;
        public final Callback<Control, ObservableValue<?>> extraction;

        public ObservableValueExtractor(Predicate<Control> applicability, Callback<Control, ObservableValue<?>> extraction) {
            this.applicability = Objects.requireNonNull(applicability);
            this.extraction = Objects.requireNonNull(extraction);
        }
    }
}

