/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.util.Callback;
import org.controlsfx.control.CheckBitSetModelBase;
import org.controlsfx.control.IndexedCheckModel;

public class CheckListView<T>
extends ListView<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private ObjectProperty<IndexedCheckModel<T>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckListView() {
        this(FXCollections.observableArrayList());
    }

    public CheckListView(ObservableList<T> items) {
        super(items);
        this.itemBooleanMap = new HashMap<T, BooleanProperty>();
        this.setCheckModel(new CheckListViewBitSetCheckModel<T>(this.getItems(), this.itemBooleanMap));
        this.itemsProperty().addListener(ov -> this.setCheckModel(new CheckListViewBitSetCheckModel<T>(this.getItems(), this.itemBooleanMap)));
        this.setCellFactory(listView -> new CheckBoxListCell(new Callback<T, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(T item) {
                return CheckListView.this.getItemBooleanProperty(item);
            }
        }));
    }

    public BooleanProperty getItemBooleanProperty(int index) {
        if (index < 0 || index >= this.getItems().size()) {
            return null;
        }
        return this.getItemBooleanProperty(this.getItems().get(index));
    }

    public BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    public final void setCheckModel(IndexedCheckModel<T> value) {
        this.checkModelProperty().set(value);
    }

    public final IndexedCheckModel<T> getCheckModel() {
        return this.checkModel == null ? null : (IndexedCheckModel)this.checkModel.get();
    }

    public final ObjectProperty<IndexedCheckModel<T>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckListViewBitSetCheckModel<T>
    extends CheckBitSetModelBase<T> {
        private final ObservableList<T> items;

        CheckListViewBitSetCheckModel(ObservableList<T> items, Map<T, BooleanProperty> itemBooleanMap) {
            super(itemBooleanMap);
            this.items = items;
            this.items.addListener(new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c2) {
                    this.updateMap();
                }
            });
            this.updateMap();
        }

        @Override
        public T getItem(int index) {
            return (T)this.items.get(index);
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemIndex(T item) {
            return this.items.indexOf(item);
        }
    }
}

