/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.GregorianCalendar;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Fixed3ArgFunction;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public final class DateFunc
extends Fixed3ArgFunction {
    public static final Function instance = new DateFunc();

    private DateFunc() {
    }

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        double result;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            double d2 = NumericFunction.singleOperandEvaluate(arg2, srcRowIndex, srcColumnIndex);
            result = DateFunc.evaluate(DateFunc.getYear(d0), (int)(d1 - 1.0), (int)d2);
            NumericFunction.checkValue(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static double evaluate(int year, int month, int pDay) throws EvaluationException {
        if (year < 0 || month < 0 || pDay < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (year == 1900 && month == 1 && pDay == 29) {
            return 60.0;
        }
        int day = pDay;
        if (year == 1900 && (month == 0 && day >= 60 || month == 1 && day >= 30)) {
            --day;
        }
        GregorianCalendar c2 = new GregorianCalendar();
        c2.set(year, month, day, 0, 0, 0);
        c2.set(14, 0);
        return HSSFDateUtil.getExcelDate(c2.getTime(), false);
    }

    private static int getYear(double d) {
        int year = (int)d;
        if (year < 0) {
            return -1;
        }
        return year < 1900 ? 1900 + year : year;
    }
}

