/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpxjQuery {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void query(String filename) throws Exception {
        ProjectReader reader = ProjectReaderUtility.getProjectReader(filename);
        ProjectFile mpx = reader.read(filename);
        System.out.println("MPP file type: " + mpx.getMppFileType());
        MpxjQuery.listProjectHeader(mpx);
        MpxjQuery.listResources(mpx);
        MpxjQuery.listTasks(mpx);
        MpxjQuery.listAssignments(mpx);
        MpxjQuery.listAssignmentsByTask(mpx);
        MpxjQuery.listAssignmentsByResource(mpx);
        MpxjQuery.listHierarchy(mpx);
        MpxjQuery.listTaskNotes(mpx);
        MpxjQuery.listResourceNotes(mpx);
        MpxjQuery.listRelationships(mpx);
        MpxjQuery.listSlack(mpx);
        MpxjQuery.listCalendars(mpx);
    }

    private static void listProjectHeader(ProjectFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        ProjectHeader header = file.getProjectHeader();
        Date startDate = header.getStartDate();
        Date finishDate = header.getFinishDate();
        String formattedStartDate = startDate == null ? "(none)" : df.format(startDate);
        String formattedFinishDate = finishDate == null ? "(none)" : df.format(finishDate);
        System.out.println("Project Header: StartDate=" + formattedStartDate + " FinishDate=" + formattedFinishDate);
        System.out.println();
    }

    private static void listResources(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ") Start=" + resource.getStart() + " Finish=" + resource.getFinish());
        }
        System.out.println();
    }

    private static void listTasks(ProjectFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        for (Task task : file.getAllTasks()) {
            Date date = task.getStart();
            String startDate = date != null ? df.format(date) : "(no date supplied)";
            date = task.getFinish();
            String finishDate = date != null ? df.format(date) : "(no date supplied)";
            Duration dur = task.getDuration();
            String duration = dur != null ? dur.toString() : "(no duration supplied)";
            String baselineDuration = task.getBaselineDurationText();
            if (baselineDuration == null) {
                dur = task.getBaselineDuration();
                baselineDuration = dur != null ? dur.toString() : "(no duration supplied)";
            }
            System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID() + " (Start Date=" + startDate + " Finish Date=" + finishDate + " Duration=" + duration + " Baseline Duration=" + baselineDuration + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + " Recurring=" + task.getRecurring() + ")");
        }
        System.out.println();
    }

    private static void listHierarchy(ProjectFile file) {
        for (Task task : file.getChildTasks()) {
            System.out.println("Task: " + task.getName());
            MpxjQuery.listHierarchy(task, " ");
        }
        System.out.println();
    }

    private static void listHierarchy(Task task, String indent) {
        for (Task child : task.getChildTasks()) {
            System.out.println(indent + "Task: " + child.getName());
            MpxjQuery.listHierarchy(child, indent + " ");
        }
    }

    private static void listAssignments(ProjectFile file) {
        for (ResourceAssignment assignment : file.getAllResourceAssignments()) {
            Task task = assignment.getTask();
            String taskName = task == null ? "(null task)" : task.getName();
            Resource resource = assignment.getResource();
            String resourceName = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + taskName + " Resource=" + resourceName);
        }
        System.out.println();
    }

    private static void listAssignmentsByTask(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            System.out.println("Assignments for task " + task.getName() + ":");
            for (ResourceAssignment assignment : task.getResourceAssignments()) {
                Resource resource = assignment.getResource();
                String resourceName = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + resourceName);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            System.out.println("Assignments for resource " + resource.getName() + ":");
            for (ResourceAssignment assignment : resource.getTaskAssignments()) {
                Task task = assignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            String notes = task.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + task.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listResourceNotes(ProjectFile file) {
        for (Resource resource : file.getAllResources()) {
            String notes = resource.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + resource.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listRelationships(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            System.out.print(task.getID());
            System.out.print('\t');
            System.out.print(task.getName());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getPredecessors());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getSuccessors());
            System.out.println();
        }
    }

    private static void dumpRelationList(List<Relation> relations) {
        if (relations != null && !relations.isEmpty()) {
            if (relations.size() > 1) {
                System.out.print('\"');
            }
            boolean first = true;
            for (Relation relation : relations) {
                if (!first) {
                    System.out.print(',');
                }
                first = false;
                System.out.print(relation.getTargetTask().getID());
                Duration lag = relation.getLag();
                if (relation.getType() != RelationType.FINISH_START || lag.getDuration() != 0.0) {
                    System.out.print(relation.getType());
                }
                if (lag.getDuration() == 0.0) continue;
                if (lag.getDuration() > 0.0) {
                    System.out.print("+");
                }
                System.out.print(lag);
            }
            if (relations.size() > 1) {
                System.out.print('\"');
            }
        }
    }

    private static void listSlack(ProjectFile file) {
        for (Task task : file.getAllTasks()) {
            System.out.println(task.getName() + " Total Slack=" + task.getTotalSlack() + " Start Slack=" + task.getStartSlack() + " Finish Slack=" + task.getFinishSlack());
        }
    }

    private static void listCalendars(ProjectFile file) {
        for (ProjectCalendar cal : file.getBaseCalendars()) {
            System.out.println(cal.toString());
        }
        for (ProjectCalendar cal : file.getResourceCalendars()) {
            System.out.println(cal.toString());
        }
    }
}

