/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.Day;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.ResultSetRow;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraDatabaseReader
implements ProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select proj_id, proj_short_name from " + this.m_schema + "project where delete_date is null");
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    /*
     * Loose catch block
     */
    public ProjectFile read() throws MPXJException {
        ProjectFile projectFile;
        block7: {
            this.m_reader = new PrimaveraReader();
            ProjectFile project = this.m_reader.getProject();
            project.addProjectListeners(this.m_projectListeners);
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            project.updateStructure();
            projectFile = project;
            Object var4_4 = null;
            if (!this.m_allocatedConnection || this.m_connection == null) break block7;
            try {
                this.m_connection.close();
            }
            catch (SQLException ex2) {
                // empty catch block
            }
            this.m_connection = null;
        }
        return projectFile;
        catch (SQLException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_5 = null;
                    if (!this.m_allocatedConnection || this.m_connection == null) break block9;
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException ex2) {
                        // empty catch block
                    }
                    this.m_connection = null;
                }
                throw throwable;
            }
        }
    }

    public List<ProjectFile> readAll() throws MPXJException {
        LinkedList<ProjectFile> result = new LinkedList<ProjectFile>();
        Map<Integer, String> projects = this.listProjects();
        for (Integer id : projects.keySet()) {
            this.setProjectID(id);
            result.add(this.read());
        }
        return result;
    }

    private void processProjectHeader() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "project where proj_id=?", this.m_projectID);
        this.m_reader.processProjectHeader(rows);
        rows = this.getRows("select * from " + this.m_schema + "prefer join " + this.m_schema + "currtype on currtype.curr_id =prefer.curr_id where prefer.delete_date is null");
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectHeader ph = this.m_reader.getProject().getProjectHeader();
            ph.setCreationDate(row.getDate("create_date"));
            ph.setLastSaved(row.getDate("update_date"));
            ph.setMinutesPerDay(row.getInt("day_hr_cnt") * 60);
            ph.setMinutesPerWeek(row.getInt("week_hr_cnt") * 60);
            ph.setWeekStartDay(Day.getInstance(row.getInt("week_start_day_num")));
            this.m_reader.processDefaultCurrency(row);
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_seq_num", this.m_projectID);
        this.m_reader.processResources(rows);
    }

    private void processTasks() throws SQLException {
        List<Row> wbs = this.getRows("select * from " + this.m_schema + "projwbs where proj_id=? and delete_date is null order by parent_wbs_id,seq_num", this.m_projectID);
        List<Row> tasks = this.getRows("select * from " + this.m_schema + "task where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processTasks(wbs, tasks);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskpred where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "calendar where (proj_id is null or proj_id=?) and delete_date is null", this.m_projectID);
        this.m_reader.processCalendars(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processAssignments(rows);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> result = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList = result;
            Object var5_4 = null;
            this.releaseConnection();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> result = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberUtility.getInt(var));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList = result;
            Object var6_5 = null;
            this.releaseConnection();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseConnection();
            throw throwable;
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop).toLowerCase();
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    public void setSchema(String schema) {
        if (schema.charAt(schema.length() - 1) != '.') {
            schema = schema + '.';
        }
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }
}

