/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class EncryptedDocumentInputStream
extends InputStream {
    private final DocumentInputStream m_dis;
    private final int m_mask;

    public EncryptedDocumentInputStream(DocumentEntry entry, int mask) throws IOException {
        this.m_dis = new DocumentInputStream(entry);
        this.m_mask = mask;
    }

    public int read() throws IOException {
        int value = this.m_dis.read();
        return value ^= this.m_mask;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int result = this.m_dis.read(b2, off, len);
        for (int loop = 0; loop < len; ++loop) {
            int n = loop + off;
            b2[n] = (byte)(b2[n] ^ this.m_mask);
        }
        return result;
    }

    public int available() {
        return this.m_dis.available();
    }

    public void close() {
        this.m_dis.close();
    }

    public synchronized void mark(int readlimit) {
        this.m_dis.mark(readlimit);
    }

    public boolean markSupported() {
        return this.m_dis.markSupported();
    }

    public synchronized void reset() {
        this.m_dis.reset();
    }

    public long skip(long n) throws IOException {
        return this.m_dis.skip(n);
    }
}

