/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class TimephasedTest
extends MPXJTestCase {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public void testMpp9() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased.mpp");
        this.testTimephased(file);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased-from12.mpp");
        this.testTimephased(file);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased-from14.mpp");
        this.testTimephased(file);
    }

    public void testMpp12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephased.mpp");
        this.testTimephased(file);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephased-from14.mpp");
        this.testTimephased(file);
    }

    public void testMpp14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp14timephased.mpp");
        this.testTimephased(file);
    }

    public void testMspdi() throws Exception {
        ProjectFile file = new MSPDIReader().read(this.m_basedir + "/mspditimephased.xml");
        this.testTimephased(file);
    }

    private void testTimephased(ProjectFile file) {
        Task task = file.getTaskByID(1);
        List<ResourceAssignment> assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        ResourceAssignment assignment = assignments.get(0);
        List<TimephasedWork> timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        TimephasedWork timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "02/12/2008 17:00", 64.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 12:00", 4.0, 4.0);
        List<TimephasedWork> timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        task = file.getTaskByID(2);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)11, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 17:00", 7.625, 7.625);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 12.0, 6.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "01/12/2008 08:00", "01/12/2008 17:00", 5.875, 5.875);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "04/12/2008 17:00", 12.0, 4.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "05/12/2008 08:00", "05/12/2008 17:00", 2.125, 2.125);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 17:00", 1.7, 1.7);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "09/12/2008 08:00", "09/12/2008 17:00", 1.2, 1.2);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "10/12/2008 08:00", "10/12/2008 17:00", 0.875, 0.875);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 15:00", 0.6, 0.6);
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 17:00", 7.625, 7.625);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 12.0, 6.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "01/12/2008 08:00", "01/12/2008 17:00", 5.875, 5.875);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "04/12/2008 17:00", 12.0, 4.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "05/12/2008 08:00", "05/12/2008 17:00", 2.125, 2.125);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 17:00", 1.7, 1.7);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "09/12/2008 08:00", "09/12/2008 17:00", 1.2, 1.2);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "10/12/2008 08:00", "10/12/2008 17:00", 0.875, 0.875);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 15:00", 0.6, 0.6);
        task = file.getTaskByID(3);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)11, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 0.7, 0.7);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "21/11/2008 17:00", 0.925, 0.925);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "24/11/2008 08:00", "24/11/2008 17:00", 1.2, 1.2);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "25/11/2008 08:00", "25/11/2008 17:00", 1.8, 1.8);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 17:00", 2.375, 2.375);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 8.0, 4.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "01/12/2008 08:00", "01/12/2008 17:00", 4.125, 4.125);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "02/12/2008 08:00", "04/12/2008 17:00", 18.0, 6.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "05/12/2008 08:00", "05/12/2008 17:00", 7.875, 7.875);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "08/12/2008 08:00", "10/12/2008 17:00", 24.0, 8.0);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 15:00", 6.0, 6.0);
        task = file.getTaskByID(4);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 15:30", 6.5, 6.5);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "26/11/2008 15:30", "26/11/2008 17:00", 1.5, 1.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "27/11/2008 08:00", "02/12/2008 17:00", 32.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 12:00", 4.0, 4.0);
        task = file.getTaskByID(5);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)7, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 09:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "01/12/2008 09:00", "01/12/2008 17:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "05/12/2008 17:00", 32.0, 8.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 12:00", 4.0, 4.0);
        task = file.getTaskByID(6);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedComplete.size());
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 09:00", 1.0, 1.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "01/12/2008 09:00", "01/12/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 15:00", 6.0, 6.0);
        task = file.getTaskByID(7);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "02/12/2008 17:00", 64.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 12:00", 4.0, 4.0);
        task = file.getTaskByID(8);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)7, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 24.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 09:00", 1.0, 1.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "01/12/2008 09:00", "01/12/2008 17:00", 7.0, 7.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "05/12/2008 17:00", 32.0, 8.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 12:00", 4.0, 4.0);
        task = file.getTaskByID(9);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)9, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "29/11/2008 00:00", 32.0, 8.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "29/11/2008 00:00", "29/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "02/12/2008 00:00", "04/12/2008 00:00", 16.0, 8.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "04/12/2008 00:00", "04/12/2008 02:00", 2.0, 2.0);
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        task = file.getTaskByID(10);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)18, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "27/11/2008 00:00", 16.0, 8.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "27/11/2008 00:00", "28/11/2008 00:00", 7.125, 7.125);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "28/11/2008 00:00", "29/11/2008 00:00", 6.0, 6.0);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "29/11/2008 00:00", "29/11/2008 08:00", 5.25, 5.25);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 0.75, 0.75);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "02/12/2008 00:00", "03/12/2008 00:00", 5.375, 5.375);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "03/12/2008 00:00", "05/12/2008 00:00", 8.0, 4.0);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "05/12/2008 00:00", "06/12/2008 00:00", 3.625, 3.625);
        timephased = timephasedPlanned.get(12);
        this.testTimephased(timephased, "06/12/2008 00:00", "06/12/2008 08:00", 1.75, 1.75);
        timephased = timephasedPlanned.get(13);
        this.testTimephased(timephased, "08/12/2008 23:00", "09/12/2008 00:00", 0.25, 0.25);
        timephased = timephasedPlanned.get(14);
        this.testTimephased(timephased, "09/12/2008 00:00", "10/12/2008 00:00", 1.5, -1.0);
        timephased = timephasedPlanned.get(15);
        this.testTimephased(timephased, "10/12/2008 00:00", "11/12/2008 00:00", 1.175, 1.175);
        timephased = timephasedPlanned.get(16);
        this.testTimephased(timephased, "11/12/2008 00:00", "12/12/2008 00:00", 0.8, 0.8);
        timephased = timephasedPlanned.get(17);
        this.testTimephased(timephased, "12/12/2008 00:00", "12/12/2008 05:00", 0.4, 0.4);
        task = file.getTaskByID(11);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)17, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 0.1, 0.1);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 0.8, 0.8);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 0.875, 0.875);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 0.15, 0.15);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "26/11/2008 00:00", 1.2, 1.2);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "26/11/2008 00:00", "27/11/2008 00:00", 2.0, 2.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "27/11/2008 00:00", "28/11/2008 00:00", 2.875, 2.875);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "28/11/2008 00:00", "29/11/2008 00:00", 4.0, 4.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "29/11/2008 00:00", "29/11/2008 08:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 0.5, 0.5);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "02/12/2008 00:00", "03/12/2008 00:00", 4.625, 4.625);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "03/12/2008 00:00", "05/12/2008 00:00", 12.0, 6.0);
        timephased = timephasedPlanned.get(12);
        this.testTimephased(timephased, "05/12/2008 00:00", "06/12/2008 00:00", 6.375, 6.375);
        timephased = timephasedPlanned.get(13);
        this.testTimephased(timephased, "06/12/2008 00:00", "06/12/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(14);
        this.testTimephased(timephased, "08/12/2008 23:00", "09/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(15);
        this.testTimephased(timephased, "09/12/2008 00:00", "12/12/2008 00:00", 24.0, 8.0);
        timephased = timephasedPlanned.get(16);
        this.testTimephased(timephased, "12/12/2008 00:00", "12/12/2008 05:00", 4.0, 4.0);
        task = file.getTaskByID(12);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "27/11/2008 00:00", 16.0, 8.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "27/11/2008 00:00", "27/11/2008 05:30", 4.5, 4.5);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "27/11/2008 05:30", "28/11/2008 00:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "28/11/2008 00:00", "29/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "29/11/2008 00:00", "29/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "02/12/2008 00:00", "04/12/2008 00:00", 16.0, 8.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "04/12/2008 00:00", "04/12/2008 02:00", 2.0, 2.0);
        task = file.getTaskByID(13);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)12, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "26/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "26/11/2008 00:00", "26/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "27/11/2008 00:00", "29/11/2008 08:00", 0.0, 0.0);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "02/12/2008 00:00", "06/12/2008 00:00", 32.0, 8.0);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "06/12/2008 00:00", "06/12/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "08/12/2008 23:00", "09/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "09/12/2008 00:00", "09/12/2008 02:00", 2.0, 2.0);
        task = file.getTaskByID(14);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)5, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)10, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "26/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "26/11/2008 00:00", "26/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "27/11/2008 00:00", "29/11/2008 08:00", 0.0, 0.0);
        timephased = timephasedComplete.get(7);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(8);
        this.testTimephased(timephased, "02/12/2008 00:00", "03/12/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(9);
        this.testTimephased(timephased, "03/12/2008 00:00", "03/12/2008 05:00", 4.0, 4.0);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "03/12/2008 05:00", "04/12/2008 00:00", 4.0, 4.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "04/12/2008 00:00", "06/12/2008 00:00", 16.0, 8.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "06/12/2008 00:00", "06/12/2008 08:00", 7.0, 7.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "08/12/2008 23:00", "09/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "09/12/2008 00:00", "09/12/2008 02:00", 2.0, 2.0);
        task = file.getTaskByID(15);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)9, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "29/11/2008 00:00", 32.0, 8.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "29/11/2008 00:00", "29/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(7);
        this.testTimephased(timephased, "02/12/2008 00:00", "04/12/2008 00:00", 16.0, 8.0);
        timephased = timephasedComplete.get(8);
        this.testTimephased(timephased, "04/12/2008 00:00", "04/12/2008 02:00", 2.0, 2.0);
        task = file.getTaskByID(16);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)12, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 23:00", "21/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "22/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "24/11/2008 23:00", "25/11/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "25/11/2008 00:00", "26/11/2008 00:00", 8.0, 8.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "26/11/2008 00:00", "26/11/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "27/11/2008 00:00", "29/11/2008 08:00", 0.0, 0.0);
        timephased = timephasedComplete.get(7);
        this.testTimephased(timephased, "01/12/2008 23:00", "02/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(8);
        this.testTimephased(timephased, "02/12/2008 00:00", "06/12/2008 00:00", 32.0, 8.0);
        timephased = timephasedComplete.get(9);
        this.testTimephased(timephased, "06/12/2008 00:00", "06/12/2008 08:00", 7.0, 7.0);
        timephased = timephasedComplete.get(10);
        this.testTimephased(timephased, "08/12/2008 23:00", "09/12/2008 00:00", 1.0, 1.0);
        timephased = timephasedComplete.get(11);
        this.testTimephased(timephased, "09/12/2008 00:00", "09/12/2008 02:00", 2.0, 2.0);
        task = file.getTaskByID(17);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "23/11/2008 00:00", 48.0, 24.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "23/11/2008 00:00", "23/11/2008 12:00", 12.0, 12.0);
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        task = file.getTaskByID(18);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 23.625, 23.625);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "23/11/2008 00:00", 17.875, 17.875);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "23/11/2008 00:00", "24/11/2008 00:00", 12.0, 12.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "24/11/2008 00:00", "25/11/2008 00:00", 5.025, 5.025);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "25/11/2008 00:00", "25/11/2008 14:00", 1.475, 1.475);
        task = file.getTaskByID(19);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 1.625, 1.625);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "22/11/2008 00:00", 5.375, 5.375);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "23/11/2008 00:00", 12.125, 12.125);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "23/11/2008 00:00", "24/11/2008 00:00", 18.0, 18.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "24/11/2008 00:00", "25/11/2008 00:00", 23.875, 23.875);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "25/11/2008 00:00", "25/11/2008 14:00", 14.0, 14.0);
        task = file.getTaskByID(20);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)2, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "21/11/2008 22:30", 22.5, 22.5);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "21/11/2008 22:30", "22/11/2008 00:00", 1.5, 1.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "22/11/2008 00:00", "23/11/2008 00:00", 24.0, 24.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "23/11/2008 00:00", "23/11/2008 12:00", 12.0, 12.0);
        task = file.getTaskByID(21);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "21/11/2008 09:00", 9.0, 9.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "25/11/2008 00:00", 0.0, 0.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "25/11/2008 09:00", "26/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "26/11/2008 00:00", "27/11/2008 00:00", 24.0, 24.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "27/11/2008 00:00", "27/11/2008 12:00", 12.0, 12.0);
        task = file.getTaskByID(22);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)4, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "21/11/2008 09:00", 9.0, 9.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "25/11/2008 00:00", 0.0, 0.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "25/11/2008 09:00", "25/11/2008 22:30", 13.5, 13.5);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "25/11/2008 22:30", "26/11/2008 00:00", 1.5, 1.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "26/11/2008 00:00", "27/11/2008 00:00", 24.0, 24.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "27/11/2008 00:00", "27/11/2008 12:00", 12.0, 12.0);
        task = file.getTaskByID(23);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "23/11/2008 00:00", 48.0, 24.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "23/11/2008 00:00", "23/11/2008 12:00", 12.0, 12.0);
        task = file.getTaskByID(24);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedComplete.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "21/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 00:00", "21/11/2008 09:00", 9.0, 9.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "22/11/2008 00:00", "25/11/2008 00:00", 0.0, 0.0);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "25/11/2008 09:00", "26/11/2008 00:00", 15.0, 15.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "26/11/2008 00:00", "27/11/2008 00:00", 24.0, 24.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "27/11/2008 00:00", "27/11/2008 12:00", 12.0, 12.0);
        task = file.getTaskByID(25);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "15/12/2008 17:00", 68.0, 4.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "16/12/2008 08:00", "16/12/2008 16:00", 3.5, 3.5);
        task = file.getTaskByID(26);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)12, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "02/12/2008 17:00", 32.0, 4.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 17:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "04/12/2008 08:00", "10/12/2008 17:00", 15.0, 3.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 17:00", 2.75, 2.75);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "12/12/2008 08:00", "19/12/2008 17:00", 12.0, 2.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "22/12/2008 08:00", "24/12/2008 17:00", 3.0, 1.0);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "25/12/2008 08:00", "25/12/2008 17:00", 0.65, 0.65);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "26/12/2008 08:00", "29/12/2008 17:00", 1.2, 0.6);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "30/12/2008 08:00", "30/12/2008 17:00", 0.45, 0.45);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "31/12/2008 08:00", "01/01/2009 17:00", 0.8, 0.4);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "02/01/2009 08:00", "02/01/2009 11:00", 0.15, 0.15);
        task = file.getTaskByID(27);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)12, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 0.35, 0.35);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "24/11/2008 17:00", 0.8, 0.4);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "25/11/2008 08:00", "25/11/2008 17:00", 0.55, 0.55);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "26/11/2008 08:00", "27/11/2008 17:00", 1.2, 0.6);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "28/11/2008 08:00", "28/11/2008 17:00", 0.85, 0.85);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "01/12/2008 08:00", "02/12/2008 17:00", 2.0, 1.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 17:00", 1.5, 1.5);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "04/12/2008 08:00", "10/12/2008 17:00", 10.0, 2.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 17:00", 2.25, 2.25);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "12/12/2008 08:00", "19/12/2008 17:00", 18.0, 3.0);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "22/12/2008 08:00", "01/01/2009 17:00", 36.0, 4.0);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "02/01/2009 08:00", "02/01/2009 11:00", 1.5, 1.5);
        task = file.getTaskByID(28);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "02/12/2008 17:00", 32.0, 4.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 12:00", 2.0, 2.0);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "03/12/2008 13:00", "03/12/2008 17:00", 2.0, 2.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "04/12/2008 08:00", "15/12/2008 17:00", 32.0, 4.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "16/12/2008 08:00", "16/12/2008 16:00", 3.5, 3.5);
        task = file.getTaskByID(29);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)7, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "01/12/2008 17:00", 28.0, 4.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 09:00", 0.5, 0.5);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "03/12/2008 08:00", "04/12/2008 17:00", 0.0, 0.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "05/12/2008 09:00", "05/12/2008 17:00", 3.5, 3.5);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "08/12/2008 08:00", "18/12/2008 17:00", 36.0, 4.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "19/12/2008 08:00", "19/12/2008 16:00", 3.5, 3.5);
        task = file.getTaskByID(30);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "01/12/2008 17:00", 28.0, 4.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 09:00", 0.5, 0.5);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "03/12/2008 08:00", "04/12/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "05/12/2008 08:00", "09/12/2008 17:00", 12.0, 4.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "10/12/2008 08:00", "10/12/2008 10:00", 1.0, 1.0);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "10/12/2008 10:00", "10/12/2008 17:00", 3.0, 3.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "11/12/2008 08:00", "18/12/2008 17:00", 24.0, 4.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "19/12/2008 08:00", "19/12/2008 15:00", 3.0, 3.0);
        task = file.getTaskByID(31);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "15/12/2008 17:00", 68.0, 4.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "16/12/2008 08:00", "16/12/2008 16:00", 3.5, 3.5);
        task = file.getTaskByID(32);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)7, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 3.5, 3.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "01/12/2008 17:00", 28.0, 4.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 09:00", 0.5, 0.5);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "03/12/2008 08:00", "04/12/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "05/12/2008 09:00", "05/12/2008 17:00", 3.5, 3.5);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "08/12/2008 08:00", "18/12/2008 17:00", 36.0, 4.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "19/12/2008 08:00", "19/12/2008 16:00", 3.5, 3.5);
        task = file.getTaskByID(33);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "27/11/2008 17:00", 60.0, 12.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "28/11/2008 08:00", "28/11/2008 11:00", 4.5, 4.5);
        task = file.getTaskByID(34);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)12, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "26/11/2008 17:00", 48.0, 12.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "27/11/2008 08:00", "27/11/2008 17:00", 10.0, 10.0);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "28/11/2008 08:00", "01/12/2008 17:00", 18.0, 9.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 17:00", 8.42, 8.42);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "03/12/2008 08:00", "05/12/2008 17:00", 18.0, 6.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 17:00", 3.83, 3.83);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "09/12/2008 08:00", "09/12/2008 17:00", 3.0, 3.0);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "10/12/2008 08:00", "10/12/2008 17:00", 1.82, 1.82);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "11/12/2008 08:00", "11/12/2008 17:00", 1.65, 1.65);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "12/12/2008 08:00", "12/12/2008 17:00", 1.2, 1.2);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "15/12/2008 08:00", "15/12/2008 11:53", 0.58, 0.58);
        task = file.getTaskByID(35);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)12, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 1.05, 1.05);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "21/11/2008 17:00", 1.28, 1.28);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "24/11/2008 08:00", "24/11/2008 17:00", 1.8, 1.8);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "25/11/2008 08:00", "25/11/2008 17:00", 2.28, 2.28);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 17:00", 3.0, 3.0);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "27/11/2008 08:00", "27/11/2008 17:00", 5.0, 5.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "28/11/2008 08:00", "01/12/2008 17:00", 12.0, 6.0);
        timephased = timephasedPlanned.get(7);
        this.testTimephased(timephased, "02/12/2008 08:00", "02/12/2008 17:00", 6.58, 6.58);
        timephased = timephasedPlanned.get(8);
        this.testTimephased(timephased, "03/12/2008 08:00", "05/12/2008 17:00", 27.0, 9.0);
        timephased = timephasedPlanned.get(9);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 17:00", 11.17, 11.17);
        timephased = timephasedPlanned.get(10);
        this.testTimephased(timephased, "09/12/2008 08:00", "12/12/2008 17:00", 48.0, 12.0);
        timephased = timephasedPlanned.get(11);
        this.testTimephased(timephased, "15/12/2008 08:00", "15/12/2008 11:53", 5.83, 5.83);
        task = file.getTaskByID(36);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "24/11/2008 17:00", 24.0, 12.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "25/11/2008 08:00", "25/11/2008 10:00", 3.0, 3.0);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "25/11/2008 10:00", "25/11/2008 17:00", 9.0, 9.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "26/11/2008 08:00", "27/11/2008 17:00", 24.0, 12.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "28/11/2008 08:00", "28/11/2008 11:00", 4.5, 4.5);
        task = file.getTaskByID(37);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)0, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)7, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "21/11/2008 17:00", 12.0, 12.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "24/11/2008 08:00", "24/11/2008 15:20", 9.5, 9.5);
        timephased = timephasedPlanned.get(3);
        this.testTimephased(timephased, "25/11/2008 08:00", "26/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedPlanned.get(4);
        this.testTimephased(timephased, "27/11/2008 15:20", "27/11/2008 17:00", 2.5, 2.5);
        timephased = timephasedPlanned.get(5);
        this.testTimephased(timephased, "28/11/2008 08:00", "02/12/2008 17:00", 36.0, 12.0);
        timephased = timephasedPlanned.get(6);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 11:00", 4.5, 4.5);
        task = file.getTaskByID(38);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)6, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)3, (int)timephasedPlanned.size());
        timephased = timephasedPlanned.get(0);
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "21/11/2008 17:00", 12.0, 12.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "24/11/2008 08:00", "24/11/2008 15:20", 9.5, 9.5);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "25/11/2008 08:00", "26/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "27/11/2008 14:20", "27/11/2008 17:00", 4.0, 4.0);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "28/11/2008 08:00", "28/11/2008 15:00", 9.0, 9.0);
        timephased = timephasedPlanned.get(0);
        this.testTimephased(timephased, "28/11/2008 15:00", "28/11/2008 17:00", 3.0, 3.0);
        timephased = timephasedPlanned.get(1);
        this.testTimephased(timephased, "01/12/2008 08:00", "02/12/2008 17:00", 24.0, 12.0);
        timephased = timephasedPlanned.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 10:00", 3.0, 3.0);
        task = file.getTaskByID(39);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)3, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "02/12/2008 17:00", 96.0, 12.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "03/12/2008 08:00", "03/12/2008 12:00", 6.0, 6.0);
        task = file.getTaskByID(40);
        assignments = task.getResourceAssignments();
        TimephasedTest.assertEquals((int)1, (int)assignments.size());
        assignment = assignments.get(0);
        timephasedPlanned = assignment.getTimephasedWork();
        timephasedComplete = assignment.getTimephasedActualWork();
        TimephasedTest.assertEquals((int)7, (int)timephasedComplete.size());
        TimephasedTest.assertEquals((int)0, (int)timephasedPlanned.size());
        timephased = timephasedComplete.get(0);
        this.testTimephased(timephased, "20/11/2008 09:00", "20/11/2008 17:00", 10.5, 10.5);
        timephased = timephasedComplete.get(1);
        this.testTimephased(timephased, "21/11/2008 08:00", "25/11/2008 17:00", 36.0, 12.0);
        timephased = timephasedComplete.get(2);
        this.testTimephased(timephased, "26/11/2008 08:00", "26/11/2008 09:00", 1.5, 1.5);
        timephased = timephasedComplete.get(3);
        this.testTimephased(timephased, "27/11/2008 08:00", "28/11/2008 17:00", 0.0, 0.0);
        timephased = timephasedComplete.get(4);
        this.testTimephased(timephased, "01/12/2008 09:00", "01/12/2008 17:00", 10.5, 10.5);
        timephased = timephasedComplete.get(5);
        this.testTimephased(timephased, "02/12/2008 08:00", "05/12/2008 17:00", 48.0, 12.0);
        timephased = timephasedComplete.get(6);
        this.testTimephased(timephased, "08/12/2008 08:00", "08/12/2008 12:00", 6.0, 6.0);
    }

    private void testTimephased(TimephasedWork assignment, String start, String finish, double totalWork, double workPerDay) {
        TimephasedTest.assertEquals((String)start, (String)this.m_df.format(assignment.getStart()));
        TimephasedTest.assertEquals((String)finish, (String)this.m_df.format(assignment.getFinish()));
        TimephasedTest.assertEquals((double)totalWork, (double)((Duration)assignment.getTotalAmount()).getDuration(), (double)0.02);
        TimephasedTest.assertEquals((Object)TimeUnit.HOURS, (Object)((Duration)assignment.getTotalAmount()).getUnits());
        if (workPerDay != -1.0) {
            TimephasedTest.assertEquals((double)workPerDay, (double)((Duration)assignment.getAmountPerDay()).getDuration(), (double)0.02);
            TimephasedTest.assertEquals((Object)TimeUnit.HOURS, (Object)((Duration)assignment.getAmountPerDay()).getUnits());
        }
    }
}

