/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.Group;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewState;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFile {
    private String m_projectFilePath;
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_assignmentUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;
    private List<Resource> m_allResources = new LinkedList<Resource>();
    private List<Task> m_allTasks = new LinkedList<Task>();
    private List<Task> m_childTasks = new LinkedList<Task>();
    private List<ResourceAssignment> m_allResourceAssignments = new LinkedList<ResourceAssignment>();
    private List<ProjectCalendar> m_baseCalendars = new LinkedList<ProjectCalendar>();
    private List<ProjectCalendar> m_resourceCalendars = new LinkedList<ProjectCalendar>();
    private FileCreationRecord m_fileCreationRecord = new FileCreationRecord(this);
    private ProjectHeader m_projectHeader = new ProjectHeader(this);
    private char m_delimiter = (char)44;
    private byte m_encryptionKey;
    private boolean m_encoded;
    private boolean m_autoWBS = true;
    private boolean m_autoOutlineLevel = true;
    private boolean m_autoOutlineNumber = true;
    private boolean m_autoTaskUniqueID = true;
    private boolean m_autoCalendarUniqueID = true;
    private boolean m_autoAssignmentUniqueID = true;
    private boolean m_autoTaskID = true;
    private boolean m_autoResourceUniqueID = true;
    private boolean m_autoResourceID = true;
    private Map<TaskField, String> m_taskFieldAlias = new HashMap<TaskField, String>();
    private Map<TaskField, List<Object>> m_taskFieldValueList = new HashMap<TaskField, List<Object>>();
    private Map<TaskField, List<String>> m_taskFieldDescriptionList = new HashMap<TaskField, List<String>>();
    private Map<String, TaskField> m_aliasTaskField = new HashMap<String, TaskField>();
    private Map<ResourceField, String> m_resourceFieldAlias = new HashMap<ResourceField, String>();
    private Map<String, ResourceField> m_aliasResourceField = new HashMap<String, ResourceField>();
    private Map<Integer, Task> m_taskUniqueIDMap = new HashMap<Integer, Task>();
    private Map<Integer, Task> m_taskIDMap = new HashMap<Integer, Task>();
    private Map<Integer, Resource> m_resourceUniqueIDMap = new HashMap<Integer, Resource>();
    private Map<Integer, Resource> m_resourceIDMap = new HashMap<Integer, Resource>();
    private Map<Integer, ProjectCalendar> m_calendarUniqueIDMap = new HashMap<Integer, ProjectCalendar>();
    private List<ProjectListener> m_projectListeners;
    private int m_mppFileType;
    private List<View> m_views = new ArrayList<View>();
    private List<Table> m_tables = new ArrayList<Table>();
    private Map<FieldType, GraphicalIndicator> m_graphicalIndicators = new HashMap<FieldType, GraphicalIndicator>();
    private Map<String, Table> m_taskTablesByName = new HashMap<String, Table>();
    private Map<String, Table> m_resourceTablesByName = new HashMap<String, Table>();
    private List<Filter> m_taskFilters = new ArrayList<Filter>();
    private List<Filter> m_resourceFilters = new ArrayList<Filter>();
    private Map<String, Filter> m_filtersByName = new HashMap<String, Filter>();
    private Map<Integer, Filter> m_filtersByID = new HashMap<Integer, Filter>();
    private List<Group> m_groups = new ArrayList<Group>();
    private Map<String, Group> m_groupsByName = new HashMap<String, Group>();
    private SubProject m_resourceSubProject;
    private List<SubProject> m_allSubProjects = new LinkedList<SubProject>();
    private boolean m_autoFilter;
    private ViewState m_viewState;
    private Map<Integer, CustomFieldValueItem> m_customFieldValueItems = new HashMap<Integer, CustomFieldValueItem>();
    private static final int MS_PROJECT_MAX_UNIQUE_ID = 0x1FFFFF;

    public char getDelimiter() {
        return this.m_delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
    }

    void addTask(Task task) {
        this.m_allTasks.add(task);
    }

    public Task addTask() {
        Task task = new Task(this, null);
        this.m_allTasks.add(task);
        this.m_childTasks.add(task);
        return task;
    }

    public void removeTask(Task task) {
        List<Task> childTaskList;
        this.m_allTasks.remove(task);
        this.m_taskUniqueIDMap.remove(task.getUniqueID());
        this.m_taskIDMap.remove(task.getID());
        Task parentTask = task.getParentTask();
        if (parentTask != null) {
            parentTask.removeChildTask(task);
        } else {
            this.m_childTasks.remove(task);
        }
        Iterator<ResourceAssignment> iter = this.m_allResourceAssignments.iterator();
        while (iter.hasNext()) {
            ResourceAssignment assignment = iter.next();
            if (assignment.getTask() != task) continue;
            Resource resource = assignment.getResource();
            if (resource != null) {
                resource.removeResourceAssignment(assignment);
            }
            iter.remove();
        }
        while (!(childTaskList = task.getChildTasks()).isEmpty()) {
            this.removeTask(childTaskList.get(0));
        }
    }

    public void renumberTaskIDs() {
        if (!this.m_allTasks.isEmpty()) {
            Collections.sort(this.m_allTasks);
            Task firstTask = this.m_allTasks.get(0);
            int id = NumberUtility.getInt(firstTask.getID());
            if (id != 0) {
                id = 1;
            }
            for (Task task : this.m_allTasks) {
                task.setID(id++);
            }
        }
    }

    public void renumberResourceIDs() {
        if (!this.m_allResources.isEmpty()) {
            Collections.sort(this.m_allResources);
            int id = 1;
            for (Resource resource : this.m_allResources) {
                resource.setID(id++);
            }
        }
    }

    private void renumberTaskUniqueIDs() {
        Task firstTask = this.getTaskByID(0);
        int uid = firstTask == null ? 1 : 0;
        for (Task task : this.m_allTasks) {
            task.setUniqueID(uid++);
        }
    }

    private void renumberResourceUniqueIDs() {
        int uid = 1;
        for (Resource resource : this.m_allResources) {
            resource.setUniqueID(uid++);
        }
    }

    private void renumberAssignmentUniqueIDs() {
        int uid = 1;
        for (ResourceAssignment assignment : this.m_allResourceAssignments) {
            assignment.setUniqueID(uid++);
        }
    }

    private void renumberCalendarUniqueIDs() {
        int uid = 1;
        for (ProjectCalendar calendar : this.m_baseCalendars) {
            calendar.setUniqueID(uid++);
        }
        for (ProjectCalendar calendar : this.m_resourceCalendars) {
            calendar.setUniqueID(uid++);
        }
    }

    public void validateUniqueIDsForMicrosoftProject() {
        if (!this.m_allTasks.isEmpty()) {
            for (Task task : this.m_allTasks) {
                if (NumberUtility.getInt(task.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberTaskUniqueIDs();
                break;
            }
        }
        if (!this.m_allResources.isEmpty()) {
            for (Resource resource : this.m_allResources) {
                if (NumberUtility.getInt(resource.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberResourceUniqueIDs();
                break;
            }
        }
        if (!this.m_allResourceAssignments.isEmpty()) {
            for (ResourceAssignment assignment : this.m_allResourceAssignments) {
                if (NumberUtility.getInt(assignment.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberAssignmentUniqueIDs();
                break;
            }
        }
        if (!this.m_baseCalendars.isEmpty()) {
            for (ProjectCalendar calendar : this.m_baseCalendars) {
                if (NumberUtility.getInt(calendar.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberCalendarUniqueIDs();
                break;
            }
        }
        if (!this.m_resourceCalendars.isEmpty()) {
            for (ProjectCalendar calendar : this.m_resourceCalendars) {
                if (NumberUtility.getInt(calendar.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberCalendarUniqueIDs();
                break;
            }
        }
    }

    public void synchronizeTaskIDToHierarchy() {
        this.m_allTasks.clear();
        int currentID = this.getTaskByID(0) == null ? 1 : 0;
        for (Task task : this.m_childTasks) {
            task.setID(currentID++);
            this.m_allTasks.add(task);
            currentID = this.synchroizeTaskIDToHierarchy(task, currentID);
        }
    }

    private int synchroizeTaskIDToHierarchy(Task parentTask, int currentID) {
        for (Task task : parentTask.getChildTasks()) {
            task.setID(currentID++);
            this.m_allTasks.add(task);
            currentID = this.synchroizeTaskIDToHierarchy(task, currentID);
        }
        return currentID;
    }

    public List<Task> getChildTasks() {
        return this.m_childTasks;
    }

    public List<Task> getAllTasks() {
        return this.m_allTasks;
    }

    public void setAutoWBS(boolean flag) {
        this.m_autoWBS = flag;
    }

    public void setAutoOutlineLevel(boolean flag) {
        this.m_autoOutlineLevel = flag;
    }

    public void setAutoOutlineNumber(boolean flag) {
        this.m_autoOutlineNumber = flag;
    }

    public void setAutoTaskUniqueID(boolean flag) {
        this.m_autoTaskUniqueID = flag;
    }

    public void setAutoCalendarUniqueID(boolean flag) {
        this.m_autoCalendarUniqueID = flag;
    }

    public void setAutoAssignmentUniqueID(boolean flag) {
        this.m_autoAssignmentUniqueID = flag;
    }

    public void setAutoTaskID(boolean flag) {
        this.m_autoTaskID = flag;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoAssignmentUniqueID() {
        return this.m_autoAssignmentUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public int getTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    int getCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getAssignmentUniqueID() {
        return ++this.m_assignmentUniqueID;
    }

    public int getTaskID() {
        return ++this.m_taskID;
    }

    public void setAutoResourceUniqueID(boolean flag) {
        this.m_autoResourceUniqueID = flag;
    }

    public void setAutoResourceID(boolean flag) {
        this.m_autoResourceID = flag;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getResourceID() {
        return ++this.m_resourceID;
    }

    public FileCreationRecord getFileCreationRecord() {
        return this.m_fileCreationRecord;
    }

    public ProjectCalendar addResourceCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this);
        this.m_resourceCalendars.add(calendar);
        return calendar;
    }

    public ProjectCalendar addBaseCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this);
        this.m_baseCalendars.add(calendar);
        return calendar;
    }

    public void removeCalendar(ProjectCalendar calendar) {
        if (this.m_baseCalendars.contains(calendar)) {
            this.m_baseCalendars.remove(calendar);
        } else if (this.m_resourceCalendars.contains(calendar)) {
            this.m_resourceCalendars.remove(calendar);
            Resource resource = calendar.getResource();
            if (resource != null) {
                resource.setResourceCalendar(null);
            }
        }
        calendar.setParent(null);
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar calendar = this.addBaseCalendar();
        calendar.setName("Standard");
        calendar.setWorkingDay(Day.SUNDAY, false);
        calendar.setWorkingDay(Day.MONDAY, true);
        calendar.setWorkingDay(Day.TUESDAY, true);
        calendar.setWorkingDay(Day.WEDNESDAY, true);
        calendar.setWorkingDay(Day.THURSDAY, true);
        calendar.setWorkingDay(Day.FRIDAY, true);
        calendar.setWorkingDay(Day.SATURDAY, false);
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    public ProjectCalendar getDefaultResourceCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this);
        calendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        return calendar;
    }

    public List<ProjectCalendar> getBaseCalendars() {
        return this.m_baseCalendars;
    }

    public List<ProjectCalendar> getResourceCalendars() {
        return this.m_resourceCalendars;
    }

    public ProjectHeader getProjectHeader() {
        return this.m_projectHeader;
    }

    public Resource addResource() {
        Resource resource = new Resource(this);
        this.m_allResources.add(resource);
        return resource;
    }

    public void removeResource(Resource resource) {
        this.m_allResources.remove(resource);
        this.m_resourceUniqueIDMap.remove(resource.getUniqueID());
        this.m_resourceIDMap.remove(resource.getID());
        Iterator<ResourceAssignment> iter = this.m_allResourceAssignments.iterator();
        Integer resourceUniqueID = resource.getUniqueID();
        while (iter.hasNext()) {
            ResourceAssignment assignment = iter.next();
            if (!NumberUtility.equals(assignment.getResourceUniqueID(), resourceUniqueID)) continue;
            assignment.getTask().removeResourceAssignment(assignment);
            iter.remove();
        }
        ProjectCalendar calendar = resource.getResourceCalendar();
        if (calendar != null) {
            calendar.remove();
        }
    }

    public List<Resource> getAllResources() {
        return this.m_allResources;
    }

    public List<ResourceAssignment> getAllResourceAssignments() {
        return this.m_allResourceAssignments;
    }

    void addResourceAssignment(ResourceAssignment assignment) {
        this.m_allResourceAssignments.add(assignment);
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_allResourceAssignments.remove(assignment);
        assignment.getTask().removeResourceAssignment(assignment);
        Resource resource = assignment.getResource();
        if (resource != null) {
            resource.removeResourceAssignment(assignment);
        }
    }

    public ResourceAssignment newResourceAssignment(Task task) {
        return new ResourceAssignment(this, task);
    }

    public ProjectCalendar getBaseCalendar(String calendarName) {
        ProjectCalendar calendar = null;
        if (calendarName != null && calendarName.length() != 0) {
            String name;
            Iterator<ProjectCalendar> iter = this.m_baseCalendars.iterator();
            while (iter.hasNext() && ((name = (calendar = iter.next()).getName()) == null || !name.equalsIgnoreCase(calendarName))) {
                calendar = null;
            }
        }
        return calendar;
    }

    public ProjectCalendar getBaseCalendarByUniqueID(Integer calendarID) {
        return this.m_calendarUniqueIDMap.get(calendarID);
    }

    int getChildTaskCount() {
        return this.m_childTasks.size();
    }

    public Duration getDuration(Date startDate, Date endDate) throws MPXJException {
        return this.getDuration("Standard", startDate, endDate);
    }

    public Duration getDuration(String calendarName, Date startDate, Date endDate) throws MPXJException {
        ProjectCalendar calendar = this.getBaseCalendar(calendarName);
        if (calendar == null) {
            throw new MPXJException("Invalid calendar: " + calendarName);
        }
        return calendar.getDuration(startDate, endDate);
    }

    public Task getTaskByID(Integer id) {
        return this.m_taskIDMap.get(id);
    }

    public Task getTaskByUniqueID(Integer id) {
        return this.m_taskUniqueIDMap.get(id);
    }

    public Resource getResourceByID(Integer id) {
        return this.m_resourceIDMap.get(id);
    }

    public Resource getResourceByUniqueID(Integer id) {
        return this.m_resourceUniqueIDMap.get(id);
    }

    public void updateStructure() {
        if (this.m_allTasks.size() > 1) {
            Collections.sort(this.m_allTasks);
            this.m_childTasks.clear();
            Task lastTask = null;
            int lastLevel = -1;
            for (Task task : this.m_allTasks) {
                task.clearChildTasks();
                Task parent = null;
                if (!task.getNull()) {
                    int level = NumberUtility.getInt(task.getOutlineLevel());
                    if (lastTask != null) {
                        if (level == lastLevel || task.getNull()) {
                            parent = lastTask.getParentTask();
                            level = lastLevel;
                        } else if (level > lastLevel) {
                            parent = lastTask;
                        } else {
                            while (level <= lastLevel && (parent = lastTask.getParentTask()) != null) {
                                lastLevel = NumberUtility.getInt(parent.getOutlineLevel());
                                lastTask = parent;
                            }
                        }
                    }
                    lastTask = task;
                    lastLevel = level;
                    if (this.getAutoWBS() || task.getWBS() == null) {
                        task.generateWBS(parent);
                    }
                    if (this.getAutoOutlineNumber()) {
                        task.generateOutlineNumber(parent);
                    }
                }
                if (parent == null) {
                    this.m_childTasks.add(task);
                    continue;
                }
                parent.addChildTask(task);
            }
        }
    }

    public void updateUniqueCounters() {
        int uniqueID;
        for (Task task : this.m_allTasks) {
            uniqueID = NumberUtility.getInt(task.getUniqueID());
            if (uniqueID <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = uniqueID;
        }
        for (Resource resource : this.m_allResources) {
            uniqueID = NumberUtility.getInt(resource.getUniqueID());
            if (uniqueID <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = uniqueID;
        }
        for (ProjectCalendar calendar : this.m_baseCalendars) {
            uniqueID = NumberUtility.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
        for (ProjectCalendar calendar : this.m_resourceCalendars) {
            uniqueID = NumberUtility.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
        for (ResourceAssignment assignment : this.m_allResourceAssignments) {
            uniqueID = NumberUtility.getInt(assignment.getUniqueID());
            if (uniqueID <= this.m_assignmentUniqueID) continue;
            this.m_assignmentUniqueID = uniqueID;
        }
    }

    public Date getStartDate() {
        Date startDate = null;
        for (Task task : this.m_allTasks) {
            Date taskStartDate;
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            if (task.getMilestone()) {
                taskStartDate = task.getActualFinish();
                if (taskStartDate == null) {
                    taskStartDate = task.getFinish();
                }
            } else {
                taskStartDate = task.getActualStart();
                if (taskStartDate == null) {
                    taskStartDate = task.getStart();
                }
            }
            if (taskStartDate == null) continue;
            if (startDate == null) {
                startDate = taskStartDate;
                continue;
            }
            if (taskStartDate.getTime() >= startDate.getTime()) continue;
            startDate = taskStartDate;
        }
        return startDate;
    }

    public Date getFinishDate() {
        Date finishDate = null;
        for (Task task : this.m_allTasks) {
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            Date taskFinishDate = task.getActualFinish();
            if (taskFinishDate == null) {
                taskFinishDate = task.getFinish();
            }
            if (taskFinishDate == null) continue;
            if (finishDate == null) {
                finishDate = taskFinishDate;
                continue;
            }
            if (taskFinishDate.getTime() <= finishDate.getTime()) continue;
            finishDate = taskFinishDate;
        }
        return finishDate;
    }

    public void fireTaskReadEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.taskRead(task);
            }
        }
    }

    public void fireTaskWrittenEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.taskWritten(task);
            }
        }
    }

    public void fireResourceReadEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.resourceRead(resource);
            }
        }
    }

    public void fireResourceWrittenEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.resourceWritten(resource);
            }
        }
    }

    public void fireCalendarReadEvent(ProjectCalendar calendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.calendarRead(calendar);
            }
        }
    }

    public void fireAssignmentReadEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.assignmentRead(resourceAssignment);
            }
        }
    }

    public void fireAssignmentWrittenEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.assignmentWritten(resourceAssignment);
            }
        }
    }

    public void fireRelationReadEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.relationRead(relation);
            }
        }
    }

    public void fireRelationWrittenEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.relationWritten(relation);
            }
        }
    }

    public void fireCalendarWrittenEvent(ProjectCalendar calendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.calendarWritten(calendar);
            }
        }
    }

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public void addProjectListeners(List<ProjectListener> listeners) {
        if (listeners != null) {
            for (ProjectListener listener : listeners) {
                this.addProjectListener(listener);
            }
        }
    }

    public void removeProjectListener(ProjectListener listener) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.remove(listener);
        }
    }

    public void setTaskFieldAlias(TaskField field, String alias) {
        if (alias != null && alias.length() != 0) {
            this.m_taskFieldAlias.put(field, alias);
            this.m_aliasTaskField.put(alias, field);
        }
    }

    public String getTaskFieldAlias(TaskField field) {
        return this.m_taskFieldAlias.get(field);
    }

    public TaskField getAliasTaskField(String alias) {
        return this.m_aliasTaskField.get(alias);
    }

    public void setTaskFieldValueList(TaskField field, List<Object> values) {
        if (values != null && values.size() != 0) {
            this.m_taskFieldValueList.put(field, values);
        }
    }

    public List<Object> getTaskFieldValueList(TaskField field) {
        return this.m_taskFieldValueList.get(field);
    }

    public void setTaskFieldDescriptionList(TaskField field, List<String> descriptions) {
        if (descriptions != null && descriptions.size() != 0) {
            this.m_taskFieldDescriptionList.put(field, descriptions);
        }
    }

    public List<String> getTaskFieldDescriptionList(TaskField field) {
        return this.m_taskFieldDescriptionList.get(field);
    }

    public void setResourceFieldAlias(ResourceField field, String alias) {
        if (alias != null && alias.length() != 0) {
            this.m_resourceFieldAlias.put(field, alias);
            this.m_aliasResourceField.put(alias, field);
        }
    }

    public String getResourceFieldAlias(ResourceField field) {
        return this.m_resourceFieldAlias.get(field);
    }

    public ResourceField getAliasResourceField(String alias) {
        return this.m_aliasResourceField.get(alias);
    }

    public Map<TaskField, String> getTaskFieldAliasMap() {
        return this.m_taskFieldAlias;
    }

    public Map<ResourceField, String> getResourceFieldAliasMap() {
        return this.m_resourceFieldAlias;
    }

    void unmapTaskUniqueID(Integer id) {
        this.m_taskUniqueIDMap.remove(id);
    }

    void mapTaskUniqueID(Integer id, Task task) {
        this.m_taskUniqueIDMap.put(id, task);
    }

    void unmapTaskID(Integer id) {
        this.m_taskIDMap.remove(id);
    }

    void mapTaskID(Integer id, Task task) {
        this.m_taskIDMap.put(id, task);
    }

    void unmapResourceUniqueID(Integer id) {
        this.m_resourceUniqueIDMap.remove(id);
    }

    void mapResourceUniqueID(Integer id, Resource resource) {
        this.m_resourceUniqueIDMap.put(id, resource);
    }

    void unmapResourceID(Integer id) {
        this.m_resourceIDMap.remove(id);
    }

    void mapResourceID(Integer id, Resource resource) {
        this.m_resourceIDMap.put(id, resource);
    }

    void unmapCalendarUniqueID(Integer id) {
        this.m_calendarUniqueIDMap.remove(id);
    }

    void mapCalendarUniqueID(Integer id, ProjectCalendar calendar) {
        this.m_calendarUniqueIDMap.put(id, calendar);
    }

    public int getMppFileType() {
        return this.m_mppFileType;
    }

    public void setMppFileType(int fileType) {
        this.m_mppFileType = fileType;
    }

    public void addView(View view) {
        this.m_views.add(view);
    }

    public List<View> getViews() {
        return this.m_views;
    }

    public void addTable(Table table) {
        this.m_tables.add(table);
        if (!table.getResourceFlag()) {
            this.m_taskTablesByName.put(table.getName(), table);
        } else {
            this.m_resourceTablesByName.put(table.getName(), table);
        }
    }

    public List<Table> getTables() {
        return this.m_tables;
    }

    public void addFilter(Filter filter) {
        if (filter.isTaskFilter()) {
            this.m_taskFilters.add(filter);
        }
        if (filter.isResourceFilter()) {
            this.m_resourceFilters.add(filter);
        }
        this.m_filtersByName.put(filter.getName(), filter);
        this.m_filtersByID.put(filter.getID(), filter);
    }

    public void removeFilter(String filterName) {
        Filter filter = this.getFilterByName(filterName);
        if (filter != null) {
            if (filter.isTaskFilter()) {
                this.m_taskFilters.remove(filter);
            }
            if (filter.isResourceFilter()) {
                this.m_resourceFilters.remove(filter);
            }
            this.m_filtersByName.remove(filterName);
            this.m_filtersByID.remove(filter.getID());
        }
    }

    public List<Filter> getAllResourceFilters() {
        return this.m_resourceFilters;
    }

    public List<Filter> getAllTaskFilters() {
        return this.m_taskFilters;
    }

    public Filter getFilterByName(String name) {
        return this.m_filtersByName.get(name);
    }

    public Filter getFilterByID(Integer id) {
        return this.m_filtersByID.get(id);
    }

    public List<Group> getAllGroups() {
        return this.m_groups;
    }

    public Group getGroupByName(String name) {
        return this.m_groupsByName.get(name);
    }

    public void addGroup(Group group) {
        this.m_groups.add(group);
        this.m_groupsByName.put(group.getName(), group);
    }

    public void addGraphicalIndicator(FieldType field, GraphicalIndicator indicator) {
        this.m_graphicalIndicators.put(field, indicator);
    }

    public GraphicalIndicator getGraphicalIndicator(FieldType field) {
        return this.m_graphicalIndicators.get(field);
    }

    public Table getTaskTableByName(String name) {
        return this.m_taskTablesByName.get(name);
    }

    public Table getResourceTableByName(String name) {
        return this.m_resourceTablesByName.get(name);
    }

    public void setResourceSubProject(SubProject project) {
        this.m_resourceSubProject = project;
    }

    public SubProject getResourceSubProject() {
        return this.m_resourceSubProject;
    }

    public void addSubProject(SubProject project) {
        this.m_allSubProjects.add(project);
    }

    public List<SubProject> getAllSubProjects() {
        return this.m_allSubProjects;
    }

    public boolean getAutoFilter() {
        return this.m_autoFilter;
    }

    public void setAutoFilter(boolean autoFilter) {
        this.m_autoFilter = autoFilter;
    }

    public void setViewState(ViewState viewState) {
        this.m_viewState = viewState;
    }

    public ViewState getViewState() {
        return this.m_viewState;
    }

    public void setEncoded(boolean encoded) {
        this.m_encoded = encoded;
    }

    public boolean getEncoded() {
        return this.m_encoded;
    }

    public void setEncryptionCode(byte encryptionKey) {
        this.m_encryptionKey = encryptionKey != 0 ? (byte)(255 - encryptionKey) : (byte)0;
    }

    public byte getEncryptionCode() {
        return this.m_encryptionKey;
    }

    public void setProjectFilePath(String projectFilePath) {
        this.m_projectFilePath = projectFilePath;
    }

    public String getProjectFilePath() {
        return this.m_projectFilePath;
    }

    public void addCustomFieldValueItem(CustomFieldValueItem item) {
        this.m_customFieldValueItems.put(item.getUniqueID(), item);
    }

    public CustomFieldValueItem getCustomFieldValueItem(Integer uniqueID) {
        return this.m_customFieldValueItems.get(uniqueID);
    }

    public ProjectCalendar getCalendar() {
        String calendarName = this.m_projectHeader.getCalendarName();
        ProjectCalendar calendar = this.getBaseCalendar(calendarName);
        return calendar;
    }

    public void setCalendar(ProjectCalendar calendar) {
        this.m_projectHeader.setCalendarName(calendar.getName());
    }

    public ProjectCalendar getBaselineCalendar() {
        ProjectCalendar result = this.getBaseCalendar("Used for Microsoft Project 98 Baseline Calendar");
        if (result == null) {
            result = this.getCalendar();
        }
        return result;
    }
}

