/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.util;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.util.ActivityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class Column<A extends Activity> {
    private List<A> activities;

    public void add(A activity) {
        if (this.activities == null) {
            this.activities = new ArrayList<A>();
        }
        this.activities.add(activity);
    }

    public boolean hasRoomFor(A activity, Predicate<A> filter) {
        if (this.activities == null) {
            return true;
        }
        if (filter != null && !filter.test(activity)) {
            return true;
        }
        for (Activity otherActivity : this.activities) {
            if (filter != null && !filter.test(otherActivity) || !ActivityHelper.intersect(activity.getStartTime(), activity.getEndTime(), otherActivity.getStartTime(), otherActivity.getEndTime())) continue;
            return false;
        }
        return true;
    }

    public List<A> getActivities() {
        return this.activities;
    }
}

