/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.timeline;

import com.flexganttfx.model.dateline.DatelineModel;
import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.DatelineScrollingEvent;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.timeline.DatelineScale;
import java.time.Instant;
import java.time.format.TextStyle;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class DatelineSkin
extends SkinBase<Dateline> {
    private final VBox scalesBox;
    private final Map<Integer, DatelineScale> rowScaleMap = new HashMap<Integer, DatelineScale>();
    private final Label zoneIdLabel = new Label();
    protected final Region lasso;

    public DatelineSkin(Dateline dateline) {
        super((Control)dateline);
        this.zoneIdLabel.getStyleClass().add((Object)"zone-id-label");
        this.zoneIdLabel.setLayoutX(0.0);
        this.zoneIdLabel.setLayoutY(0.0);
        this.zoneIdLabel.setVisible(dateline.isZoneIdVisible());
        this.zoneIdLabel.setManaged(false);
        this.updateZoneIdLabel(false);
        this.lasso = new Region();
        this.lasso.setVisible(false);
        this.lasso.getStyleClass().add((Object)"zoom-lasso");
        this.lasso.setManaged(false);
        this.lasso.setMouseTransparent(true);
        this.scalesBox = new VBox();
        this.scalesBox.setSnapToPixel(false);
        this.scalesBox.getStyleClass().add((Object)"dateline-content");
        this.getChildren().addAll((Object[])new Node[]{this.scalesBox, this.zoneIdLabel, this.lasso});
        this.registerDatelineListeners(dateline);
        this.registerDatelineModelListeners(dateline);
        this.registerTimelineListeners(dateline.getTimeline());
        dateline.selectedTimeIntervalProperty().addListener(it -> this.updateLasso());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)dateline.widthProperty());
        clip.heightProperty().bind((ObservableValue)dateline.heightProperty());
        dateline.setClip((Node)clip);
        dateline.widthProperty().addListener((value, oldNumber, newNumber) -> this.fireScrollingEvent());
        dateline.heightProperty().addListener((value, oldNumber, newNumber) -> this.fireScrollingEvent());
        this.buildRows();
    }

    private Dateline getDateline() {
        return (Dateline)this.getSkinnable();
    }

    private void registerTimelineListeners(Timeline timeline) {
        ChangeListener startTimeListener = (value, oldStartTime, newStartTime) -> {
            ((Dateline)this.getSkinnable()).requestLayout();
            this.fireScrollingEvent();
        };
        TimelineModel<?> timelineModel = timeline.getModel();
        ObjectProperty<Instant> startTimeProperty = timelineModel.startTimeProperty();
        startTimeProperty.addListener(startTimeListener);
        ChangeListener mppListener = (value, oldWidth, newWidth) -> {
            for (DatelineScale scale : this.rowScaleMap.values()) {
                scale.setResolution(null);
            }
            ((Dateline)this.getSkinnable()).requestLayout();
            this.fireScrollingEvent();
        };
        timeline.getModel().millisPerPixelProperty().addListener(mppListener);
        timeline.modelProperty().addListener((ChangeListener)new WeakChangeListener((value, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.startTimeProperty().removeListener(startTimeListener);
                oldModel.millisPerPixelProperty().removeListener(mppListener);
            }
            if (newModel != null) {
                newModel.startTimeProperty().addListener(startTimeListener);
                newModel.millisPerPixelProperty().addListener(mppListener);
            }
            ((Dateline)this.getSkinnable()).requestLayout();
        }));
    }

    private void fireScrollingEvent() {
        Timeline timeline = ((Dateline)this.getSkinnable()).getTimeline();
        Instant startTime = timeline.getModel().getStartTime();
        Instant endTime = timeline.getModel().calculateTimeForLocation(((Dateline)this.getSkinnable()).getWidth());
        DatelineScrollingEvent event = new DatelineScrollingEvent(this.getSkinnable(), (EventTarget)this.getSkinnable(), DatelineScrollingEvent.VISIBLE_RANGE_CHANGED, startTime, endTime, ((Dateline)this.getSkinnable()).getZoneId());
        ((Dateline)this.getSkinnable()).fireEvent(event);
    }

    private void registerDatelineListeners(Dateline dateline) {
        dateline.zoneIdProperty().addListener((value, oldZoneId, newZoneId) -> {
            dateline.getSelectedIntervals().clear();
            this.updateZoneIdLabel(true);
            ((Dateline)this.getSkinnable()).requestLayout();
        });
        dateline.zoneIdVisibleProperty().addListener((value, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.showZoneIdLabel();
            } else {
                this.hideZoneIdLabel();
            }
        });
    }

    private void registerDatelineModelListeners(Dateline dateline) {
        ListChangeListener resolutionListener = change -> this.buildRows();
        dateline.getModel().getResolutions().addListener(resolutionListener);
        ChangeListener scaleCountChangeListener = (value, oldWidth, newWidth) -> {
            this.buildRows();
            ((Dateline)this.getSkinnable()).requestLayout();
        };
        dateline.getModel().scaleCountProperty().addListener(scaleCountChangeListener);
        dateline.modelProperty().addListener((value, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.getResolutions().removeListener(resolutionListener);
                oldModel.scaleCountProperty().removeListener(scaleCountChangeListener);
            }
            if (newModel != null) {
                newModel.getResolutions().addListener(resolutionListener);
                newModel.scaleCountProperty().addListener(scaleCountChangeListener);
            }
        });
    }

    void buildRows() {
        if (this.getDateline().isVisible()) {
            this.rowScaleMap.clear();
            this.scalesBox.getChildren().clear();
            DatelineModel<? extends TemporalUnit> model = this.getDateline().getModel();
            int scaleCount = model.getScaleCount();
            for (int i = 0; i < scaleCount; ++i) {
                DatelineScale scale = new DatelineScale(this.getDateline(), this.getScalePosition(i, scaleCount));
                VBox.setVgrow((Node)scale, (Priority)Priority.ALWAYS);
                this.scalesBox.getChildren().add(0, (Object)scale);
                this.rowScaleMap.put(i, scale);
            }
            this.scalesBox.requestLayout();
        }
    }

    private Resolution.Position getScalePosition(int row, int scaleCount) {
        if (scaleCount == 1) {
            return Resolution.Position.ONLY;
        }
        if (row == 0) {
            return Resolution.Position.BOTTOM;
        }
        if (row == scaleCount - 1) {
            return Resolution.Position.TOP;
        }
        return Resolution.Position.MIDDLE;
    }

    private void buildCells() {
        ArrayList<Resolution<? extends TemporalUnit>> resolutions = new ArrayList<Resolution<? extends TemporalUnit>>();
        if (this.getDateline().getWidth() > 0.0 && this.getDateline().getHeight() > 0.0) {
            DatelineScale scale;
            TemporalUnit nextUnit;
            Dateline dateline = this.getDateline();
            DatelineModel<? extends TemporalUnit> model = dateline.getModel();
            Timeline timeline = dateline.getTimeline();
            TimelineModel<?> timelineModel = timeline.getModel();
            Object temporalUnit = timelineModel.getSmallestTemporalUnit();
            for (int i = 0; i < model.getScaleCount() && (nextUnit = (scale = this.rowScaleMap.get(i)).buildScale((TemporalUnit)temporalUnit)) != null; ++i) {
                temporalUnit = nextUnit;
                resolutions.add(scale.getResolution());
            }
            this.getDateline().getProperties().put((Object)"com.flexganttfx.primaryUnit", (Object)this.getPrimaryTemporalUnit());
        }
        ((Dateline)this.getSkinnable()).getScaleResolutions().setAll(resolutions);
    }

    private TemporalUnit getPrimaryTemporalUnit() {
        Resolution<? extends TemporalUnit> resolution = this.rowScaleMap.get(0).getResolution();
        if (resolution != null) {
            return resolution.getTemporalUnit();
        }
        return null;
    }

    private void showZoneIdLabel() {
        this.zoneIdLabel.setOpacity(0.0);
        this.zoneIdLabel.setVisible(true);
        double labelHeight = this.zoneIdLabel.prefHeight(this.getDateline().getHeight());
        TranslateTransition tt = new TranslateTransition(Duration.millis((double)500.0), (Node)this.zoneIdLabel);
        tt.setFromY(-labelHeight);
        tt.setToY(0.0);
        FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)0.5), (Node)this.zoneIdLabel);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{fadeIn, tt});
        parallelTransition.play();
    }

    private void hideZoneIdLabel() {
        double labelHeight = this.zoneIdLabel.prefHeight(this.getDateline().getWidth());
        TranslateTransition tt = new TranslateTransition(Duration.millis((double)500.0), (Node)this.zoneIdLabel);
        tt.setToY(-labelHeight);
        tt.setFromY(this.zoneIdLabel.getLayoutY());
        FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)0.5), (Node)this.zoneIdLabel);
        fadeOut.setToValue(0.0);
        fadeOut.setOnFinished(evt -> this.updateZoneIdText());
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{tt, fadeOut});
        parallelTransition.play();
    }

    private void updateZoneIdLabel(boolean animate) {
        if (animate) {
            FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)0.5), (Node)this.zoneIdLabel);
            fadeOut.setToValue(0.1);
            fadeOut.setOnFinished(evt -> this.updateZoneIdText());
            FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)0.5), (Node)this.zoneIdLabel);
            fadeIn.setToValue(1.0);
            SequentialTransition sequentialTransition = new SequentialTransition(new Animation[]{fadeOut, fadeIn});
            sequentialTransition.play();
        } else {
            this.updateZoneIdText();
        }
    }

    private void updateZoneIdText() {
        String text = this.getDateline().getZoneId().getDisplayName(TextStyle.FULL, Locale.getDefault());
        this.zoneIdLabel.setText(text);
        this.getDateline().requestLayout();
    }

    private void updateLasso() {
        Dateline dateline = (Dateline)this.getSkinnable();
        TimeInterval selectedTimeInterval = dateline.getSelectedTimeInterval();
        if (selectedTimeInterval != null) {
            Instant st = selectedTimeInterval.getStartTime();
            Instant et = selectedTimeInterval.getEndTime();
            TimelineModel<?> timelineModel = dateline.getTimeline().getModel();
            double x1 = timelineModel.calculateLocationForTime(st);
            double x2 = timelineModel.calculateLocationForTime(et);
            Insets insets = dateline.getInsets();
            this.lasso.setLayoutX(Math.min(x1, x2));
            this.lasso.setLayoutY(insets.getTop());
            this.lasso.setPrefWidth(Math.abs(x2 - x1));
            this.lasso.setPrefHeight(dateline.getHeight() - insets.getTop() - insets.getBottom());
            this.lasso.setVisible(true);
        } else {
            this.lasso.setVisible(false);
        }
        dateline.requestLayout();
    }

    protected void layoutChildren(double x, double y, double width, double height) {
        this.buildCells();
        super.layoutChildren(x, y, width, height);
        double w = Math.min(width, this.zoneIdLabel.prefWidth(height));
        double h = this.zoneIdLabel.prefHeight(width);
        this.zoneIdLabel.resizeRelocate(width - w - 10.0, this.zoneIdLabel.getLayoutY(), w, h);
        this.lasso.resizeRelocate(this.lasso.getLayoutX(), this.lasso.getLayoutY(), this.lasso.getPrefWidth(), this.lasso.getPrefHeight());
    }
}

