/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.timeline;

import com.flexganttfx.model.dateline.ChronoUnitResolution;
import com.flexganttfx.model.dateline.DatelineModel;
import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.DatelineCell;
import com.flexganttfx.view.timeline.Timeline;
import com.sun.javafx.css.converters.SizeConverter;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Callback;

final class DatelineScale
extends Region {
    private static final String DEFAULT_STYLE_CLASS = "scale";
    private static final String SELECTED_STYLE_CLASS = "dateline-cell-selected";
    private Resolution<?> resolution;
    private final Resolution.Position position;
    private final Dateline dateline;
    private List<DatelineCell<?>> cellList;
    private StyleableDoubleProperty cellPadding;

    DatelineScale(Dateline dateline, Resolution.Position position) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.position = position;
        this.dateline = dateline;
        switch (position) {
            case ONLY: {
                this.getStyleClass().add((Object)"scale-only");
                break;
            }
            case BOTTOM: {
                this.getStyleClass().add((Object)"scale-bottom");
                break;
            }
            case TOP: {
                this.getStyleClass().add((Object)"scale-top");
                break;
            }
            case MIDDLE: {
                this.getStyleClass().add((Object)"scale-middle");
            }
        }
        EventHandler clickSelectHandler = evt -> {
            if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == 1) {
                if (evt.isShortcutDown()) {
                    DatelineCell<?> cell = this.getCellAt(evt.getX());
                    if (cell != null) {
                        TimeInterval interval = cell.getInterval();
                        if (evt.getClickCount() == 1) {
                            if (dateline.getSelectionMode().equals((Object)SelectionMode.SINGLE)) {
                                dateline.getSelectedIntervals().clear();
                            }
                            if (cell.getStyleClass().contains((Object)SELECTED_STYLE_CLASS)) {
                                cell.getStyleClass().remove((Object)SELECTED_STYLE_CLASS);
                                dateline.getSelectedIntervals().remove((Object)interval);
                            } else {
                                cell.getStyleClass().add((Object)SELECTED_STYLE_CLASS);
                                dateline.getSelectedIntervals().add((Object)interval);
                            }
                        }
                        evt.consume();
                    }
                } else {
                    dateline.getSelectedIntervals().clear();
                }
            }
        };
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, clickSelectHandler);
        EventHandler clickZoomHandler = evt -> {
            DatelineCell<?> cell;
            if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == 2 && (cell = this.getCellAt(evt.getX())) != null) {
                TimeInterval interval = cell.getInterval();
                dateline.getTimeline().showRange(interval);
            }
        };
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, clickZoomHandler);
        EventHandler updateFocusedTimeIntervalHandler = evt -> {
            DatelineCell<?> cell = this.getCellAt(evt.getX());
            if (cell != null) {
                TimeInterval interval = cell.getInterval();
                dateline.getProperties().put((Object)"com.flexganttfx.dateline.hover.interval", (Object)interval);
            } else {
                dateline.getProperties().put((Object)"com.flexganttfx.dateline.hover.interval", null);
            }
        };
        this.addEventHandler(MouseEvent.MOUSE_MOVED, updateFocusedTimeIntervalHandler);
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, updateFocusedTimeIntervalHandler);
        EventHandler clearFocusedTimeIntervalHandler = evt -> dateline.getProperties().put((Object)"com.flexganttfx.dateline.hover.interval", null);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, clearFocusedTimeIntervalHandler);
        this.heightProperty().addListener(it -> {
            if (this.resolution != null) {
                this.buildCells(this.resolution, true);
            }
        });
    }

    final Resolution.Position getPosition() {
        return this.position;
    }

    final void setResolution(Resolution<?> resolution) {
        this.resolution = resolution;
    }

    final Resolution<? extends TemporalUnit> getResolution() {
        return this.resolution;
    }

    private StyleableDoubleProperty cellPaddingProperty() {
        if (this.cellPadding == null) {
            this.cellPadding = new StyleableDoubleProperty(){

                public CssMetaData<DatelineScale, Number> getCssMetaData() {
                    return StyleableProperties.CELL_PADDING;
                }

                public Object getBean() {
                    return DatelineScale.this;
                }

                public String getName() {
                    return "cellPadding";
                }
            };
        }
        return this.cellPadding;
    }

    public double getCellPadding() {
        return this.cellPaddingProperty().get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DatelineScale.getClassCssMetaData();
    }

    private DatelineCell<?> getCellAt(double x) {
        for (Node node : this.getChildren()) {
            if (!(node.getLayoutX() <= x) || !(node.getLayoutX() + node.prefWidth(-1.0) > x)) continue;
            return (DatelineCell)node;
        }
        return null;
    }

    final TemporalUnit buildScale(TemporalUnit unit) {
        DatelineModel<? extends TemporalUnit> datelineModel = this.dateline.getModel();
        boolean success = false;
        do {
            if (this.getResolution() != null) {
                success = this.buildCells(this.getResolution(), true);
                continue;
            }
            Iterator<Resolution<? extends TemporalUnit>> resolutions = datelineModel.getResolutions(unit);
            while (resolutions.hasNext()) {
                Resolution<? extends TemporalUnit> resolution = resolutions.next();
                if (resolution.isSupportingPosition(this.getPosition())) {
                    success = this.buildCells(resolution, false);
                }
                if (!success) continue;
                break;
            }
            if (success) continue;
            TemporalUnit nextUnit = datelineModel.nextTemporalUnit(unit);
            if (nextUnit == null) {
                return null;
            }
            unit = nextUnit;
        } while (!success);
        this.requestLayout();
        return datelineModel.nextTemporalUnit(unit);
    }

    private boolean buildCells(Resolution<? extends TemporalUnit> resolution, boolean cached) {
        Timeline timeline = this.dateline.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        TemporalUnit temporalUnit = resolution.getTemporalUnit();
        Callback<TemporalUnit, DatelineCell> cellFactory = this.dateline.getCellFactory(temporalUnit.getClass());
        this.cellList = new ArrayList();
        ObservableList<TimeInterval> selections = this.dateline.getSelectedIntervals();
        ZoneId zoneId = this.dateline.getZoneId();
        double scaleTopInsets = this.getInsets().getTop();
        double scaleHeight = this.getHeight() - scaleTopInsets - this.getInsets().getBottom();
        double datelineWidth = this.dateline.getWidth();
        boolean success = true;
        DayOfWeek firstDayOfWeek = this.dateline.getFirstDayOfWeek();
        Instant startTime = resolution.truncate(timelineModel.getStartTime(), zoneId, firstDayOfWeek);
        double x1 = timelineModel.calculateLocationForTime(startTime);
        int index = 0;
        while (x1 < this.dateline.getWidth()) {
            Instant endTime = resolution.increment(startTime, zoneId);
            int dstCorrectionInHours = 0;
            if (resolution.getTemporalUnit().equals(ChronoUnit.HOURS) && resolution instanceof ChronoUnitResolution) {
                ChronoUnitResolution chronoUnitResolution = (ChronoUnitResolution)resolution;
                if (chronoUnitResolution.isDSTEndIncrement()) {
                    dstCorrectionInHours = 1;
                } else if (chronoUnitResolution.isDSTStartIncrement()) {
                    dstCorrectionInHours = -1;
                    endTime = resolution.increment(endTime, zoneId);
                }
            }
            if (dstCorrectionInHours > 0) {
                endTime = endTime.plus(1L, ChronoUnit.HOURS);
            } else if (dstCorrectionInHours < 0) {
                endTime = endTime.minus(1L, ChronoUnit.HOURS);
            }
            x1 = timelineModel.calculateLocationForTime(startTime);
            if (x1 < this.dateline.getWidth()) {
                DatelineCell cell = null;
                if (cell == null) {
                    cell = (DatelineCell)((Object)cellFactory.call((Object)temporalUnit));
                    cell.update(startTime, endTime, resolution, this.dateline, this.getPosition());
                }
                double x2 = timelineModel.calculateLocationForTime(endTime);
                double padding = this.getCellPadding();
                if (!cached && !(x1 + cell.prefWidth(scaleHeight) + 2.0 * padding <= x2)) {
                    success = false;
                    break;
                }
                this.cellList.add(cell);
                double correctionLeft = Math.max(0.0, -x1);
                double correctionRight = Math.max(0.0, x2 - datelineWidth);
                cell.setLayoutX(x1 + correctionLeft);
                cell.setLayoutY(scaleTopInsets);
                cell.setPrefHeight(scaleHeight);
                double cellWidth = x2 - x1 - correctionLeft - correctionRight;
                cell.setPrefWidth(cellWidth);
                cell.setMaxWidth(cellWidth);
                cell.setMinWidth(cellWidth);
                if (!selections.isEmpty() && selections.contains((Object)cell.getInterval())) {
                    cell.getStyleClass().add((Object)SELECTED_STYLE_CLASS);
                }
                if (dstCorrectionInHours > 0) {
                    cell.getStyleClass().add((Object)"dst-end");
                } else if (dstCorrectionInHours < 0) {
                    cell.getStyleClass().add((Object)"dst-start");
                }
                startTime = resolution.increment(startTime, zoneId);
                if (dstCorrectionInHours > 0) {
                    startTime = startTime.plus((long)dstCorrectionInHours, ChronoUnit.HOURS);
                } else if (dstCorrectionInHours < 0) {
                    startTime = endTime;
                }
            }
            ++index;
        }
        if (success) {
            int listSize = this.cellList.size();
            if (listSize > 0) {
                DatelineCell<?> first = this.cellList.get(0);
                DatelineCell<?> last = this.cellList.get(listSize - 1);
                first.getStyleClass().add((Object)"dateline-cell-first");
                last.getStyleClass().add((Object)"dateline-cell-last");
            }
            this.setResolution(resolution);
        } else {
            this.cellList.clear();
        }
        return success;
    }

    protected final void layoutChildren() {
        if (this.cellList != null) {
            this.getChildren().setAll(this.cellList);
        }
        super.layoutChildren();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<DatelineScale, Number> CELL_PADDING;

        private StyleableProperties() {
        }

        static {
            CELL_PADDING = new CssMetaData<DatelineScale, Number>("-fx-cell-padding", SizeConverter.getInstance(), (Number)5){

                public Double getInitialValue(DatelineScale node) {
                    return node.getCellPadding();
                }

                public boolean isSettable(DatelineScale n) {
                    return n.cellPadding == null || !n.cellPadding.isBound();
                }

                public StyleableProperty<Number> getStyleableProperty(DatelineScale n) {
                    return n.cellPaddingProperty();
                }
            };
            ArrayList<CssMetaData<DatelineScale, Number>> styleables = new ArrayList<CssMetaData<DatelineScale, Number>>(Region.getClassCssMetaData());
            styleables.add(CELL_PADDING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

