/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.timeline;

import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.util.ChronoUnitUtils;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.DatelineCell;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;

public class ChronoUnitDatelineCell
extends DatelineCell<ChronoUnit> {
    @Override
    public void update(Instant startTime, Instant endTime, Resolution<ChronoUnit> resolution, Dateline dateline, Resolution.Position scalePosition) {
        super.update(startTime, endTime, resolution, dateline, scalePosition);
        ChronoUnit temporalUnit = resolution.getTemporalUnit();
        ZoneId zoneId = dateline.getZoneId();
        this.setText(resolution.format(startTime, zoneId));
        ZonedDateTime zonedStartTime = ChronoUnitUtils.truncate(ZonedDateTime.ofInstant(startTime, zoneId), temporalUnit, 1, dateline.getFirstDayOfWeek());
        switch (resolution.getTemporalUnit()) {
            case DAYS: {
                this.getStyleClass().add((Object)zonedStartTime.getDayOfWeek().toString().toLowerCase());
                break;
            }
            case HALF_DAYS: {
                this.getStyleClass().add((Object)(zonedStartTime.get(ChronoField.AMPM_OF_DAY) == 0 ? "am" : "pm"));
                break;
            }
            case MONTHS: {
                this.getStyleClass().add((Object)zonedStartTime.getMonth().toString().toLowerCase());
                break;
            }
        }
    }
}

