/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.repository.RepositoryEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import impl.com.flexganttfx.skin.graphics.FlipPane;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Pos;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class RowPane<R extends Row<?, ?, ?>>
extends StackPane {
    private final RowCanvas<R> canvas;
    private final FlipPane<R> flipPane;
    private final Label zoneIdLabel;
    private GraphicsBase<R> graphics;
    private Node controlsNode;
    private final ObjectProperty<R> row = new SimpleObjectProperty((Object)this, "row");
    private final InvalidationListener redrawListener = it -> this.draw();
    private final InvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private final InvalidationListener updateZoneIdListener = evt -> this.updateZoneIdLabel();
    private final InvalidationListener weakUpdateZoneIdListener = new WeakInvalidationListener(this.updateZoneIdListener);
    private final EventHandler<RepositoryEvent> repositoryListener = evt -> {
        if (this.graphics.isAutomaticRedraw()) {
            this.draw();
        }
    };
    private final WeakEventHandler<RepositoryEvent> weakRepositoryListener = new WeakEventHandler(this.repositoryListener);
    private final ChangeListener<ActivityRepository<?>> repositoryReplacedListener = (observable, oldRepository, newRepository) -> {
        if (oldRepository != null) {
            oldRepository.removeEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
        }
        if (newRepository != null) {
            newRepository.addEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
        }
    };
    private final WeakChangeListener<ActivityRepository<?>> weakRepositoryReplacedListener = new WeakChangeListener(this.repositoryReplacedListener);

    public RowPane(GraphicsBase<R> graphics) {
        this.graphics = graphics;
        this.getStyleClass().add((Object)"row-pane");
        this.setPrefWidth(0.0);
        this.setPrefHeight(24.0);
        this.canvas = new RowCanvas<R>(graphics);
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.canvas.rowProperty().bind(this.rowProperty());
        this.zoneIdLabel = new Label("Zone ID");
        this.zoneIdLabel.getStyleClass().add((Object)"zone-id-label");
        this.zoneIdLabel.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull(this.row), (ObservableBooleanValue)graphics.showZoneIdProperty()));
        this.flipPane = new FlipPane(this);
        this.flipPane.getFront().getChildren().add(this.canvas);
        this.flipPane.getFront().getChildren().add((Object)this.zoneIdLabel);
        StackPane.setAlignment((Node)this.zoneIdLabel, (Pos)Pos.TOP_RIGHT);
        InvalidationListener editorListener = evt -> {
            if (this.flipPane.isBackVisible()) {
                if (graphics.getRowsEditing().contains(this.getRow())) {
                    this.flipPane.setRow(this.getRow());
                } else {
                    this.flipPane.flipToFrontImmediately();
                }
            } else if (graphics.getRowsEditing().contains(this.getRow())) {
                this.flipPane.setRow(this.getRow());
                this.flipPane.flipToBackImmediately();
            }
        };
        this.rowProperty().addListener(editorListener);
        EventHandler mouseEntered = evt -> {
            Callback controlsFactory;
            if (this.getRow() != null && !this.flipPane.isBackVisible() && (controlsFactory = graphics.getRowControlsFactory()) != null) {
                GraphicsBase.RowControlsParameter<R> param = new GraphicsBase.RowControlsParameter<R>(graphics, this.getRow());
                Node controlsNode = (Node)controlsFactory.call(param);
                this.setControlsNode(controlsNode);
            }
        };
        EventHandler mouseExited = evt -> {
            if (this.getRow() != null) {
                this.setControlsNode(null);
            }
        };
        this.rowProperty().addListener((observable, oldRow, newRow) -> {
            if (oldRow != null) {
                oldRow.linesManagerProperty().removeListener(this.weakRedrawListener);
                oldRow.lineCountProperty().removeListener(this.weakRedrawListener);
                oldRow.layoutProperty().removeListener(this.weakRedrawListener);
                oldRow.getRepository().removeEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
                oldRow.repositoryProperty().removeListener(this.weakRepositoryReplacedListener);
                oldRow.zoneIdProperty().removeListener(this.weakUpdateZoneIdListener);
                oldRow.getProperties().put((Object)"com.flexganttfx.row.showing", (Object)false);
                Bindings.unbindBidirectional((Property)this.prefHeightProperty(), (Property)oldRow.heightProperty());
            }
            if (newRow != null) {
                newRow.linesManagerProperty().addListener(this.weakRedrawListener);
                newRow.lineCountProperty().addListener(this.weakRedrawListener);
                newRow.layoutProperty().addListener(this.weakRedrawListener);
                newRow.getRepository().addEventHandler((EventHandler<RepositoryEvent>)this.weakRepositoryListener);
                newRow.repositoryProperty().addListener(this.weakRepositoryReplacedListener);
                newRow.zoneIdProperty().addListener(this.weakUpdateZoneIdListener);
                newRow.getProperties().put((Object)"com.flexganttfx.row.showing", (Object)this.isVisible());
                this.setPrefHeight(newRow.getHeight());
                Bindings.bindBidirectional((Property)this.prefHeightProperty(), (Property)newRow.heightProperty());
            } else {
                this.setPrefHeight(24.0);
            }
            this.updateZoneIdLabel();
        });
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEntered);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, mouseExited);
        this.getChildren().add(this.flipPane);
    }

    public final GraphicsBase<R> getGraphics() {
        return this.graphics;
    }

    private void setControlsNode(Node node) {
        if (this.controlsNode != null) {
            this.getChildren().remove((Object)this.controlsNode);
        }
        this.controlsNode = node;
        if (this.controlsNode != null) {
            StackPane.setAlignment((Node)this.controlsNode, (Pos)Pos.TOP_RIGHT);
            if (this.controlsNode instanceof Region) {
                ((Region)this.controlsNode).setMinSize(0.0, 0.0);
            }
            this.getChildren().add((Object)this.controlsNode);
        }
    }

    public final Node getControlsNode() {
        return this.controlsNode;
    }

    public final ObjectProperty<R> rowProperty() {
        return this.row;
    }

    public final void setRow(R row) {
        this.rowProperty().set(row);
    }

    public final R getRow() {
        return (R)((Row)this.rowProperty().get());
    }

    public final RowCanvas<R> getCanvas() {
        return this.canvas;
    }

    public final void startEditing() {
        this.flipPane.setRow(this.getRow());
        this.getScene().setCamera((Camera)new PerspectiveCamera());
        if (this.graphics.isAnimateRowEditor()) {
            this.flipPane.flipToBack();
        } else {
            this.flipPane.flipToBackImmediately();
        }
    }

    public final void stopEditing() {
        if (this.graphics.isAnimateRowEditor()) {
            this.flipPane.flipToFront();
        } else {
            this.flipPane.flipToFrontImmediately();
        }
    }

    public void draw() {
        this.canvas.draw();
    }

    private void updateZoneIdLabel() {
        R row = this.getRow();
        if (row != null) {
            ZoneId zoneId = ((Row)row).getZoneId();
            this.zoneIdLabel.setText(zoneId.getDisplayName(TextStyle.FULL_STANDALONE, Locale.getDefault()));
        } else {
            this.zoneIdLabel.setText("");
        }
    }
}

