/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.util.Objects;
import java.util.logging.Level;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;

public class RowCell<R extends Row<?, ?, ?>>
extends ListCell<R> {
    private static final String DEFAULT_STYLE_CLASS = "row-cell";
    private final RowPane<R> rowPane;

    public RowCell(GraphicsBase<R> graphics) {
        Objects.requireNonNull(graphics);
        this.rowPane = new RowPane<R>(graphics);
        graphics.getRowPanes().add(this.rowPane);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.rowPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.rowPane.rowProperty().bind((ObservableValue)this.itemProperty());
        Bindings.bindBidirectional((Property)this.prefHeightProperty(), (Property)this.rowPane.prefHeightProperty());
        this.heightProperty().addListener(it -> {
            GraphicsBaseSkin skin = (GraphicsBaseSkin)graphics.getSkin();
            skin.getLinksPane().requestLayout();
        });
        this.setPrefWidth(0.0);
        this.setGraphic((Node)this.rowPane);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.visibleProperty().addListener(observable -> {
            boolean visible = this.isVisible();
            Row row = (Row)this.getItem();
            if (row != null) {
                row.getProperties().put((Object)"com.flexganttfx.row.showing", (Object)visible);
            }
            if (visible) {
                if (LoggingDomain.RENDERING.isLoggable(Level.FINE)) {
                    LoggingDomain.RENDERING.fine("redrawing canvas because of row cell visibility changing to true");
                }
                this.rowPane.draw();
            }
        });
    }

    public final RowPane<R> getRowPane() {
        return this.rowPane;
    }
}

