/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.ChartActivity;
import com.flexganttfx.model.activity.CompletableActivity;
import com.flexganttfx.model.activity.MutableActivity;
import com.flexganttfx.model.activity.MutableChartActivity;
import com.flexganttfx.model.activity.MutableCompletableActivity;
import com.flexganttfx.model.exception.IllegalLineIndexException;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.timeline.Timeline;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.com.flexganttfx.skin.graphics.DragCanvas;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.GridHelper;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.util.AgendaHelper;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public final class RowCanvasBehaviour<R extends Row<?, ?, ?>> {
    private static final String DRAGANDDROPINFO = "com.flexganttfx.draganddropinfo";
    private static final String CURRENTEDITMODE = "com.flexganttfx.currenteditmode";
    private static final String CURRENTLYEDITEDACTIVITY = "com.flexganttfx.currentlyeditedactivity";
    private static final Map<GraphicsBase.EditMode, Cursor> cursorMap = new HashMap<GraphicsBase.EditMode, Cursor>();
    private static List<ActivityBounds> selectedBounds;
    private final RowCanvas<R> canvas;
    private static GraphicsBase.EditMode editMode;
    private static ActivityBounds activityBounds;
    private static double editStartX;
    private static double editStartY;
    private static TimeInterval oldTimeInterval;
    private static double oldValue;
    private static Point2D offset;
    private MouseEvent lastMouseEvent;
    public static final DataFormat DRAG_INFO;
    private Point2D lastDragLocation;
    private boolean dragPreviouslyAccepted;
    private ScrollThread scrollThread;
    private boolean mouseWasPressed;

    public static void setCursor(GraphicsBase.EditMode editMode, Cursor cursor) {
        Objects.requireNonNull(editMode);
        Objects.requireNonNull(cursor);
        cursorMap.put(editMode, cursor);
    }

    RowCanvasBehaviour(RowCanvas<R> canvas) {
        Objects.requireNonNull(canvas);
        this.canvas = canvas;
        canvas.addEventHandler(MouseEvent.MOUSE_MOVED, this::mouseMoved);
        canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
        canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        canvas.addEventHandler(MouseEvent.DRAG_DETECTED, this::dragDetected);
        canvas.addEventHandler(DragEvent.DRAG_OVER, this::dragOver);
        canvas.addEventHandler(DragEvent.DRAG_EXITED, this::dragExited);
        canvas.addEventHandler(DragEvent.DRAG_DROPPED, this::dragDropped);
        canvas.addEventHandler(DragEvent.DRAG_DONE, this::dragDone);
        canvas.getGraphics().addEventFilter(KeyEvent.ANY, this::updateEditModeAfterKeyEvent);
    }

    public void stopEdit() {
        editMode = GraphicsBase.EditMode.NONE;
        this.canvas.draw();
    }

    private void updateEditModeAfterKeyEvent(KeyEvent evt) {
        if (activityBounds != null && this.lastMouseEvent != null && this.canvas.getRow() != null && activityBounds.getRow() == this.canvas.getRow()) {
            this.lastMouseEvent = new MouseEvent(this.lastMouseEvent.getSource(), this.lastMouseEvent.getTarget(), this.lastMouseEvent.getEventType(), this.lastMouseEvent.getX(), this.lastMouseEvent.getY(), this.lastMouseEvent.getScreenX(), this.lastMouseEvent.getScreenY(), this.lastMouseEvent.getButton(), this.lastMouseEvent.getClickCount(), evt.isShiftDown(), evt.isControlDown(), evt.isAltDown(), evt.isMetaDown(), this.lastMouseEvent.isPrimaryButtonDown(), this.lastMouseEvent.isMiddleButtonDown(), this.lastMouseEvent.isSecondaryButtonDown(), this.lastMouseEvent.isSynthesized(), this.lastMouseEvent.isPopupTrigger(), this.lastMouseEvent.isStillSincePress(), null);
            this.updateEditMode();
        }
    }

    private void dragDetected(MouseEvent event) {
        LoggingDomain.DND.fine("drag detected: " + event);
        block0 : switch (editMode) {
            case DRAGGING: 
            case DRAGGING_VERTICAL: {
                if (activityBounds == null) break;
                GraphicsBase<R> graphics = this.canvas.getGraphics();
                Callback<ActivityRef<?>, Image> dragImageProvider = graphics.getDragImageProvider();
                Dragboard dragBoard = this.canvas.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                switch (graphics.getDragAndDropFeedback()) {
                    case NATIVE: {
                        Image image;
                        if (dragImageProvider != null) {
                            image = (Image)dragImageProvider.call(activityBounds.getActivityRef());
                        } else {
                            WritableImage writableImage = new WritableImage((int)activityBounds.getWidth(), (int)activityBounds.getHeight());
                            SnapshotParameters snapshotParameters = new SnapshotParameters();
                            snapshotParameters.setViewport((Rectangle2D)activityBounds);
                            snapshotParameters.setFill((Paint)Color.TRANSPARENT);
                            image = this.canvas.snapshot(snapshotParameters, writableImage);
                        }
                        dragBoard.setDragView(image);
                        break;
                    }
                    case RENDERED: 
                    case RENDERED_GRID_SNAPPED: {
                        dragBoard.setDragView((Image)new WritableImage(1, 1));
                        break;
                    }
                }
                ClipboardContent content = new ClipboardContent();
                content.put((Object)DRAG_INFO, (Object)new DragInfo(editMode, offset.getX(), event.isShortcutDown(), event.isShiftDown(), event.isAltDown()));
                content.putString(activityBounds.getActivity().getName());
                dragBoard.setContent((Map)content);
                selectedBounds = this.computeSelectedBoundsOnSameRow();
                R row = this.canvas.getRow();
                ActivityRef<?> activityRef = activityBounds.getActivityRef();
                switch (editMode) {
                    case DRAGGING: {
                        this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_STARTED, (Row<?, ?, ?>)row, (Row<?, ?, ?>)row, oldTimeInterval));
                        break block0;
                    }
                    case DRAGGING_VERTICAL: {
                        this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.VERTICAL_DRAG_STARTED, (Row<?, ?, ?>)row, (Row<?, ?, ?>)row, oldTimeInterval));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void dragOver(DragEvent evt) {
        if (LoggingDomain.DND.isLoggable(Level.FINE)) {
            LoggingDomain.DND.fine("drag over: " + evt);
        }
        Point2D dragLocation = new Point2D(evt.getX(), evt.getY());
        if (this.lastDragLocation != null && this.lastDragLocation.equals((Object)dragLocation)) {
            if (LoggingDomain.DND.isLoggable(Level.FINE)) {
                LoggingDomain.DND.fine("returning early");
            }
            if (this.dragPreviouslyAccepted) {
                evt.acceptTransferModes(TransferMode.ANY);
            } else {
                evt.acceptTransferModes(TransferMode.NONE);
            }
            return;
        }
        this.lastDragLocation = dragLocation;
        Dragboard dragboard = evt.getDragboard();
        if (!dragboard.hasContent(DRAG_INFO)) {
            LoggingDomain.DND.fine("no drag info found, not handling drag over");
            return;
        }
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        TimeInterval dragInterval = this.getDragInterval(evt);
        this.updateMarkedTimeInterval(dragInterval);
        R row = this.canvas.getRow();
        ActivityRef<?> activityRef = activityBounds.getActivityRef();
        graphics.getProperties().put((Object)"com.flexganttfx.hover.row", row);
        Layout layout = this.canvas.getLayoutAt(evt.getY());
        graphics.getProperties().put((Object)"com.flexganttfx.hover.layout", (Object)layout);
        GraphicsBase.DragAndDropInfo dragAndDropInfo = new GraphicsBase.DragAndDropInfo((Row<?, ?, ?>)row, activityBounds, selectedBounds, dragInterval, evt, offset);
        switch (graphics.getDragAndDropFeedback()) {
            case RENDERED: 
            case RENDERED_GRID_SNAPPED: {
                GraphicsBaseSkin skin = (GraphicsBaseSkin)graphics.getSkin();
                DragCanvas dragCanvas = skin.getDragCanvas();
                dragCanvas.draw(dragAndDropInfo);
                break;
            }
        }
        graphics.getProperties().put((Object)DRAGANDDROPINFO, (Object)dragAndDropInfo);
        if (row != null) {
            Callback<GraphicsBase.DragAndDropInfo, Boolean> callback = graphics.getRowDragAndDropCallback(row.getClass());
            if (callback != null) {
                if (((Boolean)callback.call((Object)dragAndDropInfo)).booleanValue()) {
                    LoggingDomain.DND.fine("accepting transfer mode ANY");
                    this.dragPreviouslyAccepted = true;
                    evt.acceptTransferModes(TransferMode.ANY);
                } else {
                    LoggingDomain.DND.fine("not accepting any transfer mode");
                    this.dragPreviouslyAccepted = false;
                    evt.acceptTransferModes(TransferMode.NONE);
                }
            } else {
                LoggingDomain.DND.fine("accepting transfer mode ANY");
                this.dragPreviouslyAccepted = true;
                evt.acceptTransferModes(TransferMode.ANY);
            }
            DragInfo dragInfo = (DragInfo)dragboard.getContent(DRAG_INFO);
            GraphicsBase.EditMode dragEditMode = dragInfo.getEditMode();
            switch (dragEditMode) {
                case DRAGGING: {
                    this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_ONGOING, activityRef.getRow(), (Row<?, ?, ?>)row, oldTimeInterval));
                    break;
                }
                case DRAGGING_VERTICAL: {
                    this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.VERTICAL_DRAG_ONGOING, activityRef.getRow(), (Row<?, ?, ?>)row, oldTimeInterval));
                    break;
                }
            }
            evt.consume();
        }
    }

    private List<ActivityBounds> computeSelectedBoundsOnSameRow() {
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        ArrayList<ActivityBounds> bounds = new ArrayList<ActivityBounds>();
        R row = this.canvas.getRow();
        for (ActivityRef activityRef : graphics.getSelectedActivities()) {
            GraphicsBase.EditingCallbackParameter param;
            Callback<GraphicsBase.EditingCallbackParameter, Boolean> activityEditingCallback;
            Object activity;
            if (activityRef.equals(activityBounds.getActivity()) || !activityRef.getRow().equals(row) || !((activity = activityRef.getActivity()) instanceof MutableActivity) || !((Boolean)(activityEditingCallback = graphics.getActivityEditingCallback(((MutableActivity)activity).getClass())).call((Object)(param = new GraphicsBase.EditingCallbackParameter(activityRef, editMode)))).booleanValue()) continue;
            bounds.add(this.canvas.getActivityBounds(activityRef));
        }
        return bounds;
    }

    private TimeInterval getDragInterval(DragEvent evt) {
        Dragboard dragboard = evt.getDragboard();
        DragInfo dragInfo = (DragInfo)dragboard.getContent(DRAG_INFO);
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        ActivityRef<?> activityRef = activityBounds.getActivityRef();
        MutableActivity activity = (MutableActivity)activityRef.getActivity();
        if (dragInfo.getEditMode().equals((Object)GraphicsBase.EditMode.DRAGGING)) {
            Timeline timeline = graphics.getTimeline();
            TimelineModel<?> timelineModel = timeline.getModel();
            Duration duration = Duration.between(activity.getStartTime(), activity.getEndTime());
            Instant newStartTime = timelineModel.calculateTimeForLocation(evt.getX() - dragInfo.getOffset());
            Instant newEndTime = newStartTime.plus(duration);
            switch (graphics.getDragAndDropFeedback()) {
                case RENDERED_GRID_SNAPPED: {
                    if (newStartTime.isBefore(activity.getStartTime())) {
                        Instant newStartTime1 = GridHelper.grid(graphics, newStartTime, false);
                        Instant newStartTime2 = GridHelper.grid(graphics, newStartTime, true);
                        newStartTime = Math.abs(Duration.between(newStartTime, newStartTime1).toMillis()) < Math.abs(Duration.between(newStartTime, newStartTime2).toMillis()) ? newStartTime1 : newStartTime2;
                        newEndTime = newStartTime.plus(duration);
                        break;
                    }
                    Instant newEndTime1 = GridHelper.grid(graphics, newEndTime, false);
                    Instant newEndTime2 = GridHelper.grid(graphics, newEndTime, true);
                    newEndTime = Math.abs(Duration.between(newEndTime, newEndTime1).toMillis()) < Math.abs(Duration.between(newEndTime, newEndTime2).toMillis()) ? newEndTime1 : newEndTime2;
                    newStartTime = newEndTime.minus(duration);
                    break;
                }
            }
            if (LoggingDomain.DND.isLoggable(Level.FINER)) {
                LoggingDomain.DND.finer("drag interval start: " + newStartTime);
                LoggingDomain.DND.finer("drag interval end: " + newEndTime);
            }
            return new TimeInterval(newStartTime, newEndTime);
        }
        return new TimeInterval(activity.getStartTime(), activity.getEndTime());
    }

    private void dragDropped(DragEvent evt) {
        GraphicsBase.DragAndDropInfo dragAndDropInfo;
        LoggingDomain.DND.fine("drag dropped: " + evt);
        if (!evt.getDragboard().hasContent(DRAG_INFO)) {
            LoggingDomain.DND.fine("no drag info found, not handling the drop");
            return;
        }
        this.clearDragCanvas();
        this.updateMarkedTimeInterval(null);
        Dragboard dragboard = evt.getDragboard();
        DragInfo dragInfo = (DragInfo)dragboard.getContent(DRAG_INFO);
        GraphicsBase.EditMode dragEditMode = dragInfo.getEditMode();
        ActivityRef<?> oldActivityRef = activityBounds.getActivityRef();
        MutableActivity activity = (MutableActivity)oldActivityRef.getActivity();
        Row<?, ?, ?> oldRow = oldActivityRef.getRow();
        TimeInterval dragInterval = this.getDragInterval(evt);
        R newRow = this.canvas.getRow();
        if (newRow == null) {
            return;
        }
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        Callback<GraphicsBase.DragAndDropInfo, Boolean> callback = graphics.getRowDragAndDropCallback(newRow.getClass());
        if (((Boolean)callback.call((Object)(dragAndDropInfo = new GraphicsBase.DragAndDropInfo((Row<?, ?, ?>)newRow, activityBounds, selectedBounds, dragInterval, evt, offset)))).booleanValue()) {
            Callback<GraphicsBase.DragAndDropInfo, Layer> layerProvider;
            Layer newLayer;
            oldActivityRef.detachFromRow();
            if (dragEditMode == GraphicsBase.EditMode.DRAGGING) {
                activity.setStartTime(dragInterval.getStartTime());
                activity.setEndTime(dragInterval.getEndTime());
            }
            if ((newLayer = (Layer)(layerProvider = graphics.getDropLayerProvider()).call((Object)dragAndDropInfo)) == null) {
                throw new IllegalArgumentException("the drop layer provider has returned no layer for the dropped activity");
            }
            if (!graphics.getLayers().contains((Object)newLayer)) {
                throw new IllegalArgumentException("the drop layer provider has returned a layer that does not exist in the Gantt chart");
            }
            ((Row)newRow).addActivity(newLayer, (MutableActivity)activity);
            ActivityRef<MutableActivity> newActivityRef = new ActivityRef<MutableActivity>((Row<?, ?, MutableActivity>)newRow, newLayer, activity);
            this.fixLinks(oldActivityRef, newActivityRef);
            switch (dragEditMode) {
                case DRAGGING: {
                    this.fireEvent(new ActivityEvent(oldActivityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_FINISHED, oldRow, (Row<?, ?, ?>)newRow, oldTimeInterval));
                    break;
                }
                case DRAGGING_VERTICAL: {
                    this.fireEvent(new ActivityEvent(oldActivityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.VERTICAL_DRAG_FINISHED, oldRow, (Row<?, ?, ?>)newRow, oldTimeInterval));
                    break;
                }
            }
        }
        this.canvas.draw();
        this.lastDragLocation = null;
        this.dragPreviouslyAccepted = false;
    }

    private void fixLinks(ActivityRef<?> oldActivityRef, ActivityRef<?> newActivityRef) {
        for (ActivityLink link : this.canvas.getGraphics().getLinks()) {
            if (link.getSourceActivityRef().equals(oldActivityRef)) {
                link.setSourceActivityRef(newActivityRef);
            }
            if (!link.getTargetActivityRef().equals(oldActivityRef)) continue;
            link.setTargetActivityRef(newActivityRef);
        }
    }

    private void dragExited(DragEvent evt) {
        LoggingDomain.DND.fine("drag exited: " + evt);
        this.canvas.getGraphics().getProperties().remove((Object)DRAGANDDROPINFO);
        this.clearDragCanvas();
    }

    private void dragDone(DragEvent evt) {
        LoggingDomain.DND.fine("drag done: " + evt);
        selectedBounds.clear();
        this.stopAutoScrollIfNeeded();
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        graphics.getProperties().put((Object)DRAGANDDROPINFO, null);
        this.clearDragCanvas();
        this.clearCurrentlyEditedActivity();
        this.canvas.draw();
        Dragboard dragboard = evt.getDragboard();
        DragInfo dragInfo = (DragInfo)dragboard.getContent(DRAG_INFO);
        GraphicsBase.EditMode dragEditMode = dragInfo.getEditMode();
        switch (dragEditMode) {
            case DRAGGING: {
                this.fireEvent(new ActivityEvent(activityBounds.getActivityRef(), (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_DONE));
                break;
            }
            case DRAGGING_VERTICAL: {
                this.fireEvent(new ActivityEvent(activityBounds.getActivityRef(), (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.VERTICAL_DRAG_DONE));
                break;
            }
        }
        this.lastDragLocation = null;
        this.dragPreviouslyAccepted = false;
        activityBounds = null;
    }

    private void clearDragCanvas() {
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.canvas.getGraphics().getSkin();
        DragCanvas dragCanvas = skin.getDragCanvas();
        dragCanvas.draw(null);
    }

    private void handleSelection(MouseEvent event) {
        LoggingDomain.EDITING.fine(event.toString());
        LoggingDomain.EDITING.fine("consumed: " + event.isConsumed());
        LoggingDomain.EDITING.fine("edit mode: " + (Object)((Object)editMode));
        LoggingDomain.EDITING.fine("popup trigger: " + event.isPopupTrigger());
        if (!event.isConsumed()) {
            GraphicsBase<R> graphics = this.canvas.getGraphics();
            ActivityBounds bounds = this.canvas.getActivityBounds(event.getX(), event.getY());
            ObservableList<ActivityRef<?>> selectedActivities = graphics.getSelectedActivities();
            if (bounds != null) {
                ActivityRef<?> activityRef = bounds.getActivityRef();
                if (event.isShiftDown() || event.isShortcutDown()) {
                    LoggingDomain.EDITING.fine("selecting with SHIFT or CTRL/META down -> multi selection");
                    if (selectedActivities.contains(activityRef)) {
                        LoggingDomain.EDITING.fine("activity already in selection, removing it now");
                        selectedActivities.remove(activityRef);
                    } else {
                        LoggingDomain.EDITING.fine("adding activity to list of selected activities");
                        if (graphics.getSelectionMode() == GraphicsBase.SelectionMode.SINGLE) {
                            selectedActivities.setAll((Object[])new ActivityRef[]{activityRef});
                        } else {
                            selectedActivities.add(activityRef);
                        }
                    }
                } else {
                    LoggingDomain.EDITING.fine("selecting without SHIFT or CTRL/META down -> single selection");
                    if (!selectedActivities.contains(activityRef)) {
                        selectedActivities.setAll((Object[])new ActivityRef[]{activityRef});
                    }
                }
            } else if (!(event.isPopupTrigger() || event.isShiftDown() || event.isShortcutDown())) {
                LoggingDomain.EDITING.fine("no bounds found, clearing current selection");
                selectedActivities.clear();
            }
        }
    }

    private void mouseReleased(MouseEvent event) {
        LoggingDomain.EDITING.finest("mouse released: " + event);
        if (!this.mouseWasPressed) {
            return;
        }
        this.stopAutoScrollIfNeeded();
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        graphics.getProperties().put((Object)"com.flexganttfx.pressed.activity", null);
        if (editMode != GraphicsBase.EditMode.NONE && activityBounds != null && event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.clearCurrentlyEditedActivity();
            this.canvas.draw();
            this.fireActivityChangeFinished();
        }
        this.updateMarkedTimeInterval(null);
        this.mouseWasPressed = false;
        activityBounds = null;
    }

    private void autoscroll(double xOffset, double yOffset, MouseEvent event) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setMouseEvent(event);
        this.scrollThread.setDelta(xOffset, yOffset);
    }

    private void stopAutoScrollIfNeeded() {
        if (this.scrollThread != null) {
            this.scrollThread.stopRunning();
            this.scrollThread = null;
        }
    }

    private void startAutoscrollIfNeeded(MouseEvent evt) {
        double x = evt.getX();
        double sceneY = evt.getSceneY();
        double xOffset = 0.0;
        if (x < 0.0) {
            xOffset = x;
        } else if (x > this.canvas.getWidth()) {
            xOffset = x - this.canvas.getWidth();
        }
        double yOffset = 0.0;
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        if (graphics instanceof ListViewGraphics) {
            if (sceneY > graphics.localToScene(0.0, 0.0).getY() + graphics.getHeight()) {
                yOffset = sceneY - (graphics.localToScene(0.0, 0.0).getY() + this.canvas.getGraphics().getHeight());
            } else if (sceneY < graphics.localToScene(0.0, 0.0).getY()) {
                yOffset = sceneY - graphics.localToScene(0.0, 0.0).getY();
            }
        }
        if (xOffset == 0.0 && yOffset == 0.0) {
            this.stopAutoScrollIfNeeded();
            this.doMouseDragged(evt);
        } else {
            this.autoscroll(xOffset, yOffset, evt);
        }
    }

    private void mouseDragged(MouseEvent event) {
        if (!this.mouseWasPressed) {
            return;
        }
        if (LoggingDomain.EDITING.isLoggable(Level.FINEST)) {
            LoggingDomain.EDITING.finest("mouse dragged: " + event);
        }
        switch (editMode) {
            case DRAGGING: 
            case DRAGGING_VERTICAL: 
            case NONE: {
                return;
            }
        }
        this.startAutoscrollIfNeeded(event);
    }

    private void doMouseDragged(MouseEvent event) {
        if (editMode != GraphicsBase.EditMode.NONE && activityBounds != null && event.getButton().equals((Object)MouseButton.PRIMARY)) {
            if (LoggingDomain.EDITING.isLoggable(Level.FINER)) {
                LoggingDomain.EDITING.finer("dragging with editing operation " + (Object)((Object)editMode));
            }
            ActivityRef<?> activityRef = activityBounds.getActivityRef();
            activityRef.detachFromRow();
            switch (editMode) {
                case NONE: {
                    break;
                }
                case DRAGGING: 
                case DRAGGING_VERTICAL: {
                    break;
                }
                case DRAGGING_HORIZONTAL: {
                    this.changeStartAndEndTime(event);
                    activityRef.attachToRow();
                    break;
                }
                case CHART_VALUE_CHANGE: {
                    this.changeChartValue(event);
                    activityRef.attachToRow();
                    break;
                }
                case CHART_VALUE_HIGH_CHANGE: {
                    activityRef.attachToRow();
                    break;
                }
                case CHART_VALUE_LOW_CHANGE: {
                    activityRef.attachToRow();
                    break;
                }
                case START_TIME_CHANGE: {
                    this.changeStartTime(event);
                    activityRef.attachToRow();
                    break;
                }
                case END_TIME_CHANGE: {
                    this.changeEndTime(event);
                    activityRef.attachToRow();
                    break;
                }
                case PERCENTAGE_COMPLETE_CHANGE: {
                    this.changePercentageComplete(event);
                    activityRef.attachToRow();
                    break;
                }
                case AGENDA_ASSIGNING: {
                    activityRef.attachToRow();
                    break;
                }
                case AGENDA_DRAGGING: {
                    this.changeStartAndEndTimeAgenda(event);
                    activityRef.attachToRow();
                    break;
                }
                case AGENDA_END_TIME_CHANGE: {
                    this.changeEndTimeAgenda(event);
                    activityRef.attachToRow();
                    break;
                }
                case AGENDA_START_TIME_CHANGE: {
                    this.changeStartTimeAgenda(event);
                    activityRef.attachToRow();
                    break;
                }
            }
            this.fireActivityChangeOngoing();
        }
    }

    private void fireEvent(ActivityEvent event) {
        if (LoggingDomain.EVENTS.isLoggable(Level.FINE)) {
            LoggingDomain.EVENTS.fine("firing event: " + (Object)((Object)event));
        }
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        graphics.fireEvent((Event)event);
    }

    private void changeStartTime(MouseEvent event) {
        MutableActivity activity;
        TimelineModel<?> timelineModel = this.canvas.getTimelineModel();
        Instant time = GridHelper.grid(this.canvas.getGraphics(), timelineModel.calculateTimeForLocation(event.getX()));
        if (time.isAfter((activity = (MutableActivity)activityBounds.getActivity()).getEndTime())) {
            activity.setStartTime(activity.getEndTime());
        } else {
            activity.setStartTime(time);
        }
        this.updateMarkedTimeInterval(new TimeInterval(activity.getStartTime(), activity.getEndTime()));
        this.canvas.draw();
    }

    private void changeEndTime(MouseEvent event) {
        MutableActivity activity;
        TimelineModel<?> timelineModel = this.canvas.getTimelineModel();
        Instant time = GridHelper.grid(this.canvas.getGraphics(), timelineModel.calculateTimeForLocation(event.getX()));
        if (time.isBefore((activity = (MutableActivity)activityBounds.getActivity()).getStartTime())) {
            activity.setEndTime(activity.getStartTime());
        } else {
            activity.setEndTime(time);
        }
        this.updateMarkedTimeInterval(new TimeInterval(activity.getStartTime(), activity.getEndTime()));
        this.canvas.draw();
    }

    private void changeStartAndEndTime(MouseEvent event) {
        Instant timeB;
        TimelineModel<?> timelineModel = this.canvas.getTimelineModel();
        MutableActivity activity = (MutableActivity)activityBounds.getActivity();
        Instant timeA = GridHelper.grid(this.canvas.getGraphics(), timelineModel.calculateTimeForLocation(editStartX));
        if (!timeA.equals(timeB = GridHelper.grid(this.canvas.getGraphics(), timelineModel.calculateTimeForLocation(event.getX())))) {
            Duration deltaTime = Duration.between(timeA, timeB);
            activity.setStartTime(activity.getStartTime().plus(deltaTime));
            activity.setEndTime(activity.getEndTime().plus(deltaTime));
            editStartX = event.getX();
        }
        this.updateMarkedTimeInterval(new TimeInterval(activity.getStartTime(), activity.getEndTime()));
        this.canvas.draw();
    }

    private void updateMarkedTimeInterval(TimeInterval markedTimeInterval) {
        if (this.canvas.getGraphics().isAutoMarkedTimeInterval()) {
            Eventline eventline = this.getEventline();
            if (activityBounds != null && activityBounds.getLayout() instanceof AgendaLayout) {
                eventline.setMarkedTimeInterval(null);
            } else {
                eventline.setMarkedTimeInterval(markedTimeInterval);
            }
        }
    }

    private void changePercentageComplete(MouseEvent event) {
        double deltaX = Math.max(0.0, event.getX() - activityBounds.getMinX());
        double percent = Math.min(100.0, deltaX / activityBounds.getWidth() * 100.0);
        MutableCompletableActivity completable = (MutableCompletableActivity)activityBounds.getActivity();
        completable.setPercentageComplete(percent);
        this.canvas.draw();
    }

    private void changeChartValue(MouseEvent event) {
        R row = this.canvas.getRow();
        Layout layout = ((Row)row).getLayout();
        double height = ((Row)row).getHeight();
        double y = 0.0;
        MutableChartActivity chartActivity = (MutableChartActivity)activityBounds.getActivity();
        int lineIndex = ((Row)row).getLineIndex((MutableChartActivity)chartActivity);
        if (lineIndex > -1) {
            try {
                layout = ((Row)row).getLineLayout(lineIndex);
                height = ((Row)row).getLineHeight(lineIndex);
                y = ((Row)row).getLineLocation(lineIndex);
            }
            catch (IllegalLineIndexException e) {
                e.printStackTrace();
            }
        }
        LoggingDomain.EDITING.fine("row / line location = " + y);
        LoggingDomain.EDITING.fine("row / line height = " + height);
        ChartLayout chartLayout = (ChartLayout)layout;
        double padding = chartLayout.getPadding();
        double minChartValue = chartLayout.getMinValue();
        double maxChartValue = chartLayout.getMaxValue();
        double range = maxChartValue - minChartValue;
        double usedHeight = height - 2.0 * padding;
        double pixelValue = range / usedHeight;
        LoggingDomain.EDITING.fine("min chart value = " + minChartValue);
        LoggingDomain.EDITING.fine("max chart value = " + maxChartValue);
        double localY = Math.min(padding + usedHeight, Math.max(padding, event.getY() - y));
        LoggingDomain.EDITING.fine("local y = " + localY);
        double chartValueAtLocalY = (localY - padding) * pixelValue;
        chartValueAtLocalY = chartLayout.getMaxValue() - chartValueAtLocalY;
        double chartValue = Math.max(minChartValue, Math.min(maxChartValue, chartValueAtLocalY));
        LoggingDomain.EDITING.fine("chart value = " + chartValue);
        chartActivity.setChartValue(chartValue);
        this.canvas.draw();
    }

    private void changeStartAndEndTimeAgenda(MouseEvent event) {
        ZoneId rowZoneId = ((Row)this.canvas.getRow()).getZoneId();
        TimelineModel<?> timelineModel = this.canvas.getTimelineModel();
        AgendaLayout layout = (AgendaLayout)activityBounds.getLayout();
        LocalTime oldLocalTime = this.timeAt(layout, editStartY);
        LocalTime newLocalTime = this.timeAt(layout, event.getY());
        Instant oldTime = timelineModel.calculateTimeForLocation(editStartX);
        Instant newTime = timelineModel.calculateTimeForLocation(event.getX());
        LocalDate oldLocalDate = ZonedDateTime.ofInstant(oldTime, rowZoneId).toLocalDate();
        LocalDate newLocalDate = ZonedDateTime.ofInstant(newTime, rowZoneId).toLocalDate();
        ZonedDateTime oldZonedDateTime = ZonedDateTime.of(oldLocalDate, oldLocalTime, rowZoneId);
        ZonedDateTime newZonedDateTime = ZonedDateTime.of(newLocalDate, newLocalTime, rowZoneId);
        Duration moveDuration = Duration.between(oldZonedDateTime, newZonedDateTime);
        MutableActivity activity = (MutableActivity)activityBounds.getActivity();
        Duration activityDuration = Duration.between(activity.getStartTime(), activity.getEndTime());
        Instant oldStartTime = activity.getStartTime();
        Instant newStartTime = GridHelper.grid(this.canvas.getGraphics(), oldStartTime.plus(moveDuration), editStartY > event.getY());
        Instant newEndTime = newStartTime.plus(activityDuration);
        if (!newStartTime.equals(oldStartTime)) {
            activity.setStartTime(newStartTime);
            activity.setEndTime(newEndTime);
            this.canvas.draw();
            editStartY = event.getY();
            editStartX = event.getX();
        }
    }

    private void changeStartTimeAgenda(MouseEvent event) {
        ZoneId rowZoneId = ((Row)this.canvas.getRow()).getZoneId();
        AgendaLayout layout = (AgendaLayout)activityBounds.getLayout();
        LocalTime timeAt = this.timeAt(layout, event.getY());
        ZonedDateTime dateAndTimeAt = ZonedDateTime.ofInstant(this.canvas.getTimelineModel().calculateTimeForLocation(event.getX()), rowZoneId);
        LocalDate dateAt = dateAndTimeAt.toLocalDate();
        MutableActivity activity = (MutableActivity)activityBounds.getActivity();
        Instant startTime = activity.getStartTime();
        ZonedDateTime localDateTime = ZonedDateTime.ofInstant(startTime, ((Row)this.canvas.getRow()).getZoneId()).with(timeAt).with(dateAt);
        Instant time = Instant.from(localDateTime);
        if (!Duration.between(time, activity.getEndTime()).minus(layout.getMinDuration()).isNegative()) {
            activity.setStartTime(GridHelper.grid(this.canvas.getGraphics(), time));
        } else {
            activity.setStartTime(GridHelper.grid(this.canvas.getGraphics(), activity.getEndTime().minus(layout.getMinDuration())));
        }
        this.canvas.draw();
    }

    private void changeEndTimeAgenda(MouseEvent event) {
        ZoneId rowZoneId = ((Row)this.canvas.getRow()).getZoneId();
        AgendaLayout layout = (AgendaLayout)activityBounds.getLayout();
        LocalTime timeAt = this.timeAt(layout, event.getY());
        ZonedDateTime dateAndTimeAt = ZonedDateTime.ofInstant(this.canvas.getTimelineModel().calculateTimeForLocation(event.getX()), rowZoneId);
        LocalDate dateAt = dateAndTimeAt.toLocalDate();
        MutableActivity activity = (MutableActivity)activityBounds.getActivity();
        Instant endTime = activity.getEndTime();
        ZonedDateTime localDateTime = ZonedDateTime.ofInstant(endTime, ((Row)this.canvas.getRow()).getZoneId()).with(timeAt).with(dateAt);
        Instant time = Instant.from(localDateTime);
        if (!Duration.between(activity.getStartTime(), time).minus(layout.getMinDuration()).isNegative()) {
            activity.setEndTime(GridHelper.grid(this.canvas.getGraphics(), time));
        } else {
            activity.setEndTime(GridHelper.grid(this.canvas.getGraphics(), activity.getStartTime().plus(layout.getMinDuration())));
        }
        this.canvas.draw();
    }

    private LocalTime timeAt(AgendaLayout layout, double y) {
        double yOffset = 0.0;
        double height = this.canvas.getHeight();
        int lineIndex = activityBounds.getLineIndex();
        if (lineIndex >= 0) {
            R row = this.canvas.getRow();
            yOffset = ((Row)row).getLineLocation(lineIndex);
            height = ((Row)row).getLineHeight(lineIndex);
        }
        return AgendaHelper.getTimeAt(Math.min(height -= 2.0 * layout.getPadding(), Math.max(0.0, y - yOffset - layout.getPadding())), height, layout.getStartTime(), layout.getEndTime());
    }

    private void mousePressed(MouseEvent event) {
        LoggingDomain.EDITING.fine(event.toString());
        LoggingDomain.EDITING.fine("editing bounds: " + (Object)((Object)activityBounds));
        LoggingDomain.EDITING.fine("editing operation: " + (Object)((Object)editMode));
        this.mouseWasPressed = true;
        this.handleSelection(event);
        editStartX = event.getX();
        editStartY = event.getY();
        LoggingDomain.EDITING.finest("editing start x: " + editStartX);
        LoggingDomain.EDITING.finest("editing start y: " + editStartY);
        activityBounds = this.canvas.getActivityBounds(event.getX(), event.getY());
        if (activityBounds != null) {
            offset = new Point2D(event.getX() - activityBounds.getMinX(), event.getY() - activityBounds.getMinY());
            GraphicsBase<R> graphics = this.canvas.getGraphics();
            graphics.getProperties().put((Object)"com.flexganttfx.pressed.activity", activityBounds.getActivityRef());
            graphics.getProperties().put((Object)CURRENTEDITMODE, (Object)editMode);
            if (!editMode.equals((Object)GraphicsBase.EditMode.NONE) && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                oldTimeInterval = new TimeInterval(activityBounds.getActivity().getStartTime(), activityBounds.getActivity().getEndTime());
                oldValue = editMode.equals((Object)GraphicsBase.EditMode.PERCENTAGE_COMPLETE_CHANGE) ? ((CompletableActivity)activityBounds.getActivity()).getPercentageComplete() : (editMode.equals((Object)GraphicsBase.EditMode.CHART_VALUE_CHANGE) ? ((ChartActivity)activityBounds.getActivity()).getChartValue() : -1.0);
                this.updateCurrentlyEditedActivity();
                this.fireActivityChangeStarted();
            }
        }
    }

    private void updateCurrentlyEditedActivity() {
        if (activityBounds != null) {
            GraphicsBase<R> graphics = this.canvas.getGraphics();
            graphics.getProperties().put((Object)CURRENTLYEDITEDACTIVITY, activityBounds.getActivityRef());
        }
    }

    private void clearCurrentlyEditedActivity() {
        this.canvas.getGraphics().getProperties().put((Object)CURRENTLYEDITEDACTIVITY, (Object)"");
    }

    private Eventline getEventline() {
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        Timeline timeline = graphics.getTimeline();
        return timeline.getEventline();
    }

    private void mouseMoved(MouseEvent event) {
        if (LoggingDomain.EDITING.isLoggable(Level.FINEST)) {
            LoggingDomain.EDITING.finest("mouse moved: " + event);
        }
        this.lastMouseEvent = event;
        GraphicsBase<R> graphics = this.canvas.getGraphics();
        graphics.getProperties().put((Object)"com.flexganttfx.hover.row", this.canvas.getRow());
        Layout layout = this.canvas.getLayoutAt(event.getY());
        graphics.getProperties().put((Object)"com.flexganttfx.hover.layout", (Object)layout);
        activityBounds = this.canvas.getActivityBounds(event.getX(), event.getY());
        if (activityBounds != null) {
            graphics.getProperties().put((Object)"com.flexganttfx.hover.activity", activityBounds.getActivityRef());
            this.updateEditMode();
            if (LoggingDomain.EDITING.isLoggable(Level.FINER)) {
                LoggingDomain.EDITING.finer("found bounds: " + (Object)((Object)activityBounds));
                LoggingDomain.EDITING.finer("edit mode: " + (Object)((Object)editMode));
            }
        } else {
            editMode = GraphicsBase.EditMode.NONE;
            graphics.getProperties().put((Object)"com.flexganttfx.hover.activity", null);
            graphics.getProperties().put((Object)CURRENTEDITMODE, (Object)editMode);
            graphics.setCursor(Cursor.DEFAULT);
        }
    }

    private void updateEditMode() {
        if (activityBounds != null && this.lastMouseEvent != null) {
            GraphicsBase<R> graphics = this.canvas.getGraphics();
            editMode = this.lookupEditMode(activityBounds, this.lastMouseEvent);
            graphics.getProperties().put((Object)CURRENTEDITMODE, (Object)editMode);
            graphics.setCursor(cursorMap.get((Object)editMode));
        }
    }

    private GraphicsBase.EditMode lookupEditMode(ActivityBounds bounds, MouseEvent event) {
        Activity activity = bounds.getActivity();
        if (activity instanceof MutableActivity) {
            MutableActivity mutable = (MutableActivity)activity;
            GraphicsBase<R> graphics = this.canvas.getGraphics();
            Layout layout = bounds.getLayout();
            Callback<GraphicsBase.EditModeCallbackParameter, GraphicsBase.EditMode> editModeCallback = graphics.getEditModeCallback(mutable.getClass(), layout.getClass());
            if (editModeCallback == null) {
                throw new IllegalArgumentException("no edit mode controller found for activity of type " + activity.getClass());
            }
            if (LoggingDomain.EDITING.isLoggable(Level.FINER)) {
                LoggingDomain.EDITING.finer("using edit mode controller of type " + editModeCallback.getClass());
            }
            GraphicsBase.EditModeCallbackParameter parameter = new GraphicsBase.EditModeCallbackParameter(bounds, event);
            GraphicsBase.EditMode editMode = (GraphicsBase.EditMode)((Object)editModeCallback.call((Object)parameter));
            GraphicsBase.EditingCallbackParameter editingParameter = new GraphicsBase.EditingCallbackParameter(bounds.getActivityRef(), editMode);
            Callback<GraphicsBase.EditingCallbackParameter, Boolean> editingCallback = graphics.getActivityEditingCallback(mutable.getClass());
            if (editingCallback != null) {
                if (((Boolean)editingCallback.call((Object)editingParameter)).booleanValue()) {
                    if (LoggingDomain.EDITING.isLoggable(Level.FINER)) {
                        LoggingDomain.EDITING.finer("using activity edit policy of type " + editingCallback.getClass());
                    }
                    return editMode;
                }
            } else if (LoggingDomain.EDITING.isLoggable(Level.FINER)) {
                LoggingDomain.EDITING.finer("no editing policy found for activity of type " + mutable.getClass().getName());
            }
        }
        return GraphicsBase.EditMode.NONE;
    }

    private void fireActivityChangeStarted() {
        if (!this.mouseWasPressed) {
            return;
        }
        ActivityRef<?> activityRef = activityBounds.getActivityRef();
        switch (editMode) {
            case NONE: {
                break;
            }
            case DRAGGING: 
            case DRAGGING_VERTICAL: {
                break;
            }
            case DRAGGING_HORIZONTAL: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_STARTED, oldTimeInterval));
                break;
            }
            case CHART_VALUE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_VALUE_CHANGE_STARTED, oldValue));
                break;
            }
            case CHART_VALUE_HIGH_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_HIGH_VALUE_CHANGE_STARTED, oldValue));
                break;
            }
            case CHART_VALUE_LOW_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_LOW_VALUE_CHANGE_STARTED, oldValue));
                break;
            }
            case START_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_STARTED, oldTimeInterval.getStartTime()));
                break;
            }
            case END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_STARTED, oldTimeInterval.getEndTime()));
                break;
            }
            case PERCENTAGE_COMPLETE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.PERCENTAGE_CHANGE_STARTED, oldValue));
                break;
            }
            case AGENDA_ASSIGNING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_STARTED, activityBounds.getRow(), activityBounds.getRow(), oldTimeInterval));
                break;
            }
            case AGENDA_DRAGGING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_STARTED, oldTimeInterval));
                break;
            }
            case AGENDA_END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_STARTED, oldTimeInterval.getEndTime()));
                break;
            }
            case AGENDA_START_TIME_CHANGE: {
                activityRef.attachToRow();
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_STARTED, oldTimeInterval.getStartTime()));
                break;
            }
        }
    }

    private void fireActivityChangeFinished() {
        if (!this.mouseWasPressed) {
            return;
        }
        ActivityRef<?> activityRef = activityBounds.getActivityRef();
        switch (editMode) {
            case NONE: {
                break;
            }
            case DRAGGING: 
            case DRAGGING_VERTICAL: {
                break;
            }
            case DRAGGING_HORIZONTAL: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_FINISHED, oldTimeInterval));
                break;
            }
            case CHART_VALUE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_VALUE_CHANGE_FINISHED, oldValue));
                break;
            }
            case CHART_VALUE_HIGH_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_HIGH_VALUE_CHANGE_FINISHED, oldValue));
                break;
            }
            case CHART_VALUE_LOW_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_LOW_VALUE_CHANGE_FINISHED, oldValue));
                break;
            }
            case START_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_FINISHED, oldTimeInterval.getStartTime()));
                break;
            }
            case END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_FINISHED, oldTimeInterval.getEndTime()));
                break;
            }
            case PERCENTAGE_COMPLETE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.PERCENTAGE_CHANGE_FINISHED, oldValue));
                break;
            }
            case AGENDA_ASSIGNING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_FINISHED, activityBounds.getRow(), activityBounds.getRow(), oldTimeInterval));
                break;
            }
            case AGENDA_DRAGGING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_FINISHED, oldTimeInterval));
                break;
            }
            case AGENDA_END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_FINISHED, oldTimeInterval.getEndTime()));
                break;
            }
            case AGENDA_START_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_FINISHED, oldTimeInterval.getStartTime()));
                break;
            }
        }
    }

    private void fireActivityChangeOngoing() {
        if (!this.mouseWasPressed) {
            return;
        }
        ActivityRef<?> activityRef = activityBounds.getActivityRef();
        switch (editMode) {
            case NONE: {
                break;
            }
            case DRAGGING: 
            case DRAGGING_VERTICAL: {
                break;
            }
            case DRAGGING_HORIZONTAL: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_ONGOING, oldTimeInterval));
                break;
            }
            case CHART_VALUE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_VALUE_CHANGE_ONGOING, oldValue));
                break;
            }
            case CHART_VALUE_HIGH_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_HIGH_VALUE_CHANGE_ONGOING, oldValue));
                break;
            }
            case CHART_VALUE_LOW_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.CHART_LOW_VALUE_CHANGE_ONGOING, oldValue));
                break;
            }
            case START_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_ONGOING, oldTimeInterval.getStartTime()));
                break;
            }
            case END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_ONGOING, oldTimeInterval.getEndTime()));
                break;
            }
            case PERCENTAGE_COMPLETE_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.PERCENTAGE_CHANGE_ONGOING, oldValue));
                break;
            }
            case AGENDA_ASSIGNING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.DRAG_ONGOING, activityBounds.getRow(), activityBounds.getRow(), oldTimeInterval));
                break;
            }
            case AGENDA_DRAGGING: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.HORIZONTAL_DRAG_ONGOING, oldTimeInterval));
                break;
            }
            case AGENDA_END_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.END_TIME_CHANGE_ONGOING, oldTimeInterval.getEndTime()));
                break;
            }
            case AGENDA_START_TIME_CHANGE: {
                this.fireEvent(new ActivityEvent(activityRef, (EventTarget)this.canvas, (EventType<? extends ActivityEvent>)ActivityEvent.START_TIME_CHANGE_ONGOING, oldTimeInterval.getStartTime()));
                break;
            }
        }
    }

    static {
        for (GraphicsBase.EditMode op : GraphicsBase.EditMode.values()) {
            cursorMap.put(op, Cursor.DEFAULT);
        }
        cursorMap.put(GraphicsBase.EditMode.NONE, Cursor.DEFAULT);
        Image percentageImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-percentage.gif"));
        ImageCursor percentageCursor = new ImageCursor(percentageImage, percentageImage.getWidth(), percentageImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.PERCENTAGE_COMPLETE_CHANGE, (Cursor)percentageCursor);
        Image chartImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-chart-value.gif"));
        ImageCursor chartValueCursor = new ImageCursor(chartImage, chartImage.getWidth() / 2.0, chartImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.CHART_VALUE_CHANGE, (Cursor)chartValueCursor);
        Image dragImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-move.gif"));
        ImageCursor dragCursor = new ImageCursor(dragImage, dragImage.getWidth() / 2.0, dragImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.DRAGGING, (Cursor)dragCursor);
        Image dragHorizontalImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-move-horizontal.gif"));
        ImageCursor dragHorizontalCursor = new ImageCursor(dragHorizontalImage, dragHorizontalImage.getWidth() / 2.0, dragHorizontalImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.DRAGGING_HORIZONTAL, (Cursor)dragHorizontalCursor);
        Image dragVerticalImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-move-vertical.gif"));
        ImageCursor dragVerticalCursor = new ImageCursor(dragVerticalImage, dragVerticalImage.getWidth() / 2.0, dragVerticalImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.DRAGGING_VERTICAL, (Cursor)dragVerticalCursor);
        Image endTimeImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-end-time.gif"));
        ImageCursor endTimeCursor = new ImageCursor(endTimeImage, endTimeImage.getWidth() / 2.0, endTimeImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.END_TIME_CHANGE, (Cursor)endTimeCursor);
        Image startTimeImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-start-time.gif"));
        ImageCursor startTimeCursor = new ImageCursor(startTimeImage, startTimeImage.getWidth() / 2.0, startTimeImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.START_TIME_CHANGE, (Cursor)startTimeCursor);
        Image endTimeAgendaImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-end-time-agenda.gif"));
        ImageCursor endTimeAgendaCursor = new ImageCursor(endTimeAgendaImage, endTimeAgendaImage.getWidth() / 2.0, endTimeAgendaImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.AGENDA_END_TIME_CHANGE, (Cursor)endTimeAgendaCursor);
        Image startTimeAgendaImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-start-time-agenda.gif"));
        ImageCursor startTimeAgendaCursor = new ImageCursor(startTimeAgendaImage, startTimeAgendaImage.getWidth() / 2.0, startTimeAgendaImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.AGENDA_START_TIME_CHANGE, (Cursor)startTimeAgendaCursor);
        Image draggingAgendaImage = new Image(GraphicsBase.class.getResourceAsStream("cursor-move-vertical.gif"));
        ImageCursor draggingAgendaCursor = new ImageCursor(draggingAgendaImage, draggingAgendaImage.getWidth() / 2.0, draggingAgendaImage.getHeight() / 2.0);
        cursorMap.put(GraphicsBase.EditMode.AGENDA_DRAGGING, (Cursor)draggingAgendaCursor);
        editMode = GraphicsBase.EditMode.NONE;
        DRAG_INFO = new DataFormat(new String[]{"FlexGanttFX/dragInfo"});
    }

    class ScrollThread
    extends Thread {
        private boolean running;
        private double xOffset;
        private double yOffset;
        private MouseEvent evt;

        public ScrollThread() {
            super("Autoscrolling Row Canvas");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.running) {
                Platform.runLater(() -> {
                    this.scrollX();
                    this.scrollY();
                });
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollX() {
            TimelineModel<?> model = RowCanvasBehaviour.this.canvas.getTimelineModel();
            Instant targetTime = model.calculateTimeForLocation(this.xOffset);
            Instant oldStartTime = model.getStartTime();
            model.setStartTime(targetTime);
            Instant newStartTime = model.getStartTime();
            if (!oldStartTime.equals(newStartTime)) {
                editStartX = editStartX - this.xOffset;
                RowCanvasBehaviour.this.doMouseDragged(this.evt);
            }
        }

        private void scrollY() {
            VirtualFlow<?> flow = this.getFlow();
            if (flow != null) {
                flow.adjustPixels(this.yOffset);
                RowCanvasBehaviour.this.doMouseDragged(this.evt);
            }
        }

        private VirtualFlow<?> getFlow() {
            return (VirtualFlow)RowCanvasBehaviour.this.canvas.getGraphics().lookup("VirtualFlow");
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double xOffset, double yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public void setMouseEvent(MouseEvent event) {
            this.evt = event;
        }
    }

    public static final class DragInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final GraphicsBase.EditMode editMode;
        private final double xOffset;
        private final boolean shortcutDown;
        private final boolean shiftDown;
        private final boolean altDown;

        private DragInfo(GraphicsBase.EditMode editMode, double xOffset, boolean shortcutDown, boolean shiftDown, boolean altDown) {
            Objects.requireNonNull(editMode);
            this.editMode = editMode;
            this.xOffset = xOffset;
            this.shortcutDown = shortcutDown;
            this.shiftDown = shiftDown;
            this.altDown = altDown;
        }

        public GraphicsBase.EditMode getEditMode() {
            return this.editMode;
        }

        public double getOffset() {
            return this.xOffset;
        }

        public boolean isShortcutDown() {
            return this.shortcutDown;
        }

        public boolean isShiftDown() {
            return this.shiftDown;
        }

        public boolean isAltDown() {
            return this.altDown;
        }
    }
}

