/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.graphics.RowCell;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class ListViewGraphicsSkin<R extends Row<?, ?, ?>>
extends GraphicsBaseSkin<ListViewGraphics<R>, R> {
    private ListView<R> listView;
    private ScrollThread scrollThread;

    public ListViewGraphicsSkin(ListViewGraphics<R> graphics) {
        super(graphics);
        this.listView.skinProperty().addListener((observable, oldValue, newValue) -> this.registerListViewScrollBarListener());
        this.listView.skinProperty().addListener((observable, oldValue, newValue) -> this.getClippedContent().setClip(this.createClip()));
    }

    @Override
    protected Region createRowPaneRegion() {
        ListViewGraphics graphics = (ListViewGraphics)this.getSkinnable();
        this.listView = graphics.getListView();
        this.listView.setSelectionModel(new DisabledSelectionModel());
        this.listView.setCellFactory(listView -> new RowCell(graphics));
        this.listView.fixedCellSizeProperty().bind((ObservableValue)graphics.fixedCellSizeProperty());
        this.listView.placeholderProperty().bind(graphics.placeholderProperty());
        this.listView.setItems(graphics.getRows());
        this.listView.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.listView.addEventFilter(DragEvent.DRAG_EXITED_TARGET, this::stopAutoScrollIfNeeded);
        this.listView.addEventFilter(DragEvent.DRAG_DROPPED, this::stopAutoScrollIfNeeded);
        this.listView.addEventFilter(DragEvent.DRAG_DONE, this::stopAutoScrollIfNeeded);
        return this.listView;
    }

    private Node createClip() {
        Rectangle clip = new Rectangle();
        Region region = this.getClippedContainer();
        if (region != null) {
            clip.widthProperty().bind((ObservableValue)region.widthProperty());
            clip.heightProperty().bind((ObservableValue)region.heightProperty());
        }
        return clip;
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        Region hotRegion = this.getClippedContainer();
        if ((hotRegion == null || hotRegion.getBoundsInLocal().getWidth() < 1.0) && ((hotRegion = this.getSkinnable()) == null || hotRegion.getBoundsInLocal().getWidth() < 1.0)) {
            this.stopAutoScrollIfNeeded(evt);
            return;
        }
        double xOffset = 0.0;
        double yOffset = 0.0;
        double proximity = ((ListViewGraphics)this.getSkinnable()).getAutoscrollProximity();
        double delta = evt.getSceneX() - hotRegion.localToScene(0.0, 0.0).getX();
        if (delta < proximity) {
            xOffset = -(proximity - delta);
        }
        if ((delta = hotRegion.localToScene(0.0, 0.0).getX() + hotRegion.getWidth() - evt.getSceneX()) < proximity) {
            xOffset = proximity - delta;
        }
        if ((delta = evt.getSceneY() - hotRegion.localToScene(0.0, 0.0).getY()) < proximity) {
            yOffset = -(proximity - delta);
        }
        if ((delta = hotRegion.localToScene(0.0, 0.0).getY() + hotRegion.getHeight() - evt.getSceneY()) < proximity) {
            yOffset = proximity - delta;
        }
        if (xOffset != 0.0 || yOffset != 0.0) {
            this.autoscroll(xOffset, yOffset);
        } else {
            this.stopAutoScrollIfNeeded(evt);
        }
    }

    private VirtualFlow<?> getVirtualFlow() {
        return (VirtualFlow)((ListViewGraphics)this.getSkinnable()).lookup("VirtualFlow");
    }

    private Region getClippedContainer() {
        for (Node child : this.getVirtualFlow().getChildrenUnmodifiable()) {
            if (!child.getStyleClass().contains((Object)"clipped-container")) continue;
            return (Region)child;
        }
        return null;
    }

    private void autoscroll(double xOffset, double yOffset) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setDelta(xOffset, yOffset);
    }

    private void stopAutoScrollIfNeeded(DragEvent evt) {
        if (this.scrollThread != null) {
            RowCanvas canvas;
            GraphicsBase sourceGraphics;
            Object source;
            boolean stopAutoScroll = true;
            EventType eventType = evt.getEventType();
            if (eventType.equals(DragEvent.DRAG_EXITED_TARGET) && (source = evt.getGestureSource()) instanceof RowCanvas && ((Object)((Object)(sourceGraphics = (canvas = (RowCanvas)((Object)source)).getGraphics()))).equals(this.getSkinnable())) {
                stopAutoScroll = false;
            }
            if (stopAutoScroll) {
                this.scrollThread.stopRunning();
                this.scrollThread = null;
            }
        }
    }

    @Override
    protected List<Row<?, ?, ?>> findLassoSelectedRows() {
        ArrayList rows = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds lassoBounds = lasso.localToScene(lasso.getBoundsInLocal());
        List<RowCell<R>> cells = this.getVisibleRowCells();
        for (RowCell<R> cell : cells) {
            RowPane<R> pane;
            R row;
            Bounds cellBounds = cell.localToScene(cell.getLayoutBounds());
            if (!cellBounds.intersects(lassoBounds) || (row = (pane = cell.getRowPane()).getRow()) == null) continue;
            rows.add((Row<?, ?, ?>)row);
        }
        return rows;
    }

    @Override
    protected List<ActivityRef<?>> findLassoSelectedActivities() {
        ArrayList selection = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds lassoBounds = lasso.localToScene(lasso.getBoundsInLocal());
        List<RowCell<R>> cells = this.getVisibleRowCells();
        for (RowCell<R> cell : cells) {
            Bounds cellBounds = cell.localToScene(cell.getLayoutBounds());
            if (!cellBounds.intersects(lassoBounds)) continue;
            RowPane<R> pane = cell.getRowPane();
            RowCanvas<R> canvas = pane.getCanvas();
            List<ActivityBounds> selections = canvas.getActivityBounds(lasso.getBoundsInLocal().getMinX(), Math.max(0.0, lassoBounds.getMinY() - cellBounds.getMinY()), lasso.getBoundsInLocal().getWidth(), lasso.getBoundsInLocal().getHeight());
            List refs = selections.stream().map(ActivityBounds::getActivityRef).collect(Collectors.toList());
            selection.addAll(refs);
        }
        return selection;
    }

    @Override
    protected final RowPane<R> getRowPaneAt(double y) {
        Point2D localToScene = ((ListViewGraphics)this.getSkinnable()).localToScene(0.0, y);
        List<RowCell<R>> cells = this.getVisibleRowCells();
        for (RowCell<R> cell : cells) {
            Bounds cellBounds = cell.localToScene(cell.getLayoutBounds());
            if (!(cellBounds.getMinY() <= localToScene.getY()) || !(cellBounds.getMaxY() >= localToScene.getY())) continue;
            return cell.getRowPane();
        }
        return null;
    }

    @Override
    protected boolean isRowAboveViewport(R row) {
        VirtualFlow flow = (VirtualFlow)this.listView.lookup("#virtual-flow");
        RowCell rowCell = (RowCell)flow.getFirstVisibleCell();
        if (rowCell == null) {
            return false;
        }
        Object firstRow = rowCell.getRowPane().getRow();
        return ((ListViewGraphics)this.getSkinnable()).getRows().indexOf(firstRow) > ((ListViewGraphics)this.getSkinnable()).getRows().indexOf(row);
    }

    private List<RowCell<R>> getVisibleRowCells() {
        ArrayList<RowCell<R>> visibleRowCells = new ArrayList<RowCell<R>>();
        VirtualFlow flow = (VirtualFlow)this.listView.lookup("VirtualFlow");
        if (flow != null) {
            RowCell firstCell = (RowCell)flow.getFirstVisibleCell();
            RowCell lastCell = (RowCell)flow.getLastVisibleCell();
            if (firstCell != null && lastCell != null) {
                for (int index = Math.max(0, firstCell.getIndex() - 1); index <= lastCell.getIndex() + 2; ++index) {
                    RowCell cell = (RowCell)flow.getVisibleCell(index);
                    if (cell == null) continue;
                    visibleRowCells.add(cell);
                }
            }
        }
        return visibleRowCells;
    }

    private void registerListViewScrollBarListener() {
        ScrollBar graphicsViewScrollBar = this.findScrollBar((Parent)this.listView, Orientation.VERTICAL);
        if (graphicsViewScrollBar != null) {
            graphicsViewScrollBar.valueProperty().addListener(observable -> ((ListViewGraphics)this.getSkinnable()).layoutLinks());
        }
    }

    private ScrollBar findScrollBar(Parent parent, Orientation orientation) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            ScrollBar b2;
            if (node instanceof ScrollBar && (b2 = (ScrollBar)node).getOrientation().equals((Object)orientation)) {
                return b2;
            }
            if (!(node instanceof Parent) || (b2 = this.findScrollBar((Parent)node, orientation)) == null) continue;
            return b2;
        }
        return null;
    }

    static class DisabledSelectionModel<T>
    extends MultipleSelectionModel<T> {
        DisabledSelectionModel() {
            super.setSelectedIndex(-1);
            super.setSelectedItem(null);
        }

        public ObservableList<Integer> getSelectedIndices() {
            return FXCollections.emptyObservableList();
        }

        public ObservableList<T> getSelectedItems() {
            return FXCollections.emptyObservableList();
        }

        public void selectAll() {
        }

        public void selectFirst() {
        }

        public void selectIndices(int index, int ... indicies) {
        }

        public void selectLast() {
        }

        public void clearAndSelect(int index) {
        }

        public void clearSelection() {
        }

        public void clearSelection(int index) {
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean isSelected(int index) {
            return false;
        }

        public void select(int index) {
        }

        public void select(T item) {
        }

        public void selectNext() {
        }

        public void selectPrevious() {
        }
    }

    class ScrollThread
    extends Thread {
        private boolean running;
        private double xOffset;
        private double yOffset;

        public ScrollThread() {
            super("Autoscrolling List View");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (this.running) {
                Platform.runLater(() -> {
                    this.scrollX();
                    this.scrollY();
                });
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollX() {
            TimelineModel<?> model = ((ListViewGraphics)ListViewGraphicsSkin.this.getSkinnable()).getTimeline().getModel();
            Instant targetTime = model.calculateTimeForLocation(this.xOffset);
            model.setStartTime(targetTime);
        }

        private void scrollY() {
            VirtualFlow flow = ListViewGraphicsSkin.this.getVirtualFlow();
            flow.adjustPixels(this.yOffset);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double xOffset, double yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }
    }
}

