/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.calendar.CalendarActivity;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.LassoEvent;
import com.flexganttfx.view.graphics.layer.ScaleLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.DragCanvas;
import impl.com.flexganttfx.skin.graphics.GridHelper;
import impl.com.flexganttfx.skin.graphics.LinksPane;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.graphics.RowPane;
import impl.com.flexganttfx.skin.util.AgendaHelper;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public abstract class GraphicsBaseSkin<C extends GraphicsBase<R>, R extends Row<?, ?, ?>>
extends SkinBase<C> {
    private final Line verticalCursorLine = new Line();
    private final Line horizontalCursorLine;
    private final Line markedStartTimeLine;
    private final Line markedEndTimeLine;
    private final Region horizontalCursorIndicator;
    private final Cursor lassoCursor;
    private final Rectangle lasso;
    private final LinksPane<R> linksPane;
    private final DragCanvas<R> dragCanvas;
    private final Pane clippedContent;
    private StartLassoThread startLassoThread;
    private Instant lassoStartTime;
    private Instant lassoEndTime;
    private double lassoY1;
    private double lassoY2;
    private boolean lassoStarted;
    private boolean lassoUsed;
    private double mouseStartX;
    private double mouseX;
    private double mouseY;
    private final ChangeListener<Number> cursorLocationListener = (value, oldLocation, newLocation) -> {
        this.verticalCursorLine.setStartX(newLocation.doubleValue());
        this.verticalCursorLine.setStartY(0.0);
        this.verticalCursorLine.setEndX(newLocation.doubleValue());
        this.verticalCursorLine.setEndY(((GraphicsBase)this.getSkinnable()).getHeight());
    };
    private final InvalidationListener markedTimeIntervalListener = it -> this.updateMarkedTimeLines();
    private ContextMenu contextMenu;

    public GraphicsBaseSkin(C graphics) {
        super(graphics);
        Image image = new Image(GraphicsBase.class.getResourceAsStream("cursor-lasso.gif"));
        this.lassoCursor = new ImageCursor(image, image.getWidth() / 2.0, image.getHeight() / 2.0);
        ((GraphicsBase)((Object)graphics)).lassoActiveProperty().addListener(evt -> {
            if (graphics.isLassoActive()) {
                graphics.setCursor(this.lassoCursor);
            } else {
                graphics.setCursor(Cursor.DEFAULT);
            }
        });
        graphics.setFocusTraversable(true);
        graphics.focusedProperty().addListener(evt -> graphics.isFocused());
        EventHandler arrowKeysHandler = event -> {
            Timeline timeline = this.getTimeline();
            switch (event.getCode()) {
                case RIGHT: {
                    if (event.isShiftDown()) {
                        timeline.scrollRightFast();
                    } else {
                        timeline.scrollRight();
                    }
                    event.consume();
                    break;
                }
                case LEFT: {
                    if (event.isShiftDown()) {
                        timeline.scrollLeftFast();
                    } else {
                        timeline.scrollLeft();
                    }
                    event.consume();
                    break;
                }
                case BACK_SPACE: 
                case DELETE: {
                    for (ActivityRef<?> ref : new ArrayList((Collection<ActivityRef<?>>)graphics.getSelectedActivities())) {
                        Object activity = ref.getActivity();
                        Callback<GraphicsBase.EditingCallbackParameter, Boolean> callback = graphics.getActivityEditingCallback(activity.getClass());
                        GraphicsBase.EditingCallbackParameter param = new GraphicsBase.EditingCallbackParameter(ref, GraphicsBase.EditMode.DELETING);
                        if (callback != null && !((Boolean)callback.call((Object)param)).booleanValue()) continue;
                        Row<?, ?, ?> row = ref.getRow();
                        row.removeActivity(ref.getLayer(), ref.getActivity());
                        graphics.getSelectedActivities().remove(ref);
                        graphics.getLinks().removeIf(link -> link.getSourceActivityRef().equals(ref) || link.getTargetActivityRef().equals(ref));
                        graphics.fireEvent((Event)new ActivityEvent(ref, (EventTarget)graphics, ActivityEvent.ACTIVITY_DELETED));
                    }
                    break;
                }
            }
        };
        EventHandler plusMinusKeyHandler = event -> {
            Timeline timeline = this.getTimeline();
            switch (event.getCharacter()) {
                case "-": {
                    timeline.zoomOut();
                    break;
                }
                case "+": {
                    timeline.zoomIn();
                    break;
                }
            }
        };
        graphics.addEventHandler(KeyEvent.KEY_PRESSED, arrowKeysHandler);
        graphics.addEventHandler(KeyEvent.KEY_TYPED, plusMinusKeyHandler);
        this.linksPane = this.createLinksPane();
        this.linksPane.setManaged(false);
        this.dragCanvas = this.createDragCanvas();
        this.dragCanvas.setManaged(false);
        this.verticalCursorLine.getStyleClass().add((Object)"vertical-cursor");
        this.verticalCursorLine.setMouseTransparent(true);
        this.verticalCursorLine.setManaged(false);
        BooleanBinding verticalCursorVisible = Bindings.createBooleanBinding(() -> graphics.getRowsEditing().isEmpty() && graphics.isShowVerticalCursor() && graphics.getPressedActivity() == null && graphics.getTimeline().getEventline().getCursorTime() != null, (Observable[])new Observable[]{((GraphicsBase)((Object)graphics)).getRowsEditing(), ((GraphicsBase)((Object)graphics)).showVerticalCursorProperty(), ((GraphicsBase)((Object)graphics)).pressedActivityProperty(), ((GraphicsBase)((Object)graphics)).getTimeline().getEventline().cursorTimeProperty()});
        this.verticalCursorLine.visibleProperty().bind((ObservableValue)verticalCursorVisible);
        this.horizontalCursorLine = new Line();
        this.horizontalCursorLine.getStyleClass().add((Object)"horizontal-cursor");
        this.horizontalCursorLine.setMouseTransparent(true);
        this.horizontalCursorLine.setManaged(false);
        BooleanBinding horizontalCursorVisible = Bindings.createBooleanBinding(() -> graphics.getHoverLayout() != null && graphics.getHoverLayout().isSupportingHorizontalCursorLine() && graphics.isShowScaleLayer() && graphics.isShowHorizontalCursor() && graphics.getRowsEditing().isEmpty() && graphics.getPressedActivity() == null && graphics.isHover(), (Observable[])new Observable[]{((GraphicsBase)((Object)graphics)).hoverLayoutProperty(), ((GraphicsBase)((Object)graphics)).showScaleLayerProperty(), ((GraphicsBase)((Object)graphics)).showHorizontalCursorProperty(), ((GraphicsBase)((Object)graphics)).pressedActivityProperty(), ((GraphicsBase)((Object)graphics)).getRowsEditing(), graphics.hoverProperty()});
        this.horizontalCursorLine.visibleProperty().bind((ObservableValue)horizontalCursorVisible);
        this.horizontalCursorIndicator = new Region();
        this.horizontalCursorIndicator.getStyleClass().add((Object)"horizontal-cursor-indicator");
        this.horizontalCursorIndicator.setMouseTransparent(true);
        this.horizontalCursorIndicator.setManaged(false);
        this.horizontalCursorIndicator.visibleProperty().bind((ObservableValue)horizontalCursorVisible);
        this.markedStartTimeLine = new Line();
        this.markedStartTimeLine.setManaged(false);
        this.markedStartTimeLine.setStartY(0.0);
        this.markedStartTimeLine.endYProperty().bind((ObservableValue)((GraphicsBase)this.getSkinnable()).heightProperty());
        this.markedStartTimeLine.setMouseTransparent(true);
        this.markedStartTimeLine.getStyleClass().addAll((Object[])new String[]{"marked-time-line", "marked-start-time-line"});
        this.markedEndTimeLine = new Line();
        this.markedEndTimeLine.setManaged(false);
        this.markedEndTimeLine.setStartY(0.0);
        this.markedEndTimeLine.endYProperty().bind((ObservableValue)((GraphicsBase)this.getSkinnable()).heightProperty());
        this.markedEndTimeLine.setMouseTransparent(true);
        this.markedEndTimeLine.getStyleClass().addAll((Object[])new String[]{"marked-time-line", "marked-end-time-line"});
        this.lasso = new Rectangle();
        this.lasso.setMouseTransparent(true);
        this.lasso.setManaged(false);
        this.lasso.getStyleClass().add((Object)"activities-lasso");
        Region region = this.createRowPaneRegion();
        this.getChildren().add((Object)region);
        this.clippedContent = new Pane(new Node[]{this.linksPane, this.horizontalCursorLine, this.horizontalCursorIndicator, this.verticalCursorLine, this.lasso, this.markedStartTimeLine, this.markedEndTimeLine, this.dragCanvas});
        this.clippedContent.getStyleClass().add((Object)"clipped-content");
        this.clippedContent.setMouseTransparent(true);
        this.getChildren().add((Object)this.clippedContent);
        this.registerNodeListeners(region);
        ((GraphicsBase)((Object)graphics)).timelineProperty().addListener((observable, oldTimeline, newTimeline) -> {
            if (oldTimeline != null) {
                Eventline eventline1 = oldTimeline.getEventline();
                eventline1.cursorLocationProperty().removeListener(this.cursorLocationListener);
                eventline1.markedTimeIntervalProperty().removeListener(this.markedTimeIntervalListener);
                this.markedStartTimeLine.visibleProperty().unbind();
                this.markedEndTimeLine.visibleProperty().unbind();
            }
            if (newTimeline != null) {
                Eventline eventline2 = newTimeline.getEventline();
                eventline2.cursorLocationProperty().addListener(this.cursorLocationListener);
                eventline2.markedTimeIntervalProperty().addListener(this.markedTimeIntervalListener);
                this.markedStartTimeLine.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)graphics.showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline2.markedTimeIntervalProperty())));
                this.markedEndTimeLine.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)graphics.showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline2.markedTimeIntervalProperty())));
            }
        });
        if (((GraphicsBase)((Object)graphics)).getTimeline() != null) {
            Eventline eventline = ((GraphicsBase)((Object)graphics)).getTimeline().getEventline();
            eventline.cursorLocationProperty().addListener(this.cursorLocationListener);
            eventline.markedTimeIntervalProperty().addListener(this.markedTimeIntervalListener);
            this.markedStartTimeLine.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)((GraphicsBase)((Object)graphics)).showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline.markedTimeIntervalProperty())));
            this.markedEndTimeLine.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)((GraphicsBase)((Object)graphics)).showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline.markedTimeIntervalProperty())));
        }
        this.updateMarkedTimeLines();
    }

    protected Node getClippedContent() {
        return this.clippedContent;
    }

    protected DragCanvas<R> createDragCanvas() {
        return new DragCanvas((GraphicsBase)this.getSkinnable());
    }

    protected LinksPane<R> createLinksPane() {
        return new LinksPane((GraphicsBase)this.getSkinnable());
    }

    public final DragCanvas<R> getDragCanvas() {
        return this.dragCanvas;
    }

    protected final Rectangle getLasso() {
        return this.lasso;
    }

    protected final LinksPane<R> getLinksPane() {
        return this.linksPane;
    }

    protected abstract Region createRowPaneRegion();

    protected abstract List<Row<?, ?, ?>> findLassoSelectedRows();

    protected abstract List<ActivityRef<?>> findLassoSelectedActivities();

    private void performSelection() {
        if (this.lassoStartTime == null || this.lassoEndTime == null) {
            return;
        }
        GraphicsBase view = (GraphicsBase)this.getSkinnable();
        switch (view.getSelectionMode()) {
            case MULTIPLE: {
                break;
            }
            case SINGLE: {
                view.getSelectedActivities().clear();
                break;
            }
            case NONE: {
                return;
            }
        }
        List<ActivityRef<ActivityRef<?>>> selection = this.findLassoSelectedActivities();
        selection.removeAll((Collection<?>)view.getSelectedActivities());
        view.getSelectedActivities().addAll(selection);
    }

    protected final LassoEvent.LassoInfo createLassoInfo(MouseEvent evt) {
        LocalTime localStartTime = this.getLocalTimeAt(Math.min(this.lassoY1, this.lassoY2));
        LocalTime localEndTime = this.getLocalTimeAt(Math.max(this.lassoY1, this.lassoY2));
        VirtualGrid<?> grid = ((GraphicsBase)this.getSkinnable()).getVirtualGrid();
        if (grid != null) {
            if (localStartTime != null) {
                localStartTime = grid.adjustTime(localStartTime, false);
            }
            if (localEndTime != null) {
                localEndTime = grid.adjustTime(localEndTime, true);
            }
        }
        List<Row<?, ?, ?>> rows = this.findLassoSelectedRows();
        List<ActivityRef<?>> activities = this.findLassoSelectedActivities();
        if (this.lassoStartTime.isBefore(this.lassoEndTime)) {
            return new LassoEvent.LassoInfo(evt, this.lassoStartTime, this.lassoEndTime, localStartTime, localEndTime, rows, activities);
        }
        return new LassoEvent.LassoInfo(evt, this.lassoEndTime, this.lassoStartTime, localStartTime, localEndTime, rows, activities);
    }

    protected final RowPane<R> getRowPane(ActivityRef<?> ref) {
        for (RowPane pane : ((GraphicsBase)this.getSkinnable()).getRowPanes()) {
            if (pane.getRow() == null || !((Row)pane.getRow()).isShowing() || pane.getRow() != ref.getRow()) continue;
            return pane;
        }
        return null;
    }

    protected final RowCanvas<R> getRowCanvas(ActivityRef<?> ref) {
        RowPane<R> rowPane = this.getRowPane(ref);
        if (rowPane != null) {
            return rowPane.getCanvas();
        }
        return null;
    }

    protected final Rectangle2D getActivityBounds(ActivityRef<?> ref) {
        RowCanvas<R> canvas = this.getRowCanvas(ref);
        double x = 0.0;
        double y = 0.0;
        double w = 0.0;
        double h = 0.0;
        if (canvas != null) {
            ActivityBounds activityBounds = canvas.getActivityBounds(ref);
            if (activityBounds != null) {
                Point2D graphicsBounds = ((GraphicsBase)this.getSkinnable()).localToScene(0.0, 0.0);
                Bounds canvasBounds = canvas.localToScene(canvas.getLayoutBounds());
                double transY = canvasBounds.getMinY() - graphicsBounds.getY();
                x = activityBounds.getMinX();
                y = activityBounds.getMinY() + transY;
                w = activityBounds.getWidth();
                h = activityBounds.getHeight();
            }
        } else {
            Row<?, ?, ?> row = ref.getRow();
            y = this.isRowAboveViewport(row) ? -100.0 : ((GraphicsBase)this.getSkinnable()).getHeight() + 100.0;
            TimelineModel<?> timelineModel = this.getTimeline().getModel();
            double x1 = timelineModel.calculateLocationForTime(ref.getActivity().getStartTime());
            double x2 = timelineModel.calculateLocationForTime(ref.getActivity().getEndTime());
            x = x1;
            w = x2 - x1;
            h = row.getHeight();
        }
        return new Rectangle2D(x, y, w, h);
    }

    public final ActivityBounds getActivityBoundsAt(double x, double y) {
        Point2D localToScene = ((GraphicsBase)this.getSkinnable()).localToScene(x, y);
        RowCanvas<R> canvas = this.getRowCanvasAt(y);
        if (canvas != null) {
            Bounds canvasBounds = canvas.localToScene(canvas.getLayoutBounds());
            return canvas.getActivityBounds(localToScene.getX() - canvasBounds.getMinX(), localToScene.getY() - canvasBounds.getMinY());
        }
        return null;
    }

    public final ActivityRef<?> getActivityRefAt(double x, double y) {
        ActivityBounds bounds = this.getActivityBoundsAt(x, y);
        if (bounds != null) {
            return bounds.getActivityRef();
        }
        return null;
    }

    public final List<ActivityBounds> getAllActivityBoundsAt(double x, double y) {
        Point2D localToScene = ((GraphicsBase)this.getSkinnable()).localToScene(x, y);
        RowCanvas<R> canvas = this.getRowCanvasAt(y);
        if (canvas != null) {
            Bounds canvasBounds = canvas.localToScene(canvas.getLayoutBounds());
            return canvas.getAllActivityBounds(localToScene.getX() - canvasBounds.getMinX(), localToScene.getY() - canvasBounds.getMinY());
        }
        return Collections.emptyList();
    }

    public final List<ActivityRef<?>> getAllActivityRefsAt(double x, double y) {
        ArrayList result = new ArrayList();
        List<ActivityBounds> bounds = this.getAllActivityBoundsAt(x, y);
        result.addAll(bounds.stream().map(ActivityBounds::getActivityRef).collect(Collectors.toList()));
        return result;
    }

    public final List<CalendarActivity> getAllCalendarActivitiesAt(double x, double y) {
        ArrayList<CalendarActivity> result = new ArrayList<CalendarActivity>();
        Instant time = ((GraphicsBase)this.getSkinnable()).getTimeAt(x);
        Dateline dateline = ((GraphicsBase)this.getSkinnable()).getTimeline().getDateline();
        TemporalUnit unit = dateline.getPrimaryTemporalUnit();
        ZoneId zoneId = dateline.getZoneId();
        this.addCalendarEntries((List<CalendarActivity>)result, (List<Calendar<?>>)((GraphicsBase)this.getSkinnable()).getCalendars(), time, unit, zoneId);
        R row = this.getRowAt(y);
        if (row != null) {
            this.addCalendarEntries((List<CalendarActivity>)result, (List<Calendar<?>>)((Row)row).getCalendars(), time, unit, ((Row)row).getZoneId());
        }
        return result;
    }

    private void addCalendarEntries(List<CalendarActivity> result, List<Calendar<?>> calendars, Instant time, TemporalUnit unit, ZoneId zoneId) {
        for (Calendar<?> calendar : calendars) {
            Iterator activities = calendar.getActivities(null, time, time, unit, zoneId);
            if (activities == null) continue;
            while (activities.hasNext()) {
                result.add((CalendarActivity)activities.next());
            }
        }
    }

    public final R getRowAt(double y) {
        RowPane<R> pane = this.getRowPaneAt(y);
        if (pane != null) {
            return pane.getRow();
        }
        return null;
    }

    protected abstract RowPane<R> getRowPaneAt(double var1);

    protected abstract boolean isRowAboveViewport(R var1);

    protected final RowCanvas<R> getRowCanvasAt(double y) {
        RowPane<R> pane = this.getRowPaneAt(y);
        if (pane != null) {
            return pane.getCanvas();
        }
        return null;
    }

    public final Layout getLayoutAt(double y) {
        Point2D localToScene = ((GraphicsBase)this.getSkinnable()).localToScene(0.0, y);
        RowCanvas<R> canvas = this.getRowCanvasAt(y);
        if (canvas != null) {
            Bounds canvasBounds = canvas.localToScene(canvas.getLayoutBounds());
            return canvas.getLayoutAt(localToScene.getY() - canvasBounds.getMinY());
        }
        return null;
    }

    protected final Rectangle2D getLayoutBoundsAt(double y) {
        Point2D localToScene = ((GraphicsBase)this.getSkinnable()).localToScene(0.0, y);
        RowCanvas<R> canvas = this.getRowCanvasAt(y);
        if (canvas != null) {
            Bounds canvasBounds = canvas.localToScene(canvas.getLayoutBounds());
            return canvas.getLayoutBoundsAt(localToScene.getY() - canvasBounds.getMinY());
        }
        return null;
    }

    public final LocalTime getLocalTimeAt(double y) {
        Layout layout = this.getLayoutAt(y);
        Rectangle2D layoutBounds = this.getLayoutBoundsAt(y);
        if (layout instanceof AgendaLayout && layoutBounds != null) {
            AgendaLayout agendaLayout = (AgendaLayout)layout;
            RowCanvas<R> canvas = this.getRowCanvasAt(y);
            if (canvas != null) {
                Bounds graphicsViewBounds = ((GraphicsBase)this.getSkinnable()).localToScreen(((GraphicsBase)this.getSkinnable()).getBoundsInLocal());
                Bounds canvasBounds = canvas.localToScreen(canvas.getBoundsInLocal());
                double padding = layout.getPadding();
                double offset = canvasBounds.getMinY() - graphicsViewBounds.getMinY() + layoutBounds.getMinY() + padding;
                double agendaY = Math.min(layoutBounds.getHeight(), Math.max(0.0, y - offset));
                return AgendaHelper.getTimeAt(agendaY, layoutBounds.getHeight() - 2.0 * padding, agendaLayout.getStartTime(), agendaLayout.getEndTime());
            }
        }
        return null;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        this.linksPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        this.dragCanvas.setWidth(contentWidth);
        this.dragCanvas.setHeight(contentHeight);
        this.lasso.setVisible(false);
        if (this.lassoStarted && this.lassoStartTime != null && this.lassoEndTime != null) {
            Timeline timeline = this.getTimeline();
            TimelineModel<?> model = timeline.getModel();
            double x1 = model.calculateLocationForTime(this.lassoStartTime);
            double x2 = model.calculateLocationForTime(this.lassoEndTime);
            this.lasso.setX(Math.min(x1, x2));
            this.lasso.setY(Math.min(this.lassoY1, this.lassoY2));
            this.lasso.setWidth(Math.max(x2, x1) - Math.min(x1, x2));
            this.lasso.setHeight(Math.max(this.lassoY1, this.lassoY2) - Math.min(this.lassoY1, this.lassoY2));
            this.lasso.setVisible(true);
            if (this.lassoStartTime.isBefore(this.lassoEndTime)) {
                this.getTimeline().getEventline().setMarkedTimeInterval(new TimeInterval(this.lassoStartTime, this.lassoEndTime));
            } else {
                this.getTimeline().getEventline().setMarkedTimeInterval(new TimeInterval(this.lassoEndTime, this.lassoStartTime));
            }
        }
    }

    final void registerNodeListeners(Region node) {
        node.addEventHandler(MouseEvent.ANY, evt -> {
            this.mouseX = evt.getX();
            this.mouseY = evt.getY();
        });
        node.addEventHandler(ScrollEvent.SCROLL, evt -> {
            double deltaX = evt.getDeltaX();
            if (deltaX != 0.0) {
                TimelineModel<?> timelineModel = this.getTimeline().getModel();
                Instant time = timelineModel.calculateTimeForLocation(-deltaX);
                timelineModel.setStartTime(time);
            }
        });
        node.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this::showContextMenu);
        EventHandler updateHorizontalCursor = evt -> {
            ScaleLayer layer;
            this.horizontalCursorLine.setStartX(0.0);
            this.horizontalCursorLine.setEndX(((GraphicsBase)this.getSkinnable()).getWidth());
            this.horizontalCursorLine.setStartY(evt.getY());
            this.horizontalCursorLine.setEndY(evt.getY());
            this.horizontalCursorLine.setStartX(0.0);
            GraphicsBase graphicsView = (GraphicsBase)this.getSkinnable();
            if (graphicsView.isShowScaleLayer() && (layer = graphicsView.getSystemLayer(ScaleLayer.class)) != null) {
                double prefWidth = this.horizontalCursorIndicator.prefWidth(-1.0);
                double prefHeight = this.horizontalCursorIndicator.prefHeight(-1.0);
                this.horizontalCursorIndicator.resizeRelocate(layer.getScaleWidth() - prefWidth - 2.0, evt.getY() - prefHeight / 2.0, prefWidth, prefHeight);
                this.horizontalCursorLine.setStartX(layer.getPrefWidth());
            }
        };
        node.addEventHandler(MouseEvent.MOUSE_MOVED, updateHorizontalCursor);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, updateHorizontalCursor);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, evt -> this.updateCursorLocation(-1.0));
        node.addEventHandler(MouseEvent.MOUSE_MOVED, evt -> this.updateCursorLocation(evt.getX()));
        node.addEventHandler(MouseEvent.MOUSE_EXITED, evt -> {
            this.updateCursorLocation(-1.0);
            ((GraphicsBase)this.getSkinnable()).getProperties().put((Object)"com.flexganttfx.hover.activity", null);
            ((GraphicsBase)this.getSkinnable()).getProperties().put((Object)"com.flexganttfx.hover.row", null);
            ((GraphicsBase)this.getSkinnable()).getProperties().put((Object)"com.flexganttfx.hover.layout", null);
        });
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, evt -> {
            if (this.contextMenu != null && this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
            ((GraphicsBase)this.getSkinnable()).requestFocus();
            Timeline timeline = this.getTimeline();
            if (evt.isPrimaryButtonDown()) {
                timeline.getDateline().getSelectedIntervals().clear();
            }
            this.mouseStartX = evt.getScreenX();
            if (evt.isShiftDown()) {
                if (((GraphicsBase)this.getSkinnable()).getEditMode().equals((Object)GraphicsBase.EditMode.NONE) && ((GraphicsBase)this.getSkinnable()).getHoverActivity() == null) {
                    this.lassoStarted = false;
                    this.startLasso((MouseEvent)evt);
                }
            } else {
                this.lassoStarted = false;
                this.startLassoThread = new StartLassoThread((MouseEvent)evt);
                this.startLassoThread.start();
            }
        });
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, evt -> {
            if (this.lassoStarted) {
                this.stopLasso((MouseEvent)evt);
            }
            if (this.startLassoThread != null) {
                this.startLassoThread.cancel();
                this.startLassoThread = null;
            }
            this.updateCursorLocation(evt.getX());
            this.mouseStartX = evt.getScreenX();
        });
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, evt -> {
            if (evt.isConsumed()) {
                return;
            }
            Timeline timeline = this.getTimeline();
            TimelineModel<?> timelineModel = timeline.getModel();
            if (((GraphicsBase)this.getSkinnable()).isLassoActive()) {
                this.lassoEndTime = timelineModel.calculateTimeForLocation(evt.getX());
                if (((GraphicsBase)this.getSkinnable()).isLassoSnapsToGrid()) {
                    this.lassoEndTime = GridHelper.grid((GraphicsBase)this.getSkinnable(), this.lassoEndTime);
                }
                if (this.lassoStartTime == null) {
                    this.lassoStartTime = this.lassoEndTime;
                }
                this.lassoY2 = evt.getY();
                if (Math.abs(this.lassoY2 - this.lassoY1) > 5.0) {
                    this.lassoUsed = true;
                }
                GraphicsBase graphics = (GraphicsBase)this.getSkinnable();
                LassoEvent.LassoInfo info = this.createLassoInfo((MouseEvent)evt);
                LassoEvent event = new LassoEvent(graphics, LassoEvent.SELECTION_ONGOING, info);
                ((GraphicsBase)this.getSkinnable()).fireEvent((Event)event);
                ((GraphicsBase)this.getSkinnable()).requestLayout();
            } else if (((GraphicsBase)this.getSkinnable()).getEditMode().equals((Object)GraphicsBase.EditMode.NONE) && ((GraphicsBase)this.getSkinnable()).isHorizontalDragEnabled()) {
                double scrollX;
                double deltaX;
                Instant newStartTime;
                if (LoggingDomain.NAVIGATION.isLoggable(Level.FINE)) {
                    LoggingDomain.NAVIGATION.fine("scrolling");
                }
                if ((newStartTime = timelineModel.calculateTimeForLocation(deltaX = this.mouseStartX - (scrollX = evt.getScreenX()))).equals(timelineModel.getStartTime())) {
                    newStartTime = deltaX > 0.0 ? newStartTime.plusMillis(1L) : newStartTime.minusMillis(1L);
                }
                timelineModel.setStartTime(newStartTime);
                this.mouseStartX = scrollX;
            }
        });
        node.widthProperty().addListener((value, oldNumber, newNumber) -> ((GraphicsBase)this.getSkinnable()).redraw());
        node.heightProperty().addListener((value, oldHeight, newHeight) -> {
            this.verticalCursorLine.setEndY(newHeight.doubleValue());
            ((GraphicsBase)this.getSkinnable()).redraw();
        });
    }

    private void updateCursorLocation(double location) {
        this.getTimeline().getEventline().getProperties().put((Object)"com.flexganttfx.eventline.cursor.location", (Object)location);
    }

    private void startLasso(MouseEvent evt) {
        GraphicsBase graphics = (GraphicsBase)this.getSkinnable();
        if (!graphics.isLassoEnabled()) {
            return;
        }
        ObservableMap properties = graphics.getProperties();
        properties.put((Object)"com.flexganttfx.currenteditmode", (Object)GraphicsBase.EditMode.NONE);
        properties.put((Object)"com.flexganttfx.lassoActive", (Object)true);
        properties.put((Object)"com.flexganttfx.hover.activity", null);
        properties.put((Object)"com.flexganttfx.hover.row", null);
        properties.put((Object)"com.flexganttfx.hover.layout", null);
        this.lassoStarted = true;
        this.lassoUsed = false;
        this.lassoY1 = evt.getY();
        this.lassoY2 = evt.getY();
        Timeline timeline = this.getTimeline();
        TimelineModel<?> model = timeline.getModel();
        this.lassoStartTime = model.calculateTimeForLocation(evt.getX());
        if (graphics.isLassoSnapsToGrid()) {
            this.lassoStartTime = GridHelper.grid(graphics, this.lassoStartTime);
        }
        this.lassoEndTime = this.lassoStartTime;
        LassoEvent.LassoInfo info = this.createLassoInfo(evt);
        LassoEvent event = new LassoEvent(graphics, LassoEvent.SELECTION_STARTED, info);
        graphics.fireEvent((Event)event);
    }

    private void stopLasso(MouseEvent evt) {
        if (this.lassoUsed) {
            this.performSelection();
            this.lassoUsed = false;
        }
        this.lassoStarted = false;
        LassoEvent.LassoInfo info = this.createLassoInfo(evt);
        LassoEvent lassoEvent = new LassoEvent((GraphicsBase)this.getSkinnable(), LassoEvent.SELECTION_FINISHED, info);
        ((GraphicsBase)this.getSkinnable()).fireEvent((Event)lassoEvent);
        ((GraphicsBase)this.getSkinnable()).getProperties().put((Object)"com.flexganttfx.lassoActive", (Object)false);
        if (((GraphicsBase)this.getSkinnable()).getRows().isEmpty()) {
            this.getTimeline().getEventline().setMarkedTimeInterval(null);
        }
        ((GraphicsBase)this.getSkinnable()).requestLayout();
    }

    private void updateMarkedTimeLines() {
        Timeline timeline = ((GraphicsBase)this.getSkinnable()).getTimeline();
        Eventline eventline = timeline.getEventline();
        TimeInterval newInterval = eventline.getMarkedTimeInterval();
        TimelineModel<?> model = timeline.getModel();
        if (newInterval != null) {
            double x1 = model.calculateLocationForTime(newInterval.getStartTime());
            double x2 = model.calculateLocationForTime(newInterval.getEndTime());
            this.markedStartTimeLine.setStartX(x1);
            this.markedStartTimeLine.setEndX(x1);
            this.markedEndTimeLine.setStartX(x2);
            this.markedEndTimeLine.setEndX(x2);
        }
    }

    protected final Timeline getTimeline() {
        return ((GraphicsBase)this.getSkinnable()).getTimeline();
    }

    private void showContextMenu(ContextMenuEvent evt) {
        Callback factory;
        if (((GraphicsBase)this.getSkinnable()).getContextMenu() != null) {
            return;
        }
        if (this.contextMenu != null && this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
        if ((factory = ((GraphicsBase)this.getSkinnable()).getContextMenuCallback()) != null) {
            RowCanvas rowPane = null;
            Object row = null;
            EventTarget target = evt.getTarget();
            if (target instanceof RowCanvas) {
                rowPane = (RowCanvas)target;
                row = rowPane.getRow();
            }
            Layout layout = this.getLayoutAt(evt.getY());
            LocalTime localTime = this.getLocalTimeAt(evt.getY());
            Instant time = ((GraphicsBase)this.getSkinnable()).getTimeAt(evt.getX());
            GraphicsBase.ContextMenuParameter<Object> input = new GraphicsBase.ContextMenuParameter<Object>((GraphicsBase)this.getSkinnable(), row, this.getAllActivityRefsAt(evt.getX(), evt.getY()), layout, time, localTime);
            this.contextMenu = (ContextMenu)factory.call(input);
            if (this.contextMenu != null) {
                this.contextMenu.show((Node)rowPane, evt.getScreenX(), evt.getScreenY());
            }
        }
    }

    static class DisabledSelectionModel<T>
    extends MultipleSelectionModel<T> {
        DisabledSelectionModel() {
            super.setSelectedIndex(-1);
            super.setSelectedItem(null);
        }

        public ObservableList<Integer> getSelectedIndices() {
            return FXCollections.emptyObservableList();
        }

        public ObservableList<T> getSelectedItems() {
            return FXCollections.emptyObservableList();
        }

        public void selectAll() {
        }

        public void selectFirst() {
        }

        public void selectIndices(int index, int ... indicies) {
        }

        public void selectLast() {
        }

        public void clearAndSelect(int index) {
        }

        public void clearSelection() {
        }

        public void clearSelection(int index) {
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean isSelected(int index) {
            return false;
        }

        public void select(int index) {
        }

        public void select(T item) {
        }

        public void selectNext() {
        }

        public void selectPrevious() {
        }
    }

    class StartLassoThread
    extends Thread {
        private boolean cancelled;
        private final MouseEvent mouseEvent;

        public StartLassoThread(MouseEvent evt) {
            this.mouseEvent = evt;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.cancelled && this.mouseEvent.getX() == GraphicsBaseSkin.this.mouseX && this.mouseEvent.getY() == GraphicsBaseSkin.this.mouseY) {
                Platform.runLater(() -> GraphicsBaseSkin.this.startLasso(this.mouseEvent));
            }
        }
    }
}

