/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.util.RowHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import impl.com.flexganttfx.skin.GanttChartBaseSkin;
import impl.com.flexganttfx.skin.treetable.GanttChartTreeItem;
import impl.com.flexganttfx.skin.treetable.GanttChartTreeTableRow;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import org.controlsfx.control.HiddenSidesPane;
import org.controlsfx.control.MasterDetailPane;

public class GanttChartSkin<R extends Row<?, ?, ?>>
extends GanttChartBaseSkin<R, GanttChart<R>> {
    private final TreeTableView<R> treeTable;
    private final ScrollBar treeTableScrollBar;
    private final MasterDetailPane treeTableMasterDetailPane;
    private final MasterDetailPane graphicsMasterDetailPane;
    private final Node detailNode;
    private final RowHeader<R> rowHeader;
    private final HiddenSidesPane leftHandSide;
    private final HiddenSidesPane rightHandSide;

    public GanttChartSkin(GanttChart<R> ganttChart) {
        super(ganttChart);
        this.treeTable = ganttChart.getTreeTable();
        this.treeTable.getStylesheets().add((Object)GanttChart.class.getResource("gantt.css").toExternalForm());
        this.treeTable.fixedCellSizeProperty().bind((ObservableValue)ganttChart.fixedCellSizeProperty());
        this.treeTable.setTableMenuButtonVisible(false);
        this.treeTable.setRowFactory(view -> new GanttChartTreeTableRow());
        this.treeTable.showRootProperty().addListener(it -> this.updateListRows());
        ganttChart.rootProperty().addListener(observable -> this.updateRoot());
        this.rowHeader = ganttChart.getRowHeader();
        ListViewGraphics graphics = ganttChart.getGraphics();
        this.treeTableMasterDetailPane = ganttChart.getTreeTableMasterDetailPane();
        this.graphicsMasterDetailPane = ganttChart.getGraphicsMasterDetailPane();
        this.treeTableScrollBar = ganttChart.getTreeTableScrollBar();
        this.detailNode = ganttChart.getDetail();
        this.treeTable.setMinWidth(0.0);
        graphics.setMinSize(0.0, 0.0);
        this.treeTableScrollBar.setMinWidth(0.0);
        this.treeTable.skinProperty().addListener((oldSkin, skin, newSkin) -> {
            this.bindHorizontalReplacementWithBuiltInHorizontalTreeTableScrollBar();
            ((GanttChart)this.getSkinnable()).requestLayout();
        });
        this.rightHandSide = super.getHiddenSidesPane();
        this.leftHandSide = new HiddenSidesPane();
        this.leftHandSide.setContent((Node)this.treeTable);
        this.leftHandSide.setBottom((Node)this.treeTableScrollBar);
        SplitPane.setResizableWithParent((Node)this.leftHandSide, (Boolean)false);
        SplitPane.setResizableWithParent((Node)this.detailNode, (Boolean)false);
        this.applyLayout();
        ((GanttChart)this.getSkinnable()).displayModeProperty().addListener(evt -> this.applyLayout());
        this.treeTable.getColumns().addListener(e -> this.updateColumns());
        this.updateRoot();
        this.updateColumns();
        this.bindVerticalListViewScrollBarWithVerticalTreeTableScrollBar();
        graphics.getListView().skinProperty().addListener((observable, oldValue, newValue) -> this.bindVerticalListViewScrollBarWithVerticalTreeTableScrollBar());
    }

    public HiddenSidesPane getRightHandSide() {
        return this.rightHandSide;
    }

    public HiddenSidesPane getLeftHandSide() {
        return this.leftHandSide;
    }

    private void applyLayout() {
        this.getChildren().clear();
        switch (((GanttChart)this.getSkinnable()).getDisplayMode()) {
            case STANDARD: {
                this.applyLayoutStandard();
                break;
            }
            case GRAPHICS_ONLY: {
                this.applyLayoutGraphicsOnly();
                break;
            }
            case TABLE_ONLY: {
                this.applyLayoutTableOnly();
            }
        }
    }

    private void applyLayoutTableOnly() {
        this.graphicsMasterDetailPane.setDetailNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)this.leftHandSide);
        this.graphicsMasterDetailPane.setDetailNode(this.detailNode);
        this.getChildren().add((Object)this.graphicsMasterDetailPane);
    }

    private void applyLayoutGraphicsOnly() {
        this.graphicsMasterDetailPane.setDetailNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)this.rightHandSide);
        this.graphicsMasterDetailPane.setDetailNode(this.detailNode);
        this.getChildren().add((Object)this.graphicsMasterDetailPane);
    }

    private void applyLayoutStandard() {
        this.treeTableMasterDetailPane.setDetailNode((Node)new Label("Placeholder"));
        this.treeTableMasterDetailPane.setMasterNode((Node)new Label("Placeholder"));
        this.treeTableMasterDetailPane.setDetailNode((Node)this.leftHandSide);
        this.treeTableMasterDetailPane.setMasterNode((Node)this.rightHandSide);
        this.graphicsMasterDetailPane.setDetailNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)new Label("Placeholder"));
        this.graphicsMasterDetailPane.setMasterNode((Node)this.treeTableMasterDetailPane);
        this.graphicsMasterDetailPane.setDetailNode(this.detailNode);
        this.getChildren().add((Object)this.graphicsMasterDetailPane);
    }

    private void updateRoot() {
        Object root = ((GanttChart)this.getSkinnable()).getRoot();
        if (root != null) {
            GanttChartTreeItem treeItem = new GanttChartTreeItem(root);
            treeItem.filterProperty().bind(((GanttChart)this.getSkinnable()).rowFilterProperty());
            this.treeTable.setRoot(treeItem);
            this.updateListRows();
            treeItem.addEventHandler(TreeItem.treeNotificationEvent(), this::updateListRows);
        }
    }

    private void updateListRows(TreeItem.TreeModificationEvent<Object> evt) {
        LoggingDomain.EDITING.fine("updating list rows after tree modification event: " + evt);
        this.updateListRows();
    }

    private void updateListRows() {
        this.doUpdateListRows();
    }

    private void doUpdateListRows() {
        ArrayList list = new ArrayList();
        if (this.treeTable.getRoot() != null) {
            if (this.treeTable.isShowRoot()) {
                this.doUpdateListRows(this.treeTable.getRoot(), list);
            } else {
                for (TreeItem child : this.treeTable.getRoot().getChildren()) {
                    this.doUpdateListRows(child, list);
                }
            }
        }
        ((GanttChart)this.getSkinnable()).getGraphics().getRows().setAll(list);
    }

    private void doUpdateListRows(TreeItem<R> item, List<R> list) {
        list.add(item.getValue());
        if (!item.isLeaf() && item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                this.doUpdateListRows(child, list);
            }
        }
    }

    private void updateColumns() {
        ObservableList columns = this.treeTable.getColumns();
        if (!columns.contains(this.rowHeader)) {
            if (columns.size() == 0) {
                this.treeTable.getColumns().add(this.rowHeader);
            } else {
                this.treeTable.getColumns().add(0, this.rowHeader);
            }
        }
    }

    private void bindHorizontalReplacementWithBuiltInHorizontalTreeTableScrollBar() {
        ScrollBar builtInScrollBar = this.findScrollBar((Parent)this.treeTable, Orientation.HORIZONTAL);
        if (builtInScrollBar != null && this.treeTableScrollBar != null) {
            Bindings.bindBidirectional((Property)builtInScrollBar.valueProperty(), (Property)this.treeTableScrollBar.valueProperty());
            Bindings.bindBidirectional((Property)builtInScrollBar.visibleAmountProperty(), (Property)this.treeTableScrollBar.visibleAmountProperty());
            Bindings.bindBidirectional((Property)builtInScrollBar.blockIncrementProperty(), (Property)this.treeTableScrollBar.blockIncrementProperty());
            Bindings.bindBidirectional((Property)builtInScrollBar.unitIncrementProperty(), (Property)this.treeTableScrollBar.unitIncrementProperty());
            Bindings.bindBidirectional((Property)builtInScrollBar.minProperty(), (Property)this.treeTableScrollBar.minProperty());
            Bindings.bindBidirectional((Property)builtInScrollBar.maxProperty(), (Property)this.treeTableScrollBar.maxProperty());
            if (!builtInScrollBar.isVisible()) {
                this.disableTreeTableScrollBar();
            }
            builtInScrollBar.visibleProperty().addListener((value, oldVisible, newVisible) -> {
                if (newVisible.equals(Boolean.FALSE)) {
                    this.disableTreeTableScrollBar();
                }
            });
        }
    }

    private void disableTreeTableScrollBar() {
        this.treeTableScrollBar.setMin(0.0);
        this.treeTableScrollBar.setMax(0.0);
        this.treeTableScrollBar.setValue(0.0);
    }

    private ScrollBar findScrollBar(Parent parent, Orientation orientation) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            ScrollBar b2;
            if (node instanceof ScrollBar && (b2 = (ScrollBar)node).getOrientation().equals((Object)orientation)) {
                return b2;
            }
            if (!(node instanceof Parent) || node instanceof TableHeaderRow || (b2 = this.findScrollBar((Parent)node, orientation)) == null) continue;
            return b2;
        }
        return null;
    }

    protected void bindVerticalListViewScrollBarWithVerticalTreeTableScrollBar() {
        ScrollBar treeTableScrollBar = this.findScrollBar((Parent)((GanttChart)this.getSkinnable()).getTreeTable(), Orientation.VERTICAL);
        ScrollBar graphicsViewScrollBar = this.findScrollBar((Parent)((GanttChart)this.getSkinnable()).getGraphics(), Orientation.VERTICAL);
        if (treeTableScrollBar != null && graphicsViewScrollBar != null) {
            Bindings.bindBidirectional((Property)treeTableScrollBar.valueProperty(), (Property)graphicsViewScrollBar.valueProperty());
            Bindings.bindBidirectional((Property)treeTableScrollBar.visibleAmountProperty(), (Property)graphicsViewScrollBar.visibleAmountProperty());
            Bindings.bindBidirectional((Property)treeTableScrollBar.blockIncrementProperty(), (Property)graphicsViewScrollBar.blockIncrementProperty());
            Bindings.bindBidirectional((Property)treeTableScrollBar.unitIncrementProperty(), (Property)graphicsViewScrollBar.unitIncrementProperty());
            Bindings.bindBidirectional((Property)treeTableScrollBar.minProperty(), (Property)graphicsViewScrollBar.minProperty());
            Bindings.bindBidirectional((Property)treeTableScrollBar.maxProperty(), (Property)graphicsViewScrollBar.maxProperty());
        }
    }
}

